#! /usr/bin/python

# Id$
# Copyright (c) 2003 Richard Offer. All rights reserved.

#
# Original Idea and Author: Richard Offer
#
#

# The script uses raw text processing to talk to a SOAP server,
# it doesn't attempt to parse the result, just echoing the result.

# The file descriptor #3 has already been opened and *SOME* headers sent, 
# all this script needs to do is send the rest of the headers, the payload 
# and then read the reply

import sys
import socket
import httplib


def usage():
	print "temp.py <zip code>"
	sys.exit(1)

if len(sys.argv) != 2:
	usage()
	

SOAPAction=""
URN="xmethods-Temperature"

body="""<?xml version=\"1.0\" encoding="UTF-8" ?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
xmlns:xsd="http://www.w3.org/1999/XMLSchema">
<SOAP-ENV:Body>
  <ns1:getTemp xmlns:ns1="urn:xmethods-Temperature" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
    <zipcode xsi:type="xsd:string">%s</zipcode>
  </ns1:getTemp>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
""" % ( sys.argv[1] )

len=len(body)

sock=socket.fromfd(3, socket.AF_INET, socket.SOCK_STREAM)

sock.send('Content-type: text/xml; charset="UTF-8"\n')
sock.send('Content-length: %d\n' % len)
sock.send('SOAPAction: "%s"\n' % SOAPAction)
sock.send('\r\n') # end the end of headers
sock.send('%s' % body)

# tell the server we're through with sending data, doing this means the
# server doesn't have to wait around to see if any more
# is arriving, which means the script can exit as soon as its
# read all the reply.
sock.shutdown(1)


# HTTPResponse knows about parsing HTTP headers and message body
# use it to get-it-right
response=httplib.HTTPResponse(sock)
response.begin()

print "\n8<-------raw message body"
print response.read()
print "8<-----------------------"