/* $Id: gg-types.h,v 1.13 2003/01/27 11:58:08 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 */

#ifndef GG_TYPES_H
#define GG_TYPES_H

#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define TITLE "GNU Gadu"

typedef struct {
	guint uin;
	gchar *password;
	gchar *email;
	gchar *bold_font;
	gint pos_x;
	gint pos_y;
	guint auto_away;
	guint auto_reconnect;
	guint beep;
	guint beep_msg;
	guint beep_chat;
	guint beep_notify;
	guint display_color;
	guint log;
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	guint main_on_start;
#endif
	gchar *sms_send_app;
	guint sms_away;
	guint sms_max_length;
	guint send_on_enter;
	guint private;
	guint use_proxy;
	guint proxy_port;
	gchar *proxy_host;
	guint connect_on_start;
	guint last_sysmsg;
	guint width;
	guint height;
#if HAVE_ESD || HAVE_ARTS
 	guint user_sound;
 	guint login_sound;
 	guint msg_sound;

 	gchar *user_sound_path;
 	gchar *login_sound_path;
 	gchar *msg_sound_path;

#endif
 	gchar *away_msg;
 	guint away_msg_send;
 	guint away_msg_ask;
	guint save_config_on_exit;
	guint save_contacts_on_exit;
	gchar *server;
	gchar *homedir;
	guint popup_msg_windows;
	gchar *reason;
	guint status;
} GGConfig;

typedef struct {
	guint type;
	guint datalen;
	gpointer data;
} GGCmd;

typedef struct {
	guint connected;
	guint state;
	gint sock;
	gint tcp_line;
	guint online_timeout;
	gchar *hostname;
	guint port;
	guint retry;
	guint find_stage;
	guint find_content_len;
	guint resume_cmd;
	GGCmd *cmd;
	guint animate_timeout;
	guint animate_pic;
	gint pipe;
	gint watches_timeout;
	GIOChannel *chan;
	guint new_msg_timeout;
	guint new_msg_pic;
	guint new_msg_anim_count;
} GGStatus;

typedef struct {
	unsigned int uin;
	unsigned int password_hash;
	unsigned int state;
	unsigned int version;
	unsigned int ip;
	unsigned short port;
} 
#ifdef __GNUC__
__attribute__ ((packed))
#endif
GGLoginMsg;

typedef struct {
	unsigned int uin;
	unsigned int password_hash;
	unsigned int state;
	unsigned int version;
	unsigned int ip;
	unsigned short port;
	unsigned int ex_ip;
	unsigned short ex_port;
} GGLoginMsgExt;

typedef struct {
	guint uin;
	guint status;
	gchar *nick;
	gchar *display;
	gchar *first_name;
	gchar *last_name;
	gchar *comment;
	gchar *mobile;
	gchar *group;
	gchar *description;
	gulong remote_ip;
} GGContact;

typedef struct {
	guint uin;
	GtkWidget *msg_window;
	GtkWidget *chat_window;
	gint sms_pid;
} GGSession;

typedef struct {
	guint start;
	guint active_only;
	gchar *first_name;
	gchar *last_name;
	gchar *gender;
	gchar *nick;
	gchar *city;
	gchar *agemin;
	gchar *agemax;
	gchar *uin;
} GGSearch;

typedef struct {
	gchar *http_query;
	gint type;
} GGHTTPQuery;

typedef struct {
	gint type;
	gint watch;
	gint fd;
	gint pid;
	gint timeout;
	gpointer data;
	GIOChannel *chan;
} GGWatch;

typedef struct {
	gint type;
	gint pid;
} GGChild;


struct gg_status {
	guint uin;
	guint status;
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_recv_msg {
	guint sender;
	guint seq;
	guint time;
	guint class;
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_send_msg_ack {
	guint status;
	guint recipient;
	guint seq;
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_send_msg {
	guint recipient;
	guint seq;
	guint class;
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_notify_reply {
	guint uin;
	guint status;
	gulong remote_ip;
	gushort remote_port;
	guint version;
	gushort dunno2;
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

/* zmiana informacji w katalogu publicznym */

struct gg_change_info_request {
	gchar *first_name;	/* imi */
	gchar *last_name;	/* nazwisko */
	gchar *nick;		/* nick */
	gint born;		/* rok urodzenia */
	gint gender;		/* pe */
	gchar *city;		/* miasto */
	gchar *familyname;	/**/
	gchar *familycity;	/**/
};


/* wyszukiwanie w v5.0 */
struct gg_pubdir50_request {
    guint8 type;			/* GG_PUBDIR50_* */
    guint32 seq;			/* czas wysania zapytania */
}
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_pubdir50_reply {
    guint8 type;			/* GG_PUBDIR50_* */
    guint32 seq;			/* czas wysania zapytania */
} 
#ifdef __GNUC__
__attribute__ ((packed))
#endif
;

struct gg_pubdir50_entry {
    gint num;
    gchar *field;
    gchar *value;
};

struct gg_pubdir50_s {
    gint count;
    gint next;
    gint type;
    guint32 seq;
    struct gg_pubdir50_entry *entries;
    gint entries_count;
};

typedef struct gg_pubdir50_s *gg_search50_t;

/* prototypy tych funkcji bd gdzies przeniesione... */

void read_config(void);

void write_config(void);

int write_contacts(void);

void shutdown_gg(void);

#endif

