/********************************************************************************************
	Clean OS Windows library module version 1.2.1.
	This module is part of the Clean Object I/O library, version 1.2.1,
	for the Windows platform.
********************************************************************************************/

/********************************************************************************************
	About this module:
	This module contains the cross call implementations required for
	NDI, SDI, and MDI document interfaces.
********************************************************************************************/
#include "util_121.h"
#include <gdk/gdkkeysyms.h>
#include "cCrossCallxDI_121.h"
#include "cCrossCall_121.h"
#include "cCCallWindows_121.h"


/*	Global data with external references:
*/
//HWND ghTopDocWindow = NULL;
GtkWidget *gActiveTopLevelWindow = NULL;
//int gComboSelection = -1;
gboolean gInMouseDown = FALSE;
gboolean gInKey       = FALSE;
int gCurChar;

/*	Global data with internal references only:
*/
//static LONG stdMDIClientCallback = 0;				/* The standard internal Windows callback routine of MDI client windows. */


/*	GetSDIClientWindow finds the first SDI client window of the argument hwnd.
		This procedure assumes that hwnd is the handle of a SDI frame window.
		If no SDI client window could be found then GetSDIClientWindow returns NULL.
*/
/*
static HWND GetSDIClientWindow (HWND hwndFrame)
{
	HWND client;
	char *clientclassname;
	int  classnamelength;

	client = GetWindow (hwndFrame,GW_CHILD);
	classnamelength = strlen (SDIWindowClassName) + 1;
	clientclassname = rmalloc (classnamelength);
	GetClassName (client, clientclassname, classnamelength);

	while (client != NULL && strcmp(clientclassname, SDIWindowClassName) != 0)
	{
		client = GetWindow (client,GW_HWNDNEXT);
		GetClassName (client,clientclassname,classnamelength);
	}
	rfree (clientclassname);
	return client;
}

*/

/*	Sending keyboard events to Clean thread:
*/
void SendKeyDownToClean (GtkWidget *parent, GtkWidget *child, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, parent, child, c, KEYDOWN, GetModifiers ());
}

void SendKeyStillDownToClean (GtkWidget *parent, GtkWidget *child, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, parent, child, c, KEYREPEAT, GetModifiers ());
}

void SendKeyUpToClean (GtkWidget *parent, GtkWidget *child, int c)
{
	SendMessage5ToClean (CcWmKEYBOARD, parent, child, c, KEYUP, GetModifiers ());
}

/*********************************************************************************************
	Callback routine for SDI frame window procedure.
	This routine handles the SDI frame events. These concern menus, toolbar, resizes.
	Also the accelerator table is kept at the frame window (analogous to MDI frame window).
	When resized, also the SDI client window (see previous callback routine) is notified.
	Note that whenever Clean is informed about an event, the GetSDIClientWindow(hWin) value
	should be passed to Clean which identifies the Clean SDI client window! The only exception
	is the CcWmPROCESSCLOSE message.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK SDIFrameProcedure (HWND hWin,UINT uMess,WPARAM wPara,LPARAM lPara)
{
	printMessage ("Clean SDIFrameWindow",hWin,uMess,wPara,lPara);
	switch (uMess)
	{
		case WM_COMMAND:
			{
				switch (HIWORD (wPara))
				{
					case 0:		/*	0: message originates from a menu or equals BN_CLICKED */
						{
							if (lPara != 0)		/* PA: it was BN_CLICKED. */
							{
								/*	hwndClient can't be NULL, because a button has been pressed. */
								HWND hwndClient = GetSDIClientWindow (hWin);
								/*	Send also modifiers to Clean */
								SendMessage4ToClean (CcWmBUTTONCLICKED, hwndClient, lPara, GetModifiers (), LOWORD (wPara));
							}
							else				/*	It was from a menu. */
							{
								SendMessage2ToClean (CcWmCOMMAND, LOWORD (wPara), GetModifiers ());
							}
						}
						break;
					case 1:		/*	1: message originates from an accelerator */
						{
							SendMessage2ToClean (CcWmCOMMAND, LOWORD (wPara), GetModifiers ());
						}
						break;
					case CBN_SETFOCUS:
						{
							gComboSelection = SendMessage ((HWND) lPara, CB_GETCURSEL, 0, 0);
						}
						break;
					case CBN_KILLFOCUS:
						{
							gComboSelection = -1;
						}
						break;
					case CBN_SELENDOK:
						{
							char text[256];
							int newsel;
							HWND combo;

							combo = (HWND) lPara;
							newsel = SendMessage (combo, CB_GETCURSEL, 0, 0);
							SendMessage (combo, CB_GETLBTEXT, newsel, (LPARAM) text);
							if (!SendMessage (combo, CB_GETITEMDATA, newsel, 0))
							{
								SendMessage (combo, CB_SETCURSEL, gComboSelection, (LPARAM) text);
								MessageBeep (0xFFFFFFFF);
								return 0;
							}
							else
							{
								gComboSelection = newsel;
								if (newsel!=CB_ERR)
								{
									HWND hwndClient = GetSDIClientWindow (hWin);
									SendMessage3ToClean (CcWmCOMBOSELECT, hwndClient, combo, newsel);
								}
								return 1;
							}
						}
						break;
				}
			} break;
		/*	WM_NOTIFY is handled identically as for MDI client windows (see MDIClientProcedure).
		*/
		case WM_NOTIFY:
			{
				LPNMHDR pnmh        = (LPNMHDR) lPara;
				LPTOOLTIPTEXT lpttt = (LPTOOLTIPTEXT) lPara;
				UINT from, flags;

				from = lpttt->hdr.idFrom;
				flags= lpttt->uFlags;

				if (pnmh->code == TTN_NEEDTEXT && from != 0 && flags != TTF_IDISHWND)
				{
					HWND hwndToolbar;

					hwndToolbar = (HWND)GetGWL_USERDATA (hWin);

					//	get tooltip text from Clean
					SendMessage2ToClean (CcWmGETTOOLBARTIPTEXT, hwndToolbar, from);
					lstrcpy (lpttt->szText,(LPSTR)gCci.p1);
					if (gCci.p1 != 0)
						rfree ((HGLOBAL) gCci.p1);

					return 0;
				}
				return (DefWindowProc (hWin, uMess, wPara, lPara));
			}
			break;
		case WM_CLOSE:		/*	The SDI frame window is requested to be closed. */
			{
				SendMessage1ToClean (CcWmPROCESSCLOSE, hWin);
				return 0;
			}
			break;

		/*	WM_ENTERIDLE message is used to let Clean evaluate the initialisation action
			of a modal dialog by sending the CcWmIDLEDIALOG message.
		*/
		case WM_ENTERIDLE:
			{
				HWND hwndModalDialog;

				hwndModalDialog = (HWND)lPara;

				if (wPara == MSGF_DIALOGBOX && hwndModalDialog != ghwndLastModalDialog)
				{
					SendMessage1ToClean (CcWmIDLEDIALOG,(int)hwndModalDialog);
					ghwndLastModalDialog = hwndModalDialog;
				}
				else
				{
					SendMessage0ToClean (CcWmIDLETIMER);
				}
				return 0;
			} break;
		case WM_CANCELMODE:
			{
				if (gInMouseDown)
				{
					ReleaseCapture ();	/* rely on WM_CAPTURECHANGED to send the mouseUp event */
				}
				return DefWindowProc (hWin, uMess, wPara, lPara);
			}
			break;
		case WM_CAPTURECHANGED:
			{
				HWND hwndClient = GetSDIClientWindow (hWin);
				if (hwndClient != NULL && gInMouseDown)
				{
					POINT p;
					GetCursorPos (&p);
					ScreenToClient (hwndClient, &p);
//					SendMouseUpToClean (hwndClient, hwndClient, p.x, p.y);
				}
			}
			break;
		/*	The WM_CREATE message should cause the SDI frame window only to create the accelerator table.
			The crosscall request from Clean to create the SDI window will create the SDI client. The
			SDI client will notify Clean that the controls can be created.
		*/
		case WM_CREATE:
			{
				ghActiveFrameWindow  = hWin;					// Keep track of the active frame window
				ghActiveClientWindow = NULL;					//  and client window
			}
			break;
		/*	The WM_SIZE message resizes the toolbar if present and makes sure that the SDI client
			window is also resized by sending it the same size message, but with the toolbar height
			subtracted.
		*/
		case WM_SIZE:
			{
				HWND hwndToolbar,hwndClient;
				RECT toolbarRect;
				int  toolbarHeight = 0;

				/*	Also resize the toolbar if present. */
				hwndToolbar = (HWND)GetGWL_USERDATA (hWin);

				if (hwndToolbar != NULL)
				{
					SendMessage (hwndToolbar, TB_AUTOSIZE, (WPARAM)0, (LPARAM)0);
					UpdateWindow (hwndToolbar);

					if (!GetWindowRect(hwndToolbar,&toolbarRect))
						rMessageBox (NULL,MB_APPLMODAL,"SDIFrameProcedure","GetWindowRect (hwndToolbar,_) failed");
					toolbarHeight = toolbarRect.bottom - toolbarRect.top;
				}

				hwndClient = GetSDIClientWindow (hWin);
				if (hwndClient != NULL)
				{
					SetWindowPos (hwndClient,												/* the SDI client */
								  HWND_BOTTOM,												/* this value is ignored (SWP_NOZORDER)  */
								  0,0,														/* these values are ignored (SWP_NOMOVE) */
								  (int)LOWORD (lPara),(int)HIWORD (lPara)-toolbarHeight,	/* new width and height */
								  SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER
								 );
				}
			}
			break;
	}
	return DefWindowProc (hWin,uMess,wPara,lPara);
}	/* SDIFrameProcedure */

#endif

/*********************************************************************************************
	Callback routine for MDI frame window procedure.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK MDIFrameProcedure (HWND hWin,UINT uMess,WPARAM wPara,LPARAM lPara)
{
	printMessage ("Clean MDIFrameWindow",hWin,uMess,wPara,lPara);
	switch (uMess)
	{
		/*	WM_ENTERIDLE message is used to let Clean evaluate the initialisation action
			of a modal dialog by sending the CcWmIDLEDIALOG message.
		*/
		case WM_ENTERIDLE:
			{
				HWND hwndModalDialog;

				hwndModalDialog = (HWND)lPara;

				if (wPara == MSGF_DIALOGBOX && hwndModalDialog != ghwndLastModalDialog)
				{
					SendMessage1ToClean (CcWmIDLEDIALOG,(int)hwndModalDialog);
					ghwndLastModalDialog = hwndModalDialog;
				}
				else
				{
					SendMessage0ToClean (CcWmIDLETIMER);
				}
				return 0;
			} break;
		case WM_COMMAND:
			{
				if (HIWORD (wPara)==0 && lPara!=0)
				{
					HWND hwndToolbar;

					hwndToolbar = (HWND)GetGWL_USERDATA (hWin);	// Obtain the toolbar handle
					if (hwndToolbar != 0)
						SendMessage4ToClean (CcWmBUTTONCLICKED, hWin, lPara, GetModifiers (), LOWORD (wPara));
				}
			} break;
		/* WM_CREATE should create the client window, the menu bar, and the "Window" menu. */
		case WM_CREATE:
			{
				CLIENTCREATESTRUCT clientcreate;
				HMENU menuBar, windowMenu;				// The handle to the menu bar and the "Window" menu
				HWND hwndClient;						// New

				menuBar = CreateMenu ();				// Create the menu bar
				SetMenu (hWin,menuBar);					// and associate it with the frame window


				clientcreate.hWindowMenu  = NULL;
				clientcreate.idFirstChild = 0;	// Window ids must be generated from OSMenuIDEnd+5

				hwndClient = CreateWindow (	"MDICLIENT",								// The MDICLIENT window class
											NULL,										// The window name
											WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,	// Style parameters
											0,0,										// position (x,y)
											0,0,										// size (w,h)
											hWin,										// The frame window is the parent
											NULL,										// The menu (none at the moment)
											(HANDLE) ghInst,							// Instance that owns the window
											(LPSTR) &clientcreate						// The CLIENTCREATESTRUCT
											);

				ghActiveFrameWindow  = hWin;					// Keep track of the active frame window
				ghActiveClientWindow = hwndClient;				//	and client window

			} return 0;
		case WM_CLOSE:
			{
				SendMessage1ToClean (CcWmPROCESSCLOSE, hWin);
				return 0;
			}
			break;
		case WM_DESTROY:	/*	The frame is in the act of being closed. */
			{
//				DragAcceptFiles (hWin,FALSE);			/* Unregister for WM_DROPFILES events. */
			}
			break;
		case WM_NOTIFY:
			{
				LPNMHDR pnmh        = (LPNMHDR) lPara;
				LPTOOLTIPTEXT lpttt = (LPTOOLTIPTEXT) lPara;
				UINT from, flags;

				from = lpttt->hdr.idFrom;
				flags= lpttt->uFlags;

				if (pnmh->code == TTN_NEEDTEXT && from != 0 && flags != TTF_IDISHWND)
				{
					HWND hwndToolbar;

					hwndToolbar = (HWND)GetGWL_USERDATA (hWin);

					//	get tooltip text from Clean
					SendMessage2ToClean (CcWmGETTOOLBARTIPTEXT, hwndToolbar, from);
					lstrcpy (lpttt->szText,(LPSTR)gCci.p1);
					if (gCci.p1 != 0)
						rfree ((HGLOBAL) gCci.p1);
				}
			}
			break;
		case WM_SIZE:
			{
				HWND hwndToolbar;

				hwndToolbar = (HWND)GetGWL_USERDATA (hWin);
				if (hwndToolbar != NULL)
					SendMessage ((HWND)GetGWL_USERDATA (hWin), TB_AUTOSIZE, (WPARAM)0, (LPARAM)0);
			}
			break;
		/*	Accept the user dropping file(s) in the frame window. */
		case WM_DROPFILES:
			{
				//SendDropFilesToClean (hWin,wPara);
			}
			break;
		default:
			return DefFrameProc (hWin, GetWindow (hWin,GW_CHILD), uMess, wPara, lPara);
			break;
	}
	return DefFrameProc (hWin, GetWindow (hWin,GW_CHILD), uMess, wPara, lPara);
}	/* MDIFrameProcedure */

#endif

/*********************************************************************************************
	The callback routine for subclassing the client window of a MDI frame window.
	This routine catches only WM_WINDOWPOSCHANGING event.
*********************************************************************************************/
#if 0
static LRESULT CALLBACK MDIClientProcedure (HWND hwnd,UINT uMess,WPARAM wParam,LPARAM lParam)
{
	printMessage ("Clean MDI Client", hwnd, uMess, wParam, lParam);

	switch (uMess)
	{
		case WM_WINDOWPOSCHANGING:
			{
				WINDOWPOS* wp;
				RECT tbRect;
				int tbHeight;
				HWND hwndFrame, hwndToolbar;

				wp = (LPWINDOWPOS)lParam;

				hwndFrame = GetParent (hwnd);
				hwndToolbar = (HWND)GetGWL_USERDATA (hwndFrame);

				if (hwndToolbar==0)
				{
					tbHeight = 0;
				} else
				{
					GetWindowRect (hwndToolbar,&tbRect);
					tbHeight = tbRect.bottom - tbRect.top;
				}
				wp->y  = tbHeight;
				wp->cy = wp->cy - tbHeight;

				return 0;
			}
			break;
	}
	return CallWindowProc ((WNDPROC) stdMDIClientCallback, hwnd, uMess, wParam, lParam);
}	/* MDIClientProcedure */

#endif

static void prcs(GtkWidget *widget, gpointer data)
{
	if (GTK_IS_SCROLLED_WINDOW(widget))
	{
		*((GtkWidget **) data) = widget;
	}
}

static GtkWidget *get_client(GtkWidget *widget)
{
	GtkWidget *box = gtk_bin_get_child(GTK_BIN(widget));
	if (box)
	{
		GtkWidget *client = NULL;
		gtk_container_foreach(GTK_CONTAINER(box), prcs, (gpointer) &client);
		return client;
	}

	return NULL;
};

static void frame_focus_in_handler(GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	SendMessage1ToClean (CcWmACTIVATE, get_client(widget));
	GTK_WIDGET_GET_CLASS(widget)->focus_in_event(widget, event);
	gActiveTopLevelWindow = widget;
}

static void frame_focus_out_handler(GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	GtkWidget *client = get_client(widget);

	if (gInKey)
		SendKeyUpToClean (client, client, gCurChar);

	SendMessage1ToClean (CcWmDEACTIVATE, client);
	GTK_WIDGET_GET_CLASS(widget)->focus_out_event(widget, event);
	gActiveTopLevelWindow = NULL;
}


static gboolean frame_delete_handler(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if (gActiveTopLevelWindow == widget)
		gActiveTopLevelWindow = NULL;

	if (gtk_object_get_data(GTK_OBJECT (widget), "gtk-drag-dest") != NULL)
		gtk_drag_dest_unset(widget);

	SendMessage1ToClean (CcWmPROCESSCLOSE, widget);
	return gtk_true();
}

static void frame_drag_data_handler
			(GtkWidget 			*widget,
			 GdkDragContext     *context,
			 gint                x,
			 gint                y,
			 GtkSelectionData   *data,
			 guint               info,
			 guint               time)
{
  	if ((data->length >= 0) && (data->format == 8))
    {
		char *filenames = malloc(data->length);
		if (filenames)
		{
			guchar *s = data->data;
			guchar *e = s + data->length - 2;
			char *d = filenames;

			while (s < e)
			{
				if (*s != '\r') *(d++) = *s;
				s++;
			}
			*d = 0;

			gtk_drag_finish (context, TRUE, FALSE, time);
			SendMessage2ToClean (CcWmPROCESSDROPFILES, (int) widget, (int) filenames);
		}
    }
	else
  		gtk_drag_finish (context, FALSE, FALSE, time);
}

static gboolean frame_key_press_handler(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkWidget *client = get_client(widget);
	int c = (event->length > 0) ? event->string[0] : CheckVirtualKeyCode (event->keyval);
	if (!c) return gtk_false();

	if (event->keyval == GDK_Tab)
		return gtk_false();

	GTK_WIDGET_GET_CLASS(widget)->key_press_event(widget, event);

	if (gInKey)
	{
		if (gCurChar == c)
			SendKeyStillDownToClean (client, client, gCurChar);
		else
		{
			SendKeyUpToClean (client, client, gCurChar);
			gCurChar = c;
			SendKeyDownToClean (client, client, gCurChar);
		}
	}
	else
	{
		gCurChar = c;
		SendKeyDownToClean (client, client, gCurChar);
		gInKey = TRUE;
	}

	return gtk_true();
};

static gboolean frame_key_release_handler(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkWidget *client = get_client(widget);

	if (event->keyval == GDK_Tab)
		return gtk_false();

	GTK_WIDGET_GET_CLASS(widget)->key_press_event(widget, event);

	if (gInKey)
	{
		SendKeyUpToClean (client, client, gCurChar);
		gInKey = FALSE;
		gCurChar = 0;
	}

	return gtk_true();
};

/*	Create a SDI frame window. */
void EvalCcRqCREATESDIFRAMEWINDOW (CrossCallInfo *pcci)	/* accept file open; frame ptr, menubar results. */
{
	GtkWidget *window, *menuBar, *box;

	/* Create the menubar. */
	menuBar = gtk_menu_bar_new();

	/* Create the window. */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "focus-in-event",
				GTK_SIGNAL_FUNC(frame_focus_in_handler),
				NULL);
	gtk_signal_connect (GTK_OBJECT (window), "focus-out-event",
				GTK_SIGNAL_FUNC(frame_focus_out_handler),
				NULL);
	gtk_signal_connect (GTK_OBJECT (window), "delete-event",
				GTK_SIGNAL_FUNC(frame_delete_handler),
				NULL);
	gtk_signal_connect (GTK_OBJECT(window), "key-press-event",
				GTK_SIGNAL_FUNC(frame_key_press_handler),
				NULL);
	gtk_signal_connect (GTK_OBJECT(window), "key-release-event",
				GTK_SIGNAL_FUNC(frame_key_release_handler),
				NULL);

	if ((gboolean) pcci->p1)	/*	respond to file open events. */
	{
		static GtkTargetEntry target_table = { "text/uri-list", 0, 0 };

		gtk_drag_dest_set (window,
					GTK_DEST_DEFAULT_ALL,
					&target_table, 1, /* no rootwin */
					GDK_ACTION_COPY | GDK_ACTION_MOVE);

		gtk_signal_connect(GTK_OBJECT(window), "drag_data_received",
		      		GTK_SIGNAL_FUNC(frame_drag_data_handler), NULL);
	}

	gtk_window_add_accel_group (GTK_WINDOW (window), gtk_accel_group_new());

	box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), box);
	gtk_box_pack_start(GTK_BOX(box), menuBar, FALSE, FALSE, 0);

	MakeReturn2Cci (pcci, (int) window, (int) menuBar);
}

/*	Create MDI frame window. */
void EvalCcRqCREATEMDIFRAMEWINDOW (CrossCallInfo *pcci)	/* show, accept file open; frame ptr, client ptr, menubar, windowmenu results. */
{
#if 0
	BOOL show, acceptFileOpen;
	DWORD styleFlags;
	HWND hwndFrame, hwndClient;
	HMENU menuBar, windowMenu;

	show           = (BOOL) pcci->p1;
	acceptFileOpen = (BOOL) pcci->p2;	/*	respond to file open events. */

	styleFlags = WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN;
	if (show)
		styleFlags |= WS_MAXIMIZE;
	else
		styleFlags |= WS_MINIMIZE;

	hwndFrame = CreateWindow (	MDIFrameClassName			// Class name
							 ,	(LPCTSTR) gAppName			// Title is the application name
							 ,	styleFlags					// Style parameters
							 ,	0,0							// Default position (x,y)
							 ,	CW_USEDEFAULT,CW_USEDEFAULT	// Default size (w,h)
							 ,	NULL						// Every window should be top-level
							 ,	NULL
							 ,	(HANDLE) ghInst				// Instance that owns the window
							 ,	NULL
							 );
	hwndClient = GetWindow (hwndFrame,GW_CHILD);	// retrieve the "MDICLIENT" window
	menuBar    = GetMenu (hwndFrame);				// retrieve the menu bar of the frame window
	windowMenu = GetSubMenu (menuBar,0);			// retrieve the "Window" menu of the menu bar
	if (show)
	{
		ShowWindow (hwndFrame,SW_MAXIMIZE);			// show the frame window (SW_MAXIMIZE gives best result)
		UpdateWindow (hwndFrame);					// update the frame window
	}
	DrawMenuBar (hwndFrame);						// update the menu bar

//	if (acceptFileOpen)
//		DragAcceptFiles (hwndFrame,TRUE);			/* register for WM_DROPFILES events. */

	/*	Store the standard Windows callback routine adress in stdMDIClientCallback
		and subclass the MDI client window with MDIClientProcedure.
	*/
	stdMDIClientCallback = SetWindowLong (hwndClient, GWL_WNDPROC, (LONG) MDIClientProcedure);

#endif
	printf("EvalCcRqCREATEMDIFRAMEWINDOW -> not implememted\n");
	MakeReturn4Cci (pcci,(int) NULL /*hwndFrame*/,(int) NULL/*hwndClient*/,(int) NULL /*menuBar*/,(int) NULL/*windowMenu*/);
}

void EvalCcRqDESTROYWINDOW (CrossCallInfo *pcci) /* hwnd; no result. */
{
	gtk_widget_destroy((GtkWidget *) pcci->p1);
	MakeReturn0Cci (pcci);
}

void EvalCcRqGETWINDOWPOS (CrossCallInfo *pcci)	/* hwnd;   width, heigth result */
{
//	RECT rect;

//	GetWindowRect ((HWND) pcci->p1, &rect);

	printf("EvalCcRqGETWINDOWPOS -> not implemented\n");
	MakeReturn2Cci (pcci, 0 /*rect.left*/, 0 /*rect.top*/);
}

void EvalCcRqGETCLIENTSIZE (CrossCallInfo *pcci) /* hwnd;		width, height result.  */
{
	GtkWidget *frame = (GtkWidget *) pcci->p1;
	GtkWidget *vbox  = GTK_BIN(frame)->child;

	MakeReturn2Cci (pcci, vbox->allocation.width, vbox->allocation.height);
}

/*	Create a toolbar in a window. */
void EvalCcRqCREATEMDITOOLBAR (CrossCallInfo *pcci)			/* hwnd, width, height; toolbarptr, full toolbar height result; */
{
#if 0
	HWND hwndToolbar;
	HWND hwndParent;
	int  bmpWidth, bmpHeight, tbHeight;
	RECT tbRect;

	hwndParent  = (HWND) pcci->p1;	// The parent is the frame window
	bmpWidth    = pcci->p2;
	bmpHeight   = pcci->p3;

	hwndToolbar = CreateWindow (TOOLBARCLASSNAME,
								NULL,
								WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | CCS_TOP | TBSTYLE_TOOLTIPS,
								0,0,0,0,
								hwndParent,
								(HMENU) NULL,
								(HANDLE) ghInst,
								0
								);
	SetGWL_USERDATA ((LONG)hwndToolbar, hwndParent);	// Administrate the toolbar handle in the MDI frame parent handle
	SendMessage (hwndToolbar, TB_SETBITMAPSIZE, (WPARAM)0, (LPARAM)MAKELONG(bmpWidth,bmpHeight));
	SendMessage (hwndToolbar, TB_AUTOSIZE, (WPARAM)0, (LPARAM)0);
	SendMessage (hwndToolbar, TB_BUTTONSTRUCTSIZE, (WPARAM) sizeof (TBBUTTON), (LPARAM) 0);

	/*	MDI windows that will get a toolbar are initially created with the WS_MINIMIZE flag
		(see CcRqCREATEMDIFRAMEWINDOW).
		This is needed to ensure that the toolbar, after creation, becomes visible.
	*/
	ShowWindow (hwndParent,SW_MAXIMIZE);

	if (!GetWindowRect (hwndToolbar,&tbRect))
		rMessageBox (NULL,MB_APPLMODAL,"CcRqCREATEMDITOOLBAR","GetWindowRect failed");
	tbHeight = tbRect.bottom - tbRect.top;

#endif
	printf("EvalCcRqCREATEMDITOOLBAR -> not implemented\n");
	MakeReturn2Cci (pcci,(int)NULL/*hwndToolbar*/,0/*tbHeight*/);
}

static void toolbar_handler(GtkWidget *widget, gpointer data)
{
	GtkWidget *toolbar, *parent;

	toolbar = gtk_widget_get_parent(widget);
	parent  = gtk_widget_get_parent(gtk_widget_get_parent(toolbar));
	SendMessage4ToClean (CcWmBUTTONCLICKED, parent, toolbar, GetModifiers(), (int) data);
};

/*	Create a toolbar in a SDI window. */
void EvalCcRqCREATESDITOOLBAR (CrossCallInfo *pcci)			/* hwnd, width, height; toolbarptr, full toolbar height result; */
{
	GtkWidget *parent,*box,*toolbar;

	parent  = (GtkWidget *) pcci->p1;

	box = gtk_bin_get_child(GTK_BIN(parent));
	toolbar = gtk_toolbar_new();

	gtk_box_pack_start (GTK_BOX (box), toolbar, FALSE, FALSE, 0);
	gtk_widget_show(toolbar);

	MakeReturn2Cci (pcci, (int) toolbar, pcci->p3);
}

/*	Create a bitmap toolbar item. */
void EvalCcRqCREATETOOLBARITEM (CrossCallInfo *pcci)		// hwnd, hbmp, index; no results;
{
	GtkWidget *toolbar;
	GdkPixbuf *pixbuf;
	int index;

	toolbar = (GtkWidget *) pcci->p1;
	pixbuf  = (GdkPixbuf *) pcci->p2;
	index   = pcci->p3;

	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, NULL, NULL, gtk_image_new_from_pixbuf(pixbuf), GTK_SIGNAL_FUNC(toolbar_handler), (gpointer) index);

	MakeReturn0Cci (pcci);
}

/*	Create a separator toolbar item. */
void EvalCcRqCREATETOOLBARSEPARATOR (CrossCallInfo *pcci)	// hwnd; no results;
{
	GtkWidget *toolbar;

	toolbar = (GtkWidget *) pcci->p1;
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	MakeReturn0Cci (pcci);
}

/*	Install the cross call procedures in the gCrossCallProcedureTable of cCrossCall_121.
*/
void InstallCrossCallxDI ()
{
	CrossCallProcedureTable newTable;

	newTable = EmptyCrossCallProcedureTable ();
	AddCrossCallEntry (newTable, CcRqCREATESDIFRAMEWINDOW,   EvalCcRqCREATESDIFRAMEWINDOW);
	AddCrossCallEntry (newTable, CcRqCREATEMDIFRAMEWINDOW,   EvalCcRqCREATEMDIFRAMEWINDOW);
	AddCrossCallEntry (newTable, CcRqDESTROYWINDOW,          EvalCcRqDESTROYWINDOW);
	AddCrossCallEntry (newTable, CcRqGETWINDOWPOS,           EvalCcRqGETWINDOWPOS);
	AddCrossCallEntry (newTable, CcRqGETCLIENTSIZE,          EvalCcRqGETCLIENTSIZE);
	AddCrossCallEntry (newTable, CcRqCREATEMDITOOLBAR,       EvalCcRqCREATEMDITOOLBAR);
	AddCrossCallEntry (newTable, CcRqCREATESDITOOLBAR,       EvalCcRqCREATESDITOOLBAR);
	AddCrossCallEntry (newTable, CcRqCREATETOOLBARITEM,      EvalCcRqCREATETOOLBARITEM);
	AddCrossCallEntry (newTable, CcRqCREATETOOLBARSEPARATOR, EvalCcRqCREATETOOLBARSEPARATOR);
	AddCrossCallEntries (gCrossCallProcedureTable, newTable);
}
