/* -----------------------------------------------------------------------------
 *
 * (c) The GHC Team, 1998-2002
 *
 * Bytecode definitions.
 *
 * ---------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------
 * Instructions
 *
 * Notes:
 * o CASEFAIL is generated by the compiler whenever it tests an "irrefutable"
 *   pattern which fails.  If we don't see too many of these, we could
 *   optimise out the redundant test.
 * ------------------------------------------------------------------------*/

/* NOTE:

   THIS FILE IS INCLUDED IN HASKELL SOURCES (ghc/compiler/ghci/ByteCodeGen.lhs).
   DO NOT PUT C-SPECIFIC STUFF IN HERE!

   I hope that's clear :-)
*/

#define bci_STKCHECK  			1
#define bci_PUSH_L    			2
#define bci_PUSH_LL   			3
#define bci_PUSH_LLL  			4
#define bci_PUSH_G    			5
#define bci_PUSH_ALTS  			6
#define bci_PUSH_ALTS_P			7
#define bci_PUSH_ALTS_N			8 
#define bci_PUSH_ALTS_F			9 
#define bci_PUSH_ALTS_D			10
#define bci_PUSH_ALTS_L			11
#define bci_PUSH_ALTS_V			12
#define bci_PUSH_UBX  			13
#define bci_PUSH_APPLY_N		14
#define bci_PUSH_APPLY_F		15
#define bci_PUSH_APPLY_D		16
#define bci_PUSH_APPLY_L		17
#define bci_PUSH_APPLY_V		18
#define bci_PUSH_APPLY_P		19
#define bci_PUSH_APPLY_PP		20
#define bci_PUSH_APPLY_PPP		21
#define bci_PUSH_APPLY_PPPP		22
#define bci_PUSH_APPLY_PPPPP		23
#define bci_PUSH_APPLY_PPPPPP		24
/* #define bci_PUSH_APPLY_PPPPPPP		25 */
#define bci_SLIDE     			26
#define bci_ALLOC_AP   			27
#define bci_ALLOC_AP_NOUPD		28
#define bci_ALLOC_PAP  			29
#define bci_MKAP      			30
#define bci_MKPAP      			31
#define bci_UNPACK    			32
#define bci_PACK      			33
#define bci_TESTLT_I   			34
#define bci_TESTEQ_I  			35
#define bci_TESTLT_F  			36
#define bci_TESTEQ_F  			37
#define bci_TESTLT_D  			38
#define bci_TESTEQ_D  			39
#define bci_TESTLT_P  			40
#define bci_TESTEQ_P  			41
#define bci_CASEFAIL  			42
#define bci_JMP       			43
#define bci_CCALL     			44
#define bci_SWIZZLE   			45
#define bci_ENTER     			46
#define bci_RETURN    			47
#define bci_RETURN_P 			48
#define bci_RETURN_N 			49
#define bci_RETURN_F 			50
#define bci_RETURN_D 			51
#define bci_RETURN_L 			52
#define bci_RETURN_V 			53
#define bci_BRK_FUN			54
/* If you need to go past 255 then you will run into the flags */

/* If you need to go below 0x0100 then you will run into the instructions */
#define bci_FLAG_LARGE_ARGS     0x8000

/* If a BCO definitely requires less than this many words of stack,
   don't include an explicit STKCHECK insn in it.  The interpreter
   will check for this many words of stack before running each BCO,
   rendering an explicit check unnecessary in the majority of
   cases. */
#define INTERP_STACK_CHECK_THRESH  50

/*-------------------------------------------------------------------------*/
