--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.OpenAL.ALUT.Initialization
-- Copyright   :  (c) Sven Panne 2003-2004
-- License     :  BSD-style (see the file libraries/OpenAL/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.OpenAL.ALUT.Initialization (
   runOpenAL
) where

import Graphics.Rendering.OpenGL.GL.StateVar ( HasGetter(get), HasSetter(($=)) )
import Sound.OpenAL.ALUT.Exception ( bracket_ )
import Sound.OpenAL.ALC.Context (
   createContext, destroyContext, currentContext, contextsDevice )
import Sound.OpenAL.ALC.Device ( openDevice, closeDevice )

--------------------------------------------------------------------------------

alutInit :: IO ()
alutInit = do
  device <- openDevice Nothing
  context <- createContext device []
  currentContext $= Just context

alutExit :: IO ()
alutExit = get currentContext >>= maybe (return ()) cleanupContext
   where cleanupContext context = do
            maybeDevice <- get (contextsDevice context)
            currentContext $= Nothing
            destroyContext context
            maybe (return ()) closeDevice maybeDevice

runOpenAL :: IO a -> IO a
runOpenAL = bracket_ alutInit alutExit
