--------------------------------------------------------------------------------
-- |
-- Module      :  Sound.ALUT.Sleep
-- Copyright   :  (c) Sven Panne 2005
-- License     :  BSD-style (see the file libraries/ALUT/LICENSE)
-- 
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  provisional
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Sound.ALUT.Sleep (
   sleep
)  where

import Sound.ALUT.Errors ( throwIfALfalse )
import Sound.OpenAL.AL.BasicTypes ( ALboolean, ALfloat )

--------------------------------------------------------------------------------

sleep :: Float -> IO ()
sleep = throwIfALfalse "sleep" . alutSleep

foreign import CALLCONV unsafe "alutSleep"
   alutSleep :: ALfloat -> IO ALboolean
