/********************************************************************************************
	Clean OS Windows library module version 1.2.1.
	This module is part of the Clean Object I/O library, version 1.2.1,
	for the Windows platform.
********************************************************************************************/

/********************************************************************************************
	About this module:
	Routines related to font handling.
********************************************************************************************/
#include "cCrossCallFont_121.h"
#include "cCrossCall_121.h"

/*

static int CALLBACK EnumFontNameProc (ENUMLOGFONT FAR * lpelf,		// pointer to logical-font  data 
									  NEWTEXTMETRIC FAR * lpntm,	// pointer to physical-font data 
									  int fontType,					// type of font
									  LPARAM lParam					// address of application-defined data
									 )
{
	SendMessage1ToClean (CcCbFONTNAME, lpelf->elfLogFont.lfFaceName);

	return 1;
}

static int CALLBACK EnumFontSizeProc (ENUMLOGFONT FAR * lpelf,		// pointer to logical-font data
									  NEWTEXTMETRIC FAR * lpntm,	// pointer to physical-font data
									  int fontType,				// type of font  
									  LPARAM lParam				// address of application-defined data	
									 )
{
	SendMessage2ToClean (CcCbFONTSIZE,lpntm->tmHeight - lpntm->tmInternalLeading, fontType == TRUETYPE_FONTTYPE);

	if (fontType == TRUETYPE_FONTTYPE)
		return 0;
	else
		return 1;
}

*/

/*	Cross call procedure implementations.
	Eval<nr> corresponds with a CrossCallEntry generated by NewCrossCallEntry (nr,Eval<nr>).
*/
void EvalCcRqGETFONTNAMES (CrossCallInfo *pcci)		// no params; no result.
{
/*	HDC hdc;

	hdc = GetDC (ghMainWindow);
	EnumFontFamilies (hdc, NULL, (FONTENUMPROC) EnumFontNameProc, 0);
	ReleaseDC (ghMainWindow, hdc);
	MakeReturn0Cci (pcci);
*/
    printf("EvalCcRqGETFONTNAMES -> not implemented");
    MakeReturn0Cci(pcci);
}

void EvalCcRqGETFONTSIZES (CrossCallInfo *pcci)		// textptr; no result.
{
/*	HDC hdc;

	hdc = GetDC (ghMainWindow);
	EnumFontFamilies (hdc, (char *) pcci->p1, (FONTENUMPROC) EnumFontSizeProc, 0);
	ReleaseDC (ghMainWindow, hdc);
	rfree ((char *) pcci->p1);
	MakeReturn0Cci (pcci);
*/
    printf("EvalCcRqGETFONTSIZES -> not implemented");
    MakeReturn0Cci(pcci);
}


//	InstallCrossCallFont adds the proper cross call procedures to the
//	cross call procedures managed by cCrossCall_121.c.
void InstallCrossCallFont ()
{
	CrossCallProcedureTable newTable;

	newTable = EmptyCrossCallProcedureTable ();
	AddCrossCallEntry (newTable, CcRqGETFONTNAMES,EvalCcRqGETFONTNAMES);
	AddCrossCallEntry (newTable, CcRqGETFONTSIZES,EvalCcRqGETFONTSIZES);
	AddCrossCallEntries (gCrossCallProcedureTable, newTable);
}
