package Grt.Hooks is
   pragma Preelaborate (Grt.Hooks);

   type Option_Hook_Type is access function (Opt : String) return Boolean;
   type Proc_Hook_Type is access procedure;

   type Hooks_Type is record
      --  Called for every unknown command line argument.
      --  Return TRUE if handled.
      Option : Option_Hook_Type;

      --  Display command line help.
      Help : Proc_Hook_Type;

      --  Called at initialization (after decoding options).
      Init : Proc_Hook_Type;

      --  Called just after elaboration.
      Start : Proc_Hook_Type;

      --  Called at the end of execution.
      Finish : Proc_Hook_Type;
   end record;

   type Hooks_Acc is access constant Hooks_Type;

   --  Registers hook.
   procedure Register_Hooks (Hooks : Hooks_Acc);

   --  Register an hook which will call PROC after every non-delta cycles.
   procedure Register_Cycle_Hook (Proc : Proc_Hook_Type);

   --  Call hooks.
   function Call_Option_Hooks (Opt : String) return Boolean;
   procedure Call_Help_Hooks;
   procedure Call_Init_Hooks;
   procedure Call_Start_Hooks;
   procedure Call_Finish_Hooks;

   --  Call non-delta cycles hooks.
   procedure Call_Cycle_Hooks;
   pragma Inline_Always (Call_Cycle_Hooks);

   --  Nil procedure.
   procedure Proc_Hook_Nil;
end Grt.Hooks;
