with Grt.Types; use Grt.Types;

package Grt.Lib is
   pragma Preelaborate (Grt.Lib);

   procedure Ghdl_Memcpy
     (Dest : Ghdl_Ptr; Src : Ghdl_Ptr; Size : Ghdl_Index_Type);

   procedure Ghdl_Assert_Failed
     (Str : Std_String_Ptr; Severity : Integer; Loc : Ghdl_Location_Ptr);

   procedure Ghdl_Report
     (Str : Std_String_Ptr; Severity : Integer; Loc : Ghdl_Location_Ptr);

   Note_Severity    : constant Integer := 0;
   Warning_Severity : constant Integer := 1;
   Error_Severity   : constant Integer := 2;
   Failure_Severity : constant Integer := 3;

   procedure Ghdl_Bound_Check_Failed_L0 (Number : Ghdl_Index_Type);
   procedure Ghdl_Bound_Check_Failed_L1 (Filename : Ghdl_C_String;
                                         Line: Ghdl_I32);

   --  Program error has occured:
   --  * configuration of an already configured block.
   procedure Ghdl_Program_Error;

   function Ghdl_Integer_Exp (V : Ghdl_I32; E : Ghdl_I32)
     return Ghdl_I32;

   function Ghdl_Malloc (Size : Ghdl_Index_Type) return Ghdl_Ptr;

   --  Allocate and clear SIZE bytes.
   function Ghdl_Malloc0 (Size : Ghdl_Index_Type) return Ghdl_Ptr;

   procedure Ghdl_Deallocate (Ptr : Ghdl_Ptr);

   function Ghdl_Real_Exp (X : Ghdl_Real; Exp : Ghdl_I32)
     return Ghdl_Real;

   --Ghdl_Assert_Default_Report : constant Std_String_Address;
private
   pragma Export (C, Ghdl_Memcpy, "__ghdl_memcpy");

   pragma Export (C, Ghdl_Assert_Failed, "__ghdl_assert_failed");
   pragma Export (C, Ghdl_Report, "__ghdl_report");

   pragma Export (C, Ghdl_Bound_Check_Failed_L0,
                  "__ghdl_bound_check_failed_l0");
   pragma Export (C, Ghdl_Bound_Check_Failed_L1,
                  "__ghdl_bound_check_failed_l1");
   pragma Export (C, Ghdl_Program_Error, "__ghdl_program_error");

   pragma Export (C, Ghdl_Malloc, "__ghdl_malloc");
   pragma Export (C, Ghdl_Malloc0, "__ghdl_malloc0");
   pragma Export (C, Ghdl_Deallocate, "__ghdl_deallocate");

   pragma Export (C, Ghdl_Integer_Exp, "__ghdl_integer_exp");
   pragma Export (C, Ghdl_Real_Exp, "__ghdl_real_exp");

   --  Create a vhdl string.
   Ghdl_Assert_Default_Report_Arr : constant String := "Assertion violation";
   Ghdl_Assert_Default_Report_Bounds : constant Std_String_Bound :=
     (Dim_1 => (Left => 1,
                Right => Ghdl_Assert_Default_Report_Arr'Length,
                Dir => Dir_To,
                Length => Ghdl_Assert_Default_Report_Arr'Length));
   Ghdl_Assert_Default_Report : constant Ghdl_Uc_Array :=
     (Base => Ghdl_Assert_Default_Report_Arr'Address,
      Bounds => Ghdl_Assert_Default_Report_Bounds'Address);

   pragma Export (C, Ghdl_Assert_Default_Report,
                  "__ghdl_assert_default_report");

end Grt.Lib;


