with Iirs; use Iirs;

--  The generic package Chain_Handling can be used to build or modify
--  chains.
--  The formals are the subprograms to get and set the first element
--   from the parent.
generic
   with function Get_Chain_Start (Parent : Iir) return Iir;
   with procedure Set_Chain_Start (Parent : Iir; First : Iir);
package Iir_Chain_Handling is

   --  Building a chain:
   --  Initialize (set LAST to NULL_IIR).
   procedure Build_Init (Last : out Iir);
   --  Set LAST with the last element of the chain.
   --  This is an initialization for an already built chain.
   procedure Build_Init (Last : out Iir; Parent : Iir);

   --  Append element EL to the chain, whose parent is PARENT and last
   --   element LAST.
   procedure Append (Last : in out Iir; Parent : Iir; El : Iir);

   --  Append a subchain whose first element is ELS to a chain, whose
   --   parent is PARENT and last element LAST.
   --   The Parent field of each elements of Els is set to PARENT.
   --  Note: the Append procedure declared just above is an optimization
   --   of this subprogram if ELS has no next element.  However, the
   --   above subprogram does not set the Parent field of EL.
   procedure Append_Subchain (Last : in out Iir; Parent : Iir; Els : Iir);
end Iir_Chain_Handling;
