// MM2UTIL.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm2util.h"
#include "mm2mdl.h"

/*################################################################################################*/

mm2_chn::mm2_chn(void)
{
	description = NULL;
	
	pdb_chn_id = '?';
	pdb_seqres = NULL;	// this indicates that there is no data!!!
}

mm2_chn::mm2_chn(const char * p1)
{
	description = NULL;
	SetDescription(p1);
	
	pdb_chn_id = '?';
	pdb_seqres = NULL;	// this indicates that there is no data!!!
}

mm2_chn::mm2_chn(const mm2_chn & p1)
{
	description = NULL;
	SetDescription(p1.description);
	
	res_vector = p1.res_vector;
	
	if (p1.pdb_seqres != NULL)
	{
		pdb_chn_id = p1.pdb_chn_id;
		
		pdb_seqres = new char[strlen(p1.pdb_seqres) + 1];
		strcpy(pdb_seqres, p1.pdb_seqres);
		
		pdb_missing_residues = p1.pdb_missing_residues;
	}
	else
	{
		pdb_chn_id = '?';
		pdb_seqres = NULL;
	}
}

mm2_chn::~mm2_chn(void)
{
	if (description != NULL) delete[] description;
	if (pdb_seqres != NULL) delete[] pdb_seqres;
}

void mm2_chn::SetDescription(const char * p1)
{
	if (description != NULL) delete[] description;
	
	if (p1 != NULL)
	{
		description = new char[strlen(p1) + 1];
		strcpy(description, p1);
	}
	else description = NULL;
}

/*################################################################################################*/

mm2_res::mm2_res(void)
{
	symbol = '?';
	state = STATE_LOOP; sel = false;
	
	natm = 0;
}

mm2_res::mm2_res(char p1, i32u p2, mm2_eng_param * prm)
{
	symbol = p1;
	state = STATE_LOOP; sel = false;
	
	switch (symbol)
	{
		case 'A': natm = 1;							// 71.1
		vdwr[0] = 0.193391;
		mass[0] = 71.1;
		break;
		
		case 'R': natm = 3;							// 156.7
		vdwr[0] = 0.222079;
		mass[0] = 53.9;		// 1.05
		
		vdwr[1] = 0.195669;
		mass[1] = 51.4;		// 1.00
		
		vdwr[2] = 0.189176;
		mass[2] = 51.4;		// 1.00
		break;
		
		case 'N': natm = 2;							// 114.1
		vdwr[0] = 0.224929;
		mass[0] = 58.4;		// 1.05
		
		vdwr[1] = 0.187591;
		mass[1] = 55.7;		// 1.00
		break;
		
		case 'D': natm = 2;							// 114.5
		vdwr[0] = 0.225038;
		mass[0] = 58.6;		// 1.05
		
		vdwr[1] = 0.187136;
		mass[1] = 55.9;		// 1.00
		break;
		
		case 'C': natm = 2;							// 103.2
		vdwr[0] = 0.229061;
		mass[0] = 51.6;		// 1.00
		
		vdwr[1] = 0.179623;
		mass[1] = 51.6;		// 1.00
		break;
		
		case 'Q': natm = 2;							// 128.2
		vdwr[0] = 0.226117;
		mass[0] = 64.1;		// 1.00
		
		vdwr[1] = 0.204211;
		mass[1] = 64.1;		// 1.00
		break;
		
		case 'E': natm = 2;							// 128.7
		vdwr[0] = 0.222040;
		mass[0] = 64.3;		// 1.00
		
		vdwr[1] = 0.191868;
		mass[1] = 64.3;		// 1.00
		break;
		
		case 'G': natm = 1;							// 57.1
		vdwr[0] = 0.173764;
		mass[0] = 57.1;
		break;
		
		case 'H': natm = 2;							// 137.7
		vdwr[0] = 0.229728;
		mass[0] = 68.9;		// 1.00
		
		vdwr[1] = 0.213733;
		mass[1] = 68.9;		// 1.00
		break;
		
		case 'I': natm = 2;							// 113.1
		vdwr[0] = 0.224550;
		mass[0] = 56.6;		// 1.00
		
		vdwr[1] = 0.180242;
		mass[1] = 56.6;		// 1.00
		break;
		
		case 'L': natm = 2;							// 113.1
		vdwr[0] = 0.220761;
		mass[0] = 56.6;		// 1.00
		
		vdwr[1] = 0.182951;
		mass[1] = 56.6;		// 1.00
		break;
		
		case 'K': natm = 3;							// 129.2
		vdwr[0] = 0.222174;
		mass[0] = 49.7;		// 1.25
		
		vdwr[1] = 0.184924;
		mass[1] = 39.8;		// 1.00
		
		vdwr[2] = 0.199069;
		mass[2] = 39.8;		// 1.00
		break;
		
		case 'M': natm = 2;							// 131.2
		vdwr[0] = 0.230562;
		mass[0] = 65.6;		// 1.00
		
		vdwr[1] = 0.221798;
		mass[1] = 65.6;		// 1.00
		break;
		
		case 'F': natm = 2;							// 147.2
		vdwr[0] = 0.224414;
		mass[0] = 68.5;		// 1.00
		
		vdwr[1] = 0.198277;
		mass[1] = 78.7;		// 1.15
		break;
		
		case 'P': natm = 1;							// 97.1
		vdwr[0] = 0.210783;
		mass[0] = 97.1;
		break;
		
		case 'S': natm = 1;							// 87.1
		vdwr[0] = 0.204505;
		mass[0] = 87.1;
		break;
		
		case 'T': natm = 1;							// 101.1
		vdwr[0] = 0.214132;
		mass[0] = 101.1;
		break;
		
		case 'W': natm = 3;							// 188.2
		vdwr[0] = 0.232409;
		mass[0] = 62.7;		// 1.00
		
		vdwr[1] = 0.233762;
		mass[1] = 62.7;		// 1.00
		
		vdwr[2] = 0.225098;
		mass[2] = 62.7;		// 1.00
		break;
		
		case 'Y': natm = 2;							// 163.2
		vdwr[0] = 0.224633;
		mass[0] = 72.5;		// 1.00
		
		vdwr[1] = 0.198270;
		mass[1] = 90.6;		// 1.25
		break;
		
		case 'V': natm = 1;							// 99.1
		vdwr[0] = 0.213718;
		mass[0] = 99.1;
		break;
		
		default:
		cout << "bad problems: unknown residue " << symbol << " !!!" << endl;
		exit(EXIT_FAILURE);
	}
	
	for (i32u n1 = 0;n1 < natm;n1++)
	{
		vdwr[n1] *= prm->vdwrad;
	}
	
	charge[0] = charge[1] = charge[2] = 0.0;
	sasa[0] = sasa[1] = sasa[2] = 0.0;

	label[0] = label[1] = label[2] = 0.0;
	
	// coordinates and dipoles are not handled here...
	// coordinates and dipoles are not handled here...
	// coordinates and dipoles are not handled here...
	
	fGL data1 = 0.0;
	fGL_a3 data2 = { 0.0, 0.0, 0.0 };
	
	for (i32u n1 = 0;n1 < p2;n1++)
	{
		peptide_vector.push_back(data1);
		
		for (i32u n2 = 0;n2 < natm;n2++)
		{
			crd_vector[n2].push_back(data2);
		}
	}
}

mm2_res::mm2_res(const mm2_res & p1)
{
	symbol = p1.symbol;
	state = p1.state; sel = p1.sel;
	
	natm = p1.natm;
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		mass[n1] = p1.mass[n1];
		vdwr[n1] = p1.vdwr[n1];
		
		charge[n1] = p1.charge[n1];
		sasa[n1] = p1.sasa[n1];
		
		label[n1] = p1.label[n1];
	}
	
	peptide_vector = p1.peptide_vector;
	
	crd_vector[0] = p1.crd_vector[0];
	crd_vector[1] = p1.crd_vector[1];
	crd_vector[2] = p1.crd_vector[2];
}

mm2_res::~mm2_res(void)
{
}

/*################################################################################################*/

mm2_atm::mm2_atm(void)
{
	data = 0;
}

mm2_atm::mm2_atm(i32u p1, i32u p2, i32u p3)
{
	data = (p1 << 20) + (p2 << 4) + p3;
}

mm2_atm::~mm2_atm(void)
{
}

i32u mm2_atm::operator[](i32s p1) const
{
	switch (p1)
	{
		case 0:		return (data & 0xFFF00000) >> 20;
		case 1:		return (data & 0x000FFFF0) >> 4;
		case 2:		return (data & 0x0000000F);
		default:	return 0;
	}
}

bool mm2_atm::operator==(const mm2_atm & p1) const
{
	return (data == p1.data);
}

/*################################################################################################*/

// eof
