// T1M_MM2PARAM.H : the simplified protein model parametrization.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

class ddsolver;

/*################################################################################################*/

#include "mm2mdl.h"
#include "mm2eng.h"
#include "mm2alg.h"

#include "mm1mdl.h"

/*################################################################################################*/

class ddsolver : public conjugate_gradient
{
	public:
	
	f64 var[8]; f64 dvar[8];
	f64 * xdata; f64 * ydata; f64 * ycount;
	
	public:
	
	ddsolver(i32s, f64 *, f64 *, f64 *);
	~ddsolver(void);
	
	f64 GetValue(void);
};

/*################################################################################################*/

class decoys_ddata
{
	public:
	
	decoys_ddata(istream &);
	~decoys_ddata(void);
	
	public:
	
	static const f64 scale;
	
	private:
	
	char type;
	
	f64 energy_bt[4];
	f64 energy_nbt[5];
	i32s hdata[20];
	i32s sdata[20];
	i32s ldata[20];
	
	char * name;
	
	f64 RMSdistance;
	
	friend class decoys_dset;
	friend class decoys_opt;
};

class decoys_dset
{
	public:
	
	decoys_dset(void);
	~decoys_dset(void);
	
	void AddData(decoys_ddata *);
	
	void UpdateRMS(void);
	void WriteScatter(ofstream &);
	
	void Compute(i32s);
	
//	private:
	public:		// FIXME
	
	static f64 f;
	
	static i32u badcount;
	static i32u totcount;
	
	static f64 df_bterms[4];
	static f64 df_nbterms[5];
	static f64 df_helix[20];
	static f64 df_strand[20];
	static f64 df_loop[20];
	
	static f64 w_bterms[4];
	static f64 w_nbterms[5];
	static f64 w_helix[20];
	static f64 w_strand[20];
	static f64 w_loop[20];
	
	vector<decoys_ddata *> dd_vector;
	
	friend class decoys_opt;
};

class decoys_opt : public conjugate_gradient
{
	public:
	
	decoys_opt(void);
	~decoys_opt(void);
	
	void AddFile(const char *);
	void ClearAll(void);
	
	void UpdateRMS(void);
	void WriteScatter(ofstream &);
	
	void Compute(i32s);
	void Check(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
	
	void PrintResults(ostream &);
	
	private:
	
	vector<decoys_dset *> ds_vector;
};

/*################################################################################################*/

struct rms_param
{
	i32s osteps;
	
	i32s cfrq; i32s csize;
	i32s start; i32s equil; i32s simul;
	
	f64 temp; f64 timestep;
};

f64 getRMSdistance(char *, rms_param *, mm2_eng_param *);

/*################################################################################################*/

// eof
