// MOLDYN_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "moldyn_dialog.h"

#include <gtk/gtk.h>

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

moldyn_dialog::moldyn_dialog(moldyn_param * p1) : glade_dialog("glade/moldyn_dialog.glade")
{
	param = p1;
	
	dialog = glade_xml_get_widget(xml, "moldyn_dialog");
	if (dialog == NULL) { cout << "moldyn_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// initialize the widgets...
	
	entry_nsteps_h = glade_xml_get_widget(xml, "entry_nsteps_h");
	entry_nsteps_e = glade_xml_get_widget(xml, "entry_nsteps_e");
	entry_nsteps_s = glade_xml_get_widget(xml, "entry_nsteps_s");
	entry_temperature = glade_xml_get_widget(xml, "entry_temperature");
	entry_timestep = glade_xml_get_widget(xml, "entry_timestep");
	checkbutton_constant_e = glade_xml_get_widget(xml, "checkbutton_constant_e");
	checkbutton_langevin = glade_xml_get_widget(xml, "checkbutton_langevin");
	
	entry_trajfile = glade_xml_get_widget(xml, "entry_trajfile");
	button_browse = glade_xml_get_widget(xml, "button_browse");
	file_selector = NULL;
	
	char buffer[64];
	
	ostrstream str_nsteps_h(buffer, sizeof(buffer));
	str_nsteps_h << param->nsteps_h << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_nsteps_h), buffer);

	ostrstream str_nsteps_e(buffer, sizeof(buffer));
	str_nsteps_e << param->nsteps_e << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_nsteps_e), buffer);

	ostrstream str_nsteps_s(buffer, sizeof(buffer));
	str_nsteps_s << param->nsteps_s << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_nsteps_s), buffer);
	
	ostrstream str_grad(buffer, sizeof(buffer));
	str_grad << param->temperature << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_temperature), buffer);
	
	ostrstream str_delta_e(buffer, sizeof(buffer));
	str_delta_e << param->timestep << ends;
	gtk_entry_set_text(GTK_ENTRY(entry_timestep), buffer);
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_constant_e), (param->constant_e ? TRUE : FALSE));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_langevin), (param->langevin ? TRUE : FALSE));
	
	gtk_entry_set_text(GTK_ENTRY(entry_trajfile), param->filename);
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);

	glade_xml_signal_connect_data(xml, "on_button_ok_clicked", (GtkSignalFunc) handler_ButtonOK, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_browse_clicked", (GtkSignalFunc) handler_ButtonBrowse, (gpointer) this);
	
 	gtk_dialog_run(GTK_DIALOG(dialog));	// MODAL
	gtk_widget_destroy(dialog);		// MODAL
}

moldyn_dialog::~moldyn_dialog(void)
{
}

void moldyn_dialog::handler_Destroy(GtkWidget *, gpointer data)			// not really needed...
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	//cout << "handler_Destroy() : ref = " << ref << endl;
}

void moldyn_dialog::handler_ButtonOK(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	//cout << "handler_ButtonOK() : ref = " << ref << endl;
	
	// read the user's settings from widgets...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	const gchar * buffer;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_nsteps_h));
	istrstream istr1a(buffer, strlen(buffer) + 1);
	istr1a >> ref->param->nsteps_h;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_nsteps_e));
	istrstream istr1b(buffer, strlen(buffer) + 1);
	istr1b >> ref->param->nsteps_e;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_nsteps_s));
	istrstream istr1c(buffer, strlen(buffer) + 1);
	istr1c >> ref->param->nsteps_s;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_temperature));
	istrstream istr2(buffer, strlen(buffer) + 1);
	istr2 >> ref->param->temperature;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_timestep));
	istrstream istr3(buffer, strlen(buffer) + 1);
	istr3 >> ref->param->timestep;
	
	buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_trajfile));
	strcpy(ref->param->filename, buffer);
	
	ref->param->constant_e = (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ref->checkbutton_constant_e)) == TRUE ? true : false);
	ref->param->langevin = (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ref->checkbutton_langevin)) == TRUE ? true : false);
	
	ref->param->confirm = true;
}

void moldyn_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)		// not really needed...
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	//cout << "handler_ButtonCancel() : ref = " << ref << endl;
}

void moldyn_dialog::handler_ButtonBrowse(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	//cout << "handler_ButtonBrowse() : ref = " << ref << endl;
	
	// handle the file selection...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	ref->file_selector = gtk_file_selection_new("Select a Trajectory File.");
	g_signal_connect(GTK_FILE_SELECTION(ref->file_selector)->ok_button, "clicked", G_CALLBACK(handler_FileChooser), data);
	
	g_signal_connect_swapped(GTK_FILE_SELECTION(ref->file_selector)->ok_button, "clicked", G_CALLBACK(gtk_widget_destroy), ref->file_selector);
	g_signal_connect_swapped(GTK_FILE_SELECTION(ref->file_selector)->cancel_button, "clicked", G_CALLBACK(gtk_widget_destroy), ref->file_selector);
	
	gtk_dialog_run(GTK_DIALOG(ref->file_selector)); ref->file_selector = NULL;
}

void moldyn_dialog::handler_FileChooser(GtkWidget *, gpointer data)
{
	moldyn_dialog * ref = (moldyn_dialog *) data;
	//cout << "handler_FileChooser() : ref = " << ref << endl;
	
	// save the selected filename...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	const gchar * selected_filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(ref->file_selector));
	gtk_entry_set_text(GTK_ENTRY(ref->entry_trajfile), selected_filename);
}

/*################################################################################################*/

// eof
