// GAMESS.H

// Copyright (C) 2006 Donald Curtis, Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef __GAMESS_H
#define __GAMESS_H

#include <list>
#include <atom.h>

#include <string>

#include <glib.h>

typedef list<atom*>::iterator iter_alp;

class EFPGroup
{

	public:

	enum type { EFP = 0, QM, NUM_TYPES };

	EFPGroup();
	EFPGroup(string);
	EFPGroup(const char *);

	iter_alp GetAtomsBegin(void) { return atom_list.begin(); }
	iter_alp GetAtomsEnd(void) { return atom_list.end(); }

	bool AddAtom(atom*);
	EFPGroup::type GetType(void) { return t; }
	void SetType(EFPGroup::type p) { t = p; }
	char * GetAtomListString(const char *);
	char * GetTypeString();
	fGL * GetCenterOfMass();
	string GetLabel();
	void SetLabel(string);
	bool Contains(atom*);
	void Sort(void) { atom_list.sort(); }
	//void Sort( bool (*func)(const atom*, const atom*) ) { std::sort(atom_list.begin(), atom_list.end(), func); }
	
	bool operator==(EFPGroup &);
	
	protected:

	EFPGroup::type t;
	list<atom*> atom_list;
	string label;

};

typedef list<EFPGroup>::iterator iter_efpgl;       // efpgl = EFP Group List

class EFPData
{
	protected:

	list<EFPGroup> group_list;

	public:

	EFPData();

	iter_efpgl GetGroupBegin(void) { return group_list.begin(); }
	iter_efpgl GetGroupEnd(void) { return group_list.end(); }
	int GetGroupCount(EFPGroup::type type);
	int GetGroupCount(void) { return group_list.size(); }
	bool AddGroup(EFPGroup &);
	bool RemoveGroup(iter_efpgl);
	
	bool operator==(const EFPData &) const;
};

class GamessData 
{
	protected:

	EFPData efp_data;

	public:

	GamessData();

	EFPData * GetEFPData();
};



#endif  // __GAMESS_H
