// W32_OGLVIEW_WND.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "w32_oglview_wnd.h"

#include "oglview_wcl.h"

#include "w32_app.h"
#include "res_w32/resource.h"

//#include "w32_project.h"
#include "w32_command_dialog.h"

#include <ghemical/utility.h>

/*################################################################################################*/

w32_oglview_wnd::w32_oglview_wnd(void) :
	w32_wnd()
{
	my_popup = LoadMenu(w32_app::GetHINST(), MAKEINTRESOURCE(IDR_MENU2));
	if (my_popup != NULL) my_popup = GetSubMenu(my_popup, 0);
	
	timer_id = NULL;
}

w32_oglview_wnd::~w32_oglview_wnd(void)
{
	if (timer_id != NULL) SetTimerOFF();
}

bool w32_oglview_wnd::IsTimerON(void)
{
	return (timer_id != NULL);
}

void w32_oglview_wnd::SetTimerON(int msec)
{
	timer_id = SetTimer(my_hwnd, 1, msec, NULL);
}

void w32_oglview_wnd::SetTimerOFF(void)
{
	if (timer_id != NULL) KillTimer(my_hwnd, timer_id);
	timer_id = NULL;
}

// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here

void w32_oglview_wnd::popup_ProjOrthographic(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	wcl->cam->ortho = true;
	//wcl->cam->stereo_mode = false;
	//wcl->cam->stereo_relaxed = false;
	
	w32_app::GetPrjX()->UpdateGraphicsViews(wcl->cam);
}

void w32_oglview_wnd::popup_ProjPerspective(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	wcl->cam->ortho = false;
	//wcl->cam->stereo_mode = false;
	//wcl->cam->stereo_relaxed = false;
	
	w32_app::GetPrjX()->UpdateGraphicsViews(wcl->cam);
}

void w32_oglview_wnd::popup_ProjSterRedBlue(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	w32_oglview_wnd * xwnd = dynamic_cast<w32_oglview_wnd *>(wnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	// this works as a toggle item!!!
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if (wcl->cam->stereo_mode && !wcl->cam->stereo_relaxed)
	{
		wcl->cam->stereo_mode = false;		// turn OFF..
		wcl->cam->stereo_relaxed = false;
		
	/*	if (xwnd->my_stereo_dialog)
		{
			gtk_stereo_dialog * tmpdlg = xwnd->my_stereo_dialog;
			xwnd->my_stereo_dialog = NULL;	// disconnect...
			
			tmpdlg->CloseDialog();
			delete tmpdlg;
		}	*/
	}
	else
	{
		wcl->cam->stereo_mode = true;		// turn ON!!!
		wcl->cam->stereo_relaxed = false;
		
	/*	if (!xwnd->my_stereo_dialog) xwnd->my_stereo_dialog = new gtk_stereo_dialog(xwnd);
		xwnd->my_stereo_dialog->SetScaling(0.25);	*/
	}
	
	w32_app::GetPrjX()->UpdateGraphicsViews(wcl->cam);
}

void w32_oglview_wnd::popup_ProjSterRelaxed(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	w32_oglview_wnd * xwnd = dynamic_cast<w32_oglview_wnd *>(wnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	// this works as a toggle item!!!
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if (wcl->cam->stereo_mode && wcl->cam->stereo_relaxed)
	{
		wcl->cam->stereo_mode = false;		// turn OFF..
		wcl->cam->stereo_relaxed = false;
		
	/*	if (xwnd->my_stereo_dialog)
		{
			gtk_stereo_dialog * tmpdlg = xwnd->my_stereo_dialog;
			xwnd->my_stereo_dialog = NULL;	// disconnect...
			
			tmpdlg->CloseDialog();
			delete tmpdlg;
		}	*/
	}
	else
	{
		wcl->cam->stereo_mode = true;		// turn ON!!!
		wcl->cam->stereo_relaxed = true;
		
	/*	if (!xwnd->my_stereo_dialog) xwnd->my_stereo_dialog = new gtk_stereo_dialog(xwnd);
		xwnd->my_stereo_dialog->SetScaling(0.50);	*/
	}
	
	w32_app::GetPrjX()->UpdateGraphicsViews(wcl->cam);
}

void w32_oglview_wnd::popup_RenderQuickUpdate(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	wcl->quick_update = !wcl->quick_update;
}

void w32_oglview_wnd::popup_ViewsNewWnd(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	bool detached = true;
	
	w32_app::GetPrjX()->AddGraphicsClient(wcl->ccam, detached);
}

void w32_oglview_wnd::popup_ViewsNewCam(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	bool detached = true;
	
	w32_app::GetPrjX()->AddGraphicsClient(NULL, detached);
}

void w32_oglview_wnd::popup_ViewsDeleteView(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	w32_app::GetPrjX()->RemoveGraphicsClient(wcl, false);
}

void w32_oglview_wnd::popup_ViewsPushCRDSet(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
w32_project * prjX = w32_app::GetPrjX();
	
	prjX->PushCRDSets(1);
	
	i32s tmp1 = ((i32s) prjX->GetCRDSetCount()) - 1;
	while (tmp1 > 0) { prjX->CopyCRDSet(tmp1 - 1, tmp1); tmp1 -= 1; }
	
	int last_crdset = ((int) prjX->GetCRDSetCount()) - 1;
	prjX->SetCRDSetVisible(last_crdset, true);
	prjX->UpdateAllGraphicsViews();
}

void w32_oglview_wnd::popup_ViewsSuperimpose(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
#ifdef ENABLE_OPENBABEL
base_app::GetAppB()->ErrorMessage("\
FIXME : superimpose conflicts with openbabel?\n\
g++ (GCC) 3.3.5 (Debian 1:3.3.5-13) 20050701\n\
compiler says superimpose is undeclared???");
#else
	f64 sum = 0.0;
	for (i32s n1 = 1;n1 < (i32s) custom_app::GetPrj()->GetCRDSetCount();n1++)
	{
		superimpose si(custom_app::GetPrj(), 0, n1);
		
		for (i32s n2 = 0;n2 < 100;n2++)
		{
			si.TakeCGStep(conjugate_gradient::Newton2An);
		}
		
		f64 rms = si.GetRMS(); sum += rms;
		cout << "sets 0 <-> " << n1 << " RMS = " << rms << endl;
		
		si.Transform();		// modify the coordinates!!!
	}
	
	f64 average = sum / ((f64) custom_app::GetPrj()->GetCRDSetCount() - 1);
	cout << "average RMS = " << average << endl;
#endif	// ENABLE_OPENBABEL
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_oglview_wnd::popup_LightsNewLight(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	oglview_wcl * wcl = dynamic_cast<oglview_wcl *>(wnd->GetClient());
	
	static const char command[] = "add light";
	w32_command_dialog * d = new w32_command_dialog(wcl, command);
	delete d; d = NULL;
}

void w32_oglview_wnd::popup_LightsSwitchLoc(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	custom_app::GetPrj()->DoSwitchLocalLights(wnd->GetClient()->GetCam(), false);
}

void w32_oglview_wnd::popup_LightsSwitchGlob(HWND hwnd)
{
	w32_wnd * wnd = iv_Find(hwnd);
	custom_app::GetPrj()->DoSwitchGlobalLights(wnd->GetClient()->GetCam(), false);
}

/*################################################################################################*/

// eof
