#include "log.h"
#include "socket.h"
#include "system.h"
#include "config.h"
#include "parse.h"
#include "request.h"

int main(int argc, char **argv)
{
	GetConfig(argc, argv);
	
	inetd=config.inetd==0?IsInetd():config.inetd==1;
	
	if(inetd) SetInetdSocket(); // get ready for inetd use
	LogOpen(config.logfile); // open logfile
	if(inetd) CloseFiles(2); // close open files
	else {
		Log("gidentd v%s started in daemon mode.", VERSION);
		BgProcess(); // close open files && become daemon
		OpenListenSock(config.port, config.forcev4); // open listening sock
	}
	SetSigs(); // set signal handler
	
	while(NewConn());
	while(!Handle_Request(ReadLine()));
	
	return(0);
}
