/*                                                         -*- c++ -*-
 * Copyright (C) 2007-2015 Andreas Persson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

#ifndef GIGEDIT_GLOBAL_H
#define GIGEDIT_GLOBAL_H

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <sstream>

//FIXME: for some reason AC GETTEXT check fails on the Mac cross compiler?
#if (HAVE_GETTEXT || defined(__APPLE__))
# include <libintl.h>
# define _(String) gettext(String)
#else
# define _(String) String
#endif

#if defined(WIN32) && !HAVE_CONFIG_H
# include "../../win32/libgigedit_private.h" // like config.h, automatically generated by Dev-C++
# define PACKAGE "gigedit"
# define VERSION VER_STRING // VER_STRING defined in libgig_private.h
#endif // WIN32

#define UNICODE_RIGHT_ARROW     Glib::ustring(1, gunichar(0x2192))
#define UNICODE_LEFT_ARROW      Glib::ustring(1, gunichar(0x2190))

template<class T> inline std::string ToString(T o) {
    std::stringstream ss;
    ss << o;
    return ss.str();
}

/// Find the number of bits required to hold the specified amount of zones.
inline int zoneCountToBits(int nZones) {
    if (!nZones) return 0;
    int iFinalBits = 0;
    int zoneBits = nZones - 1;
    for (; zoneBits > 1; iFinalBits += 2, zoneBits >>= 2);
    iFinalBits += zoneBits;
    return iFinalBits;
}

#endif // GIGEDIT_GLOBAL_H
