/*
 *  
 *  $Id: iexception.h 4782 2012-03-08 11:01:25Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <string>
#include <exception>
#include <ostream>

#include <api/api.h>
#include <api/internacionalization/internacionalization.h>

namespace GNC {
	namespace GCS {
		class EXTAPI IException : public std::exception {
		public:
			IException(const std::string& msg, const std::string& component="GNC", bool fatal = true) throw();

			virtual ~IException() throw();

			const std::string& GetComponent() const;

			const std::string& GetCause() const;

			virtual const char* what() const throw();

			std::string GetFullCause() const;

			bool IsFatal()  const;

			operator std::string () const;

			friend std::ostream& operator<<(std::ostream& out, const IException& ex)
			{
				return (out << (std::string) ex);
			}

			friend std::ostream& operator<<(std::ostream& out, const IException* ex)
			{
				if (ex != NULL) {
					out << *ex;
				}
				else {
					out << "(NULL)";
				}
				return out;
			}
			
		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};
		
	}
}
