/*
 *  
 *  $Id: xmlrpccontroller.h 4670 2012-02-08 07:11:51Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <wx/thread.h>

namespace XmlRpc {
	class XmlRpcServer;
	class GinkgoLogHandler;
}

namespace GIL {
	namespace XMLRPC {
		class EXTAPI XMLRPCController: protected wxThread
		{
		public:
			static void FreeInstance();
			static void StartServer();

		protected:
			static XMLRPCController* m_pInstance;
			static wxCriticalSection m_criticalSection;

			void Abort();
			virtual void* Entry();

			XMLRPCController();
			~XMLRPCController();

			XmlRpc::XmlRpcServer* m_pServer;
			XmlRpc::GinkgoLogHandler* m_pLogHandler;
		};
	}
}
