/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <main/controllers/configurationcontroller.h>
#include "icontroladormodulo.h"
#include <wx/bitmap.h>
#define TAG_WIDGETS					    0xb
#define UID_TAGS_PRIVADOS_COMUNES	 "100"

GNC::GCS::IControladorModulo::IControladorModulo(GNC::GCS::IEntorno* pEntorno, const std::string& uid, int priority)
{
	m_pEntorno       = pEntorno;
	m_UID            = uid;
	m_VersionMayor   = 0;
	m_VersionMinor   = 0;
	m_VersionRelease = 0;
	m_Bitmap         = NULL;
	m_priority = priority;
	GTRACE("IControladorModulo::IControladorModulo( " << m_UID << " )");
}

/* Destructor */
GNC::GCS::IControladorModulo::~IControladorModulo()
{
	GTRACE(">>IControladorModulo::~IControladorModulo( " << m_UID << " )");
	GTRACE("<<IControladorModulo::~IControladorModulo( " << m_UID << " )");
}

void GNC::GCS::IControladorModulo::RegistrarConfiguracion()
{
	bool written = false;

	std::string key;
	std::string val;

	GNC::GCS::ConfigurationController * pConfig = GNC::GCS::ConfigurationController::Instance();

	for (TipoListaIdsHL7::iterator it = m_ListaInformes.begin(); it != m_ListaInformes.end(); it++)
	{
		const IdHL7& i = *it;

		key = i.etiqueta;
		if ( !pConfig->readStringGeneral("/GinkgoCore/HCE/Plantillas",key, val)) {
			pConfig->writeStringGeneral("/GinkgoCore/HCE/Plantillas",key,(const std::string)i);
			written = true;
		}
	}

	for (TipoMapaIdsHL7::iterator it = m_ListaEstudios.begin(); it != m_ListaEstudios.end(); it++)
	{
		IdHL7& i = (*it).second;

		std::ostringstream ostr;
		ostr << "/GinkgoCore/HCE/" << m_UID << i.version << "/" << i.etiqueta;
		std::string scope = ostr.str();

		key = "Codigo";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.codigo);
			written = true;
		}
		else {
			i.codigo = std::string(val);
		}
		key = "Descripcion";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.descripcion);
			written = true;
		}
		else {
			i.descripcion = std::string(val);
		}
		key = "NamespaceID";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.namespaceid);
			written = true;
		}
		else {
			i.namespaceid = std::string(val);
		}
		key = "TipoOBX";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.tipoobservacion);
			written = true;
		}
		else {
			i.tipoobservacion = std::string(val);
		}
	}

	for (TipoMapaIdsHL7::iterator it = m_ListaRegistros.begin(); it != m_ListaRegistros.end(); it++)
	{
		IdHL7& i = (*it).second;

		std::ostringstream ostr;
		ostr << "/GinkgoCore/HCE/" << m_UID << i.version << "/" << i.etiqueta;
		std::string scope = ostr.str();

		key = "Codigo";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.codigo);
			written = true;
		}
		else {
			i.codigo = std::string(val);
		}
		key = "Descripcion";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.descripcion);
			written = true;
		}
		else {
			i.descripcion = std::string(val);
		}
		key = "NamespaceID";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.namespaceid);
			written = true;
		}
		else {
			i.namespaceid = std::string(val);
		}
		key = "TipoOBX";
		if ( !pConfig->readStringGeneral(scope, key, val) ) {
			pConfig->writeStringGeneral(scope,key,i.tipoobservacion);
			written = true;
		}
		else {
			i.tipoobservacion = std::string(val);
		}
	}

	if (written) {
		pConfig->Flush();
	}

}

const GNC::GCS::IdHL7 GNC::GCS::IControladorModulo::GetIdEstudioHL7(const std::string& key) const
{

	IdHL7 id;

	TipoMapaIdsHL7::const_iterator it = m_ListaEstudios.find(key);
	if (it != m_ListaEstudios.end()) {
		return (*it).second;
	}
	return id;
}

const GNC::GCS::IdHL7 GNC::GCS::IControladorModulo::GetIdRegistroHL7(const std::string& key) const
{
	IdHL7 id;
	TipoMapaIdsHL7::const_iterator it = m_ListaRegistros.find(key);
	if (it != m_ListaRegistros.end()) {
		return (*it).second;
	}
	return id;

}

void GNC::GCS::IControladorModulo::GetTagsPrivadosReplace(GNC::GCS::IControladorModulo::TMapaTagsPrivados& mapaTags)
{
	if (mapaTags.find(UID_TAGS_PRIVADOS_COMUNES) == mapaTags.end()) {
		mapaTags[UID_TAGS_PRIVADOS_COMUNES] = TListaIdsTagsPrivados();
	}

	mapaTags[UID_TAGS_PRIVADOS_COMUNES].push_back(GNC::GCS::IControladorModulo::TPrivateTagReemplazable(TAG_WIDGETS, GNC::GCS::IControladorModulo::TPrivateTagReemplazable::XML));
}

GNC::GCS::IContextoEstudio::TModoFuncionamiento GNC::GCS::IControladorModulo::GetDiagnosticMode()
{
	return GNC::GCS::IContextoEstudio::TMF_UNDiagnostico;
}


bool GNC::GCS::IControladorModulo::SupportsImportationUID(const std::string &)
{
	return false;
}
