/*
*  
*  $Id: progresocomando.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

namespace GNC {
	namespace GCS {

		class IComando;

		namespace Eventos {

			class EXTAPI EventoProgresoComando : public GNC::GCS::Eventos::IEvento
			{
			public:

				typedef enum
				{
					TEP_Iniciado,
					TEP_Progreso,
					TEP_Finalizado,
					TEP_Unknown
				} TipoEventoProgreso;

				EventoProgresoComando(IComando* pComando = NULL, TipoEventoProgreso tipo = TEP_Unknown, float progresoNormalizado = 0.0f, const std::string& texto = "", void* pOwner = NULL) : GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_ProgresoComando, 0, 100, NULL)
				{
					m_Nombre = "ProgresoComando";
					m_pComando = pComando;
					m_Tipo = tipo;
					m_ProgresoNormalizado = progresoNormalizado;
					m_Texto = texto;
					m_pOwner = pOwner;
				}

				~EventoProgresoComando()
				{
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "Tipo = ";
					switch (m_Tipo) {
						case TEP_Iniciado:
							out << "Iniciado";
							break;
						case TEP_Progreso:
							out << "Progreso";
							break;
						case TEP_Finalizado:
							out << "Finalizado";
							break;
						case TEP_Unknown:
						default:
							out << "Unknown";
					}
					out << ", Progreso = " << m_ProgresoNormalizado << ", Texto = " << m_Texto << ", Comando = " << m_pComando;
				}

				IComando* GetComando() const
				{
					return m_pComando;
				}

				void* GetOwner() const 
				{
					return m_pOwner;
				}

				void SetOwner(void * pOwner)
				{
					m_pOwner = pOwner;
				}

				TipoEventoProgreso GetTipo() const
				{
					return m_Tipo;
				}

				float GetProgresoNormalizado() const
				{
					return m_ProgresoNormalizado;
				}

				const std::string& GetTexto() const
				{
					return m_Texto;
				}

			protected:
				GNC::GCS::IComando*             m_pComando;
				TipoEventoProgreso              m_Tipo;
				float                           m_ProgresoNormalizado;
				std::string                     m_Texto;
				void *								  m_pOwner;

			};

		}
	}
}
