/*
 *  
 *  $Id: ginkgoresourcemanager.cpp 3756 2011-04-25 08:57:12Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "ginkgoresourcemanager.h"

#include "adquisicion/iconos.h"
#include "barraangulo/iconos.h"
#include "barrachroma/iconos.h"
#include "barraelevacion/iconos.h"
#include "barralupa/iconos.h"
#include "barrarejilla/iconos.h"
#include "barrawindowlevel/iconos.h"
#include "barramarcado/iconos.h"
#include "historial/iconos.h"
#include "iconosherramientas/iconos.h"
#include "iconosmenus/iconos.h"
#include "logos/iconos.h"
#include "cursores/iconos.h"
#include "barraprogreso/iconos.h"
#include "wizards/ico_barra_superior.h"
#include "barralayout/iconos.h"
#include "menustabs/iconos.h"
#include <api/globals.h>

#include <wx/mstream.h>
#include <wx/image.h>

#define wxMEMORY_IMAGE( name ) _wxConvertMemoryToImage( name, sizeof( name ) )
#define wxMEMORY_IMAGEEX( name, type ) _wxConvertMemoryToImage( name, sizeof( name ), type )
#define wxMEMORY_BITMAP( name ) _wxConvertMemoryToBitmap( name, sizeof( name ) )
#define wxMEMORY_BITMAPEX( name, type ) _wxConvertMemoryToBitmap( name, sizeof( name ), type )

inline wxImage _wxConvertMemoryToImage(const unsigned char* data, int length, long type = wxBITMAP_TYPE_ANY )
{
	wxMemoryInputStream stream( data, length );
	return wxImage( stream, type, -1 );
}

inline wxBitmap _wxConvertMemoryToBitmap(const unsigned char* data, int length, long type = wxBITMAP_TYPE_ANY )
{
	wxMemoryInputStream stream( data, length );
	return wxBitmap( wxImage( stream, type, -1 ), -1 );
}


// Adquisicion
const wxBitmap GinkgoResourcesManager::Adquisicion::GetIcoAdquirirArchivo() {return wxMEMORY_BITMAP(ico_adquirir_archivo); }
const wxBitmap GinkgoResourcesManager::Adquisicion::GetIcoAdquirirPACS(){return wxMEMORY_BITMAP(ico_adquirir_pacs); }
const wxBitmap GinkgoResourcesManager::Adquisicion::GetIcoDownload(){return wxMEMORY_BITMAP(ico_download); }
const wxBitmap GinkgoResourcesManager::Adquisicion::GetIcoClear(){return wxMEMORY_BITMAP(ico_clear); }
const wxBitmap GinkgoResourcesManager::Adquisicion::GetIcoEliminarDescarga(){return wxMEMORY_BITMAP(ico_eliminar_descarga); }

// Barra Angulo
const wxBitmap GinkgoResourcesManager::BarraAngulo::GetIcoAnguloCobb(){return wxMEMORY_BITMAP(ico_angulo_cobb); }
const wxBitmap GinkgoResourcesManager::BarraAngulo::GetIcoAnguloNormal(){return wxMEMORY_BITMAP(ico_angulo_normal); }


// Barra Chroma
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoAmbitoGlobal(){return wxMEMORY_BITMAP(ico_ambito_global); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoAmbitoLocal(){return wxMEMORY_BITMAP(ico_ambito_local); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoChroma(){return wxMEMORY_BITMAP(ico_chroma); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoInvertir(){return wxMEMORY_BITMAP(ico_invertir); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoPiel(){return wxMEMORY_BITMAP(ico_piel); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoTodoChroma(){return wxMEMORY_BITMAP(ico_todo_chroma); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetIcoTodoPiel(){return wxMEMORY_BITMAP(ico_todo_piel); }
const wxBitmap GinkgoResourcesManager::BarraChroma::GetTodosChroma(){return wxMEMORY_BITMAP(ico_todo_chroma); }

// Barra Elevacion
const wxBitmap GinkgoResourcesManager::BarraElevacion::GetIcoAumentarValoracion(){return wxMEMORY_BITMAP(ico_aumentar_valoracion); }
const wxBitmap GinkgoResourcesManager::BarraElevacion::GetIcoDisminuirValoracion(){return wxMEMORY_BITMAP(ico_disminuir_valoracion); }

// Barra Lupa
const wxBitmap GinkgoResourcesManager::BarraLupa::GetIcoZoomIn(){return wxMEMORY_BITMAP(ico_zoom_in); }
const wxBitmap GinkgoResourcesManager::BarraLupa::GetIcoZoomOut(){return wxMEMORY_BITMAP(ico_zoom_out); }

// Barra Rejilla
const wxBitmap GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla(){return wxMEMORY_BITMAP(ico_ver_rejilla); }
const wxBitmap GinkgoResourcesManager::BarraRejilla::GetIcoOcultarRejilla(){return wxMEMORY_BITMAP(ico_ocultar_rejilla); }

// Barra WindowLevel
const wxBitmap GinkgoResourcesManager::BarraWindowLevel::GetIcoReset(){return wxMEMORY_BITMAP(ico_reset_wl); }

// Barra Marcado
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoElipse() {return wxMEMORY_BITMAP(ico_elipse_marcado);}
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoFlecha() {return wxMEMORY_BITMAP(ico_flecha_marcado);}
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoPoligono() {return wxMEMORY_BITMAP(ico_poligono_marcado);}
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoPunto() {return wxMEMORY_BITMAP(ico_punto_marcado);}
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoRectangulo() {return wxMEMORY_BITMAP(ico_rectangulo_marcado);}
const wxBitmap GinkgoResourcesManager::BarraMarcado::GetIcoTrapezoide() {return wxMEMORY_BITMAP(ico_rectangulo_marcado);}

// Panel Historial
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoEstudio(){return wxMEMORY_BITMAP(ico_estudio); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoSerie(){return wxMEMORY_BITMAP(ico_serie); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoImagen(){return wxMEMORY_BITMAP(ico_imagen); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoHistorial(){return wxMEMORY_BITMAP(historial); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoHistorialOpen(){return wxMEMORY_BITMAP(historial_open); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoHombre(){return wxMEMORY_BITMAP(hombre); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoMujer(){return wxMEMORY_BITMAP(mujer); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoOtro(){return wxMEMORY_BITMAP(otro); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoFicheroClave(){return wxMEMORY_BITMAP(ico_fichero_clave); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoPlegar(){return wxMEMORY_BITMAP(ico_plegar); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetIcoDesplegar(){return wxMEMORY_BITMAP(ico_desplegar); }
const wxBitmap GinkgoResourcesManager::PanelHistorial::GetMoviePreview(){return wxMEMORY_BITMAP(ico_movie_preview); }

// Iconos de herramientas
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoAngulo(){return wxMEMORY_BITMAP(ico_angulo); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoAnotacion(){return wxMEMORY_BITMAP(ico_anotacion); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoCruz(){return wxMEMORY_BITMAP(ico_cruz); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoElevacion(){return wxMEMORY_BITMAP(ico_elevacion); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoFlecha(){return wxMEMORY_BITMAP(ico_flecha); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoLongitud(){return wxMEMORY_BITMAP(ico_longitud); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoPoligono(){return wxMEMORY_BITMAP(ico_poligono); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoVarita(){return wxMEMORY_BITMAP(ico_varita); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoLazoChroma(){return wxMEMORY_BITMAP(ico_lazo_chroma); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoWindowLevel(){return wxMEMORY_BITMAP(ico_wl); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoZoom(){return wxMEMORY_BITMAP(ico_zoom); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoSinOpciones(){return wxMEMORY_BITMAP(ico_sin_opciones); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoDebug() { return wxMEMORY_BITMAP(ico_debug); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoMarcado() { return wxMEMORY_BITMAP(ico_marcado); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoRejilla() { return wxMEMORY_BITMAP(ico_rejillametrica); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags(){return wxMEMORY_BITMAP(ico_mostrar_ocultar_tags); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoDesencajar(){return wxMEMORY_BITMAP(ico_desencajar); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations(){return wxMEMORY_BITMAP(ico_corner_annotations); }
const wxBitmap GinkgoResourcesManager::IconosHerramientas::GetIcoInforme(){return wxMEMORY_BITMAP(ico_informe); }

// Iconos de menus
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoAbrir(){return wxMEMORY_BITMAP(ico_abrir); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoOpenDir(){return wxMEMORY_BITMAP(ico_open_dir); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoOpenFile(){return wxMEMORY_BITMAP(ico_open_file); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab(){return wxMEMORY_BITMAP(ico_cerrar_tab); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoConfiguracion(){return wxMEMORY_BITMAP(ico_configuracion); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoEditor(){return wxMEMORY_BITMAP(ico_editor); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoExportar(){return wxMEMORY_BITMAP(ico_exportar); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoFiltrado(){return wxMEMORY_BITMAP(ico_filtrado); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoGuardar(){return wxMEMORY_BITMAP(ico_guardar); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoImportar(){return wxMEMORY_BITMAP(ico_importar); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoReset(){return wxMEMORY_BITMAP(ico_reset); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoSalir(){return wxMEMORY_BITMAP(ico_salir); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoImpresora(){return wxMEMORY_BITMAP(ico_impresora); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoVistaPreliminar(){return wxMEMORY_BITMAP(ico_vista_preliminar); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoCalibrarImagen(){return wxMEMORY_BITMAP(ico_calibrar_imagen); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoEliminar(){return wxMEMORY_BITMAP(ico_eliminar_widget); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoEditar(){return wxMEMORY_BITMAP(ico_editar); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS(){return wxMEMORY_BITMAP(ico_send_to_pacs); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoEliminarWidget(){return wxMEMORY_BITMAP(ico_eliminar_widget); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoPantallaCompleta(){return wxMEMORY_BITMAP(ico_pantalla_completa); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoUser(){return wxMEMORY_BITMAP(ico_user); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoHelp(){return wxMEMORY_BITMAP(ico_help); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoSupport(){return wxMEMORY_BITMAP(ico_support); }
const wxBitmap GinkgoResourcesManager::IconosMenus::GetIcoObtainExtensions(){return wxMEMORY_BITMAP(ico_obtain_extensions); }


// Logos
const wxBitmap GinkgoResourcesManager::Logos::GetLogoGinkgo48x48() {return wxMEMORY_BITMAP(ginkgo_logo48x48); } // Not used
const wxBitmap GinkgoResourcesManager::Logos::GetLogoGinkgo16x16() {return wxMEMORY_BITMAP(ico_ginkgo16x16); }
const wxBitmap GinkgoResourcesManager::Logos::GetLogoGinkgo32x32() {return wxMEMORY_BITMAP(ico_ginkgo32x32); }
const wxBitmap GinkgoResourcesManager::Logos::GetLogoSplash(){return wxMEMORY_BITMAP(ico_logo_splash); }
const wxBitmap GinkgoResourcesManager::Logos::GetLogoBackground(){return wxMEMORY_BITMAP(ico_logo_background); }

//cursores
const wxImage GinkgoResourcesManager::Cursores::GetCursorTransparente()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_transparente);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorLupa()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_lupa);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearLinea()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_linea);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorManoAbierta()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_mano_abierta);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorManoCerrada()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_mano_cerrada);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorSeleccionar()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_seleccionar);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearAnguloCobb()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_angulo_cobb);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearAnguloNormal()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_angulo_normal);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearAnotacion()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_anotacion);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearElipse()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_elipse);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearPoligono()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_poligono);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearPunto()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_punto);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorCrearRectangulo()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_crear_rectangulo);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}
const wxImage GinkgoResourcesManager::Cursores::GetCursorWindowLevel()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_window_level);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 4);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 26);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorAnclaSimple()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_ancla_simple);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

const wxImage GinkgoResourcesManager::Cursores::GetCursorAnclaCompuesta()
{
	wxImage img = wxMEMORY_IMAGE(ico_cursor_ancla_compuesta);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_X, 16);
	img.SetOption(wxIMAGE_OPTION_CUR_HOTSPOT_Y, 16);
	return img;
}

//progreso
const wxAnimation GinkgoResourcesManager::BarraProgreso::GetIcoLoading(){
	wxAnimation animation;
	wxMemoryInputStream stream( ico_loading, sizeof(ico_loading) );
	animation.Load(stream,wxANIMATION_TYPE_GIF);
	return animation;
}

const wxBitmap GinkgoResourcesManager::BarraProgreso::GetIcoStopped(){return wxMEMORY_BITMAP(ico_stopped); }


const wxBitmap GinkgoResourcesManager::Wizards::GetIcoBarraSuperior(){return wxMEMORY_BITMAP(ico_barra_superior); }

const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoAddColumna(){return wxMEMORY_BITMAP(ico_add_columna); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoAddFila(){return wxMEMORY_BITMAP(ico_add_fila); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoDelColumna(){return wxMEMORY_BITMAP(ico_del_columna); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoDelFila(){return wxMEMORY_BITMAP(ico_del_fila); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout1x1(){return wxMEMORY_BITMAP(ico_layout_1x1); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout1x2(){return wxMEMORY_BITMAP(ico_layout_1x2); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout2x1(){return wxMEMORY_BITMAP(ico_layout_2x1); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout2x2(){return wxMEMORY_BITMAP(ico_layout_2x2); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout3x3(){return wxMEMORY_BITMAP(ico_layout_3x3); }
const wxBitmap GinkgoResourcesManager::BarraLayout::GetIcoLayout4x4(){return wxMEMORY_BITMAP(ico_layout_4x4); }

const wxBitmap GinkgoResourcesManager::MenusTabs::GetIcoCerrarTab(){return wxMEMORY_BITMAP(ico_cerrar_tab_32); }
const wxBitmap GinkgoResourcesManager::MenusTabs::GetIcoPrimerPlano(){return wxMEMORY_BITMAP(ico_primer_plano_tab); }
const wxBitmap GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col(){return wxMEMORY_BITMAP(ico_grid_2_col); }
const wxBitmap GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col(){return wxMEMORY_BITMAP(ico_grid_3_col); }
const wxBitmap GinkgoResourcesManager::MenusTabs::GetIcoReagrupar(){return wxMEMORY_BITMAP(ico_reagrupar); }


