/*
 *
 *  $Id: volume.cpp 3893 2011-06-21 13:01:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include "volume.h"
#include <wx/dc.h>
#include <wx/aui/aui.h>
#include <wx/timer.h>
#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <main/controllers/configurationcontroller.h>

#include <api/math/geometria3d.h>
#include <api/ientorno.h>
#include <api/icontroladorcarga.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorcomandos.h>
#include <main/gui/progress/statusbarprogreso.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include "volumedataset/volumedataset.h"
#include "pipelines/volumepipeline.h"
#include "commands/voiextractioncommand.h"
#include "commands/volumecommand.h"
#include <eventos/eventosginkgo.h>

#include "../../../recursos/aprimresourcemanager.h"
#include <resources/ginkgoresourcemanager.h>
#include "../../exportacion/tagsprivados.h"
#include <export/tagsprivadoscomunes.h>
#include "../../comandos/comandodicomizacionintegracion.h"
#include <api/icontroladorcomandos.h>


#define ID_HIDE_BAR 1

#define ID_CURSOR 0
#define ID_STEREO 1
#define ID_DEMO_MODE 2
#define ID_RESET 3
#define ID_SAVE 4
#define ID_WL 5

namespace MedicalViewer
{
	namespace Reconstruction
	{
		namespace GUI
		{
			class VolumeReconstructionBar: public wxAuiToolBar{
			public:
				VolumeReconstructionBar(wxWindow* pParent, wxVolumeRendering* VolumeRenderingDialog): wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize, wxAUI_TB_DEFAULT_STYLE)
				{
					m_pVolumeRenderingDialog = VolumeRenderingDialog;

					SetToolBitmapSize(wxSize(16,16));
					AddTool( ID_CURSOR, _("Cursor"), APrimResourcesManager::Bar3D::GetIco3DArrow(),_("Cursor"), wxITEM_CHECK );
					AddTool (ID_WL, _("Window/Level"), GinkgoResourcesManager::IconosHerramientas::GetIcoWindowLevel(), _("Window/Level"), wxITEM_CHECK );
					AddSeparator();
					AddTool( ID_RESET, _("Reset"), APrimResourcesManager::Herramientas::GetIcoReset(),_("Reset") );
					AddSeparator();
					AddTool( ID_STEREO, _("Stereo view"), APrimResourcesManager::Bar3D::GetIcoStereo(),_("Stereo view"), wxITEM_CHECK );
					AddSeparator();
					AddTool( ID_DEMO_MODE, _("Demo mode"), APrimResourcesManager::Bar3D::GetIcoDemo(),_("Demo mode"), wxITEM_CHECK );
					AddSeparator();
					AddTool( ID_SAVE, _("Save Frame"), GinkgoResourcesManager::IconosMenus::GetIcoGuardar(),_("Save current frame to new serie") );

					ToggleTool(ID_CURSOR, true);
					Realize();
					Layout();

					// Connect Events
					this->Connect( ID_CURSOR, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBCursor ) );
					this->Connect( ID_STEREO, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBStereo ) );
					this->Connect( ID_DEMO_MODE, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBDemo ) );
					this->Connect( ID_RESET, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBReset ) );
					this->Connect( ID_SAVE, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBSave ) );
					this->Connect( ID_WL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( VolumeReconstructionBar::OnBWL ) );

					Realize();
				}

				~VolumeReconstructionBar()
				{
				}

				virtual void OnBCursor(wxCommandEvent& event) {
					ToggleTool(ID_CURSOR, true);
					ToggleTool(ID_WL, false);
					m_pVolumeRenderingDialog->SetInteractorStyleToDefault();
					event.Skip(true);
				}

				virtual void OnBWL(wxCommandEvent& event) {
					ToggleTool(ID_WL, true);
					ToggleTool(ID_CURSOR, false);
					m_pVolumeRenderingDialog->SetInteractorStyleToWindowLevel();
					event.Skip(true);
				}

				virtual void OnBStereo(wxCommandEvent& event) {
					m_pVolumeRenderingDialog->SetStereo(GetToolToggled(ID_STEREO));
					event.Skip(true);
				}

				virtual void OnBDemo(wxCommandEvent& event) {
					m_pVolumeRenderingDialog->SetDemo(GetToolToggled(ID_DEMO_MODE));
					event.Skip(true);
				}

				virtual void OnBReset(wxCommandEvent&) {
					m_pVolumeRenderingDialog->Reset();
				}

				virtual void OnBSave(wxCommandEvent&) {
					m_pVolumeRenderingDialog->SaveFrameToSerie();
				}

				wxVolumeRendering* m_pVolumeRenderingDialog;
			};

			class VolumeTimerDemo : public wxTimer
			{
				typedef MedicalViewer::Reconstruction::Pipelines::VolumePipeline TPipeline;
			public:
				VolumeTimerDemo(GnkPtr<TPipeline>& pipeline):wxTimer()
				{
					Pipeline = pipeline;
				}

				~VolumeTimerDemo()
				{}

				virtual void Notify()
				{
					Pipeline->RotateDemo(1);
					Pipeline->Render();
				}

				virtual void Start()
				{
					wxTimer::Start(100, false);
				}

				GnkPtr<TPipeline> Pipeline;
			};
		}
	}
}


MedicalViewer::Reconstruction::GUI::wxVolumeRendering::wxVolumeRendering(wxWindow* pParent, const GnkPtr<TStudy>& study, double cwindow, double clevel) : wxVolumeRenderingBase(pParent), RefStudy(TStudy::NewRef(study))
{

	typedef MedicalViewer::Reconstruction::Commands::VOIExtractionCommandParams    TVOIParams;
	typedef MedicalViewer::Reconstruction::Commands::VOIExtractionCommand          TVOICommand;

	RefStudy->UnRefViewer();

	m_editing = false;
	m_pProgressBar = new GNC::GUI::StatusBarProgreso(this, this, false);
	SetStatusBar(m_pProgressBar);

	wxIcon icono;
	icono.CopyFromBitmap(GinkgoResourcesManager::Logos::GetLogoGinkgo32x32());
	this->SetIcon(icono);

	Pipeline = new TPipeline(ViewInteractor);
	m_pTimer = new MedicalViewer::Reconstruction::GUI::VolumeTimerDemo(Pipeline);

	m_pHeaderPanel->GetButtonBar()->AddTool(ID_HIDE_BAR,_("Hide"),APrimResourcesManager::Bar3D::GetIcoPin(),_("Hide"), wxITEM_NORMAL);
	m_pHeaderPanel->GetButtonBar()->Connect(ID_HIDE_BAR,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnToolTitleButtonClick),NULL,this);
	m_pHeaderPanel->Realize();

	//aui bar
	VolumeReconstructionBar* m_pBar = new VolumeReconstructionBar(this, this);
	m_pBarSizer->Add(m_pBar, 0, wxEXPAND);

	ViewInteractor->GetRenderWindow()->AddRenderer(Pipeline->GetRenderer());
	Pipeline->SetupInteractor();

	study->Entorno->GetControladorEventos()->Registrar(this, GNC::GCS::Eventos::EventoProgresoComando());

	m_pWindowTextBox->SetValue(wxString::Format(wxT("%lf"), cwindow));
	m_pLevelTextBox->SetValue(wxString::Format(wxT("%lf"), clevel));

	m_pBlendModeComboBox->SetSelection(0);

	TVOICommand* voiCmd = new TVOICommand(new TVOIParams(RefStudy, Pipeline, this));
	GNC::GCS::ControladorComandos::Instance()->ProcessAsync("VOI Extraction", voiCmd, this);

	m_pBody->Layout();
	m_pToolPanel->Layout();
	Layout();
}


MedicalViewer::Reconstruction::GUI::wxVolumeRendering::~wxVolumeRendering()
{
	GNC::GCS::ControladorComandos::Instance()->AbortarComandosDeOwnerAsincrono(this);
	ViewInteractor->Delete();
	ViewInteractor->Reparent(NULL);
	if (m_pTimer != NULL) {
		delete m_pTimer;
		m_pTimer = NULL;
	}
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::SetDemo(bool enabled)
{
	if (enabled) {
		m_pTimer->Start();
	} else {
		m_pTimer->Stop();
	}
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::Reset()
{
	Pipeline->ResetWindowLevel();
	Pipeline->ResetCamera();
	Pipeline->Render();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::SaveFrameToSerie()
{
	wxString wxNuevoDirTemp;
	do {
		wxNuevoDirTemp = FROMPATH(RefStudy->Entorno->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
	} while(wxDir::Exists(wxNuevoDirTemp));

	#ifdef _WIN32
			wxFileName::Mkdir(wxNuevoDirTemp);
	#else
			wxFileName::Mkdir(wxNuevoDirTemp.c_str(), 0777);
	#endif

	wxString fileNameExport = wxNuevoDirTemp + wxFileName::GetPathSeparator() + wxT("1.jpg");
	Pipeline->Print(std::string(TOPATH(fileNameExport)));

	GnkPtr<GNKVisualizator::GUI::TipoWizardImportacion> pPersistentData(new GNKVisualizator::GUI::TipoWizardImportacion(NULL));

	GNKVisualizator::GUI::TipoWizardImportacion::TFicheroDicomizacionGNKVisualizator ficheroADicomizar;
	ficheroADicomizar.pathImagen = TOPATH(fileNameExport);
	pPersistentData->m_listaFicherosADicomizar.push_back(ficheroADicomizar);

	//institucion
	std::string tag;
	if (GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/Estacion", "CentroNombre", tag)) {
		pPersistentData->baseImagenes.tags[std::string("0008|0080")] = tag;
	}

	//nombre del medico responsable de la institucion
	if (GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Estacion", "NombreMedico", tag)) {
		pPersistentData->baseImagenes.tags[std::string("0008|0090")] = tag;
	}

	pPersistentData->baseImagenes.tags[std::string("0008|0070")] = std::string("Metaemotion S.L.");

	pPersistentData->baseImagenes.tags[std::string("0008|1090")] = std::string("Ginkgo Atencin Primaria");

	//uid de aprimaria
	pPersistentData->baseImagenes.tags[std::string("0018|1030")] = UID_APRIM;

	//study data
	//date
	std::string tmp;
	RefStudy->GetTagImagenActiva("0008|0020", tmp);
	pPersistentData->baseImagenes.tags[std::string("0008|0020")] = tmp;
	//time
	RefStudy->GetTagImagenActiva("0008|0030", tmp);
	pPersistentData->baseImagenes.tags[std::string("0008|0030")] = tmp;
	//description
	RefStudy->GetTagImagenActiva("0008|1030", tmp);
	pPersistentData->baseImagenes.tags[std::string("0008|1030")] = tmp;
	//uid
	RefStudy->GetTagImagenActiva("0020|000d", tmp);
	pPersistentData->baseImagenes.tags[std::string("0020|000d")] = tmp;
	pPersistentData->StudyInstanceUID = tmp;

	//serie and image data
	//date
	pPersistentData->baseImagenes.tags[std::string("0008|0022")] = pPersistentData->baseImagenes.tags[std::string("0008|0021")] = wxDateTime::Now().Format(wxT("%Y%m%d")).ToUTF8();
	//time
	pPersistentData->baseImagenes.tags[std::string("0008|0032")] = pPersistentData->baseImagenes.tags[std::string("0008|0031")] = wxDateTime::Now().Format(wxT("%H%M%S")).ToUTF8();
	//description
	pPersistentData->baseImagenes.tags[std::string("0020|4000")] = pPersistentData->baseImagenes.tags[std::string("0008|103e")] = _Std("3D Volume");

	//patient
	//name
	RefStudy->GetTagImagenActiva("0010|0010", tmp);
	pPersistentData->baseImagenes.tags[std::string("0010|0010")] = tmp;
	//id
	RefStudy->GetTagImagenActiva("0010|0020", tmp);
	pPersistentData->baseImagenes.tags[std::string("0010|0020")] = tmp;
	//age
	RefStudy->GetTagImagenActiva("0010|1010", tmp);
	pPersistentData->baseImagenes.tags[std::string("0010|1010")] = tmp;
	//birth date
	RefStudy->GetTagImagenActiva("0010|0030", tmp);
	pPersistentData->baseImagenes.tags[std::string("0010|0030")] = tmp;
	//sex
	RefStudy->GetTagImagenActiva("0010|0040", tmp);
	pPersistentData->baseImagenes.tags[std::string("0010|0040")] = tmp;

	GNKVisualizator::GADAPI::ComandoDicomizacionIntegracionParams* pDicomParams = new GNKVisualizator::GADAPI::ComandoDicomizacionIntegracionParams(pPersistentData,RefStudy->Entorno, std::string(TOPATH(wxNuevoDirTemp)));
	GNKVisualizator::GADAPI::ComandoDicomizacionIntegracion* pDicomCmd = new GNKVisualizator::GADAPI::ComandoDicomizacionIntegracion(pDicomParams);
	RefStudy->Entorno->GetControladorComandos()->ProcessAsync(_Std("Performing tasks of integration ..."),pDicomCmd,NULL);

	#if defined (_WINDOWS)
	wxRmDir(wxNuevoDirTemp);
	#else
	wxRmDir(std::string(wxNuevoDirTemp.ToUTF8()).c_str());
	#endif
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::SetInteractorStyleToDefault()
{
	Pipeline->SetInteractorStyleToDefault();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::SetInteractorStyleToWindowLevel()
{
	Pipeline->SetInteractorStyleToWindowLevel();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnRangeCalculated()
{
	const unsigned int current_dataset = 0;
	GnkPtr<MedicalViewer::Reconstruction::DataSet::DataSet> d = Pipeline->FindDataSet(current_dataset);
	if (d ) {
		double window = d->MaxValue - d->MinValue;
		double level = 0.5 * window;
		if (window > 0.0) {
			m_pWindowTextBox->SetValue(wxString::Format(wxT("%lf"), window));
			m_pLevelTextBox->SetValue(wxString::Format(wxT("%lf"), level));
		}
	}
}



void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::SetStereo(bool enabled)
{
	ViewInteractor->GetRenderWindow()->SetStereoTypeToRedBlue();
	ViewInteractor->GetRenderWindow()->SetStereoRender(enabled? 1: 0);
	ViewInteractor->Refresh(false);
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnWindowSize( wxSizeEvent& /*event*/ )
{
	Freeze();
	Layout();
	Refresh(false);
	Thaw();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnToolTitleButtonClick( wxCommandEvent& event )
{
	Freeze();
	m_pToolPanel->Show(false);
	m_pToolTitlePanel->Show(true);
	Layout();
	Refresh(true);
	Thaw();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnTitleLeftUp( wxMouseEvent& /*event*/ )
{
	Freeze();
	m_pToolPanel->Show(true);
	m_pToolTitlePanel->Show(false);
	Layout();
	Refresh(true);
	Thaw();
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnEraseBackground( wxEraseEvent& event )
{
	event.Skip(true);
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnDataSetSliderChanged( wxScrollEvent& event )
{
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::OnApplyClick(wxCommandEvent &event)
{
	typedef MedicalViewer::Reconstruction::Volume::Commands::VolumeCommandParams TVolumeParams;
	typedef MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand       TVolumeCommand;

	double windowlevel[2] = {0, 0};

	if (!m_pWindowTextBox->GetValue().ToDouble(&windowlevel[0]))
	{
		wxMessageBox(_("Radiolucency Window does not have a valid value"), _("Warning"),wxICON_WARNING);
		return;
	}

	if (!m_pLevelTextBox->GetValue().ToDouble(&windowlevel[1]))
	{
		wxMessageBox(_("Radiolucency Level does not have a valid value"), _("Warning"),wxICON_WARNING);
		return;
	}

	Pipeline->Enable(false);
	Refresh(false);

	TPipeline::VolumeBlendType blendType = TPipeline::VBT_MIP;
	switch (m_pBlendModeComboBox->GetSelection()) {
		case 0:
			blendType = TPipeline::VBT_MIP;
			break;
		case 1:
			blendType = TPipeline::VBT_CompositeRamp;
			break;
		case 2:
			blendType = TPipeline::VBT_CompositeShadeRamp;
			break;
		case 3:
			blendType = TPipeline::VBT_RGB_Composite;
			break;
		case 4:
			blendType = TPipeline::VBT_CT_Skin;
			break;
		case 5:
			blendType = TPipeline::VBT_CT_Muscle;
			break;
		case 6:
			blendType = TPipeline::VBT_CT_Bone;
			break;

	}

	TVolumeCommand* volCmd = new TVolumeCommand(
		new TVolumeParams(
			Pipeline,                                             // Pipeline
			0,                                                    // DataSet

			(double)m_pResolutionSlider->GetValue() / 100.0,      // ReductionFactor [0, ..,  1]
			windowlevel[0],                                       // Window
			windowlevel[1],                                       // Level
			blendType                                             // Blend Type
			)
		);
	GNC::GCS::ControladorComandos::Instance()->ProcessAsync("Volume setup", volCmd, this);
}

void MedicalViewer::Reconstruction::GUI::wxVolumeRendering::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	GNC::GCS::Eventos::EventoProgresoComando* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoProgresoComando*> (evt);

	if (pEvt == NULL  || pEvt->GetComando() == NULL || pEvt->GetComando()->GetOwner() != this) {
		return;
	}
	switch (pEvt->GetTipo()) {
		case GNC::GCS::Eventos::EventoProgresoComando::TEP_Iniciado:
			//
			m_pProgressBar->InsertarTarea(pEvt->GetComando()->GetId(), pEvt->GetTexto());
			break;
		case GNC::GCS::Eventos::EventoProgresoComando::TEP_Progreso:
			//
			m_pProgressBar->SetProgresoTarea(pEvt->GetComando()->GetId(), pEvt->GetProgresoNormalizado(), pEvt->GetTexto());
			break;
		case GNC::GCS::Eventos::EventoProgresoComando::TEP_Finalizado:
			//
			m_pProgressBar->EliminarTarea(pEvt->GetComando()->GetId());
			break;
		case GNC::GCS::Eventos::EventoProgresoComando::TEP_Unknown:
			break;
	}
}
