/*
*  
*  $Id: voiextractioncommand.h 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once

#define IDC_VOI_EXTRACTION 4001

#include <list>
#include <api/icomando.h>
#include <yasper/yasper.h>

namespace GNC {
	namespace GCS {
		class IContextoEstudioReferido;
	}
}

namespace MedicalViewer {
	namespace Reconstruction {

		namespace Pipelines {
			class IPipeline;
		}
		namespace Commands {
			class IRangeListener {
			public:
				virtual void OnRangeCalculated() = 0;
			};
		}
	}
}

namespace MedicalViewer {
	namespace Reconstruction {
		namespace Commands {

			typedef GNC::GCS::IContextoEstudioReferido                  TRefStudy;
			typedef MedicalViewer::Reconstruction::Pipelines::IPipeline TPipeline;

			class VOIExtractionCommandParams : public GNC::GCS::IComandoParams {
			public:

				VOIExtractionCommandParams(const GnkPtr<TRefStudy>& ref, const GnkPtr<TPipeline>& Pipeline, IRangeListener* rangeListener = NULL);

				virtual ~VOIExtractionCommandParams() ;

				GnkPtr<TRefStudy>     RefStudy;
				GnkPtr<TPipeline>     Pipeline;
				IRangeListener*       RangeListener;

			};


			class VOIExtractionCommand : public GNC::GCS::IComando
			{
			public:
				VOIExtractionCommand(VOIExtractionCommandParams* pParams);
				
				virtual ~VOIExtractionCommand(void);				

			protected:

				virtual void Execute();
				virtual void Update();

				virtual void OnAbort();

				void LiberarRecursos();

				VOIExtractionCommandParams* m_pExtractionParams;
			};
		}
	}
}
