/*
 *  
 *  $Id: toolslider.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include "toolslider.h"

#if defined (ENABLE_SLIDERTOOL)
#include <export/contracts/iwidgetscontract.h>

#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include <resources/ginkgoresourcesmanager.h>
#include <vtkInteractorStyle.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>


GNC::ToolSlider::ToolSlider() 
{
	m_pBuilder = NULL;
}

GNC::ToolSlider::~ToolSlider()
{
	if (m_pBuilder != NULL) {
		delete m_pBuilder;
		m_pBuilder = NULL;
	}
}


GNC::GCS::ITool* GNC::ToolSlider::NewTool()
{
	return new GNC::ToolSlider();
}

void GNC::ToolSlider::Connect()
{
	if (SliderContract) {
		if (m_pBuilder != NULL) {
			delete m_pBuilder;
			m_pBuilder = NULL;
		}

		m_pBuilder = new TBuilder(SliderContract->GetManager(),SliderContract, GetTriggerButton(), (unsigned long)this);
		SliderContract->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
		SliderContract->GetManager()->SetCursor(m_pBuilder->GetCursor());
	}
}

void GNC::ToolSlider::Disconnect()
{
	if (SliderContract) {
		SliderContract->GetViewerActivo()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
		SliderContract->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
		// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
		if (m_pBuilder != NULL) {
			delete m_pBuilder;
			m_pBuilder = NULL;
		}
	}
}
//endregion
#endif