/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"



static void builtin_module_init (void);

static gpointer procedure_blink_widget (gpointer data,
					gpointer func_data,
					gpointer invoke_data);



void
g_inspector_builtin_register_module_misc_blink_widget (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-misc-blink-widget";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("blink-widget",
				  "Blink Widget",
				  G_INSPECTOR_PROCEDURE_TYPE_MISC,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_WIDGET,
				  procedure_blink_widget,
				  NULL);
}



static void     blink_widget    (GtkWidget *widget);
static gboolean timeout_handler (gpointer data);


static gpointer
procedure_blink_widget (gpointer data,
			gpointer func_data,
			gpointer invoke_data)
{
  GtkWidget *widget;

  widget = GTK_WIDGET (data);

  blink_widget (widget);

  return NULL;
}

static void
blink_widget (GtkWidget *widget)
{
  GInspectorElementHolder *element_holder;

  {
    element_holder = g_inspector_element_holder_new ();

    g_inspector_element_holder_set_gobject (element_holder,
					    G_OBJECT (widget));
    g_object_weak_ref (G_OBJECT (widget),
		       (GWeakNotify)g_inspector_element_holder_unset,
		       element_holder);
    g_object_set_data (G_OBJECT (element_holder),
		       "count",
		       GINT_TO_POINTER (6));
  }

  {
    GClosure *closure;
    GSource *source;

    closure = g_cclosure_new_object (G_CALLBACK (timeout_handler),
                                     G_OBJECT (element_holder));

    source = g_timeout_source_new (700);

    g_source_set_closure (source, closure);
    g_source_attach (source, NULL);
    g_source_unref (source);
  }
}

static gboolean
timeout_handler (gpointer data)
{
  GInspectorElementHolder *element_holder;
  GtkWidget *widget;
  gint count;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (data);

  widget = g_inspector_element_holder_get_element (element_holder);
  count = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (element_holder),
					      "count"));

  if ((widget != NULL) &&
      (GTK_WIDGET_REALIZED (widget)) &&
      (GTK_WIDGET_MAPPED   (widget)) &&
      (GTK_WIDGET_VISIBLE  (widget)) &&
      (gtk_widget_get_child_visible (widget)))
    {
      if ((count%2) == 0)
	{
	  gint x;
	  gint y;
	  gint width;
	  gint height;

	  if (GTK_WIDGET_NO_WINDOW (widget))
	    {
	      x = widget->allocation.x;
	      y = widget->allocation.y;
	    }
	  else
	    {
	      x = 0;
	      y = 0;
	    }

	  width  = widget->allocation.width;
	  height = widget->allocation.height;


	  gdk_draw_rectangle (widget->window,
			      widget->style->white_gc,
			      TRUE,
			      x,
			      y,
			      width,
			      height);
	  gdk_draw_rectangle (widget->window,
			      widget->style->black_gc,
			      FALSE,
			      x,
			      y,
			      (width  - 1),
			      (height - 1));
	}
      else
	{
	  gtk_widget_queue_draw (widget);
	}

      --count;
    }
  else
    {
      count = 0;
    }

  g_object_set_data (G_OBJECT (element_holder),
		     "count",
		     GINT_TO_POINTER (count));


  if (count > 0)
    {
      return TRUE;
    }
  else
    {
      return FALSE;
    }
}
