//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import "time"

// AssignmentPrincipal - The AssignmentPrincipal
type AssignmentPrincipal struct {
	// REQUIRED; The principal id being assigned to.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The Type of the principal ID.
	PrincipalType *string `json:"principalType,omitempty"`

	// Other metadata for the principal.
	PrincipalMetadata map[string]*string `json:"principalMetadata,omitempty"`
}

// AuthorizationPoliciesClientCreateOrUpdateOptions contains the optional parameters for the AuthorizationPoliciesClient.CreateOrUpdate
// method.
type AuthorizationPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationPoliciesClientGetOptions contains the optional parameters for the AuthorizationPoliciesClient.Get method.
type AuthorizationPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationPoliciesClientListByHubOptions contains the optional parameters for the AuthorizationPoliciesClient.ListByHub
// method.
type AuthorizationPoliciesClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationPoliciesClientRegeneratePrimaryKeyOptions contains the optional parameters for the AuthorizationPoliciesClient.RegeneratePrimaryKey
// method.
type AuthorizationPoliciesClientRegeneratePrimaryKeyOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationPoliciesClientRegenerateSecondaryKeyOptions contains the optional parameters for the AuthorizationPoliciesClient.RegenerateSecondaryKey
// method.
type AuthorizationPoliciesClientRegenerateSecondaryKeyOptions struct {
	// placeholder for future optional parameters
}

// AuthorizationPolicy - The authorization policy.
type AuthorizationPolicy struct {
	// REQUIRED; The permissions associated with the policy.
	Permissions []*PermissionTypes `json:"permissions,omitempty"`

	// Primary key associated with the policy.
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Secondary key associated with the policy.
	SecondaryKey *string `json:"secondaryKey,omitempty"`

	// READ-ONLY; Name of the policy.
	PolicyName *string `json:"policyName,omitempty" azure:"ro"`
}

// AuthorizationPolicyListResult - The response of list authorization policy operation.
type AuthorizationPolicyListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*AuthorizationPolicyResourceFormat `json:"value,omitempty"`
}

// AuthorizationPolicyResourceFormat - The authorization policy resource format.
type AuthorizationPolicyResourceFormat struct {
	// The authorization policy.
	Properties *AuthorizationPolicy `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureBlobConnectorProperties - The Azure Blob connector properties.
type AzureBlobConnectorProperties struct {
	// REQUIRED; The connection KeyVault URL.
	ConnectionKeyVaultURL *string `json:"connectionKeyVaultUrl,omitempty"`
}

// CanonicalProfileDefinition - Definition of canonical profile.
type CanonicalProfileDefinition struct {
	// Canonical profile ID.
	CanonicalProfileID *int32 `json:"canonicalProfileId,omitempty"`

	// Properties of the canonical profile.
	Properties []*CanonicalProfileDefinitionPropertiesItem `json:"properties,omitempty"`
}

// CanonicalProfileDefinitionPropertiesItem - The definition of a canonical profile property.
type CanonicalProfileDefinitionPropertiesItem struct {
	// Profile name.
	ProfileName *string `json:"profileName,omitempty"`

	// Property name of profile.
	ProfilePropertyName *string `json:"profilePropertyName,omitempty"`

	// The rank.
	Rank *int32 `json:"rank,omitempty"`

	// Type of canonical property value.
	Type *CanonicalPropertyValueType `json:"type,omitempty"`

	// Value of the canonical property.
	Value *string `json:"value,omitempty"`
}

// Connector - Properties of connector.
type Connector struct {
	// REQUIRED; The connector properties.
	ConnectorProperties map[string]interface{} `json:"connectorProperties,omitempty"`

	// REQUIRED; Type of connector.
	ConnectorType *ConnectorTypes `json:"connectorType,omitempty"`

	// Name of the connector.
	ConnectorName *string `json:"connectorName,omitempty"`

	// Description of the connector.
	Description *string `json:"description,omitempty"`

	// Display name of the connector.
	DisplayName *string `json:"displayName,omitempty"`

	// If this is an internal connector.
	IsInternal *bool `json:"isInternal,omitempty"`

	// READ-ONLY; ID of the connector.
	ConnectorID *int32 `json:"connectorId,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The last modified time.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; State of connector.
	State *ConnectorStates `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ConnectorListResult - The response of list connector operation.
type ConnectorListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ConnectorResourceFormat `json:"value,omitempty"`
}

// ConnectorMapping - The connector mapping definition.
type ConnectorMapping struct {
	// REQUIRED; Defines which entity type the file should map to.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// REQUIRED; The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`

	// REQUIRED; The properties of the mapping.
	MappingProperties *ConnectorMappingProperties `json:"mappingProperties,omitempty"`

	// Type of connector.
	ConnectorType *ConnectorTypes `json:"connectorType,omitempty"`

	// The description of the connector mapping.
	Description *string `json:"description,omitempty"`

	// Display name for the connector mapping.
	DisplayName *string `json:"displayName,omitempty"`

	// READ-ONLY; The connector mapping name
	ConnectorMappingName *string `json:"connectorMappingName,omitempty" azure:"ro"`

	// READ-ONLY; The connector name.
	ConnectorName *string `json:"connectorName,omitempty" azure:"ro"`

	// READ-ONLY; The created time.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The DataFormat ID.
	DataFormatID *string `json:"dataFormatId,omitempty" azure:"ro"`

	// READ-ONLY; The last modified time.
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`

	// READ-ONLY; The next run time based on customer's settings.
	NextRunTime *time.Time `json:"nextRunTime,omitempty" azure:"ro"`

	// READ-ONLY; The RunId.
	RunID *string `json:"runId,omitempty" azure:"ro"`

	// READ-ONLY; State of connector mapping.
	State *ConnectorMappingStates `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ConnectorMappingAvailability - Connector mapping property availability.
type ConnectorMappingAvailability struct {
	// REQUIRED; The interval of the given frequency to use.
	Interval *int32 `json:"interval,omitempty"`

	// The frequency to update.
	Frequency *FrequencyTypes `json:"frequency,omitempty"`
}

// ConnectorMappingCompleteOperation - The complete operation.
type ConnectorMappingCompleteOperation struct {
	// The type of completion operation.
	CompletionOperationType *CompletionOperationTypes `json:"completionOperationType,omitempty"`

	// The destination folder where files will be moved to once the import is done.
	DestinationFolder *string `json:"destinationFolder,omitempty"`
}

// ConnectorMappingErrorManagement - The error management.
type ConnectorMappingErrorManagement struct {
	// REQUIRED; The type of error management to use for the mapping.
	ErrorManagementType *ErrorManagementTypes `json:"errorManagementType,omitempty"`

	// The error limit allowed while importing data.
	ErrorLimit *int32 `json:"errorLimit,omitempty"`
}

// ConnectorMappingFormat - Connector mapping property format.
type ConnectorMappingFormat struct {
	// REQUIRED; The type mapping format.
	FormatType *string `json:"formatType,omitempty"`

	// The oData language.
	AcceptLanguage *string `json:"acceptLanguage,omitempty"`

	// Character separating array elements.
	ArraySeparator *string `json:"arraySeparator,omitempty"`

	// The character that signifies a break between columns.
	ColumnDelimiter *string `json:"columnDelimiter,omitempty"`

	// Quote character, used to indicate enquoted fields.
	QuoteCharacter *string `json:"quoteCharacter,omitempty"`

	// Escape character for quotes, can be the same as the quoteCharacter.
	QuoteEscapeCharacter *string `json:"quoteEscapeCharacter,omitempty"`
}

// ConnectorMappingListResult - The response of list connector mapping operation.
type ConnectorMappingListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ConnectorMappingResourceFormat `json:"value,omitempty"`
}

// ConnectorMappingProperties - The connector mapping properties.
type ConnectorMappingProperties struct {
	// REQUIRED; The availability of mapping property.
	Availability *ConnectorMappingAvailability `json:"availability,omitempty"`

	// REQUIRED; The operation after import is done.
	CompleteOperation *ConnectorMappingCompleteOperation `json:"completeOperation,omitempty"`

	// REQUIRED; The error management setting for the mapping.
	ErrorManagement *ConnectorMappingErrorManagement `json:"errorManagement,omitempty"`

	// REQUIRED; The format of mapping property.
	Format *ConnectorMappingFormat `json:"format,omitempty"`

	// REQUIRED; Ingestion mapping information at property level.
	Structure []*ConnectorMappingStructure `json:"structure,omitempty"`

	// The file filter for the mapping.
	FileFilter *string `json:"fileFilter,omitempty"`

	// The folder path for the mapping.
	FolderPath *string `json:"folderPath,omitempty"`

	// If the file contains a header or not.
	HasHeader *bool `json:"hasHeader,omitempty"`
}

// ConnectorMappingResourceFormat - The connector mapping resource format.
type ConnectorMappingResourceFormat struct {
	// The connector mapping definition.
	Properties *ConnectorMapping `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectorMappingStructure - Connector mapping property structure.
type ConnectorMappingStructure struct {
	// REQUIRED; The column name of the import file.
	ColumnName *string `json:"columnName,omitempty"`

	// REQUIRED; The property name of the mapping entity.
	PropertyName *string `json:"propertyName,omitempty"`

	// Custom format specifier for input parsing.
	CustomFormatSpecifier *string `json:"customFormatSpecifier,omitempty"`

	// Indicates if the column is encrypted.
	IsEncrypted *bool `json:"isEncrypted,omitempty"`
}

// ConnectorMappingsClientCreateOrUpdateOptions contains the optional parameters for the ConnectorMappingsClient.CreateOrUpdate
// method.
type ConnectorMappingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectorMappingsClientDeleteOptions contains the optional parameters for the ConnectorMappingsClient.Delete method.
type ConnectorMappingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectorMappingsClientGetOptions contains the optional parameters for the ConnectorMappingsClient.Get method.
type ConnectorMappingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectorMappingsClientListByConnectorOptions contains the optional parameters for the ConnectorMappingsClient.ListByConnector
// method.
type ConnectorMappingsClientListByConnectorOptions struct {
	// placeholder for future optional parameters
}

// ConnectorResourceFormat - The connector resource format.
type ConnectorResourceFormat struct {
	// Properties of connector.
	Properties *Connector `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ConnectorsClient.BeginCreateOrUpdate
// method.
type ConnectorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectorsClientBeginDeleteOptions contains the optional parameters for the ConnectorsClient.BeginDelete method.
type ConnectorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectorsClientGetOptions contains the optional parameters for the ConnectorsClient.Get method.
type ConnectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectorsClientListByHubOptions contains the optional parameters for the ConnectorsClient.ListByHub method.
type ConnectorsClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// CrmConnectorEntities - The CRM connector entities.
type CrmConnectorEntities struct {
	// REQUIRED; The logical name.
	LogicalName *string `json:"logicalName,omitempty"`

	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Indicating whether this is profile.
	IsProfile *bool `json:"isProfile,omitempty"`
}

// CrmConnectorProperties - The CRM connector properties.
type CrmConnectorProperties struct {
	// REQUIRED; The entities like account, contact, opportunity.
	Entities []*CrmConnectorEntities `json:"entities,omitempty"`

	// REQUIRED; The organization ID.
	OrganizationID *string `json:"organizationId,omitempty"`

	// REQUIRED; The organization URL.
	OrganizationURL *string `json:"organizationUrl,omitempty"`

	// The access token.
	AccessToken *string `json:"accessToken,omitempty"`

	// The connection string.
	ConnectionString *string `json:"connectionString,omitempty"`
}

// DataSource - Data Source is a way for us to know the source of instances. A single type can have data coming in from multiple
// places. In activities we use this to determine precedence rules.
type DataSource struct {
	// READ-ONLY; The data source reference id.
	DataSourceReferenceID *string `json:"dataSourceReferenceId,omitempty" azure:"ro"`

	// READ-ONLY; The data source type.
	DataSourceType *DataSourceType `json:"dataSourceType,omitempty" azure:"ro"`

	// READ-ONLY; The data source ID.
	ID *int32 `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The data source name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The data source status.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// DataSourcePrecedence - The data source precedence is a way to know the precedence of each data source.
type DataSourcePrecedence struct {
	// Data Source is a way for us to know the source of instances. A single type can have data coming in from multiple places.
	// In activities we use this to determine precedence rules.
	DataSource *DataSource `json:"dataSource,omitempty"`

	// the precedence value.
	Precedence *int32 `json:"precedence,omitempty"`
}

// EnrichingKpi - The enriching KPI definition.
type EnrichingKpi struct {
	// REQUIRED; The calculation window.
	CalculationWindow *CalculationWindowTypes `json:"calculationWindow,omitempty"`

	// REQUIRED; The mapping entity type.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// REQUIRED; The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`

	// REQUIRED; The computation expression for the KPI.
	Expression *string `json:"expression,omitempty"`

	// REQUIRED; The computation function for the KPI.
	Function *KpiFunctions `json:"function,omitempty"`

	// The aliases.
	Aliases []*KpiAlias `json:"aliases,omitempty"`

	// Name of calculation window field.
	CalculationWindowFieldName *string `json:"calculationWindowFieldName,omitempty"`

	// Localized description for the KPI.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name for the KPI.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The KPI extracts.
	Extracts []*KpiExtract `json:"extracts,omitempty"`

	// The filter expression for the KPI.
	Filter *string `json:"filter,omitempty"`

	// the group by properties for the KPI.
	GroupBy []*string `json:"groupBy,omitempty"`

	// The KPI thresholds.
	ThresHolds *KpiThresholds `json:"thresHolds,omitempty"`

	// The unit of measurement for the KPI.
	Unit *string `json:"unit,omitempty"`

	// READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata []*KpiGroupByMetadata `json:"groupByMetadata,omitempty" azure:"ro"`

	// READ-ONLY; The KPI name.
	KpiName *string `json:"kpiName,omitempty" azure:"ro"`

	// READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata []*KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// EntityTypeDefinition - Describes an entity.
type EntityTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`

	// The attributes for the Type.
	Attributes map[string][]*string `json:"attributes,omitempty"`

	// Localized descriptions for the property.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display names for the property.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// Type of entity.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// The properties of the Profile.
	Fields []*PropertyDefinition `json:"fields,omitempty"`

	// The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`

	// Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes,omitempty"`

	// Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`

	// Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`

	// The name of the entity.
	TypeName *string `json:"typeName,omitempty"`

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time `json:"lastChangedUtc,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// GetImageUploadURLInput - Input type for getting image upload url.
type GetImageUploadURLInput struct {
	// Type of entity. Can be Profile or Interaction.
	EntityType *string `json:"entityType,omitempty"`

	// Name of the entity type.
	EntityTypeName *string `json:"entityTypeName,omitempty"`

	// Relative path of the image.
	RelativePath *string `json:"relativePath,omitempty"`
}

// Hub resource.
type Hub struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of hub.
	Properties *HubPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HubBillingInfoFormat - Hub billing info.
type HubBillingInfoFormat struct {
	// The maximum number of units can be used. One unit is 10,000 Profiles and 100,000 Interactions.
	MaxUnits *int32 `json:"maxUnits,omitempty"`

	// The minimum number of units will be billed. One unit is 10,000 Profiles and 100,000 Interactions.
	MinUnits *int32 `json:"minUnits,omitempty"`

	// The sku name.
	SKUName *string `json:"skuName,omitempty"`
}

// HubListResult - Response of list hub operation.
type HubListResult struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Hub `json:"value,omitempty"`
}

// HubPropertiesFormat - Properties of hub.
type HubPropertiesFormat struct {
	// Billing settings of the hub.
	HubBillingInfo *HubBillingInfoFormat `json:"hubBillingInfo,omitempty"`

	// The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is
	// set to 1 indicates the hub is disabled, or enabled if set to 0.
	TenantFeatures *int32 `json:"tenantFeatures,omitempty"`

	// READ-ONLY; API endpoint URL of the hub.
	APIEndpoint *string `json:"apiEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the hub.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Web endpoint URL of the hub.
	WebEndpoint *string `json:"webEndpoint,omitempty" azure:"ro"`
}

// HubsClientBeginDeleteOptions contains the optional parameters for the HubsClient.BeginDelete method.
type HubsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// HubsClientCreateOrUpdateOptions contains the optional parameters for the HubsClient.CreateOrUpdate method.
type HubsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// HubsClientGetOptions contains the optional parameters for the HubsClient.Get method.
type HubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HubsClientListByResourceGroupOptions contains the optional parameters for the HubsClient.ListByResourceGroup method.
type HubsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// HubsClientListOptions contains the optional parameters for the HubsClient.List method.
type HubsClientListOptions struct {
	// placeholder for future optional parameters
}

// HubsClientUpdateOptions contains the optional parameters for the HubsClient.Update method.
type HubsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ImageDefinition - The image definition.
type ImageDefinition struct {
	// Content URL for the image blob.
	ContentURL *string `json:"contentUrl,omitempty"`

	// Whether image exists already.
	ImageExists *bool `json:"imageExists,omitempty"`

	// Relative path of the image.
	RelativePath *string `json:"relativePath,omitempty"`
}

// ImagesClientGetUploadURLForDataOptions contains the optional parameters for the ImagesClient.GetUploadURLForData method.
type ImagesClientGetUploadURLForDataOptions struct {
	// placeholder for future optional parameters
}

// ImagesClientGetUploadURLForEntityTypeOptions contains the optional parameters for the ImagesClient.GetUploadURLForEntityType
// method.
type ImagesClientGetUploadURLForEntityTypeOptions struct {
	// placeholder for future optional parameters
}

// InteractionListResult - The response of list interaction operation.
type InteractionListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*InteractionResourceFormat `json:"value,omitempty"`
}

// InteractionResourceFormat - The interaction resource format.
type InteractionResourceFormat struct {
	// The Interaction Type Definition
	Properties *InteractionTypeDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InteractionTypeDefinition - The Interaction Type Definition
type InteractionTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`

	// The attributes for the Type.
	Attributes map[string][]*string `json:"attributes,omitempty"`

	// Default data source is specifically used in cases where data source is not specified in an instance.
	DefaultDataSource *DataSource `json:"defaultDataSource,omitempty"`

	// Localized descriptions for the property.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display names for the property.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// Type of entity.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// The properties of the Profile.
	Fields []*PropertyDefinition `json:"fields,omitempty"`

	// The id property names. Properties which uniquely identify an interaction instance.
	IDPropertyNames []*string `json:"idPropertyNames,omitempty"`

	// The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`

	// An interaction can be tagged as an activity only during create. This enables the interaction to be editable and can enable
	// merging of properties from multiple data sources based on precedence, which
	// is defined at a link level.
	IsActivity *bool `json:"isActivity,omitempty"`

	// Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes,omitempty"`

	// Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`

	// Profiles that participated in the interaction.
	ParticipantProfiles []*Participant `json:"participantProfiles,omitempty"`

	// The primary participant property name for an interaction ,This is used to logically represent the agent of the interaction,
	// Specify the participant name here from ParticipantName.
	PrimaryParticipantProfilePropertyName *string `json:"primaryParticipantProfilePropertyName,omitempty"`

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`

	// Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`

	// The name of the entity.
	TypeName *string `json:"typeName,omitempty"`

	// READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored
	// and also in precedence rules.
	DataSourcePrecedenceRules []*DataSourcePrecedence `json:"dataSourcePrecedenceRules,omitempty" azure:"ro"`

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time `json:"lastChangedUtc,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// InteractionsClientBeginCreateOrUpdateOptions contains the optional parameters for the InteractionsClient.BeginCreateOrUpdate
// method.
type InteractionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InteractionsClientGetOptions contains the optional parameters for the InteractionsClient.Get method.
type InteractionsClientGetOptions struct {
	// Locale of interaction to retrieve, default is en-us.
	LocaleCode *string
}

// InteractionsClientListByHubOptions contains the optional parameters for the InteractionsClient.ListByHub method.
type InteractionsClientListByHubOptions struct {
	// Locale of interaction to retrieve, default is en-us.
	LocaleCode *string
}

// InteractionsClientSuggestRelationshipLinksOptions contains the optional parameters for the InteractionsClient.SuggestRelationshipLinks
// method.
type InteractionsClientSuggestRelationshipLinksOptions struct {
	// placeholder for future optional parameters
}

// KpiAlias - The KPI alias.
type KpiAlias struct {
	// REQUIRED; KPI alias name.
	AliasName *string `json:"aliasName,omitempty"`

	// REQUIRED; The expression.
	Expression *string `json:"expression,omitempty"`
}

// KpiClientBeginCreateOrUpdateOptions contains the optional parameters for the KpiClient.BeginCreateOrUpdate method.
type KpiClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KpiClientBeginDeleteOptions contains the optional parameters for the KpiClient.BeginDelete method.
type KpiClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KpiClientGetOptions contains the optional parameters for the KpiClient.Get method.
type KpiClientGetOptions struct {
	// placeholder for future optional parameters
}

// KpiClientListByHubOptions contains the optional parameters for the KpiClient.ListByHub method.
type KpiClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// KpiClientReprocessOptions contains the optional parameters for the KpiClient.Reprocess method.
type KpiClientReprocessOptions struct {
	// placeholder for future optional parameters
}

// KpiDefinition - Defines the KPI Threshold limits.
type KpiDefinition struct {
	// REQUIRED; The calculation window.
	CalculationWindow *CalculationWindowTypes `json:"calculationWindow,omitempty"`

	// REQUIRED; The mapping entity type.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// REQUIRED; The mapping entity name.
	EntityTypeName *string `json:"entityTypeName,omitempty"`

	// REQUIRED; The computation expression for the KPI.
	Expression *string `json:"expression,omitempty"`

	// REQUIRED; The computation function for the KPI.
	Function *KpiFunctions `json:"function,omitempty"`

	// The aliases.
	Aliases []*KpiAlias `json:"aliases,omitempty"`

	// Name of calculation window field.
	CalculationWindowFieldName *string `json:"calculationWindowFieldName,omitempty"`

	// Localized description for the KPI.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name for the KPI.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The KPI extracts.
	Extracts []*KpiExtract `json:"extracts,omitempty"`

	// The filter expression for the KPI.
	Filter *string `json:"filter,omitempty"`

	// the group by properties for the KPI.
	GroupBy []*string `json:"groupBy,omitempty"`

	// The KPI thresholds.
	ThresHolds *KpiThresholds `json:"thresHolds,omitempty"`

	// The unit of measurement for the KPI.
	Unit *string `json:"unit,omitempty"`

	// READ-ONLY; The KPI GroupByMetadata.
	GroupByMetadata []*KpiGroupByMetadata `json:"groupByMetadata,omitempty" azure:"ro"`

	// READ-ONLY; The KPI name.
	KpiName *string `json:"kpiName,omitempty" azure:"ro"`

	// READ-ONLY; The participant profiles.
	ParticipantProfilesMetadata []*KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// KpiExtract - The KPI extract.
type KpiExtract struct {
	// REQUIRED; The expression.
	Expression *string `json:"expression,omitempty"`

	// REQUIRED; KPI extract name.
	ExtractName *string `json:"extractName,omitempty"`
}

// KpiGroupByMetadata - The KPI GroupBy field metadata.
type KpiGroupByMetadata struct {
	// The display name.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The name of the field.
	FieldName *string `json:"fieldName,omitempty"`

	// The type of the field.
	FieldType *string `json:"fieldType,omitempty"`
}

// KpiListResult - The response of list KPI operation.
type KpiListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*KpiResourceFormat `json:"value,omitempty"`
}

// KpiParticipantProfilesMetadata - The KPI participant profile metadata.
type KpiParticipantProfilesMetadata struct {
	// REQUIRED; Name of the type.
	TypeName *string `json:"typeName,omitempty"`
}

// KpiResourceFormat - The KPI resource format.
type KpiResourceFormat struct {
	// Defines the KPI Threshold limits.
	Properties *KpiDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KpiThresholds - Defines the KPI Threshold limits.
type KpiThresholds struct {
	// REQUIRED; Whether or not the KPI is an increasing KPI.
	IncreasingKpi *bool `json:"increasingKpi,omitempty"`

	// REQUIRED; The lower threshold limit.
	LowerLimit *float64 `json:"lowerLimit,omitempty"`

	// REQUIRED; The upper threshold limit.
	UpperLimit *float64 `json:"upperLimit,omitempty"`
}

// LinkDefinition - The definition of Link.
type LinkDefinition struct {
	// REQUIRED; The properties that represent the participating profile.
	ParticipantPropertyReferences []*ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`

	// REQUIRED; Type of source entity.
	SourceEntityType *EntityType `json:"sourceEntityType,omitempty"`

	// REQUIRED; Name of the source Entity Type.
	SourceEntityTypeName *string `json:"sourceEntityTypeName,omitempty"`

	// REQUIRED; Type of target entity.
	TargetEntityType *EntityType `json:"targetEntityType,omitempty"`

	// REQUIRED; Name of the target Entity Type.
	TargetEntityTypeName *string `json:"targetEntityTypeName,omitempty"`

	// Localized descriptions for the Link.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name for the Link.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The set of properties mappings between the source and target Types.
	Mappings []*TypePropertiesMapping `json:"mappings,omitempty"`

	// Determines whether this link is supposed to create or delete instances if Link is NOT Reference Only.
	OperationType *InstanceOperationType `json:"operationType,omitempty"`

	// Indicating whether the link is reference only link. This flag is ignored if the Mappings are defined. If the mappings are
	// not defined and it is set to true, links processing will not create or update
	// profiles.
	ReferenceOnly *bool `json:"referenceOnly,omitempty"`

	// READ-ONLY; The link name.
	LinkName *string `json:"linkName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// LinkListResult - The response of list link operation.
type LinkListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*LinkResourceFormat `json:"value,omitempty"`
}

// LinkResourceFormat - The link resource format.
type LinkResourceFormat struct {
	// The definition of Link.
	Properties *LinkDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LinksClientBeginCreateOrUpdateOptions contains the optional parameters for the LinksClient.BeginCreateOrUpdate method.
type LinksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LinksClientDeleteOptions contains the optional parameters for the LinksClient.Delete method.
type LinksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LinksClientGetOptions contains the optional parameters for the LinksClient.Get method.
type LinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// LinksClientListByHubOptions contains the optional parameters for the LinksClient.ListByHub method.
type LinksClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// MetadataDefinitionBase - The Metadata definition base.
type MetadataDefinitionBase struct {
	// The attributes for the Type.
	Attributes map[string][]*string `json:"attributes,omitempty"`

	// Localized descriptions for the property.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display names for the property.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes,omitempty"`

	// Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`

	// Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`
}

// Operation - A Customer Insights REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.CustomerInsights
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Customer Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Customer Insights operations supported by the Microsoft.CustomerInsights resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Participant - Describes a profile type participating in an interaction.
type Participant struct {
	// REQUIRED; Participant name.
	ParticipantName *string `json:"participantName,omitempty"`

	// REQUIRED; The property references.
	ParticipantPropertyReferences []*ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`

	// REQUIRED; Profile type name.
	ProfileTypeName *string `json:"profileTypeName,omitempty"`

	// Localized descriptions.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The role that the participant is playing in the interaction.
	Role *string `json:"role,omitempty"`
}

// ParticipantProfilePropertyReference - The participant profile property reference.
type ParticipantProfilePropertyReference struct {
	// REQUIRED; The source interaction property that maps to the target profile property.
	InteractionPropertyName *string `json:"interactionPropertyName,omitempty"`

	// REQUIRED; The target profile property that maps to the source interaction property.
	ProfilePropertyName *string `json:"profilePropertyName,omitempty"`
}

// ParticipantPropertyReference - The participant property reference.
type ParticipantPropertyReference struct {
	// REQUIRED; The source property that maps to the target property.
	SourcePropertyName *string `json:"sourcePropertyName,omitempty"`

	// REQUIRED; The target property that maps to the source property.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
}

// Prediction - The prediction definition.
type Prediction struct {
	// REQUIRED; Whether do auto analyze.
	AutoAnalyze *bool `json:"autoAnalyze,omitempty"`

	// REQUIRED; Definition of the link mapping of prediction.
	Mappings *PredictionMappings `json:"mappings,omitempty"`

	// REQUIRED; Negative outcome expression.
	NegativeOutcomeExpression *string `json:"negativeOutcomeExpression,omitempty"`

	// REQUIRED; Positive outcome expression.
	PositiveOutcomeExpression *string `json:"positiveOutcomeExpression,omitempty"`

	// REQUIRED; Primary profile type.
	PrimaryProfileType *string `json:"primaryProfileType,omitempty"`

	// REQUIRED; Scope expression.
	ScopeExpression *string `json:"scopeExpression,omitempty"`

	// REQUIRED; Score label.
	ScoreLabel *string `json:"scoreLabel,omitempty"`

	// Description of the prediction.
	Description map[string]*string `json:"description,omitempty"`

	// Display name of the prediction.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The prediction grades.
	Grades []*PredictionGradesItem `json:"grades,omitempty"`

	// Interaction types involved in the prediction.
	InvolvedInteractionTypes []*string `json:"involvedInteractionTypes,omitempty"`

	// KPI types involved in the prediction.
	InvolvedKpiTypes []*string `json:"involvedKpiTypes,omitempty"`

	// Relationships involved in the prediction.
	InvolvedRelationships []*string `json:"involvedRelationships,omitempty"`

	// Name of the prediction.
	PredictionName *string `json:"predictionName,omitempty"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; System generated entities.
	SystemGeneratedEntities *PredictionSystemGeneratedEntities `json:"systemGeneratedEntities,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// PredictionDistributionDefinition - The definition of the prediction distribution.
type PredictionDistributionDefinition struct {
	// Distributions of the prediction.
	Distributions []*PredictionDistributionDefinitionDistributionsItem `json:"distributions,omitempty"`

	// Total negatives in the distribution.
	TotalNegatives *int64 `json:"totalNegatives,omitempty"`

	// Total positive in the distribution.
	TotalPositives *int64 `json:"totalPositives,omitempty"`
}

// PredictionDistributionDefinitionDistributionsItem - The definition of a prediction distribution.
type PredictionDistributionDefinitionDistributionsItem struct {
	// Number of negatives.
	Negatives *int64 `json:"negatives,omitempty"`

	// Number of negatives above threshold.
	NegativesAboveThreshold *int64 `json:"negativesAboveThreshold,omitempty"`

	// Number of positives.
	Positives *int64 `json:"positives,omitempty"`

	// Number of positives above threshold.
	PositivesAboveThreshold *int64 `json:"positivesAboveThreshold,omitempty"`

	// Score threshold.
	ScoreThreshold *int32 `json:"scoreThreshold,omitempty"`
}

// PredictionGradesItem - The definition of a prediction grade.
type PredictionGradesItem struct {
	// Name of the grade.
	GradeName *string `json:"gradeName,omitempty"`

	// Maximum score threshold.
	MaxScoreThreshold *int32 `json:"maxScoreThreshold,omitempty"`

	// Minimum score threshold.
	MinScoreThreshold *int32 `json:"minScoreThreshold,omitempty"`
}

// PredictionListResult - The response of list predictions operation.
type PredictionListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*PredictionResourceFormat `json:"value,omitempty"`
}

// PredictionMappings - Definition of the link mapping of prediction.
type PredictionMappings struct {
	// REQUIRED; The grade of the link mapping.
	Grade *string `json:"grade,omitempty"`

	// REQUIRED; The reason of the link mapping.
	Reason *string `json:"reason,omitempty"`

	// REQUIRED; The score of the link mapping.
	Score *string `json:"score,omitempty"`
}

// PredictionModelStatus - The prediction model status.
type PredictionModelStatus struct {
	// REQUIRED; Prediction model life cycle. When prediction is in PendingModelConfirmation status, it is allowed to update the
	// status to PendingFeaturing or Active through API.
	Status *PredictionModelLifeCycle `json:"status,omitempty"`

	// READ-ONLY; The model status message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Version of the model.
	ModelVersion *string `json:"modelVersion,omitempty" azure:"ro"`

	// READ-ONLY; The prediction GUID ID.
	PredictionGUIDID *string `json:"predictionGuidId,omitempty" azure:"ro"`

	// READ-ONLY; The prediction name.
	PredictionName *string `json:"predictionName,omitempty" azure:"ro"`

	// READ-ONLY; The signals used.
	SignalsUsed *int32 `json:"signalsUsed,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Count of the test set.
	TestSetCount *int32 `json:"testSetCount,omitempty" azure:"ro"`

	// READ-ONLY; The training accuracy.
	TrainingAccuracy *float64 `json:"trainingAccuracy,omitempty" azure:"ro"`

	// READ-ONLY; Count of the training set.
	TrainingSetCount *int32 `json:"trainingSetCount,omitempty" azure:"ro"`

	// READ-ONLY; Count of the validation set.
	ValidationSetCount *int32 `json:"validationSetCount,omitempty" azure:"ro"`
}

// PredictionResourceFormat - The prediction resource format.
type PredictionResourceFormat struct {
	// The prediction definition.
	Properties *Prediction `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PredictionSystemGeneratedEntities - System generated entities.
type PredictionSystemGeneratedEntities struct {
	// Generated interaction types.
	GeneratedInteractionTypes []*string `json:"generatedInteractionTypes,omitempty"`

	// Generated KPIs.
	GeneratedKpis map[string]*string `json:"generatedKpis,omitempty"`

	// Generated links.
	GeneratedLinks []*string `json:"generatedLinks,omitempty"`
}

// PredictionTrainingResults - The training results of the prediction.
type PredictionTrainingResults struct {
	// READ-ONLY; Canonical profiles.
	CanonicalProfiles []*CanonicalProfileDefinition `json:"canonicalProfiles,omitempty" azure:"ro"`

	// READ-ONLY; Prediction distribution.
	PredictionDistribution *PredictionDistributionDefinition `json:"predictionDistribution,omitempty" azure:"ro"`

	// READ-ONLY; Instance count of the primary profile.
	PrimaryProfileInstanceCount *int64 `json:"primaryProfileInstanceCount,omitempty" azure:"ro"`

	// READ-ONLY; Score name.
	ScoreName *string `json:"scoreName,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// PredictionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PredictionsClient.BeginCreateOrUpdate
// method.
type PredictionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PredictionsClientBeginDeleteOptions contains the optional parameters for the PredictionsClient.BeginDelete method.
type PredictionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PredictionsClientGetModelStatusOptions contains the optional parameters for the PredictionsClient.GetModelStatus method.
type PredictionsClientGetModelStatusOptions struct {
	// placeholder for future optional parameters
}

// PredictionsClientGetOptions contains the optional parameters for the PredictionsClient.Get method.
type PredictionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PredictionsClientGetTrainingResultsOptions contains the optional parameters for the PredictionsClient.GetTrainingResults
// method.
type PredictionsClientGetTrainingResultsOptions struct {
	// placeholder for future optional parameters
}

// PredictionsClientListByHubOptions contains the optional parameters for the PredictionsClient.ListByHub method.
type PredictionsClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// PredictionsClientModelStatusOptions contains the optional parameters for the PredictionsClient.ModelStatus method.
type PredictionsClientModelStatusOptions struct {
	// placeholder for future optional parameters
}

// ProfileEnumValidValuesFormat - Valid enum values in case of an enum property.
type ProfileEnumValidValuesFormat struct {
	// Localized names of the enum member.
	LocalizedValueNames map[string]*string `json:"localizedValueNames,omitempty"`

	// The integer value of the enum member.
	Value *int32 `json:"value,omitempty"`
}

// ProfileListResult - The response of list profile operation.
type ProfileListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ProfileResourceFormat `json:"value,omitempty"`
}

// ProfileResourceFormat - The profile resource format.
type ProfileResourceFormat struct {
	// The profile type definition.
	Properties *ProfileTypeDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProfileTypeDefinition - The profile type definition.
type ProfileTypeDefinition struct {
	// The api entity set name. This becomes the odata entity set name for the entity Type being referred in this object.
	APIEntitySetName *string `json:"apiEntitySetName,omitempty"`

	// The attributes for the Type.
	Attributes map[string][]*string `json:"attributes,omitempty"`

	// Localized descriptions for the property.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display names for the property.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// Type of entity.
	EntityType *EntityTypes `json:"entityType,omitempty"`

	// The properties of the Profile.
	Fields []*PropertyDefinition `json:"fields,omitempty"`

	// The instance count.
	InstancesCount *int32 `json:"instancesCount,omitempty"`

	// Large Image associated with the Property or EntityType.
	LargeImage *string `json:"largeImage,omitempty"`

	// Any custom localized attributes for the Type.
	LocalizedAttributes map[string]map[string]*string `json:"localizedAttributes,omitempty"`

	// Medium Image associated with the Property or EntityType.
	MediumImage *string `json:"mediumImage,omitempty"`

	// The schema org link. This helps ACI identify and suggest semantic models.
	SchemaItemTypeLink *string `json:"schemaItemTypeLink,omitempty"`

	// Small Image associated with the Property or EntityType.
	SmallImage *string `json:"smallImage,omitempty"`

	// The strong IDs.
	StrongIDs []*StrongID `json:"strongIds,omitempty"`

	// The timestamp property name. Represents the time when the interaction or profile update happened.
	TimestampFieldName *string `json:"timestampFieldName,omitempty"`

	// The name of the entity.
	TypeName *string `json:"typeName,omitempty"`

	// READ-ONLY; The last changed time for the type definition.
	LastChangedUTC *time.Time `json:"lastChangedUtc,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ProfilesClientBeginCreateOrUpdateOptions contains the optional parameters for the ProfilesClient.BeginCreateOrUpdate method.
type ProfilesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientBeginDeleteOptions contains the optional parameters for the ProfilesClient.BeginDelete method.
type ProfilesClientBeginDeleteOptions struct {
	// Locale of profile to retrieve, default is en-us.
	LocaleCode *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProfilesClientGetEnrichingKpisOptions contains the optional parameters for the ProfilesClient.GetEnrichingKpis method.
type ProfilesClientGetEnrichingKpisOptions struct {
	// placeholder for future optional parameters
}

// ProfilesClientGetOptions contains the optional parameters for the ProfilesClient.Get method.
type ProfilesClientGetOptions struct {
	// Locale of profile to retrieve, default is en-us.
	LocaleCode *string
}

// ProfilesClientListByHubOptions contains the optional parameters for the ProfilesClient.ListByHub method.
type ProfilesClientListByHubOptions struct {
	// Locale of profile to retrieve, default is en-us.
	LocaleCode *string
}

// PropertyDefinition - Property definition.
type PropertyDefinition struct {
	// REQUIRED; Name of the property.
	FieldName *string `json:"fieldName,omitempty"`

	// REQUIRED; Type of the property.
	FieldType *string `json:"fieldType,omitempty"`

	// Array value separator for properties with isArray set.
	ArrayValueSeparator *string `json:"arrayValueSeparator,omitempty"`

	// Describes valid values for an enum property.
	EnumValidValues []*ProfileEnumValidValuesFormat `json:"enumValidValues,omitempty"`

	// Indicates if the property is actually an array of the fieldType above on the data api.
	IsArray *bool `json:"isArray,omitempty"`

	// Whether property is available in graph or not.
	IsAvailableInGraph *bool `json:"isAvailableInGraph,omitempty"`

	// Indicates if the property is an enum.
	IsEnum *bool `json:"isEnum,omitempty"`

	// Indicates if the property is an flag enum.
	IsFlagEnum *bool `json:"isFlagEnum,omitempty"`

	// Whether the property is an Image.
	IsImage *bool `json:"isImage,omitempty"`

	// Whether the property is a localized string.
	IsLocalizedString *bool `json:"isLocalizedString,omitempty"`

	// Whether the property is a name or a part of name.
	IsName *bool `json:"isName,omitempty"`

	// Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check
	// for required field.
	IsRequired *bool `json:"isRequired,omitempty"`

	// Max length of string. Used only if type is string.
	MaxLength *int32 `json:"maxLength,omitempty"`

	// The ID associated with the property.
	PropertyID *string `json:"propertyId,omitempty"`

	// URL encoded schema.org item prop link for the property.
	SchemaItemPropLink *string `json:"schemaItemPropLink,omitempty"`

	// READ-ONLY; This is specific to interactions modeled as activities. Data sources are used to determine where data is stored
	// and also in precedence rules.
	DataSourcePrecedenceRules []*DataSourcePrecedence `json:"dataSourcePrecedenceRules,omitempty" azure:"ro"`
}

// ProxyResource - Common properties of proxy resource.
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelationshipDefinition - The definition of Relationship.
type RelationshipDefinition struct {
	// REQUIRED; Profile type.
	ProfileType *string `json:"profileType,omitempty"`

	// REQUIRED; Related profile being referenced.
	RelatedProfileType *string `json:"relatedProfileType,omitempty"`

	// The Relationship Cardinality.
	Cardinality *CardinalityTypes `json:"cardinality,omitempty"`

	// Localized descriptions for the Relationship.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name for the Relationship.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The expiry date time in UTC.
	ExpiryDateTimeUTC *time.Time `json:"expiryDateTimeUtc,omitempty"`

	// The properties of the Relationship.
	Fields []*PropertyDefinition `json:"fields,omitempty"`

	// Optional property to be used to map fields in profile to their strong ids in related profile.
	LookupMappings []*RelationshipTypeMapping `json:"lookupMappings,omitempty"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string `json:"relationshipGuidId,omitempty" azure:"ro"`

	// READ-ONLY; The Relationship name.
	RelationshipName *string `json:"relationshipName,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// RelationshipLinkDefinition - The definition of relationship link.
type RelationshipLinkDefinition struct {
	// REQUIRED; The InteractionType associated with the Relationship Link.
	InteractionType *string `json:"interactionType,omitempty"`

	// REQUIRED; The property references for the Profile of the Relationship.
	ProfilePropertyReferences []*ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty"`

	// REQUIRED; The property references for the Related Profile of the Relationship.
	RelatedProfilePropertyReferences []*ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty"`

	// REQUIRED; The Relationship associated with the Link.
	RelationshipName *string `json:"relationshipName,omitempty"`

	// Localized descriptions for the Relationship Link.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name for the Relationship Link.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The mappings between Interaction and Relationship fields.
	Mappings []*RelationshipLinkFieldMapping `json:"mappings,omitempty"`

	// READ-ONLY; The name of the Relationship Link.
	LinkName *string `json:"linkName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The relationship guid id.
	RelationshipGUIDID *string `json:"relationshipGuidId,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// RelationshipLinkFieldMapping - The fields mapping for Relationships.
type RelationshipLinkFieldMapping struct {
	// REQUIRED; The field name on the Interaction Type.
	InteractionFieldName *string `json:"interactionFieldName,omitempty"`

	// REQUIRED; The field name on the Relationship metadata.
	RelationshipFieldName *string `json:"relationshipFieldName,omitempty"`

	// Link type.
	LinkType *LinkTypes `json:"linkType,omitempty"`
}

// RelationshipLinkListResult - The response of list relationship link operation.
type RelationshipLinkListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*RelationshipLinkResourceFormat `json:"value,omitempty"`
}

// RelationshipLinkResourceFormat - The relationship link resource format.
type RelationshipLinkResourceFormat struct {
	// The definition of relationship link.
	Properties *RelationshipLinkDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelationshipLinksClientBeginCreateOrUpdateOptions contains the optional parameters for the RelationshipLinksClient.BeginCreateOrUpdate
// method.
type RelationshipLinksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RelationshipLinksClientBeginDeleteOptions contains the optional parameters for the RelationshipLinksClient.BeginDelete
// method.
type RelationshipLinksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RelationshipLinksClientGetOptions contains the optional parameters for the RelationshipLinksClient.Get method.
type RelationshipLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// RelationshipLinksClientListByHubOptions contains the optional parameters for the RelationshipLinksClient.ListByHub method.
type RelationshipLinksClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// RelationshipListResult - The response of list relationship operation.
type RelationshipListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*RelationshipResourceFormat `json:"value,omitempty"`
}

// RelationshipResourceFormat - The relationship resource format.
type RelationshipResourceFormat struct {
	// The definition of Relationship.
	Properties *RelationshipDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelationshipTypeFieldMapping - Map a field of profile to its corresponding StrongId in Related Profile.
type RelationshipTypeFieldMapping struct {
	// REQUIRED; Specifies the fieldName in profile.
	ProfileFieldName *string `json:"profileFieldName,omitempty"`

	// REQUIRED; Specifies the KeyProperty (from StrongId) of the related profile.
	RelatedProfileKeyProperty *string `json:"relatedProfileKeyProperty,omitempty"`
}

// RelationshipTypeMapping - Maps fields in Profile to their corresponding StrongIds in Related Profile.
type RelationshipTypeMapping struct {
	// REQUIRED; Maps a profile property with the StrongId of related profile. This is an array to support StrongIds that are
	// composite key as well.
	FieldMappings []*RelationshipTypeFieldMapping `json:"fieldMappings,omitempty"`
}

// RelationshipsClientBeginCreateOrUpdateOptions contains the optional parameters for the RelationshipsClient.BeginCreateOrUpdate
// method.
type RelationshipsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RelationshipsClientBeginDeleteOptions contains the optional parameters for the RelationshipsClient.BeginDelete method.
type RelationshipsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RelationshipsClientGetOptions contains the optional parameters for the RelationshipsClient.Get method.
type RelationshipsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RelationshipsClientListByHubOptions contains the optional parameters for the RelationshipsClient.ListByHub method.
type RelationshipsClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// RelationshipsLookup - The definition of suggested relationship for the type.
type RelationshipsLookup struct {
	// READ-ONLY; The name of existing Relationship.
	ExistingRelationshipName *string `json:"existingRelationshipName,omitempty" azure:"ro"`

	// READ-ONLY; The relationship profile.
	ProfileName *string `json:"profileName,omitempty" azure:"ro"`

	// READ-ONLY; The property references for the profile type.
	ProfilePropertyReferences []*ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty" azure:"ro"`

	// READ-ONLY; The related profile.
	RelatedProfileName *string `json:"relatedProfileName,omitempty" azure:"ro"`

	// READ-ONLY; The property references for the related profile type.
	RelatedProfilePropertyReferences []*ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty" azure:"ro"`
}

// Resource - Common properties of Azure resource.
type Resource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceSetDescription - The resource set description.
type ResourceSetDescription struct {
	// The elements included in the set.
	Elements []*string `json:"elements,omitempty"`

	// The elements that are not included in the set, in case elements contains '*' indicating 'all'.
	Exceptions []*string `json:"exceptions,omitempty"`
}

// Role - The Role definition.
type Role struct {
	// The description of the role.
	Description *string `json:"description,omitempty"`

	// The role name.
	RoleName *string `json:"roleName,omitempty"`
}

// RoleAssignment - The Role Assignment definition.
type RoleAssignment struct {
	// REQUIRED; The principals being assigned to.
	Principals []*AssignmentPrincipal `json:"principals,omitempty"`

	// REQUIRED; Type of roles.
	Role *RoleTypes `json:"role,omitempty"`

	// Widget types set for the assignment.
	ConflationPolicies *ResourceSetDescription `json:"conflationPolicies,omitempty"`

	// Connectors set for the assignment.
	Connectors *ResourceSetDescription `json:"connectors,omitempty"`

	// Localized description for the metadata.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display names for the metadata.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// Interactions set for the assignment.
	Interactions *ResourceSetDescription `json:"interactions,omitempty"`

	// Kpis set for the assignment.
	Kpis *ResourceSetDescription `json:"kpis,omitempty"`

	// Links set for the assignment.
	Links *ResourceSetDescription `json:"links,omitempty"`

	// Profiles set for the assignment.
	Profiles *ResourceSetDescription `json:"profiles,omitempty"`

	// The Role assignments set for the relationship links.
	RelationshipLinks *ResourceSetDescription `json:"relationshipLinks,omitempty"`

	// The Role assignments set for the relationships.
	Relationships *ResourceSetDescription `json:"relationships,omitempty"`

	// The Role assignments set for the assignment.
	RoleAssignments *ResourceSetDescription `json:"roleAssignments,omitempty"`

	// Sas Policies set for the assignment.
	SasPolicies *ResourceSetDescription `json:"sasPolicies,omitempty"`

	// The Role assignments set for the assignment.
	Segments *ResourceSetDescription `json:"segments,omitempty"`

	// Views set for the assignment.
	Views *ResourceSetDescription `json:"views,omitempty"`

	// Widget types set for the assignment.
	WidgetTypes *ResourceSetDescription `json:"widgetTypes,omitempty"`

	// READ-ONLY; The name of the metadata object.
	AssignmentName *string `json:"assignmentName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningStates `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// RoleAssignmentListResult - The response of list role assignment operation.
type RoleAssignmentListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*RoleAssignmentResourceFormat `json:"value,omitempty"`
}

// RoleAssignmentResourceFormat - The Role Assignment resource format.
type RoleAssignmentResourceFormat struct {
	// The Role Assignment definition.
	Properties *RoleAssignment `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the RoleAssignmentsClient.BeginCreateOrUpdate
// method.
type RoleAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoleAssignmentsClientDeleteOptions contains the optional parameters for the RoleAssignmentsClient.Delete method.
type RoleAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetOptions contains the optional parameters for the RoleAssignmentsClient.Get method.
type RoleAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientListByHubOptions contains the optional parameters for the RoleAssignmentsClient.ListByHub method.
type RoleAssignmentsClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// RoleListResult - The response of list role assignment operation.
type RoleListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*RoleResourceFormat `json:"value,omitempty"`
}

// RoleResourceFormat - The role resource format.
type RoleResourceFormat struct {
	// The Role definition.
	Properties *Role `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RolesClientListByHubOptions contains the optional parameters for the RolesClient.ListByHub method.
type RolesClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// SalesforceConnectorProperties - The Salesforce connector properties.
type SalesforceConnectorProperties struct {
	// REQUIRED; The Salesforce tables.
	Salesforcetables []*SalesforceTable `json:"salesforcetables,omitempty"`

	// REQUIRED; The user settings.
	Usersetting *SalesforceDiscoverSetting `json:"usersetting,omitempty"`
}

// SalesforceDiscoverSetting - Salesforce discover setting.
type SalesforceDiscoverSetting struct {
	// REQUIRED; The salesforce connection string secret URL.
	SalesforceConnectionStringSecretURL *string `json:"salesforceConnectionStringSecretUrl,omitempty"`
}

// SalesforceTable - Salesforce table.
type SalesforceTable struct {
	// REQUIRED; The table category.
	TableCategory *string `json:"tableCategory,omitempty"`

	// REQUIRED; The name of the table.
	TableName *string `json:"tableName,omitempty"`

	// REQUIRED; The table schema.
	TableSchema *string `json:"tableSchema,omitempty"`

	// Indicating whether this instance is profile.
	IsProfile *string `json:"isProfile,omitempty"`

	// The table remarks.
	TableRemarks *string `json:"tableRemarks,omitempty"`
}

// StrongID - Property/Properties which represent a unique ID.
type StrongID struct {
	// REQUIRED; The properties which make up the unique ID.
	KeyPropertyNames []*string `json:"keyPropertyNames,omitempty"`

	// REQUIRED; The Name identifying the strong ID.
	StrongIDName *string `json:"strongIdName,omitempty"`

	// Localized descriptions.
	Description map[string]*string `json:"description,omitempty"`

	// Localized display name.
	DisplayName map[string]*string `json:"displayName,omitempty"`
}

// SuggestRelationshipLinksResponse - The response of suggest relationship links operation.
type SuggestRelationshipLinksResponse struct {
	// READ-ONLY; The interaction name.
	InteractionName *string `json:"interactionName,omitempty" azure:"ro"`

	// READ-ONLY; Suggested relationships for the type.
	SuggestedRelationships []*RelationshipsLookup `json:"suggestedRelationships,omitempty" azure:"ro"`
}

// TypePropertiesMapping - Metadata for a Link's property mapping.
type TypePropertiesMapping struct {
	// REQUIRED; Property name on the source Entity Type.
	SourcePropertyName *string `json:"sourcePropertyName,omitempty"`

	// REQUIRED; Property name on the target Entity Type.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`

	// Link type.
	LinkType *LinkTypes `json:"linkType,omitempty"`
}

// View - The view in Customer 360 web application.
type View struct {
	// REQUIRED; View definition.
	Definition *string `json:"definition,omitempty"`

	// Localized display name for the view.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// the user ID.
	UserID *string `json:"userId,omitempty"`

	// READ-ONLY; Date time when view was last modified.
	Changed *time.Time `json:"changed,omitempty" azure:"ro"`

	// READ-ONLY; Date time when view was created.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; the hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the view.
	ViewName *string `json:"viewName,omitempty" azure:"ro"`
}

// ViewListResult - The response of list view operation.
type ViewListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ViewResourceFormat `json:"value,omitempty"`
}

// ViewResourceFormat - The view resource format.
type ViewResourceFormat struct {
	// The view in Customer 360 web application.
	Properties *View `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ViewsClientCreateOrUpdateOptions contains the optional parameters for the ViewsClient.CreateOrUpdate method.
type ViewsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientDeleteOptions contains the optional parameters for the ViewsClient.Delete method.
type ViewsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientGetOptions contains the optional parameters for the ViewsClient.Get method.
type ViewsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientListByHubOptions contains the optional parameters for the ViewsClient.ListByHub method.
type ViewsClientListByHubOptions struct {
	// placeholder for future optional parameters
}

// WidgetType - Definition of WidgetType.
type WidgetType struct {
	// REQUIRED; Definition for widget type.
	Definition *string `json:"definition,omitempty"`

	// Description for widget type.
	Description *string `json:"description,omitempty"`

	// Localized display name for the widget type.
	DisplayName map[string]*string `json:"displayName,omitempty"`

	// The image URL.
	ImageURL *string `json:"imageUrl,omitempty"`

	// The widget version.
	WidgetVersion *string `json:"widgetVersion,omitempty"`

	// READ-ONLY; Date time when widget type was last modified.
	Changed *time.Time `json:"changed,omitempty" azure:"ro"`

	// READ-ONLY; Date time when widget type was created.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The hub name.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the widget type.
	WidgetTypeName *string `json:"widgetTypeName,omitempty" azure:"ro"`
}

// WidgetTypeListResult - The response of list widget type operation.
type WidgetTypeListResult struct {
	// Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*WidgetTypeResourceFormat `json:"value,omitempty"`
}

// WidgetTypeResourceFormat - The WidgetTypeResourceFormat
type WidgetTypeResourceFormat struct {
	// Definition of WidgetType.
	Properties *WidgetType `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WidgetTypesClientGetOptions contains the optional parameters for the WidgetTypesClient.Get method.
type WidgetTypesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WidgetTypesClientListByHubOptions contains the optional parameters for the WidgetTypesClient.ListByHub method.
type WidgetTypesClientListByHubOptions struct {
	// placeholder for future optional parameters
}
