//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AttachedDatabaseConfigurationProperties.
func (a AttachedDatabaseConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attachedDatabaseNames", a.AttachedDatabaseNames)
	populate(objectMap, "databaseName", a.DatabaseName)
	populate(objectMap, "defaultPrincipalsModificationKind", a.DefaultPrincipalsModificationKind)
	populate(objectMap, "clusterResourceId", a.KustoPoolResourceID)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "tableLevelSharingProperties", a.TableLevelSharingProperties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AzureADOnlyAuthenticationProperties.
func (a AzureADOnlyAuthenticationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureADOnlyAuthentication", a.AzureADOnlyAuthentication)
	populateTimeRFC3339(objectMap, "creationDate", a.CreationDate)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureADOnlyAuthenticationProperties.
func (a *AzureADOnlyAuthenticationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureADOnlyAuthentication":
			err = unpopulate(val, "AzureADOnlyAuthentication", &a.AzureADOnlyAuthentication)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &a.CreationDate)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolPatchInfo.
func (b BigDataPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolResourceInfo.
func (b BigDataPoolResourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolResourceProperties.
func (b BigDataPoolResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoPause", b.AutoPause)
	populate(objectMap, "autoScale", b.AutoScale)
	populate(objectMap, "cacheSize", b.CacheSize)
	populateTimeRFC3339(objectMap, "creationDate", b.CreationDate)
	populate(objectMap, "customLibraries", b.CustomLibraries)
	populate(objectMap, "defaultSparkLogFolder", b.DefaultSparkLogFolder)
	populate(objectMap, "dynamicExecutorAllocation", b.DynamicExecutorAllocation)
	populate(objectMap, "isComputeIsolationEnabled", b.IsComputeIsolationEnabled)
	populateTimeRFC3339(objectMap, "lastSucceededTimestamp", b.LastSucceededTimestamp)
	populate(objectMap, "libraryRequirements", b.LibraryRequirements)
	populate(objectMap, "nodeCount", b.NodeCount)
	populate(objectMap, "nodeSize", b.NodeSize)
	populate(objectMap, "nodeSizeFamily", b.NodeSizeFamily)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "sessionLevelPackagesEnabled", b.SessionLevelPackagesEnabled)
	populate(objectMap, "sparkConfigProperties", b.SparkConfigProperties)
	populate(objectMap, "sparkEventsFolder", b.SparkEventsFolder)
	populate(objectMap, "sparkVersion", b.SparkVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolResourceProperties.
func (b *BigDataPoolResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoPause":
			err = unpopulate(val, "AutoPause", &b.AutoPause)
			delete(rawMsg, key)
		case "autoScale":
			err = unpopulate(val, "AutoScale", &b.AutoScale)
			delete(rawMsg, key)
		case "cacheSize":
			err = unpopulate(val, "CacheSize", &b.CacheSize)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &b.CreationDate)
			delete(rawMsg, key)
		case "customLibraries":
			err = unpopulate(val, "CustomLibraries", &b.CustomLibraries)
			delete(rawMsg, key)
		case "defaultSparkLogFolder":
			err = unpopulate(val, "DefaultSparkLogFolder", &b.DefaultSparkLogFolder)
			delete(rawMsg, key)
		case "dynamicExecutorAllocation":
			err = unpopulate(val, "DynamicExecutorAllocation", &b.DynamicExecutorAllocation)
			delete(rawMsg, key)
		case "isComputeIsolationEnabled":
			err = unpopulate(val, "IsComputeIsolationEnabled", &b.IsComputeIsolationEnabled)
			delete(rawMsg, key)
		case "lastSucceededTimestamp":
			err = unpopulateTimeRFC3339(val, "LastSucceededTimestamp", &b.LastSucceededTimestamp)
			delete(rawMsg, key)
		case "libraryRequirements":
			err = unpopulate(val, "LibraryRequirements", &b.LibraryRequirements)
			delete(rawMsg, key)
		case "nodeCount":
			err = unpopulate(val, "NodeCount", &b.NodeCount)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &b.NodeSize)
			delete(rawMsg, key)
		case "nodeSizeFamily":
			err = unpopulate(val, "NodeSizeFamily", &b.NodeSizeFamily)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "sessionLevelPackagesEnabled":
			err = unpopulate(val, "SessionLevelPackagesEnabled", &b.SessionLevelPackagesEnabled)
			delete(rawMsg, key)
		case "sparkConfigProperties":
			err = unpopulate(val, "SparkConfigProperties", &b.SparkConfigProperties)
			delete(rawMsg, key)
		case "sparkEventsFolder":
			err = unpopulate(val, "SparkEventsFolder", &b.SparkEventsFolder)
			delete(rawMsg, key)
		case "sparkVersion":
			err = unpopulate(val, "SparkVersion", &b.SparkVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetup.
func (c CmdkeySetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = "CmdkeySetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetup.
func (c *CmdkeySetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetupTypeProperties.
func (c CmdkeySetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "password", c.Password)
	populate(objectMap, "targetName", &c.TargetName)
	populate(objectMap, "userName", &c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetupTypeProperties.
func (c *CmdkeySetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "targetName":
			err = unpopulate(val, "TargetName", &c.TargetName)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentSetup.
func (c ComponentSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = "ComponentSetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentSetup.
func (c *ComponentSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnection.
func (d DataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = d.Kind
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionListResult.
func (d *DataConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			d.Value, err = unmarshalDataConnectionClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectionValidation.
func (d DataConnectionValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataConnectionName", d.DataConnectionName)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectionValidation.
func (d *DataConnectionValidation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataConnectionName":
			err = unpopulate(val, "DataConnectionName", &d.DataConnectionName)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDataConnectionClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = d.Kind
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseListResult.
func (d *DatabaseListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			d.Value, err = unmarshalDatabaseClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariableSetup.
func (e EnvironmentVariableSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = "EnvironmentVariableSetup"
	populate(objectMap, "typeProperties", e.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridDataConnection.
func (e EventGridDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = DataConnectionKindEventGrid
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridDataConnection.
func (e *EventGridDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubConnectionProperties.
func (e EventHubConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "compression", e.Compression)
	populate(objectMap, "consumerGroup", e.ConsumerGroup)
	populate(objectMap, "dataFormat", e.DataFormat)
	populate(objectMap, "eventHubResourceId", e.EventHubResourceID)
	populate(objectMap, "eventSystemProperties", e.EventSystemProperties)
	populate(objectMap, "managedIdentityResourceId", e.ManagedIdentityResourceID)
	populate(objectMap, "mappingRuleName", e.MappingRuleName)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "tableName", e.TableName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type EventHubDataConnection.
func (e EventHubDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = DataConnectionKindEventHub
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubDataConnection.
func (e *EventHubDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedSQLPoolBlobAuditingPolicyProperties.
func (e ExtendedSQLPoolBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedServerBlobAuditingPolicyProperties.
func (e ExtendedServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", e.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", e.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", e.IsDevopsAuditEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", e.IsStorageSecondaryKeyInUse)
	populate(objectMap, "predicateExpression", e.PredicateExpression)
	populate(objectMap, "queueDelayMs", e.QueueDelayMs)
	populate(objectMap, "retentionDays", e.RetentionDays)
	populate(objectMap, "state", e.State)
	populate(objectMap, "storageAccountAccessKey", e.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", e.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", e.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntime.
func (i IntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", i.Description)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntime.
func (i *IntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeComputeProperties.
func (i IntegrationRuntimeComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataFlowProperties", i.DataFlowProperties)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "maxParallelExecutionsPerNode", i.MaxParallelExecutionsPerNode)
	populate(objectMap, "nodeSize", i.NodeSize)
	populate(objectMap, "numberOfNodes", i.NumberOfNodes)
	populate(objectMap, "vNetProperties", i.VNetProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeComputeProperties.
func (i *IntegrationRuntimeComputeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFlowProperties":
			err = unpopulate(val, "DataFlowProperties", &i.DataFlowProperties)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "maxParallelExecutionsPerNode":
			err = unpopulate(val, "MaxParallelExecutionsPerNode", &i.MaxParallelExecutionsPerNode)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &i.NodeSize)
			delete(rawMsg, key)
		case "numberOfNodes":
			err = unpopulate(val, "NumberOfNodes", &i.NumberOfNodes)
			delete(rawMsg, key)
		case "vNetProperties":
			err = unpopulate(val, "VNetProperties", &i.VNetProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeConnectionInfo.
func (i *IntegrationRuntimeConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostServiceUri":
			err = unpopulate(val, "HostServiceURI", &i.HostServiceURI)
			delete(rawMsg, key)
		case "identityCertThumbprint":
			err = unpopulate(val, "IdentityCertThumbprint", &i.IdentityCertThumbprint)
			delete(rawMsg, key)
		case "isIdentityCertExprired":
			err = unpopulate(val, "IsIdentityCertExprired", &i.IsIdentityCertExprired)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &i.PublicKey)
			delete(rawMsg, key)
		case "serviceToken":
			err = unpopulate(val, "ServiceToken", &i.ServiceToken)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i IntegrationRuntimeDataFlowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cleanup", i.Cleanup)
	populate(objectMap, "computeType", i.ComputeType)
	populate(objectMap, "coreCount", i.CoreCount)
	populate(objectMap, "timeToLive", i.TimeToLive)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i *IntegrationRuntimeDataFlowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cleanup":
			err = unpopulate(val, "Cleanup", &i.Cleanup)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &i.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &i.CoreCount)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &i.TimeToLive)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeNodeMonitoringData.
func (i *IntegrationRuntimeNodeMonitoringData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableMemoryInMB":
			err = unpopulate(val, "AvailableMemoryInMB", &i.AvailableMemoryInMB)
			delete(rawMsg, key)
		case "cpuUtilization":
			err = unpopulate(val, "CPUUtilization", &i.CPUUtilization)
			delete(rawMsg, key)
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &i.ConcurrentJobsLimit)
			delete(rawMsg, key)
		case "concurrentJobsRunning":
			err = unpopulate(val, "ConcurrentJobsRunning", &i.ConcurrentJobsRunning)
			delete(rawMsg, key)
		case "maxConcurrentJobs":
			err = unpopulate(val, "MaxConcurrentJobs", &i.MaxConcurrentJobs)
			delete(rawMsg, key)
		case "nodeName":
			err = unpopulate(val, "NodeName", &i.NodeName)
			delete(rawMsg, key)
		case "receivedBytes":
			err = unpopulate(val, "ReceivedBytes", &i.ReceivedBytes)
			delete(rawMsg, key)
		case "sentBytes":
			err = unpopulate(val, "SentBytes", &i.SentBytes)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeResource.
func (i IntegrationRuntimeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeResource.
func (i *IntegrationRuntimeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i IntegrationRuntimeSsisCatalogInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "catalogAdminPassword", i.CatalogAdminPassword)
	populate(objectMap, "catalogAdminUserName", i.CatalogAdminUserName)
	populate(objectMap, "catalogPricingTier", i.CatalogPricingTier)
	populate(objectMap, "catalogServerEndpoint", i.CatalogServerEndpoint)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i *IntegrationRuntimeSsisCatalogInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogAdminPassword":
			err = unpopulate(val, "CatalogAdminPassword", &i.CatalogAdminPassword)
			delete(rawMsg, key)
		case "catalogAdminUserName":
			err = unpopulate(val, "CatalogAdminUserName", &i.CatalogAdminUserName)
			delete(rawMsg, key)
		case "catalogPricingTier":
			err = unpopulate(val, "CatalogPricingTier", &i.CatalogPricingTier)
			delete(rawMsg, key)
		case "catalogServerEndpoint":
			err = unpopulate(val, "CatalogServerEndpoint", &i.CatalogServerEndpoint)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisProperties.
func (i IntegrationRuntimeSsisProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "catalogInfo", i.CatalogInfo)
	populate(objectMap, "customSetupScriptProperties", i.CustomSetupScriptProperties)
	populate(objectMap, "dataProxyProperties", i.DataProxyProperties)
	populate(objectMap, "edition", i.Edition)
	populate(objectMap, "expressCustomSetupProperties", i.ExpressCustomSetupProperties)
	populate(objectMap, "licenseType", i.LicenseType)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisProperties.
func (i *IntegrationRuntimeSsisProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogInfo":
			err = unpopulate(val, "CatalogInfo", &i.CatalogInfo)
			delete(rawMsg, key)
		case "customSetupScriptProperties":
			err = unpopulate(val, "CustomSetupScriptProperties", &i.CustomSetupScriptProperties)
			delete(rawMsg, key)
		case "dataProxyProperties":
			err = unpopulate(val, "DataProxyProperties", &i.DataProxyProperties)
			delete(rawMsg, key)
		case "edition":
			err = unpopulate(val, "Edition", &i.Edition)
			delete(rawMsg, key)
		case "expressCustomSetupProperties":
			i.ExpressCustomSetupProperties, err = unmarshalCustomSetupBaseClassificationArray(val)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &i.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatusResponse.
func (i *IntegrationRuntimeStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeStatusClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeVNetProperties.
func (i IntegrationRuntimeVNetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicIPs", i.PublicIPs)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "subnetId", i.SubnetID)
	populate(objectMap, "vNetId", i.VNetID)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeVNetProperties.
func (i *IntegrationRuntimeVNetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &i.PublicIPs)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		case "vNetId":
			err = unpopulate(val, "VNetID", &i.VNetID)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IotHubConnectionProperties.
func (i IotHubConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "consumerGroup", i.ConsumerGroup)
	populate(objectMap, "dataFormat", i.DataFormat)
	populate(objectMap, "eventSystemProperties", i.EventSystemProperties)
	populate(objectMap, "iotHubResourceId", i.IotHubResourceID)
	populate(objectMap, "mappingRuleName", i.MappingRuleName)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "sharedAccessPolicyName", i.SharedAccessPolicyName)
	populate(objectMap, "tableName", i.TableName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IotHubDataConnection.
func (i IotHubDataConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = DataConnectionKindIotHub
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IotHubDataConnection.
func (i *IotHubDataConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustoPool.
func (k KustoPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", k.Etag)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "sku", k.SKU)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolUpdate.
func (k KustoPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "sku", k.SKU)
	populate(objectMap, "tags", k.Tags)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LanguageExtensionsList.
func (l LanguageExtensionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LibraryInfo.
func (l LibraryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "containerName", l.ContainerName)
	populate(objectMap, "creatorId", l.CreatorID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "path", l.Path)
	populate(objectMap, "provisioningStatus", l.ProvisioningStatus)
	populate(objectMap, "type", l.Type)
	populateTimeRFC3339(objectMap, "uploadedTimestamp", l.UploadedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryInfo.
func (l *LibraryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &l.ContainerName)
			delete(rawMsg, key)
		case "creatorId":
			err = unpopulate(val, "CreatorID", &l.CreatorID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &l.Path)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &l.ProvisioningStatus)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "uploadedTimestamp":
			err = unpopulateTimeRFC3339(val, "UploadedTimestamp", &l.UploadedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LibraryRequirements.
func (l LibraryRequirements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "content", l.Content)
	populate(objectMap, "filename", l.Filename)
	populateTimeRFC3339(objectMap, "time", l.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LibraryRequirements.
func (l *LibraryRequirements) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &l.Content)
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &l.Filename)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &l.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LicensedComponentSetupTypeProperties.
func (l LicensedComponentSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "componentName", l.ComponentName)
	populate(objectMap, "licenseKey", l.LicenseKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LicensedComponentSetupTypeProperties.
func (l *LicensedComponentSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &l.ComponentName)
			delete(rawMsg, key)
		case "licenseKey":
			l.LicenseKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntime.
func (l *LinkedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &l.CreateTime)
			delete(rawMsg, key)
		case "dataFactoryLocation":
			err = unpopulate(val, "DataFactoryLocation", &l.DataFactoryLocation)
			delete(rawMsg, key)
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &l.DataFactoryName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l LinkedIntegrationRuntimeKeyAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authorizationType"] = "Key"
	populate(objectMap, "key", l.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &l.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l LinkedIntegrationRuntimeRbacAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authorizationType"] = "RBAC"
	populate(objectMap, "resourceId", l.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowOptionsProperties.
func (m MaintenanceWindowOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowMultipleMaintenanceWindowsPerCycle", m.AllowMultipleMaintenanceWindowsPerCycle)
	populate(objectMap, "defaultDurationInMinutes", m.DefaultDurationInMinutes)
	populate(objectMap, "isEnabled", m.IsEnabled)
	populate(objectMap, "maintenanceWindowCycles", m.MaintenanceWindowCycles)
	populate(objectMap, "minCycles", m.MinCycles)
	populate(objectMap, "minDurationInMinutes", m.MinDurationInMinutes)
	populate(objectMap, "timeGranularityInMinutes", m.TimeGranularityInMinutes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowsProperties.
func (m MaintenanceWindowsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "timeRanges", m.TimeRanges)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentity.
func (m ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIntegrationRuntime.
func (m ManagedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", m.Description)
	populate(objectMap, "managedVirtualNetwork", m.ManagedVirtualNetwork)
	populate(objectMap, "state", m.State)
	objectMap["type"] = IntegrationRuntimeTypeManaged
	populate(objectMap, "typeProperties", m.TypeProperties)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "managedVirtualNetwork":
			err = unpopulate(val, "ManagedVirtualNetwork", &m.ManagedVirtualNetwork)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeError.
func (m *ManagedIntegrationRuntimeError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &m.Time)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeNode.
func (m *ManagedIntegrationRuntimeNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &m.Errors)
			delete(rawMsg, key)
		case "nodeId":
			err = unpopulate(val, "NodeID", &m.NodeID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeOperationResult.
func (m *ManagedIntegrationRuntimeOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &m.ActivityID)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &m.ErrorCode)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &m.Result)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &m.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIntegrationRuntimeStatusTypeProperties.
func (m *ManagedIntegrationRuntimeStatusTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &m.CreateTime)
			delete(rawMsg, key)
		case "lastOperation":
			err = unpopulate(val, "LastOperation", &m.LastOperation)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &m.Nodes)
			delete(rawMsg, key)
		case "otherErrors":
			err = unpopulate(val, "OtherErrors", &m.OtherErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedVirtualNetworkSettings.
func (m ManagedVirtualNetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedAadTenantIdsForLinking", m.AllowedAADTenantIDsForLinking)
	populate(objectMap, "linkedAccessCheckOnTargetResource", m.LinkedAccessCheckOnTargetResource)
	populate(objectMap, "preventDataExfiltration", m.PreventDataExfiltration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResource.
func (o *OperationResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &o.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHub.
func (p PrivateLinkHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHubPatchInfo.
func (p PrivateLinkHubPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkHubProperties.
func (p PrivateLinkHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryInterval.
func (q *QueryInterval) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "executionCount":
			err = unpopulate(val, "ExecutionCount", &q.ExecutionCount)
			delete(rawMsg, key)
		case "intervalStartTime":
			err = unpopulateTimeRFC3339(val, "IntervalStartTime", &q.IntervalStartTime)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &q.Metrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadOnlyFollowingDatabase.
func (r ReadOnlyFollowingDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = KindReadOnlyFollowing
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReadWriteDatabase.
func (r ReadWriteDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = KindReadWrite
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendedSensitivityLabelUpdateList.
func (r RecommendedSensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operations", r.Operations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RecoverableSQLPoolProperties.
func (r RecoverableSQLPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "edition", r.Edition)
	populate(objectMap, "elasticPoolName", r.ElasticPoolName)
	populateTimeRFC3339(objectMap, "lastAvailableBackupDate", r.LastAvailableBackupDate)
	populate(objectMap, "serviceLevelObjective", r.ServiceLevelObjective)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoverableSQLPoolProperties.
func (r *RecoverableSQLPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "edition":
			err = unpopulate(val, "Edition", &r.Edition)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &r.ElasticPoolName)
			delete(rawMsg, key)
		case "lastAvailableBackupDate":
			err = unpopulateTimeRFC3339(val, "LastAvailableBackupDate", &r.LastAvailableBackupDate)
			delete(rawMsg, key)
		case "serviceLevelObjective":
			err = unpopulate(val, "ServiceLevelObjective", &r.ServiceLevelObjective)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplaceAllIPFirewallRulesRequest.
func (r ReplaceAllIPFirewallRulesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipFirewallRules", r.IPFirewallRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationLinkProperties.
func (r ReplicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isTerminationAllowed", r.IsTerminationAllowed)
	populate(objectMap, "partnerDatabase", r.PartnerDatabase)
	populate(objectMap, "partnerLocation", r.PartnerLocation)
	populate(objectMap, "partnerRole", r.PartnerRole)
	populate(objectMap, "partnerServer", r.PartnerServer)
	populate(objectMap, "percentComplete", r.PercentComplete)
	populate(objectMap, "replicationMode", r.ReplicationMode)
	populate(objectMap, "replicationState", r.ReplicationState)
	populate(objectMap, "role", r.Role)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationLinkProperties.
func (r *ReplicationLinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isTerminationAllowed":
			err = unpopulate(val, "IsTerminationAllowed", &r.IsTerminationAllowed)
			delete(rawMsg, key)
		case "partnerDatabase":
			err = unpopulate(val, "PartnerDatabase", &r.PartnerDatabase)
			delete(rawMsg, key)
		case "partnerLocation":
			err = unpopulate(val, "PartnerLocation", &r.PartnerLocation)
			delete(rawMsg, key)
		case "partnerRole":
			err = unpopulate(val, "PartnerRole", &r.PartnerRole)
			delete(rawMsg, key)
		case "partnerServer":
			err = unpopulate(val, "PartnerServer", &r.PartnerServer)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &r.PercentComplete)
			delete(rawMsg, key)
		case "replicationMode":
			err = unpopulate(val, "ReplicationMode", &r.ReplicationMode)
			delete(rawMsg, key)
		case "replicationState":
			err = unpopulate(val, "ReplicationState", &r.ReplicationState)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &r.Role)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorableDroppedSQLPoolProperties.
func (r RestorableDroppedSQLPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationDate", r.CreationDate)
	populate(objectMap, "databaseName", r.DatabaseName)
	populateTimeRFC3339(objectMap, "deletionDate", r.DeletionDate)
	populateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populate(objectMap, "edition", r.Edition)
	populate(objectMap, "elasticPoolName", r.ElasticPoolName)
	populate(objectMap, "maxSizeBytes", r.MaxSizeBytes)
	populate(objectMap, "serviceLevelObjective", r.ServiceLevelObjective)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorableDroppedSQLPoolProperties.
func (r *RestorableDroppedSQLPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &r.CreationDate)
			delete(rawMsg, key)
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &r.DatabaseName)
			delete(rawMsg, key)
		case "deletionDate":
			err = unpopulateTimeRFC3339(val, "DeletionDate", &r.DeletionDate)
			delete(rawMsg, key)
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "edition":
			err = unpopulate(val, "Edition", &r.Edition)
			delete(rawMsg, key)
		case "elasticPoolName":
			err = unpopulate(val, "ElasticPoolName", &r.ElasticPoolName)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &r.MaxSizeBytes)
			delete(rawMsg, key)
		case "serviceLevelObjective":
			err = unpopulate(val, "ServiceLevelObjective", &r.ServiceLevelObjective)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestorePointProperties.
func (r RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "earliestRestoreDate", r.EarliestRestoreDate)
	populateTimeRFC3339(objectMap, "restorePointCreationDate", r.RestorePointCreationDate)
	populate(objectMap, "restorePointLabel", r.RestorePointLabel)
	populate(objectMap, "restorePointType", r.RestorePointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestorePointProperties.
func (r *RestorePointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "earliestRestoreDate":
			err = unpopulateTimeRFC3339(val, "EarliestRestoreDate", &r.EarliestRestoreDate)
			delete(rawMsg, key)
		case "restorePointCreationDate":
			err = unpopulateTimeRFC3339(val, "RestorePointCreationDate", &r.RestorePointCreationDate)
			delete(rawMsg, key)
		case "restorePointLabel":
			err = unpopulate(val, "RestorePointLabel", &r.RestorePointLabel)
			delete(rawMsg, key)
		case "restorePointType":
			err = unpopulate(val, "RestorePointType", &r.RestorePointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPool.
func (s SQLPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolBlobAuditingPolicyProperties.
func (s SQLPoolBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", s.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", s.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", s.IsStorageSecondaryKeyInUse)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", s.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolOperationProperties.
func (s SQLPoolOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "databaseName", s.DatabaseName)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "errorCode", s.ErrorCode)
	populate(objectMap, "errorDescription", s.ErrorDescription)
	populate(objectMap, "errorSeverity", s.ErrorSeverity)
	populateTimeRFC3339(objectMap, "estimatedCompletionTime", s.EstimatedCompletionTime)
	populate(objectMap, "isCancellable", s.IsCancellable)
	populate(objectMap, "isUserError", s.IsUserError)
	populate(objectMap, "operation", s.Operation)
	populate(objectMap, "operationFriendlyName", s.OperationFriendlyName)
	populate(objectMap, "percentComplete", s.PercentComplete)
	populate(objectMap, "serverName", s.ServerName)
	populateTimeRFC3339(objectMap, "startTime", s.StartTime)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolOperationProperties.
func (s *SQLPoolOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databaseName":
			err = unpopulate(val, "DatabaseName", &s.DatabaseName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "errorDescription":
			err = unpopulate(val, "ErrorDescription", &s.ErrorDescription)
			delete(rawMsg, key)
		case "errorSeverity":
			err = unpopulate(val, "ErrorSeverity", &s.ErrorSeverity)
			delete(rawMsg, key)
		case "estimatedCompletionTime":
			err = unpopulateTimeRFC3339(val, "EstimatedCompletionTime", &s.EstimatedCompletionTime)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &s.IsCancellable)
			delete(rawMsg, key)
		case "isUserError":
			err = unpopulate(val, "IsUserError", &s.IsUserError)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &s.Operation)
			delete(rawMsg, key)
		case "operationFriendlyName":
			err = unpopulate(val, "OperationFriendlyName", &s.OperationFriendlyName)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &s.PercentComplete)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &s.ServerName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolPatchInfo.
func (s SQLPoolPatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolResourceProperties.
func (s SQLPoolResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "collation", s.Collation)
	populate(objectMap, "createMode", s.CreateMode)
	populateTimeRFC3339(objectMap, "creationDate", s.CreationDate)
	populate(objectMap, "maxSizeBytes", s.MaxSizeBytes)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "recoverableDatabaseId", s.RecoverableDatabaseID)
	populateTimeRFC3339(objectMap, "restorePointInTime", s.RestorePointInTime)
	populateTimeRFC3339(objectMap, "sourceDatabaseDeletionDate", s.SourceDatabaseDeletionDate)
	populate(objectMap, "sourceDatabaseId", s.SourceDatabaseID)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "storageAccountType", s.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolResourceProperties.
func (s *SQLPoolResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collation":
			err = unpopulate(val, "Collation", &s.Collation)
			delete(rawMsg, key)
		case "createMode":
			err = unpopulate(val, "CreateMode", &s.CreateMode)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateTimeRFC3339(val, "CreationDate", &s.CreationDate)
			delete(rawMsg, key)
		case "maxSizeBytes":
			err = unpopulate(val, "MaxSizeBytes", &s.MaxSizeBytes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "recoverableDatabaseId":
			err = unpopulate(val, "RecoverableDatabaseID", &s.RecoverableDatabaseID)
			delete(rawMsg, key)
		case "restorePointInTime":
			err = unpopulateTimeRFC3339(val, "RestorePointInTime", &s.RestorePointInTime)
			delete(rawMsg, key)
		case "sourceDatabaseDeletionDate":
			err = unpopulateTimeRFC3339(val, "SourceDatabaseDeletionDate", &s.SourceDatabaseDeletionDate)
			delete(rawMsg, key)
		case "sourceDatabaseId":
			err = unpopulate(val, "SourceDatabaseID", &s.SourceDatabaseID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &s.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SQLPoolUsage.
func (s *SQLPoolUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &s.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateTimeRFC3339(val, "NextResetTime", &s.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &s.ResourceName)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineItem.
func (s SQLPoolVulnerabilityAssessmentRuleBaselineItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "result", s.Result)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SQLPoolVulnerabilityAssessmentRuleBaselineProperties.
func (s SQLPoolVulnerabilityAssessmentRuleBaselineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "baselineResults", s.BaselineResults)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecureString.
func (s SecureString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["type"] = "SecureString"
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureString.
func (s *SecureString) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertPolicyProperties.
func (s SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertPolicyProperties.
func (s *SecurityAlertPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntime.
func (s SelfHostedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", s.Description)
	objectMap["type"] = IntegrationRuntimeTypeSelfHosted
	populate(objectMap, "typeProperties", s.TypeProperties)
	if s.AdditionalProperties != nil {
		for key, val := range s.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntime.
func (s *SelfHostedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &s.TypeProperties)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeNode.
func (s *SelfHostedIntegrationRuntimeNode) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &s.ConcurrentJobsLimit)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateTimeRFC3339(val, "ExpiryTime", &s.ExpiryTime)
			delete(rawMsg, key)
		case "hostServiceUri":
			err = unpopulate(val, "HostServiceURI", &s.HostServiceURI)
			delete(rawMsg, key)
		case "isActiveDispatcher":
			err = unpopulate(val, "IsActiveDispatcher", &s.IsActiveDispatcher)
			delete(rawMsg, key)
		case "lastConnectTime":
			err = unpopulateTimeRFC3339(val, "LastConnectTime", &s.LastConnectTime)
			delete(rawMsg, key)
		case "lastEndUpdateTime":
			err = unpopulateTimeRFC3339(val, "LastEndUpdateTime", &s.LastEndUpdateTime)
			delete(rawMsg, key)
		case "lastStartTime":
			err = unpopulateTimeRFC3339(val, "LastStartTime", &s.LastStartTime)
			delete(rawMsg, key)
		case "lastStartUpdateTime":
			err = unpopulateTimeRFC3339(val, "LastStartUpdateTime", &s.LastStartUpdateTime)
			delete(rawMsg, key)
		case "lastStopTime":
			err = unpopulateTimeRFC3339(val, "LastStopTime", &s.LastStopTime)
			delete(rawMsg, key)
		case "lastUpdateResult":
			err = unpopulate(val, "LastUpdateResult", &s.LastUpdateResult)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &s.MachineName)
			delete(rawMsg, key)
		case "maxConcurrentJobs":
			err = unpopulate(val, "MaxConcurrentJobs", &s.MaxConcurrentJobs)
			delete(rawMsg, key)
		case "nodeName":
			err = unpopulate(val, "NodeName", &s.NodeName)
			delete(rawMsg, key)
		case "registerTime":
			err = unpopulateTimeRFC3339(val, "RegisterTime", &s.RegisterTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &s.VersionStatus)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeStatus.
func (s *SelfHostedIntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &s.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &s.TypeProperties)
			delete(rawMsg, key)
		default:
			if s.AdditionalProperties == nil {
				s.AdditionalProperties = map[string]interface{}{}
			}
			if val != nil {
				var aux interface{}
				err = json.Unmarshal(val, &aux)
				s.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeStatusTypeProperties.
func (s *SelfHostedIntegrationRuntimeStatusTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpdate":
			err = unpopulate(val, "AutoUpdate", &s.AutoUpdate)
			delete(rawMsg, key)
		case "autoUpdateETA":
			err = unpopulateTimeRFC3339(val, "AutoUpdateETA", &s.AutoUpdateETA)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateTimeRFC3339(val, "CreateTime", &s.CreateTime)
			delete(rawMsg, key)
		case "internalChannelEncryption":
			err = unpopulate(val, "InternalChannelEncryption", &s.InternalChannelEncryption)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &s.LatestVersion)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &s.Links)
			delete(rawMsg, key)
		case "localTimeZoneOffset":
			err = unpopulate(val, "LocalTimeZoneOffset", &s.LocalTimeZoneOffset)
			delete(rawMsg, key)
		case "newerVersions":
			err = unpopulate(val, "NewerVersions", &s.NewerVersions)
			delete(rawMsg, key)
		case "nodeCommunicationChannelEncryptionMode":
			err = unpopulate(val, "NodeCommunicationChannelEncryptionMode", &s.NodeCommunicationChannelEncryptionMode)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &s.Nodes)
			delete(rawMsg, key)
		case "pushedVersion":
			err = unpopulate(val, "PushedVersion", &s.PushedVersion)
			delete(rawMsg, key)
		case "scheduledUpdateDate":
			err = unpopulateTimeRFC3339(val, "ScheduledUpdateDate", &s.ScheduledUpdateDate)
			delete(rawMsg, key)
		case "serviceRegion":
			err = unpopulate(val, "ServiceRegion", &s.ServiceRegion)
			delete(rawMsg, key)
		case "serviceUrls":
			err = unpopulate(val, "ServiceUrls", &s.ServiceUrls)
			delete(rawMsg, key)
		case "taskQueueId":
			err = unpopulate(val, "TaskQueueID", &s.TaskQueueID)
			delete(rawMsg, key)
		case "updateDelayOffset":
			err = unpopulate(val, "UpdateDelayOffset", &s.UpdateDelayOffset)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &s.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SelfHostedIntegrationRuntimeTypeProperties.
func (s SelfHostedIntegrationRuntimeTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "linkedInfo", s.LinkedInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SelfHostedIntegrationRuntimeTypeProperties.
func (s *SelfHostedIntegrationRuntimeTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkedInfo":
			s.LinkedInfo, err = unmarshalLinkedIntegrationRuntimeTypeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SensitivityLabelUpdateList.
func (s SensitivityLabelUpdateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operations", s.Operations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerBlobAuditingPolicyProperties.
func (s ServerBlobAuditingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "auditActionsAndGroups", s.AuditActionsAndGroups)
	populate(objectMap, "isAzureMonitorTargetEnabled", s.IsAzureMonitorTargetEnabled)
	populate(objectMap, "isDevopsAuditEnabled", s.IsDevopsAuditEnabled)
	populate(objectMap, "isStorageSecondaryKeyInUse", s.IsStorageSecondaryKeyInUse)
	populate(objectMap, "queueDelayMs", s.QueueDelayMs)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageAccountSubscriptionId", s.StorageAccountSubscriptionID)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServerSecurityAlertPolicyProperties.
func (s ServerSecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "creationTime", s.CreationTime)
	populate(objectMap, "disabledAlerts", s.DisabledAlerts)
	populate(objectMap, "emailAccountAdmins", s.EmailAccountAdmins)
	populate(objectMap, "emailAddresses", s.EmailAddresses)
	populate(objectMap, "retentionDays", s.RetentionDays)
	populate(objectMap, "state", s.State)
	populate(objectMap, "storageAccountAccessKey", s.StorageAccountAccessKey)
	populate(objectMap, "storageEndpoint", s.StorageEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerSecurityAlertPolicyProperties.
func (s *ServerSecurityAlertPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &s.CreationTime)
			delete(rawMsg, key)
		case "disabledAlerts":
			err = unpopulate(val, "DisabledAlerts", &s.DisabledAlerts)
			delete(rawMsg, key)
		case "emailAccountAdmins":
			err = unpopulate(val, "EmailAccountAdmins", &s.EmailAccountAdmins)
			delete(rawMsg, key)
		case "emailAddresses":
			err = unpopulate(val, "EmailAddresses", &s.EmailAddresses)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &s.RetentionDays)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "storageAccountAccessKey":
			err = unpopulate(val, "StorageAccountAccessKey", &s.StorageAccountAccessKey)
			delete(rawMsg, key)
		case "storageEndpoint":
			err = unpopulate(val, "StorageEndpoint", &s.StorageEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerUsage.
func (s *ServerUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &s.CurrentValue)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateTimeRFC3339(val, "NextResetTime", &s.NextResetTime)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &s.ResourceName)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigProperties.
func (s SparkConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "configurationType", s.ConfigurationType)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "filename", s.Filename)
	populateTimeRFC3339(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigProperties.
func (s *SparkConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationType":
			err = unpopulate(val, "ConfigurationType", &s.ConfigurationType)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "filename":
			err = unpopulate(val, "Filename", &s.Filename)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkConfigurationInfo.
func (s SparkConfigurationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "annotations", s.Annotations)
	populate(objectMap, "configs", s.Configs)
	populateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "notes", s.Notes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkConfigurationInfo.
func (s *SparkConfigurationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &s.Annotations)
			delete(rawMsg, key)
		case "configs":
			err = unpopulate(val, "Configs", &s.Configs)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &s.Notes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisEnvironment.
func (s *SsisEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "variables":
			err = unpopulate(val, "Variables", &s.Variables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisFolder.
func (s *SsisFolder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisObjectMetadataListResponse.
func (s *SsisObjectMetadataListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			s.Value, err = unmarshalSsisObjectMetadataClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisPackage.
func (s *SsisPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "projectId":
			err = unpopulate(val, "ProjectID", &s.ProjectID)
			delete(rawMsg, key)
		case "projectVersion":
			err = unpopulate(val, "ProjectVersion", &s.ProjectVersion)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SsisProject.
func (s *SsisProject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "environmentRefs":
			err = unpopulate(val, "EnvironmentRefs", &s.EnvironmentRefs)
			delete(rawMsg, key)
		case "folderId":
			err = unpopulate(val, "FolderID", &s.FolderID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableLevelSharingProperties.
func (t TableLevelSharingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "externalTablesToExclude", t.ExternalTablesToExclude)
	populate(objectMap, "externalTablesToInclude", t.ExternalTablesToInclude)
	populate(objectMap, "materializedViewsToExclude", t.MaterializedViewsToExclude)
	populate(objectMap, "materializedViewsToInclude", t.MaterializedViewsToInclude)
	populate(objectMap, "tablesToExclude", t.TablesToExclude)
	populate(objectMap, "tablesToInclude", t.TablesToInclude)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopQueries.
func (t *TopQueries) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationFunction":
			err = unpopulate(val, "AggregationFunction", &t.AggregationFunction)
			delete(rawMsg, key)
		case "executionType":
			err = unpopulate(val, "ExecutionType", &t.ExecutionType)
			delete(rawMsg, key)
		case "intervalType":
			err = unpopulate(val, "IntervalType", &t.IntervalType)
			delete(rawMsg, key)
		case "numberOfTopQueries":
			err = unpopulate(val, "NumberOfTopQueries", &t.NumberOfTopQueries)
			delete(rawMsg, key)
		case "observationEndTime":
			err = unpopulateTimeRFC3339(val, "ObservationEndTime", &t.ObservationEndTime)
			delete(rawMsg, key)
		case "observationStartTime":
			err = unpopulateTimeRFC3339(val, "ObservationStartTime", &t.ObservationStartTime)
			delete(rawMsg, key)
		case "observedMetric":
			err = unpopulate(val, "ObservedMetric", &t.ObservedMetric)
			delete(rawMsg, key)
		case "queries":
			err = unpopulate(val, "Queries", &t.Queries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIntegrationRuntimeNodeRequest.
func (u UpdateIntegrationRuntimeNodeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "concurrentJobsLimit", u.ConcurrentJobsLimit)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateIntegrationRuntimeRequest.
func (u UpdateIntegrationRuntimeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoUpdate", u.AutoUpdate)
	populate(objectMap, "updateDelayOffset", u.UpdateDelayOffset)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentRecurringScansProperties.
func (v VulnerabilityAssessmentRecurringScansProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "emailSubscriptionAdmins", v.EmailSubscriptionAdmins)
	populate(objectMap, "emails", v.Emails)
	populate(objectMap, "isEnabled", v.IsEnabled)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v VulnerabilityAssessmentScanRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", v.EndTime)
	populate(objectMap, "errors", v.Errors)
	populate(objectMap, "numberOfFailedSecurityChecks", v.NumberOfFailedSecurityChecks)
	populate(objectMap, "scanId", v.ScanID)
	populateTimeRFC3339(objectMap, "startTime", v.StartTime)
	populate(objectMap, "state", v.State)
	populate(objectMap, "storageContainerPath", v.StorageContainerPath)
	populate(objectMap, "triggerType", v.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VulnerabilityAssessmentScanRecordProperties.
func (v *VulnerabilityAssessmentScanRecordProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &v.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &v.Errors)
			delete(rawMsg, key)
		case "numberOfFailedSecurityChecks":
			err = unpopulate(val, "NumberOfFailedSecurityChecks", &v.NumberOfFailedSecurityChecks)
			delete(rawMsg, key)
		case "scanId":
			err = unpopulate(val, "ScanID", &v.ScanID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &v.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &v.State)
			delete(rawMsg, key)
		case "storageContainerPath":
			err = unpopulate(val, "StorageContainerPath", &v.StorageContainerPath)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &v.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePatchInfo.
func (w WorkspacePatchInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adlaResourceId", w.AdlaResourceID)
	populate(objectMap, "azureADOnlyAuthentication", w.AzureADOnlyAuthentication)
	populate(objectMap, "connectivityEndpoints", w.ConnectivityEndpoints)
	populate(objectMap, "cspWorkspaceAdminProperties", w.CspWorkspaceAdminProperties)
	populate(objectMap, "defaultDataLakeStorage", w.DefaultDataLakeStorage)
	populate(objectMap, "encryption", w.Encryption)
	populate(objectMap, "extraProperties", w.ExtraProperties)
	populate(objectMap, "managedResourceGroupName", w.ManagedResourceGroupName)
	populate(objectMap, "managedVirtualNetwork", w.ManagedVirtualNetwork)
	populate(objectMap, "managedVirtualNetworkSettings", w.ManagedVirtualNetworkSettings)
	populate(objectMap, "privateEndpointConnections", w.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "purviewConfiguration", w.PurviewConfiguration)
	populate(objectMap, "sqlAdministratorLogin", w.SQLAdministratorLogin)
	populate(objectMap, "sqlAdministratorLoginPassword", w.SQLAdministratorLoginPassword)
	populate(objectMap, "settings", w.Settings)
	populate(objectMap, "trustedServiceBypassEnabled", w.TrustedServiceBypassEnabled)
	populate(objectMap, "virtualNetworkProfile", w.VirtualNetworkProfile)
	populate(objectMap, "workspaceRepositoryConfiguration", w.WorkspaceRepositoryConfiguration)
	populate(objectMap, "workspaceUID", w.WorkspaceUID)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
