// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateMember struct {
}

func (*validateOpAssociateMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetFreeTrialInfo struct {
}

func (*validateOpBatchGetFreeTrialInfo) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetFreeTrialInfo) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetFreeTrialInfoInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetFreeTrialInfoInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelFindingsReport struct {
}

func (*validateOpCancelFindingsReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelFindingsReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelFindingsReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelFindingsReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFilter struct {
}

func (*validateOpCreateFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFindingsReport struct {
}

func (*validateOpCreateFindingsReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFindingsReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFindingsReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFindingsReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFilter struct {
}

func (*validateOpDeleteFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableDelegatedAdminAccount struct {
}

func (*validateOpDisableDelegatedAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableDelegatedAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableDelegatedAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableDelegatedAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateMember struct {
}

func (*validateOpDisassociateMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableDelegatedAdminAccount struct {
}

func (*validateOpEnableDelegatedAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableDelegatedAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableDelegatedAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableDelegatedAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnable struct {
}

func (*validateOpEnable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMember struct {
}

func (*validateOpGetMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCoverage struct {
}

func (*validateOpListCoverage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCoverage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCoverageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCoverageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCoverageStatistics struct {
}

func (*validateOpListCoverageStatistics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCoverageStatistics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCoverageStatisticsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCoverageStatisticsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindingAggregations struct {
}

func (*validateOpListFindingAggregations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindingAggregations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingAggregationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingAggregationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindings struct {
}

func (*validateOpListFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConfiguration struct {
}

func (*validateOpUpdateConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFilter struct {
}

func (*validateOpUpdateFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOrganizationConfiguration struct {
}

func (*validateOpUpdateOrganizationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOrganizationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOrganizationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOrganizationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateMember{}, middleware.After)
}

func addOpBatchGetFreeTrialInfoValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetFreeTrialInfo{}, middleware.After)
}

func addOpCancelFindingsReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelFindingsReport{}, middleware.After)
}

func addOpCreateFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFilter{}, middleware.After)
}

func addOpCreateFindingsReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFindingsReport{}, middleware.After)
}

func addOpDeleteFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFilter{}, middleware.After)
}

func addOpDisableDelegatedAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableDelegatedAdminAccount{}, middleware.After)
}

func addOpDisassociateMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateMember{}, middleware.After)
}

func addOpEnableDelegatedAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableDelegatedAdminAccount{}, middleware.After)
}

func addOpEnableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnable{}, middleware.After)
}

func addOpGetMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMember{}, middleware.After)
}

func addOpListCoverageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCoverage{}, middleware.After)
}

func addOpListCoverageStatisticsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCoverageStatistics{}, middleware.After)
}

func addOpListFindingAggregationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindingAggregations{}, middleware.After)
}

func addOpListFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindings{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConfiguration{}, middleware.After)
}

func addOpUpdateFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFilter{}, middleware.After)
}

func addOpUpdateOrganizationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOrganizationConfiguration{}, middleware.After)
}

func validateAggregationRequest(v types.AggregationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AggregationRequest"}
	switch uv := v.(type) {
	case *types.AggregationRequestMemberAmiAggregation:
		if err := validateAmiAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[amiAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberAwsEcrContainerAggregation:
		if err := validateAwsEcrContainerAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[awsEcrContainerAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberEc2InstanceAggregation:
		if err := validateEc2InstanceAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[ec2InstanceAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberImageLayerAggregation:
		if err := validateImageLayerAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[imageLayerAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberPackageAggregation:
		if err := validatePackageAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[packageAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberRepositoryAggregation:
		if err := validateRepositoryAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[repositoryAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberTitleAggregation:
		if err := validateTitleAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[titleAggregation]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAmiAggregation(v *types.AmiAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmiAggregation"}
	if v.Amis != nil {
		if err := validateStringFilterList(v.Amis); err != nil {
			invalidParams.AddNested("Amis", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoEnable(v *types.AutoEnable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoEnable"}
	if v.Ec2 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Ec2"))
	}
	if v.Ecr == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Ecr"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsEcrContainerAggregation(v *types.AwsEcrContainerAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsEcrContainerAggregation"}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImageShas != nil {
		if err := validateStringFilterList(v.ImageShas); err != nil {
			invalidParams.AddNested("ImageShas", err.(smithy.InvalidParamsError))
		}
	}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if v.Architectures != nil {
		if err := validateStringFilterList(v.Architectures); err != nil {
			invalidParams.AddNested("Architectures", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImageTags != nil {
		if err := validateStringFilterList(v.ImageTags); err != nil {
			invalidParams.AddNested("ImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageFilterCriteria(v *types.CoverageFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageFilterCriteria"}
	if v.ScanStatusCode != nil {
		if err := validateCoverageStringFilterList(v.ScanStatusCode); err != nil {
			invalidParams.AddNested("ScanStatusCode", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanStatusReason != nil {
		if err := validateCoverageStringFilterList(v.ScanStatusReason); err != nil {
			invalidParams.AddNested("ScanStatusReason", err.(smithy.InvalidParamsError))
		}
	}
	if v.AccountId != nil {
		if err := validateCoverageStringFilterList(v.AccountId); err != nil {
			invalidParams.AddNested("AccountId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId != nil {
		if err := validateCoverageStringFilterList(v.ResourceId); err != nil {
			invalidParams.AddNested("ResourceId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceType != nil {
		if err := validateCoverageStringFilterList(v.ResourceType); err != nil {
			invalidParams.AddNested("ResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanType != nil {
		if err := validateCoverageStringFilterList(v.ScanType); err != nil {
			invalidParams.AddNested("ScanType", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrRepositoryName != nil {
		if err := validateCoverageStringFilterList(v.EcrRepositoryName); err != nil {
			invalidParams.AddNested("EcrRepositoryName", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageTags != nil {
		if err := validateCoverageStringFilterList(v.EcrImageTags); err != nil {
			invalidParams.AddNested("EcrImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceTags != nil {
		if err := validateCoverageMapFilterList(v.Ec2InstanceTags); err != nil {
			invalidParams.AddNested("Ec2InstanceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageMapFilter(v *types.CoverageMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageMapFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageMapFilterList(v []types.CoverageMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageMapFilterList"}
	for i := range v {
		if err := validateCoverageMapFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageStringFilter(v *types.CoverageStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageStringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageStringFilterList(v []types.CoverageStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageStringFilterList"}
	for i := range v {
		if err := validateCoverageStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestination(v *types.Destination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Destination"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.KmsKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2InstanceAggregation(v *types.Ec2InstanceAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2InstanceAggregation"}
	if v.Amis != nil {
		if err := validateStringFilterList(v.Amis); err != nil {
			invalidParams.AddNested("Amis", err.(smithy.InvalidParamsError))
		}
	}
	if v.OperatingSystems != nil {
		if err := validateStringFilterList(v.OperatingSystems); err != nil {
			invalidParams.AddNested("OperatingSystems", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceIds != nil {
		if err := validateStringFilterList(v.InstanceIds); err != nil {
			invalidParams.AddNested("InstanceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceTags != nil {
		if err := validateMapFilterList(v.InstanceTags); err != nil {
			invalidParams.AddNested("InstanceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcrConfiguration(v *types.EcrConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcrConfiguration"}
	if len(v.RescanDuration) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RescanDuration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterCriteria(v *types.FilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterCriteria"}
	if v.FindingArn != nil {
		if err := validateStringFilterList(v.FindingArn); err != nil {
			invalidParams.AddNested("FindingArn", err.(smithy.InvalidParamsError))
		}
	}
	if v.AwsAccountId != nil {
		if err := validateStringFilterList(v.AwsAccountId); err != nil {
			invalidParams.AddNested("AwsAccountId", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingType != nil {
		if err := validateStringFilterList(v.FindingType); err != nil {
			invalidParams.AddNested("FindingType", err.(smithy.InvalidParamsError))
		}
	}
	if v.Severity != nil {
		if err := validateStringFilterList(v.Severity); err != nil {
			invalidParams.AddNested("Severity", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingStatus != nil {
		if err := validateStringFilterList(v.FindingStatus); err != nil {
			invalidParams.AddNested("FindingStatus", err.(smithy.InvalidParamsError))
		}
	}
	if v.Title != nil {
		if err := validateStringFilterList(v.Title); err != nil {
			invalidParams.AddNested("Title", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceType != nil {
		if err := validateStringFilterList(v.ResourceType); err != nil {
			invalidParams.AddNested("ResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId != nil {
		if err := validateStringFilterList(v.ResourceId); err != nil {
			invalidParams.AddNested("ResourceId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceTags != nil {
		if err := validateMapFilterList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceImageId != nil {
		if err := validateStringFilterList(v.Ec2InstanceImageId); err != nil {
			invalidParams.AddNested("Ec2InstanceImageId", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceVpcId != nil {
		if err := validateStringFilterList(v.Ec2InstanceVpcId); err != nil {
			invalidParams.AddNested("Ec2InstanceVpcId", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceSubnetId != nil {
		if err := validateStringFilterList(v.Ec2InstanceSubnetId); err != nil {
			invalidParams.AddNested("Ec2InstanceSubnetId", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageArchitecture != nil {
		if err := validateStringFilterList(v.EcrImageArchitecture); err != nil {
			invalidParams.AddNested("EcrImageArchitecture", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageRegistry != nil {
		if err := validateStringFilterList(v.EcrImageRegistry); err != nil {
			invalidParams.AddNested("EcrImageRegistry", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageRepositoryName != nil {
		if err := validateStringFilterList(v.EcrImageRepositoryName); err != nil {
			invalidParams.AddNested("EcrImageRepositoryName", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageTags != nil {
		if err := validateStringFilterList(v.EcrImageTags); err != nil {
			invalidParams.AddNested("EcrImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageHash != nil {
		if err := validateStringFilterList(v.EcrImageHash); err != nil {
			invalidParams.AddNested("EcrImageHash", err.(smithy.InvalidParamsError))
		}
	}
	if v.NetworkProtocol != nil {
		if err := validateStringFilterList(v.NetworkProtocol); err != nil {
			invalidParams.AddNested("NetworkProtocol", err.(smithy.InvalidParamsError))
		}
	}
	if v.ComponentId != nil {
		if err := validateStringFilterList(v.ComponentId); err != nil {
			invalidParams.AddNested("ComponentId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ComponentType != nil {
		if err := validateStringFilterList(v.ComponentType); err != nil {
			invalidParams.AddNested("ComponentType", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilityId != nil {
		if err := validateStringFilterList(v.VulnerabilityId); err != nil {
			invalidParams.AddNested("VulnerabilityId", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilitySource != nil {
		if err := validateStringFilterList(v.VulnerabilitySource); err != nil {
			invalidParams.AddNested("VulnerabilitySource", err.(smithy.InvalidParamsError))
		}
	}
	if v.VendorSeverity != nil {
		if err := validateStringFilterList(v.VendorSeverity); err != nil {
			invalidParams.AddNested("VendorSeverity", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerablePackages != nil {
		if err := validatePackageFilterList(v.VulnerablePackages); err != nil {
			invalidParams.AddNested("VulnerablePackages", err.(smithy.InvalidParamsError))
		}
	}
	if v.RelatedVulnerabilities != nil {
		if err := validateStringFilterList(v.RelatedVulnerabilities); err != nil {
			invalidParams.AddNested("RelatedVulnerabilities", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImageLayerAggregation(v *types.ImageLayerAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImageLayerAggregation"}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.LayerHashes != nil {
		if err := validateStringFilterList(v.LayerHashes); err != nil {
			invalidParams.AddNested("LayerHashes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMapFilter(v *types.MapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MapFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMapFilterList(v []types.MapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MapFilterList"}
	for i := range v {
		if err := validateMapFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageAggregation(v *types.PackageAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageAggregation"}
	if v.PackageNames != nil {
		if err := validateStringFilterList(v.PackageNames); err != nil {
			invalidParams.AddNested("PackageNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageFilter(v *types.PackageFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageFilter"}
	if v.Name != nil {
		if err := validateStringFilter(v.Name); err != nil {
			invalidParams.AddNested("Name", err.(smithy.InvalidParamsError))
		}
	}
	if v.Version != nil {
		if err := validateStringFilter(v.Version); err != nil {
			invalidParams.AddNested("Version", err.(smithy.InvalidParamsError))
		}
	}
	if v.Release != nil {
		if err := validateStringFilter(v.Release); err != nil {
			invalidParams.AddNested("Release", err.(smithy.InvalidParamsError))
		}
	}
	if v.Architecture != nil {
		if err := validateStringFilter(v.Architecture); err != nil {
			invalidParams.AddNested("Architecture", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceLayerHash != nil {
		if err := validateStringFilter(v.SourceLayerHash); err != nil {
			invalidParams.AddNested("SourceLayerHash", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageFilterList(v []types.PackageFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageFilterList"}
	for i := range v {
		if err := validatePackageFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRepositoryAggregation(v *types.RepositoryAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RepositoryAggregation"}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSortCriteria(v *types.SortCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SortCriteria"}
	if len(v.Field) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Field"))
	}
	if len(v.SortOrder) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SortOrder"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringFilter(v *types.StringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringFilterList(v []types.StringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringFilterList"}
	for i := range v {
		if err := validateStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTitleAggregation(v *types.TitleAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TitleAggregation"}
	if v.Titles != nil {
		if err := validateStringFilterList(v.Titles); err != nil {
			invalidParams.AddNested("Titles", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilityIds != nil {
		if err := validateStringFilterList(v.VulnerabilityIds); err != nil {
			invalidParams.AddNested("VulnerabilityIds", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateMemberInput(v *AssociateMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetFreeTrialInfoInput(v *BatchGetFreeTrialInfoInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetFreeTrialInfoInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelFindingsReportInput(v *CancelFindingsReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelFindingsReportInput"}
	if v.ReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFilterInput(v *CreateFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFilterInput"}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if v.FilterCriteria == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterCriteria"))
	} else if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFindingsReportInput(v *CreateFindingsReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFindingsReportInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.ReportFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFormat"))
	}
	if v.S3Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Destination"))
	} else if v.S3Destination != nil {
		if err := validateDestination(v.S3Destination); err != nil {
			invalidParams.AddNested("S3Destination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFilterInput(v *DeleteFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFilterInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableDelegatedAdminAccountInput(v *DisableDelegatedAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableDelegatedAdminAccountInput"}
	if v.DelegatedAdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateMemberInput(v *DisassociateMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableDelegatedAdminAccountInput(v *EnableDelegatedAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableDelegatedAdminAccountInput"}
	if v.DelegatedAdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableInput(v *EnableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableInput"}
	if v.ResourceTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMemberInput(v *GetMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCoverageInput(v *ListCoverageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCoverageInput"}
	if v.FilterCriteria != nil {
		if err := validateCoverageFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCoverageStatisticsInput(v *ListCoverageStatisticsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCoverageStatisticsInput"}
	if v.FilterCriteria != nil {
		if err := validateCoverageFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingAggregationsInput(v *ListFindingAggregationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingAggregationsInput"}
	if len(v.AggregationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AggregationType"))
	}
	if v.AccountIds != nil {
		if err := validateStringFilterList(v.AccountIds); err != nil {
			invalidParams.AddNested("AccountIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.AggregationRequest != nil {
		if err := validateAggregationRequest(v.AggregationRequest); err != nil {
			invalidParams.AddNested("AggregationRequest", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingsInput(v *ListFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingsInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.SortCriteria != nil {
		if err := validateSortCriteria(v.SortCriteria); err != nil {
			invalidParams.AddNested("SortCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConfigurationInput(v *UpdateConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConfigurationInput"}
	if v.EcrConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EcrConfiguration"))
	} else if v.EcrConfiguration != nil {
		if err := validateEcrConfiguration(v.EcrConfiguration); err != nil {
			invalidParams.AddNested("EcrConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFilterInput(v *UpdateFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFilterInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.FilterArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOrganizationConfigurationInput"}
	if v.AutoEnable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AutoEnable"))
	} else if v.AutoEnable != nil {
		if err := validateAutoEnable(v.AutoEnable); err != nil {
			invalidParams.AddNested("AutoEnable", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
