// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideomedia

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideomedia/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpGetMedia struct {
}

func (*awsRestjson1_serializeOpGetMedia) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMedia) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMediaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/getMedia")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetMediaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMediaInput(v *GetMediaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetMediaInput(v *GetMediaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StartSelector != nil {
		ok := object.Key("StartSelector")
		if err := awsRestjson1_serializeDocumentStartSelector(v.StartSelector, ok); err != nil {
			return err
		}
	}

	if v.StreamARN != nil {
		ok := object.Key("StreamARN")
		ok.String(*v.StreamARN)
	}

	if v.StreamName != nil {
		ok := object.Key("StreamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentStartSelector(v *types.StartSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterFragmentNumber != nil {
		ok := object.Key("AfterFragmentNumber")
		ok.String(*v.AfterFragmentNumber)
	}

	if v.ContinuationToken != nil {
		ok := object.Key("ContinuationToken")
		ok.String(*v.ContinuationToken)
	}

	if len(v.StartSelectorType) > 0 {
		ok := object.Key("StartSelectorType")
		ok.String(string(v.StartSelectorType))
	}

	if v.StartTimestamp != nil {
		ok := object.Key("StartTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTimestamp))
	}

	return nil
}
