// $Id: checkbutton.cc,v 1.20 2002/12/09 09:42:29 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "checkbutton.hh"
typedef float gfloat;

static Gtk_CheckButton Gtk_CheckButton(false);

const std::string Gtk_CheckButton::TypeName(const Widget &w) const
{  return GtkPrefix()+"CheckButton";
}
const std::string Gtk_CheckButton::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"checkbutton.h";
}
Gtk_CheckButton::Gtk_CheckButton(bool base_class_init)
{  if (!base_class_init) Writer["GtkCheckButton"]=this;
}
void Gtk_CheckButton::ConstructionArgs(const Widget &w, CxxFile &f) const
{  if (w.hasProperty("label"))
   {  std::string label=w.getProperty("label");
      f.FunctionArg() << Configuration.Translatable(label);
      // this is unique to check/radiobuttons
      if (GTKMM1)
      {  gfloat xalign=0.0;
         gfloat yalign=0.5;
         f.FunctionArg() << xalign;
         f.FunctionArg() << yalign;
      }
      else
      {  if (label.find('_')!=std::string::npos) f.FunctionArg() << "true";
      }
   }
}
