// $Id: container.cc,v 1.41 2002/07/11 14:47:42 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

void Gtk_Container::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  if (Configuration.debug)
   {  std::cout << TypeName(w) << "::AddChildren(" << w.Name() << ",," 
	<< instance << ',' << writer_for_subw.TypeName(widget_for_subw) << ',' 
	<< widget_for_subw.Name() << ")\n";
   }
   if (writer_for_subw.IsSubwidget(widget_for_subw,w)==is_Subwidget_all) return;
   
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  switch(writer_for_subw.IsSubwidget(widget_for_subw,*i))
         {  case no_Subwidgets: case not_Subwidget:
	   	 AddChild(*i,f,instance);
	   	 break;
	    default: // ok.
	         break;
	 }
      }
   }
}

void Gtk_Container::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const std::string cn=w.ChildName();
   if (!cn.empty())
   {  std::cerr << "Warning: Gtk_Container::AddChild(" << w.Name() << ",,"
           << instance << ") with child name " << cn
           << ",\n\t" << TypeName(w) << "::IsSubwidget() might need fixing\n";
   }
   f.Statement() << instance << "add(" << Reference(w) << ')';
}


void Gtk_Container::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteIntProperty(w,f,instance, "border_width");
}

void Gtk_Container::GHInclude(const Widget &w,CxxFile &f) const
{  Parent::GHInclude(w,f);
   if (!w.getBoolProperty(CXX_SEPERATE_CLASS,false)) return;
   bool children_have_tooltips=false;
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
   		i!=w.end_contained();++i)
   {  Widget w(*i);
      if (w.isSeperateClass()) continue;
      if (w.hasProperty("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips || w.hasProperty("tooltip"))
   {  f.Include(Configuration.GtkmmIncludePath()+"tooltips.h");
   }
}

void Gtk_Container::AdditionalMemberVars(const Widget &w, CxxFile &f,bool container) const
{  bool children_have_tooltips=false;
   if (!w.getBoolProperty(CXX_SEPERATE_CLASS,false)) return;
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
   	i!=w.end_contained();++i)
   {  Widget w(*i);
      if (!container && w.getBoolProperty(CXX_SEPERATE_CLASS,false)) continue;
      if (w.hasProperty("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips || w.hasProperty("tooltip"))
   {  const std::string visibility(w.getProperty("cxx_visibility","private"));
      if (visibility=="private") f.Private();
      else if (visibility=="protected") f.Protected();
      else if (visibility=="public") f.Public();
      f.Declaration() << (GtkPrefix()+"Tooltips _tooltips");
   }
   Parent::AdditionalMemberVars(w,f,container);
}
