// $Id: textview.cc,v 1.7 2002/10/29 08:06:59 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_TextView : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_TextView();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
	virtual void ApplyPreferences(Tag &t) const;
};

static Gtk_TextView Gtk_TextView;

const std::string Gtk_TextView::TypeName(const Widget &w) const
{  return GtkPrefix()+"TextView";
}

const std::string Gtk_TextView::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"textview.h";
}

Gtk_TextView::Gtk_TextView()
{  Writer["GtkTextView"]=this;
}

void Gtk_TextView::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteBoolProperty(w,f,instance, "editable");
   WriteBoolProperty(w,f,instance, "cursor_visible");
   WriteIntProperty(w,f,instance, "pixels_above_lines");
   WriteIntProperty(w,f,instance, "pixels_below_lines");
   WriteIntProperty(w,f,instance, "pixels_inside_wrap");
   WriteIntProperty(w,f,instance, "left_margin");
   WriteIntProperty(w,f,instance, "right_margin");
   WriteIntProperty(w,f,instance, "indent");
   WriteEnumPropertyNS(w,f,instance, "wrap_mode");
   WriteEnumPropertyNS(w,f,instance, "justification");
   std::string text=w.getProperty("text");
   if (!text.empty())
      f.Statement() << instance << "get_buffer()->set_text("
      	<< Configuration.Translatable(text) << ')';
}

const std::string Gtk_TextView::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const
{  scope=Gtk_TextView::TypeName(w);
   if (signal=="set_scroll_adjustments")
      return "Gtk::Adjustment *p0, Gtk::Adjustment *p1";
   if (signal=="populate_popup") return "";
   if (signal=="move_cursor") 
      return "Gtk::MovementStep step, int count, bool extend_selection";
#warning to be continued
   return Parent::SignalHandlerArgs(w,signal,rettype,scope);
}

void Gtk_TextView::ApplyPreferences(Tag &t) const
{  if (GTKMM1)
   {  static_cast<GladeTag*>(&t)->setWidgetType("GtkText");
      Widget w(&t);
      LookupWriter(w).ApplyPreferences(t);
   }
   else
      Parent::ApplyPreferences(t);
}

