// $Id: tree.cc,v 1.27 2002/06/17 07:03:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Tree : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Tree();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void ApplyPreferences(Tag &t) const;
};

void Gtk_Tree::ApplyPreferences(Tag &t) const
{  if (GTKMM2) static_cast<GladeTag*>(&t)->setWidgetType("GtkTreeView");
   Parent::ApplyPreferences(t);
}

static Gtk_Tree Gtk_Tree;

const std::string Gtk_Tree::TypeName(const Widget &w) const
{  return GtkPrefix()+"Tree";
}

const std::string Gtk_Tree::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"tree.h";
}

Gtk_Tree::Gtk_Tree()
{  Writer["GtkTree"]=this;
}

void Gtk_Tree::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "selection_mode");
   WriteEnumPropertyNS(w,f,instance, "view_mode");
   WriteBoolProperty(w,f,instance, "view_line", false, "view_lines");
}

#if 0
void Gtk_Tree::Include(CxxFile &f,const Widget &w)
{  f.Include(Configuration.GtkmmIncludePath()+"tree.h");
   if (Configuration.sample_code) 
   {  f.Include(Configuration.GtkmmIncludePath()+"treeitem.h");
      f.Include("vector");
   }
   Gtk_Container::Include(f,w);
}

bool Gtk_Tree::SampleCode(CxxFile &f,const Widget &w,enum WriterType::CodePosition pos,const std::string misc)
{  const std::string name(Configuration.InstanceName(w.Name()));
   switch(pos)
   {  case WriterType::ContainingConstructor:
         {  // insert items
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"alpha\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"beta\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"gamma\"));\n";
            f << "\tfor (std::vector<"<<GtkPrefix()<<"TreeItem*>::iterator i=" << name 
              << "_items.begin();\n\t\t\ti!=" << name << "_items.end();++i)\n"
              << "\t{\t" << name << "->" 
              << "append("
              << "*"
              << "*i);\n" 
              << "\t\t(*i)->show();\n"
              << "\t}\n";
            f << "\t" << name << "_items.back()->set_subtree("
              << name << "_sub);\n";
            f << "\t" << name << "_sub.show();\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"epsilon\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"tau\"));\n";
            f << "\t" << name << "_items.push_back(new Gtk_TreeItem(\"rho\"));\n";
            f << "\tfor (std::vector<"<<GtkPrefix()<<"TreeItem*>::iterator i=" << name 
              << "_items.begin()+3;\n\t\t\ti!=" << name << "_items.end();++i)\n"
              << "\t{\t" << name << "_sub.append("
              << "**i);\n"
              << "\t\t(*i)->show();\n"
              << "\t}\n";
   	 }
   	 break;
      case WriterType::ContainingDestructor:
         {  f << "\tfor (std::vector<"<<GtkPrefix()<<"TreeItem*>::iterator i=" << name 
              << "_items.begin();i!=" << name << "_items.end();++i)\n"
              << "\t\tdelete *i;\n";
         }
         break;
      case WriterType::ContainingPrivateMember:
         {  f << "\tGtk_Tree " << name << "_sub;\n";
            f << "\tvector<"<<GtkPrefix()<<"TreeItem *> " << name << "_items;\n";
         }
         break;
      default: break;
   }
   return false;
}
#endif
