// $Id: Naming.hh,v 1.15 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NAMING_HH
#define NAMING_HH
#include <config.h>
#include <string>
#include "File_type.hh"
#include "Widget.hh"

class Naming
{               
public:
	// map illegal chars
	const std::string FName(const std::string &tag) const throw()
	{  return ToFileName(tag); }
	// map illegal chars
	const std::string CName(const std::string &tag) const throw();
	// map illegal chars
	const std::string AMName(const std::string &tag) const throw()
	{  return CName(tag); }
	const std::string TypeName(const std::string &tag,bool glade=false) const;
	const std::string InstanceName(const std::string &tag) const;
//	std::string RequireName(const std::string &tag) const;
	const std::string FileName(const std::string &tag,File_type tp,int flags=0) const;
	const std::string FileDefine(const std::string &tag,File_type tp) const;
	const std::string CString_WithQuotes(const std::string &s) const
	{  return '"'+CString(s)+'"'; }
	const std::string static_Translatable(const std::string &s) const;
	const std::string Translatable(const std::string &s) const;
	// 2do: map illegal chars (e.g. '"','\\','\n')
	const std::string CString(const std::string &s) const throw();
	const std::string DefineName(const std::string &tag) const throw();
	
	static const std::string UpperCase(const std::string &s) throw();
	static const std::string LowerCase(const std::string &s) throw();
	static const std::string Capitalize(const std::string &s) throw();
	static const std::string UnCapitalize(const std::string &s) throw();
	static const std::string ToFileName(const std::string &s) throw();
	static const std::string ToCIdentifier(const std::string &s) throw();
};
#endif
