// $Id: button.cc,v 1.60 2004/05/14 10:20:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2004  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "button.hh"
#include "toolitem.hh"

void Gtk_Button::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   if (GTKMM1 && !Configuration.gnome_support && Widget(&t).hasProperty("stock_button"))
   {  // hmmm, turn on gnome_support or turn stock_button to label?
      std::cerr << "Stock Buttons need gnome_support, please turn it on\n";
      Configuration.gnome_support=true;
   }
}

void Gtk_Button::GCInclude(const Widget &w, CxxFile &f) const
{  if (GTKMM1 && (w.hasProperty("stock_button") || w.hasProperty("stock_pixmap") 
		|| w.hasProperty("stock_id")))
      f.Include("libgnomeui/gnome-stock.h");
   if (GTKMM2 && (w.hasProperty("stock_pixmap") || w.hasProperty("stock_id")
   		|| w.hasProperty("stock_button")))
   {  f.Include(Configuration.GtkmmIncludePath()+"image.h");
      f.Include(Configuration.GtkmmIncludePath()+"stockid.h");
   }
   if (GTKMM1 && w.hasProperty("icon"))
   {  const std::string icon(w.getProperty("icon"));
      if (!icon.empty() && !xpmname(icon).empty())
      {  f.Include(Configuration.GtkmmIncludePath()+"pixmap.h");
         f.Include(Configuration.CString(Configuration.pixmap_dir_relative_to_src+"/"+icon),true);
      }
   }
   else if (GTKMM2 && w.hasProperty("icon"))
   {  const Widget image=get_image(w);
      const WriterBase &wr=LookupWriter(image);
      wr.GHInclude(image,f);
      wr.GCInclude(image,f);
   }
   Parent::GCInclude(w,f);
}

const std::string Gtk_Button::TypeName(const Widget &w) const
{  return GtkPrefix()+(IsToolItem(w)?"Tool":"")+"Button";
}

const std::string Gtk_Button::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+(IsToolItem(w)?"tool":"")+"button.h";
}

Gtk_Button::Gtk_Button(bool base_class_init)
{  if (!base_class_init) 
   {  Writer["GtkButton"]=this;
      Writer["button"]=this; // B.W.Headley says needed for 2.0
      Writer["GtkToolButton"]=this; // not sure about this
   }
}

void Gtk_Button::ConstructionArgs(const Widget &w, CxxFile &f) const
{  assert(!w.hasProperty("stock_button"));
   if (Configuration.glade2 && GTKMM2 && w.getBoolProperty("use_stock"))
   {  f.FunctionArg();
      f << "Gtk::StockID(" << Configuration.CString_WithQuotes(w.getProperty("label")) << ')';
   }
   else if (w.hasProperty("label"))
   {  f.FunctionArg();
      std::string label=w.getProperty("label");
      if (GTKMM1 && label.find('_')!=std::string::npos)
         f << "\"\"";
      else
         f << Configuration.Translatable(label);
      if (GTKMM1)
      {  
#if 0 // why don't we support this?
         gfloat xalign=0.5;
         gfloat yalign=0.5; // w.getFloatProperty("xalign");
         f.FunctionArg() << xalign;
         f.FunctionArg() << yalign;
#endif
      }
      if (GTKMM2 && label.find('_')!=std::string::npos)
         f.FunctionArg() << "true";
   }
}

bool Gtk_Button::NeedExplicitCtor(const Widget &w) const
{  return w.hasProperty("label"); }

static Gtk_Button Gtk_Button(false);

bool Gtk_Button::CantMemberConstruct(const Widget &w) const
{  return w.hasProperty("stock_button");
}

bool Gtk_Button::hasImage(const Widget &w) const
{  return w.hasProperty("icon") || w.hasProperty("stock_pixmap") 
	|| (w.hasProperty("stock_id") && w.hasProperty("label"));
}

void Gtk_Button::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  // 2.4 has a different ancestry
   if (GTKMM24 && w.Class().size()>10 && 
   		w.Class().substr(w.Class().size()-10)=="ToolButton") 
      LookupWriter("GtkToolItem").Configure(w,f,instance);
   else Parent::Configure(w,f,instance);

   WriteEnumPropertyNS(w,f,instance, "relief");
      
   std::string label=w.getProperty("label");
   if (GTKMM1 && !label.empty() && label.find('_')!=std::string::npos)
      f.Statement() << "dynamic_cast<Gtk::Label*>(" << instance << "get_child())->"
      		"parse_uline(" << Configuration.Translatable(label) << ")";
   if (GTKMM2 && hasImage(w))
   {  const Widget image=get_image(w);
      f.Statement() << Configuration.InstanceName(image.Name()) << "->show()";
   }
}

void Gtk_Button::ToolBarElemCreation(const Widget &w, CxxFile &f) const
{  f.FunctionName() << ToolBarElemName(w);
   ToolBarElemArgs(w,f);
}

std::string Gtk_Button::ToolBarElemName(const Widget &w) const
{  if (w.hasProperty("stock_id") && !w.hasProperty("label")) 
      return ToolBarElemPrefix()+"StockElem";
   else 
      return ToolBarElemPrefix()+"ButtonElem";
}

void Gtk_Button::ToolBarElemArgs(const Widget &w, CxxFile &f) const
{  if (w.hasProperty("stock_id") && !w.hasProperty("label"))
   {  f.FunctionArg();
      f << "Gtk::StockID(" << Configuration.CString_WithQuotes(w.getProperty("stock_id")) << ')';
   }
   else
  {if (!GTKMM24 && w.hasProperty("label"))
   {  f.FunctionArg() << Configuration.Translatable(w.getProperty("label"));
   }
   if (GTKMM1 && w.hasProperty("icon"))
   {  std::string icon=w.getProperty("icon");
      if (!xpmname(icon).empty())
         f.FunctionArg() << "*manage(new "<< GtkPrefix() << "Pixmap" << "(" 
             	<< xpmname(icon) << "))";
   }
   else if (GTKMM1 && Configuration.gnome_support && w.hasProperty("stock_pixmap"))
   {  // manage this pixmap?
      f.FunctionArg() << "*" << gtk_wrapper() << "("
        << "gnome_stock_pixmap_widget(GTK_WIDGET("
	<< gtk_object_pointer() << "), " // window
        << w.getProperty("stock_pixmap") << "))";
   }
   else if (GTKMM2 && hasImage(w))
   {  f.FunctionArg() << Reference(get_image(w));
   }
   if (GTKMM24 && w.hasProperty("label"))
   {  f.FunctionArg() << Configuration.Translatable(w.getProperty("label"));
   }
  }
   if (GTKMM24) ;
   else if (GTKMM1) f.FunctionArg() << 0;
   else f.FunctionArg() << ToolBarElemPrefix()+"Callback0()";
   // tooltip_text
   // tooltip_private_text
}

const Widget Gtk_Button::get_image(const Widget &w) const
{  static Tag image("widget");
   std::string name(Configuration.InstanceName(w.Name())+"_img");
   if (Widget(image).Name()==name)
   {  return Widget(image);
   }
   image=createWidgetTag("GtkImage", name);
   Widget w2(image);
   w2.setProperty(("pixbuf"),w.getProperty("icon"));
   if (w.hasProperty("stock_pixmap"))
      w2.setProperty(("stock"),w.getProperty("stock_pixmap")); 
   else if (w.hasProperty("stock_id"))
      w2.setProperty(("stock"),w.getProperty("stock_id")); 
   w2.setProperty("icon_size","3");
   w2.setProperty(CXX_IS_MANAGED);
   return w2;
}

bool Gtk_Button::IsToolItem(const Widget &w) const
{  return GTKMM24 && w.Class().size()>10 && 
   		w.Class().substr(w.Class().size()-10)=="ToolButton";
}

// hmmm. Why did I write this to create internal toolbar children?
void Gtk_Button::CreatePointer(const Widget &w, CxxFile &f) const
{  if (IsToolItem(w))
   {  if (hasImage(w))
      {  const Widget image=get_image(w);
         LookupWriter(image).CreatePointer(image,f);
      }
      ToolBar_vars(w,f);
      
      If24(f);
      if (w.getProperty("cxx_visibility","private")=="private" && CanBeManaged(w))
         f.Declaration() << TypeName(w) << " *";
      else 
        f.Statement();
      f << Configuration.InstanceName(w.Name());
      f.Assignment();
      if (CanBeManaged(w))
      {  f.FunctionName(GTKMM1?"manage":"Gtk::manage").FunctionArg();
         w.markManaged();
      }
      f << "new class ";
      f.FunctionName() << TypeName(w);
      ToolBarElemArgs(w,f);
      f.EndLine();
      CreatePointer_Toplevel(w,f);
      f.EndIf();
      return;
   }
   if (w.hasProperty("stock_button"))
   {  if (w.getProperty("cxx_visibility","private")=="private") // && CanBeManaged(w))
	 f.Declaration() << TypeName(w) << " *";
      else 
	 f.Statement();
      f << Configuration.InstanceName(w.Name());
      f.Assignment().FunctionName(GtkPrefix()) << "wrap";
      // or f << GtkCast(w) <<'(';
      f.FunctionArg() << '(' << GtkName(w) << "*)"
      		 "gnome_stock_button(" << w.getProperty("stock_button") << ')';
      f.EndLine();
      w.markManaged();
   }
   else Parent::CreatePointer(w,f);
}
