// $Id: clock.cc,v 1.7 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

class Gtk_Clock : public Gtk_Widget
{public:
	typedef Gtk_Widget Parent;
	virtual const std::string TypeName(const Widget &w) const;
	Gtk_Clock();
	virtual const std::string IncludeName(const Widget &w) const;
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool CanBeManaged(const Widget &w) const
	{  return false; }
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

#include "label.hh"

static Gtk_Clock Gtk_Clock;

const std::string Gtk_Clock::TypeName(const Widget &w) const
{  return GtkPrefix()+"Clock";
}

Gtk_Clock::Gtk_Clock()
{  Writer["GtkClock"]=this;
}

const std::string Gtk_Clock::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"clock.h";
}

void Gtk_Clock::ConstructionArgs(const Widget &w, CxxFile &f) const
{  const std::string type(w.getProperty("type"));
   f.FunctionArg() << "Gtk::Clock::Type(" << type << ')';
}

bool Gtk_Clock::NeedExplicitCtor(const Widget &w) const
{  return true; }

void Gtk_Clock::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteTranslatableProperty(w,f,instance, "format");
   WriteIntProperty(w,f,instance, "seconds");
   WriteIntProperty(w,f,instance, "interval", false, "update_interval");
   // start() oder stop()
}
