// $Id: notebook.cc,v 1.51 2004/05/10 14:08:21 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gtk_Notebook : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
//	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	Gtk_Notebook();
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
	virtual bool isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const;
	const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const;
	virtual bool isProxySignal(const Widget &w,std::string &method,bool after)const;
private:
	bool is_Tab(const Widget &w) const;	
};

static Gtk_Notebook Gtk_Notebook;

const std::string Gtk_Notebook::TypeName(const Widget &w) const
{  return GtkPrefix()+"Notebook";
}

const std::string Gtk_Notebook::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"notebook.h";
}

Gtk_Notebook::Gtk_Notebook()
{  Writer["GtkNotebook"]=this;
}

void Gtk_Notebook::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   WriteBoolProperty(w,f,instance, "show_tabs");
   WriteBoolProperty(w,f,instance, "show_border");
   WriteEnumPropertyNS(w,f,instance, "tab_pos");
   WriteBoolProperty(w,f,instance, "scrollable");
   WriteIntProperty(w,f,instance, "tab_border", GTKMM2);
   if (GTKMM2)
   {  WriteIntProperty(w,f,instance, "tab_hborder",true);
      WriteIntProperty(w,f,instance, "tab_vborder",true);
   }
//   if (GTKMM2) WriteBoolProperty(w,f,instance, "popup_enable", true);
// it's called enable_popup
   WriteBoolProp_2Fun(w,f,instance, "popup_enable", "popup_disable()", "popup_enable()");
   WriteBoolProperty(w,f,instance, "homogeneous",true, GTKMM2?"":"homogeneous_tabs");
}

bool Gtk_Notebook::is_Tab(const Widget &w) const
{  if (Configuration.glade2) 
   {  const ChildParamList ch(w.get_Child_params());
      return ch.getProperty("type")=="tab";
   }
   else return !w.ChildName().empty();
}

void Gtk_Notebook::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  Widget::const_iterator label=w.begin();
   Widget::const_iterator i=w.begin();
   for (;i!=w.end() && label!=w.end();++i,++label)
   {  while (i!=w.end() && is_Tab(*i)) ++i;
      if (i==w.end()) 
      {  std::cerr << w.Name() << ": more tabs than widgets, omitting tabs\n";
         break;
      }
      while (label!=w.end() && !is_Tab(*label)) ++label;
      if (label==w.end()) 
      {  std::cerr << w.Name() << ": more widgets than tabs, omitting widgets\n";
         break;
      }
      if ((*i).Class()=="Placeholder")
      {  std::cerr << w.Name() << ": cannot create empty pages in Gtkmm (?).\n"
      		"\tPlease add an empty label\n";
      	 exit(20);
      }
      if (GTKMM1)
         f.Statement() << instance << "pages().push_back(Gtk::Notebook_Helpers::TabElem(" 
           << Reference(*i) << ", " << Reference(*label) << "))";
      else
         f.Statement() << instance << "append_page("
           << Reference(*i) << ", " << Reference(*label) << ")";
           
      const ChildParamList ch((*i).get_Child_params());
      if (ch.hasProperty("tab_expand") || ch.hasProperty("tab_fill"))
      {  f.Statement() << instance << "pages().back().set_tab_label_packing("
         	<< PRINT_BOOL(ch.getBoolProperty("tab_expand")) << ", "
         	<< PRINT_BOOL(ch.getBoolProperty("tab_fill")) << ", "
         	<< Gtkmm2Namespace(ch.getProperty("tab_pack","GTK_PACK_START"))
         	<< ')';
      }
      if (GTKMM2 && ch.hasProperty("menu_label"))
      {  f.Statement() << instance << "pages().back().set_menu_label_text("
      		<< Configuration.Translatable(ch.getProperty("menu_label")) << ')';
      }
   }
}

const std::string Gtk_Notebook::InternalInstance(const Widget &parent,const Widget &w2) const
{  // we can't configure the tabs
   return Parent::InternalInstance(parent,w2);
}

bool Gtk_Notebook::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gtk_notebook_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
   if ((method=="next_page" && args.empty())
	|| ((method=="prev_page" ||method=="popup_enable"||method=="popup_disable")
		 && args.empty())
	|| ((method=="set_show_tabs"||method=="set_show_border"
		||method=="set_scrollable"||method=="set_homogeneous_tabs")
		 && matches("bool\\ \\_",args))
	|| ((method=="set_page"||method=="set_tab_border"
		||method=="set_tab_hborder"||method=="set_tab_vborder")
	         && (matches("gint\\ \\_",args)||matches("int\\ \\_",args))))
   {  scope=Gtk_Notebook::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

const std::string Gtk_Notebook::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const
{  scope=Gtk_Notebook::TypeName(w);
   if (signal=="switch_page") return "GtkNotebookPage *p0, guint p1";
   return Parent::SignalHandlerArgs(w,signal,rettype,scope);
}

void Gtk_Notebook::GHInclude(const Widget &w, CxxFile &f) const
{  Parent::GHInclude(w,f);
   for (Widget::const_iterator i=w.get_Signals();i!=w.end();++i)
   {  std::string signal=i->getGladeAttr("name","");
      if (signal=="switch_page") 
      {  f.Include(IncludeName(w));
         break;
      }
   }
}

void Gtk_Notebook::ApplyPreferences(Tag &t) const
{  if (!Configuration.need_notebook_hack && GTKMM1)
   {  const Widget w(t);
      for (Widget::const_iterator i=w.get_Signals();i!=w.end();++i)
      {  if (i->getGladeAttr("name")=="switch_page") Configuration.need_notebook_hack=true;
      }
   }
   Parent::ApplyPreferences(t);
}

bool Gtk_Notebook::isProxySignal(const Widget &w,std::string &method,bool after)const
{  if (method=="switch_page" && !after)
      std::cerr << "You really should connect with 'after' to " << w.Name() 
      		<< "'s " << method << '\n';
   return Parent::isProxySignal(w,method,after);
}
