/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.management.support;

import java.util.Set;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.MBeanInfo;
import javax.management.JMException;

import static com.sun.appserv.management.base.SystemInfo.*;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

/**
    Single-use utility class to contain the  details of initializing various
    SystemInfo data.  Appropriate code can be added here, but can be implemented just as
    well elsewhere, most properly within the module that wishes to advertised presence of
    a feature.
 */
final class SystemInfoIniter
{
    private final SystemInfoImpl mSystemInfo;
	private final MBeanServer	 mServer;
    
    SystemInfoIniter( final MBeanServer mbeanServer, final SystemInfoImpl systemInfo )
    {
        mServer     = mbeanServer;
        mSystemInfo = systemInfo;
    }
    
        public void
    init()
    {
		final boolean	supportsClusters	= supportsClusters( );
		
		mSystemInfo.addFeature( CLUSTERS_FEATURE, supportsClusters );
		mSystemInfo.addFeature( MULTIPLE_SERVERS_FEATURE, supportsClusters );
		mSystemInfo.addFeature( RUNNING_IN_DAS_FEATURE, isRunningInDomainAdminServer() );
    }

    		private final boolean
	supportsClusters( )
	{
		final ObjectName	serversObjectName	= getOldServersMBeanObjectName();
		
		boolean	supportsClusters	= false;
		if ( serversObjectName != null )
		{
			// see if the 'servers' MBean supports listing unclustered instances
			try
			{
				final MBeanInfo				info	= mServer.getMBeanInfo( serversObjectName );
				
				final String	operationName	= "listUnclusteredServerInstancesAsString";
				final Set	operations	= JMXUtil.findInfoByName( info.getOperations(), operationName );
				supportsClusters	= operations.size() != 0;
				
			}
			catch( JMException e )
			{
				// should never happen...
				throw new RuntimeException( "problem with 'servers' MBean: " + serversObjectName, e );
			}
		}
		else
		{
			// presumably, we're in another instance, which implies multiple instances.
			// assume this also means clustering is possible
			supportsClusters	= true;
		}
		
		return( supportsClusters );
	}
    
    /**
		Get the ObjectName of the "type=servers" MBean, which only exists in the DAS.
	 */
		private ObjectName
	getOldServersMBeanObjectName()
	{
		// if we find the old "servers" MBean, it should only be running in the DAS.
		final ObjectName	pattern		=
				Util.newObjectName( "com.sun.appserv", "category=config,type=servers" );
		final Set<ObjectName> serversSet	= JMXUtil.queryNames( mServer, pattern, null );
		
		final ObjectName	objectName	= serversSet.size() == 0 ? 
					null : (ObjectName)GSetUtil.getSingleton( serversSet );
					
		return( objectName );
	}
	
		private boolean
	isRunningInDomainAdminServer()
	{
		return( getOldServersMBeanObjectName() != null );
	}

    

}








