/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.apache.tools.ant.taskdefs.optional.iplanet;

import org.apache.tools.ant.BuildException;

import java.util.Map;
import java.util.HashMap;

public class ComponentTask extends ComponentAdmin {
	private String action;

	private static final String ACTION_ENABLE  = "enable";
	private static final String ACTION_DISABLE = "disable";

	private static final Map ACTION_MAP = new HashMap(2);
	static {
		ACTION_MAP.put(ACTION_ENABLE, "enable");
		ACTION_MAP.put(ACTION_DISABLE, "disable");
	};

	public void setAction(String action) {
		this.action = action;
	}

	protected void checkComponentConfig(Component comp) throws BuildException {
		super.checkComponentConfig(comp);

		if (action == null) {
			String msg = "The action command must be specified.";
			throw new BuildException(msg, getLocation());
		}

		if (!ACTION_MAP.containsKey(action)) {

			String msg = "The action command (\"" + action + "\") is invalid.";
			throw new BuildException(msg, getLocation());
		}

		// name must be valid string
		String theName = comp.getName();
		if ((theName == null) || (theName.length() == 0)) {
			String msg = "The component name (\"" + theName + "\") is not valid";
			throw new BuildException(msg, getLocation());
		}
	}

	protected String getCommandString(Server server, Component comp) {
		StringBuffer cmdString = new StringBuffer();
		cmdString.append(ACTION_MAP.get(action));
		cmdString.append(server.getCommandParameters(true));
		if (comp.getType() != null) {
			cmdString.append(" --type ").append(comp.getType());
		}
		cmdString.append(" ").append(comp.getName());

		return cmdString.toString();
	}
}