
import sys

import gst

import glitch, glitch.gtk
from glitch.gst import VideoLoop

if __name__ == '__main__':
    v = VideoLoop(path=sys.argv[1])

    pipeline = gst.Pipeline()
    pipeline.add(v.bin)
    pipeline.set_state(gst.STATE_PLAYING)

    camera = glitch.gtk.GtkCamera(eye=[0.5, 0.5, 1], ref=[0.5, 0.5, 0],
        children=[
            glitch.ApplyTexture(v, children=[glitch.TexturedRectangle()])])
    v.connect('new-buffer', lambda *args: camera.refresh())
    camera.run()
    v.stop()

