/*
  File autogenerated by gengetopt version 2.12.1
  generated with the following command:
  gengetopt --input=../tools/gliv.ggo --unamed-opts --no-handle-error 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->duration_given = 0 ;
  args_info->menu_given = 0 ;
  args_info->client_given = 0 ;
  args_info->alpha_checks_given = 0 ;
  args_info->delay_given = 0 ;
  args_info->no_center_given = 0 ;
  args_info->build_menus_given = 0 ;
  args_info->force_load_given = 0 ;
  args_info->full_screen_given = 0 ;
  args_info->glivrc_given = 0 ;
  args_info->info_given = 0 ;
  args_info->loop_given = 0 ;
  args_info->scale_down_given = 0 ;
  args_info->maximize_given = 0 ;
  args_info->make_fit_given = 0 ;
  args_info->mnemonics_given = 0 ;
  args_info->scrollbars_given = 0 ;
  args_info->fps_given = 0 ;
  args_info->mipmap_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->sort_given = 0 ;
  args_info->shuffle_given = 0 ;
  args_info->thumbnails_given = 0 ;
  args_info->dither_given = 0 ;
  args_info->history_given = 0 ;
  args_info->resize_win_given = 0 ;
  args_info->slide_show_given = 0 ;
  args_info->zoom_pointer_given = 0 ;
  args_info->null_given = 0 ;
  args_info->one_image_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->menu_arg = gengetopt_strdup ("on");
  args_info->client_arg = gengetopt_strdup ("on");
  args_info->alpha_checks_arg = gengetopt_strdup ("on");
  args_info->no_center_arg = gengetopt_strdup ("on");
  args_info->build_menus_arg = gengetopt_strdup ("on");
  args_info->force_load_arg = gengetopt_strdup ("on");
  args_info->full_screen_arg = gengetopt_strdup ("on");
  args_info->glivrc_arg = gengetopt_strdup ("on");
  args_info->info_arg = gengetopt_strdup ("on");
  args_info->loop_arg = gengetopt_strdup ("on");
  args_info->scale_down_arg = gengetopt_strdup ("on");
  args_info->maximize_arg = gengetopt_strdup ("on");
  args_info->make_fit_arg = gengetopt_strdup ("on");
  args_info->mnemonics_arg = gengetopt_strdup ("on");
  args_info->scrollbars_arg = gengetopt_strdup ("on");
  args_info->mipmap_arg = gengetopt_strdup ("on");
  args_info->recursive_arg = gengetopt_strdup ("on");
  args_info->sort_arg = gengetopt_strdup ("on");
  args_info->shuffle_arg = gengetopt_strdup ("on");
  args_info->thumbnails_arg = gengetopt_strdup ("on");
  args_info->dither_arg = gengetopt_strdup ("on");
  args_info->resize_win_arg = gengetopt_strdup ("on");
  args_info->slide_show_arg = gengetopt_strdup ("on");
  args_info->zoom_pointer_arg = gengetopt_strdup ("on");
  args_info->null_arg = gengetopt_strdup ("on");
  args_info->one_image_arg = gengetopt_strdup ("on");
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Image Viewer using OpenGL\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                 Print help and exit");
  printf("%s\n","  -V, --version              Print version and exit");
  printf("%s\n","  -a, --duration=delay       Delay between each image");
  printf("%s\n","  -b, --menu[=on|off]        Hide the menu bar  (default=`on')");
  printf("%s\n","  -C, --client[=on|off]      Connect to an already running gliv  (default=\n                               `on')");
  printf("%s\n","  -c, --alpha-checks[=on|off]No alpha checks in the background  (default=`on')");
  printf("%s\n","  -d, --delay=hide-delay     Delay before hiding the cursor");
  printf("%s\n","  -E, --no-center[=on|off]   No automatic image centering  (default=`on')");
  printf("%s\n","  -e, --build-menus[=on|off] No images menu at startup  (default=`on')");
  printf("%s\n","  -F, --force-load[=on|off]  Try to load every file  (default=`on')");
  printf("%s\n","  -f, --full-screen[=on|off] Start in full screen mode  (default=`on')");
  printf("%s\n","  -g, --glivrc[=on|off]      Ignore ~/.glivrc  (default=`on')");
  printf("%s\n","  -i, --info[=on|off]        Hide the status bar  (default=`on')");
  printf("%s\n","  -L, --loop[=on|off]        Make the slide show loop at the end  (default=\n                               `on')");
  printf("%s\n","  -l, --scale-down[=on|off]  Reduce the image to the window  (default=`on')");
  printf("%s\n","  -M, --maximize[=on|off]    Maximize the image to the window  (default=`on')");
  printf("%s\n","  -m, --make-fit[=on|off]    Make the image fit the window  (default=`on')");
  printf("%s\n","  -n, --mnemonics[=on|off]   No mnemonics in images menus  (default=`on')");
  printf("%s\n","  -o, --scrollbars[=on|off]  Hide the scrollbars  (default=`on')");
  printf("%s\n","  -P, --fps=fps              Maximum framerate");
  printf("%s\n","  -p, --mipmap[=on|off]      Build Mipmaps  (default=`on')");
  printf("%s\n","  -R, --recursive[=on|off]   Process directories recursively  (default=`on')");
  printf("%s\n","  -S, --sort[=on|off]        Show images in sorted order  (default=`on')");
  printf("%s\n","  -s, --shuffle[=on|off]     Show images in random order  (default=`on')");
  printf("%s\n","  -T, --thumbnails[=on|off]  No thumbnails in images menus  (default=`on')");
  printf("%s\n","  -t, --dither[=on|off]      Enable dithering  (default=`on')");
  printf("%s\n","  -u, --history=length       Length of history");
  printf("%s\n","  -W, --resize-win[=on|off]  No automatic window resizing  (default=`on')");
  printf("%s\n","  -w, --slide-show[=on|off]  Start the slide show immediately  (default=`on')");
  printf("%s\n","  -z, --zoom-pointer[=on|off]Zoom centered on pointer  (default=`on')");
  printf("%s\n","  -0, --null[=on|off]        Read null-terminated filenames  (default=`on')");
  printf("%s\n","  -1, --one-image[=on|off]   Keep only one image in memory  (default=`on')");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  int i;
  if (args_info->menu_arg)
    {
      free (args_info->menu_arg); /* free previous argument */
      args_info->menu_arg = 0;
    }
  if (args_info->client_arg)
    {
      free (args_info->client_arg); /* free previous argument */
      args_info->client_arg = 0;
    }
  if (args_info->alpha_checks_arg)
    {
      free (args_info->alpha_checks_arg); /* free previous argument */
      args_info->alpha_checks_arg = 0;
    }
  if (args_info->no_center_arg)
    {
      free (args_info->no_center_arg); /* free previous argument */
      args_info->no_center_arg = 0;
    }
  if (args_info->build_menus_arg)
    {
      free (args_info->build_menus_arg); /* free previous argument */
      args_info->build_menus_arg = 0;
    }
  if (args_info->force_load_arg)
    {
      free (args_info->force_load_arg); /* free previous argument */
      args_info->force_load_arg = 0;
    }
  if (args_info->full_screen_arg)
    {
      free (args_info->full_screen_arg); /* free previous argument */
      args_info->full_screen_arg = 0;
    }
  if (args_info->glivrc_arg)
    {
      free (args_info->glivrc_arg); /* free previous argument */
      args_info->glivrc_arg = 0;
    }
  if (args_info->info_arg)
    {
      free (args_info->info_arg); /* free previous argument */
      args_info->info_arg = 0;
    }
  if (args_info->loop_arg)
    {
      free (args_info->loop_arg); /* free previous argument */
      args_info->loop_arg = 0;
    }
  if (args_info->scale_down_arg)
    {
      free (args_info->scale_down_arg); /* free previous argument */
      args_info->scale_down_arg = 0;
    }
  if (args_info->maximize_arg)
    {
      free (args_info->maximize_arg); /* free previous argument */
      args_info->maximize_arg = 0;
    }
  if (args_info->make_fit_arg)
    {
      free (args_info->make_fit_arg); /* free previous argument */
      args_info->make_fit_arg = 0;
    }
  if (args_info->mnemonics_arg)
    {
      free (args_info->mnemonics_arg); /* free previous argument */
      args_info->mnemonics_arg = 0;
    }
  if (args_info->scrollbars_arg)
    {
      free (args_info->scrollbars_arg); /* free previous argument */
      args_info->scrollbars_arg = 0;
    }
  if (args_info->mipmap_arg)
    {
      free (args_info->mipmap_arg); /* free previous argument */
      args_info->mipmap_arg = 0;
    }
  if (args_info->recursive_arg)
    {
      free (args_info->recursive_arg); /* free previous argument */
      args_info->recursive_arg = 0;
    }
  if (args_info->sort_arg)
    {
      free (args_info->sort_arg); /* free previous argument */
      args_info->sort_arg = 0;
    }
  if (args_info->shuffle_arg)
    {
      free (args_info->shuffle_arg); /* free previous argument */
      args_info->shuffle_arg = 0;
    }
  if (args_info->thumbnails_arg)
    {
      free (args_info->thumbnails_arg); /* free previous argument */
      args_info->thumbnails_arg = 0;
    }
  if (args_info->dither_arg)
    {
      free (args_info->dither_arg); /* free previous argument */
      args_info->dither_arg = 0;
    }
  if (args_info->resize_win_arg)
    {
      free (args_info->resize_win_arg); /* free previous argument */
      args_info->resize_win_arg = 0;
    }
  if (args_info->slide_show_arg)
    {
      free (args_info->slide_show_arg); /* free previous argument */
      args_info->slide_show_arg = 0;
    }
  if (args_info->zoom_pointer_arg)
    {
      free (args_info->zoom_pointer_arg); /* free previous argument */
      args_info->zoom_pointer_arg = 0;
    }
  if (args_info->null_arg)
    {
      free (args_info->null_arg); /* free previous argument */
      args_info->null_arg = 0;
    }
  if (args_info->one_image_arg)
    {
      free (args_info->one_image_arg); /* free previous argument */
      args_info->one_image_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  
  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);
  
  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "duration",	1, NULL, 'a' },
        { "menu",	2, NULL, 'b' },
        { "client",	2, NULL, 'C' },
        { "alpha-checks",	2, NULL, 'c' },
        { "delay",	1, NULL, 'd' },
        { "no-center",	2, NULL, 'E' },
        { "build-menus",	2, NULL, 'e' },
        { "force-load",	2, NULL, 'F' },
        { "full-screen",	2, NULL, 'f' },
        { "glivrc",	2, NULL, 'g' },
        { "info",	2, NULL, 'i' },
        { "loop",	2, NULL, 'L' },
        { "scale-down",	2, NULL, 'l' },
        { "maximize",	2, NULL, 'M' },
        { "make-fit",	2, NULL, 'm' },
        { "mnemonics",	2, NULL, 'n' },
        { "scrollbars",	2, NULL, 'o' },
        { "fps",	1, NULL, 'P' },
        { "mipmap",	2, NULL, 'p' },
        { "recursive",	2, NULL, 'R' },
        { "sort",	2, NULL, 'S' },
        { "shuffle",	2, NULL, 's' },
        { "thumbnails",	2, NULL, 'T' },
        { "dither",	2, NULL, 't' },
        { "history",	1, NULL, 'u' },
        { "resize-win",	2, NULL, 'W' },
        { "slide-show",	2, NULL, 'w' },
        { "zoom-pointer",	2, NULL, 'z' },
        { "null",	2, NULL, '0' },
        { "one-image",	2, NULL, '1' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVa:b::C::c::d:E::e::F::f::g::i::L::l::M::m::n::o::P:p::R::S::s::T::t::u:W::w::z::0::1::", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'a':	/* Delay between each image.  */
          if (local_args_info.duration_given)
            {
              fprintf (stderr, "%s: `--duration' (`-a') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->duration_given && ! override)
            continue;
          local_args_info.duration_given = 1;
          args_info->duration_given = 1;
          args_info->duration_arg = strtol (optarg,&stop_char,0);
          break;

        case 'b':	/* Hide the menu bar.  */
          if (local_args_info.menu_given)
            {
              fprintf (stderr, "%s: `--menu' (`-b') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->menu_given && ! override)
            continue;
          local_args_info.menu_given = 1;
          args_info->menu_given = 1;
          if (optarg)
            {
              if (args_info->menu_arg)
                free (args_info->menu_arg); /* free previous string */
              args_info->menu_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'C':	/* Connect to an already running gliv.  */
          if (local_args_info.client_given)
            {
              fprintf (stderr, "%s: `--client' (`-C') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->client_given && ! override)
            continue;
          local_args_info.client_given = 1;
          args_info->client_given = 1;
          if (optarg)
            {
              if (args_info->client_arg)
                free (args_info->client_arg); /* free previous string */
              args_info->client_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'c':	/* No alpha checks in the background.  */
          if (local_args_info.alpha_checks_given)
            {
              fprintf (stderr, "%s: `--alpha-checks' (`-c') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->alpha_checks_given && ! override)
            continue;
          local_args_info.alpha_checks_given = 1;
          args_info->alpha_checks_given = 1;
          if (optarg)
            {
              if (args_info->alpha_checks_arg)
                free (args_info->alpha_checks_arg); /* free previous string */
              args_info->alpha_checks_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'd':	/* Delay before hiding the cursor.  */
          if (local_args_info.delay_given)
            {
              fprintf (stderr, "%s: `--delay' (`-d') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->delay_given && ! override)
            continue;
          local_args_info.delay_given = 1;
          args_info->delay_given = 1;
          args_info->delay_arg = strtol (optarg,&stop_char,0);
          break;

        case 'E':	/* No automatic image centering.  */
          if (local_args_info.no_center_given)
            {
              fprintf (stderr, "%s: `--no-center' (`-E') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->no_center_given && ! override)
            continue;
          local_args_info.no_center_given = 1;
          args_info->no_center_given = 1;
          if (optarg)
            {
              if (args_info->no_center_arg)
                free (args_info->no_center_arg); /* free previous string */
              args_info->no_center_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'e':	/* No images menu at startup.  */
          if (local_args_info.build_menus_given)
            {
              fprintf (stderr, "%s: `--build-menus' (`-e') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->build_menus_given && ! override)
            continue;
          local_args_info.build_menus_given = 1;
          args_info->build_menus_given = 1;
          if (optarg)
            {
              if (args_info->build_menus_arg)
                free (args_info->build_menus_arg); /* free previous string */
              args_info->build_menus_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'F':	/* Try to load every file.  */
          if (local_args_info.force_load_given)
            {
              fprintf (stderr, "%s: `--force-load' (`-F') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->force_load_given && ! override)
            continue;
          local_args_info.force_load_given = 1;
          args_info->force_load_given = 1;
          if (optarg)
            {
              if (args_info->force_load_arg)
                free (args_info->force_load_arg); /* free previous string */
              args_info->force_load_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'f':	/* Start in full screen mode.  */
          if (local_args_info.full_screen_given)
            {
              fprintf (stderr, "%s: `--full-screen' (`-f') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->full_screen_given && ! override)
            continue;
          local_args_info.full_screen_given = 1;
          args_info->full_screen_given = 1;
          if (optarg)
            {
              if (args_info->full_screen_arg)
                free (args_info->full_screen_arg); /* free previous string */
              args_info->full_screen_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'g':	/* Ignore ~/.glivrc.  */
          if (local_args_info.glivrc_given)
            {
              fprintf (stderr, "%s: `--glivrc' (`-g') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->glivrc_given && ! override)
            continue;
          local_args_info.glivrc_given = 1;
          args_info->glivrc_given = 1;
          if (optarg)
            {
              if (args_info->glivrc_arg)
                free (args_info->glivrc_arg); /* free previous string */
              args_info->glivrc_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'i':	/* Hide the status bar.  */
          if (local_args_info.info_given)
            {
              fprintf (stderr, "%s: `--info' (`-i') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->info_given && ! override)
            continue;
          local_args_info.info_given = 1;
          args_info->info_given = 1;
          if (optarg)
            {
              if (args_info->info_arg)
                free (args_info->info_arg); /* free previous string */
              args_info->info_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'L':	/* Make the slide show loop at the end.  */
          if (local_args_info.loop_given)
            {
              fprintf (stderr, "%s: `--loop' (`-L') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->loop_given && ! override)
            continue;
          local_args_info.loop_given = 1;
          args_info->loop_given = 1;
          if (optarg)
            {
              if (args_info->loop_arg)
                free (args_info->loop_arg); /* free previous string */
              args_info->loop_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'l':	/* Reduce the image to the window.  */
          if (local_args_info.scale_down_given)
            {
              fprintf (stderr, "%s: `--scale-down' (`-l') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->scale_down_given && ! override)
            continue;
          local_args_info.scale_down_given = 1;
          args_info->scale_down_given = 1;
          if (optarg)
            {
              if (args_info->scale_down_arg)
                free (args_info->scale_down_arg); /* free previous string */
              args_info->scale_down_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'M':	/* Maximize the image to the window.  */
          if (local_args_info.maximize_given)
            {
              fprintf (stderr, "%s: `--maximize' (`-M') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->maximize_given && ! override)
            continue;
          local_args_info.maximize_given = 1;
          args_info->maximize_given = 1;
          if (optarg)
            {
              if (args_info->maximize_arg)
                free (args_info->maximize_arg); /* free previous string */
              args_info->maximize_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'm':	/* Make the image fit the window.  */
          if (local_args_info.make_fit_given)
            {
              fprintf (stderr, "%s: `--make-fit' (`-m') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->make_fit_given && ! override)
            continue;
          local_args_info.make_fit_given = 1;
          args_info->make_fit_given = 1;
          if (optarg)
            {
              if (args_info->make_fit_arg)
                free (args_info->make_fit_arg); /* free previous string */
              args_info->make_fit_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'n':	/* No mnemonics in images menus.  */
          if (local_args_info.mnemonics_given)
            {
              fprintf (stderr, "%s: `--mnemonics' (`-n') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->mnemonics_given && ! override)
            continue;
          local_args_info.mnemonics_given = 1;
          args_info->mnemonics_given = 1;
          if (optarg)
            {
              if (args_info->mnemonics_arg)
                free (args_info->mnemonics_arg); /* free previous string */
              args_info->mnemonics_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'o':	/* Hide the scrollbars.  */
          if (local_args_info.scrollbars_given)
            {
              fprintf (stderr, "%s: `--scrollbars' (`-o') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->scrollbars_given && ! override)
            continue;
          local_args_info.scrollbars_given = 1;
          args_info->scrollbars_given = 1;
          if (optarg)
            {
              if (args_info->scrollbars_arg)
                free (args_info->scrollbars_arg); /* free previous string */
              args_info->scrollbars_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'P':	/* Maximum framerate.  */
          if (local_args_info.fps_given)
            {
              fprintf (stderr, "%s: `--fps' (`-P') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->fps_given && ! override)
            continue;
          local_args_info.fps_given = 1;
          args_info->fps_given = 1;
          args_info->fps_arg = strtol (optarg,&stop_char,0);
          break;

        case 'p':	/* Build Mipmaps.  */
          if (local_args_info.mipmap_given)
            {
              fprintf (stderr, "%s: `--mipmap' (`-p') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->mipmap_given && ! override)
            continue;
          local_args_info.mipmap_given = 1;
          args_info->mipmap_given = 1;
          if (optarg)
            {
              if (args_info->mipmap_arg)
                free (args_info->mipmap_arg); /* free previous string */
              args_info->mipmap_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'R':	/* Process directories recursively.  */
          if (local_args_info.recursive_given)
            {
              fprintf (stderr, "%s: `--recursive' (`-R') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->recursive_given && ! override)
            continue;
          local_args_info.recursive_given = 1;
          args_info->recursive_given = 1;
          if (optarg)
            {
              if (args_info->recursive_arg)
                free (args_info->recursive_arg); /* free previous string */
              args_info->recursive_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'S':	/* Show images in sorted order.  */
          if (local_args_info.sort_given)
            {
              fprintf (stderr, "%s: `--sort' (`-S') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->sort_given && ! override)
            continue;
          local_args_info.sort_given = 1;
          args_info->sort_given = 1;
          if (optarg)
            {
              if (args_info->sort_arg)
                free (args_info->sort_arg); /* free previous string */
              args_info->sort_arg = gengetopt_strdup (optarg);
            }
          break;

        case 's':	/* Show images in random order.  */
          if (local_args_info.shuffle_given)
            {
              fprintf (stderr, "%s: `--shuffle' (`-s') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->shuffle_given && ! override)
            continue;
          local_args_info.shuffle_given = 1;
          args_info->shuffle_given = 1;
          if (optarg)
            {
              if (args_info->shuffle_arg)
                free (args_info->shuffle_arg); /* free previous string */
              args_info->shuffle_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'T':	/* No thumbnails in images menus.  */
          if (local_args_info.thumbnails_given)
            {
              fprintf (stderr, "%s: `--thumbnails' (`-T') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->thumbnails_given && ! override)
            continue;
          local_args_info.thumbnails_given = 1;
          args_info->thumbnails_given = 1;
          if (optarg)
            {
              if (args_info->thumbnails_arg)
                free (args_info->thumbnails_arg); /* free previous string */
              args_info->thumbnails_arg = gengetopt_strdup (optarg);
            }
          break;

        case 't':	/* Enable dithering.  */
          if (local_args_info.dither_given)
            {
              fprintf (stderr, "%s: `--dither' (`-t') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->dither_given && ! override)
            continue;
          local_args_info.dither_given = 1;
          args_info->dither_given = 1;
          if (optarg)
            {
              if (args_info->dither_arg)
                free (args_info->dither_arg); /* free previous string */
              args_info->dither_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'u':	/* Length of history.  */
          if (local_args_info.history_given)
            {
              fprintf (stderr, "%s: `--history' (`-u') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->history_given && ! override)
            continue;
          local_args_info.history_given = 1;
          args_info->history_given = 1;
          args_info->history_arg = strtol (optarg,&stop_char,0);
          break;

        case 'W':	/* No automatic window resizing.  */
          if (local_args_info.resize_win_given)
            {
              fprintf (stderr, "%s: `--resize-win' (`-W') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->resize_win_given && ! override)
            continue;
          local_args_info.resize_win_given = 1;
          args_info->resize_win_given = 1;
          if (optarg)
            {
              if (args_info->resize_win_arg)
                free (args_info->resize_win_arg); /* free previous string */
              args_info->resize_win_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'w':	/* Start the slide show immediately.  */
          if (local_args_info.slide_show_given)
            {
              fprintf (stderr, "%s: `--slide-show' (`-w') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->slide_show_given && ! override)
            continue;
          local_args_info.slide_show_given = 1;
          args_info->slide_show_given = 1;
          if (optarg)
            {
              if (args_info->slide_show_arg)
                free (args_info->slide_show_arg); /* free previous string */
              args_info->slide_show_arg = gengetopt_strdup (optarg);
            }
          break;

        case 'z':	/* Zoom centered on pointer.  */
          if (local_args_info.zoom_pointer_given)
            {
              fprintf (stderr, "%s: `--zoom-pointer' (`-z') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->zoom_pointer_given && ! override)
            continue;
          local_args_info.zoom_pointer_given = 1;
          args_info->zoom_pointer_given = 1;
          if (optarg)
            {
              if (args_info->zoom_pointer_arg)
                free (args_info->zoom_pointer_arg); /* free previous string */
              args_info->zoom_pointer_arg = gengetopt_strdup (optarg);
            }
          break;

        case '0':	/* Read null-terminated filenames.  */
          if (local_args_info.null_given)
            {
              fprintf (stderr, "%s: `--null' (`-0') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->null_given && ! override)
            continue;
          local_args_info.null_given = 1;
          args_info->null_given = 1;
          if (optarg)
            {
              if (args_info->null_arg)
                free (args_info->null_arg); /* free previous string */
              args_info->null_arg = gengetopt_strdup (optarg);
            }
          break;

        case '1':	/* Keep only one image in memory.  */
          if (local_args_info.one_image_given)
            {
              fprintf (stderr, "%s: `--one-image' (`-1') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->one_image_given && ! override)
            continue;
          local_args_info.one_image_given = 1;
          args_info->one_image_given = 1;
          if (optarg)
            {
              if (args_info->one_image_arg)
                free (args_info->one_image_arg); /* free previous string */
              args_info->one_image_arg = gengetopt_strdup (optarg);
            }
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;

failure:
  cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
