/*
  Copyright (C) 2001-2004 Stephane Magnenat & Luc-Olivier de Charrière
  for any question or comment contact us at nct@ysagoon.com or nuage@ysagoon.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef __SUPPORT_FUNCTION_H
#define __SUPPORT_FUNCTION_H

#include "GAGSys.h"
#include <stdlib.h>
#include <string>
#include <stdarg.h>

namespace GAGCore
{
	// rectangle
	//! return true if (x,y) is in r
	bool ptInRect(int x, int y, SDL_Rect *r);
	//! FIXME : please Luc document this
	void rectClipRect(int &x, int &y, int &w, int &h, SDL_Rect &r);
	//! FIXME : please Luc document this
	void rectExtendRect(SDL_Rect *rs, SDL_Rect *rd);
	//! FIXME : please Luc document this
	void rectExtendRect(int xs, int ys, int ws, int hs, int *xd, int *yd, int *wd, int *hd);
	//! FIXME : please Luc document this
	void sdcRects(SDL_Rect *source, SDL_Rect *destination, const SDL_Rect &clipping);

	// color space conversion
	//! do a color space conversion from RGB to HSV
	void RGBtoHSV( float r, float g, float b, float *h, float *s, float *v );
	//! do a color space conversion from HSV to RGB
	void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v );
	// color space conversion support functions
	//! return min of f1, f2 and f3
	float fmin(float f1, float f2, float f3);
	//! return max of f1, f2 and f3
	float fmax(float f1, float f2, float f3);

	//! c++ version of asprintf (n for new instead of a for alloc)
	std::string nsprintf(const char* s, ...);
	//! c++ version of asprintf (n for new instead of a for alloc)
	std::string vnsprintf(const char* s, va_list args);

	//! strdup function using new
	char* newstrdup(const char* str);
};

#endif

