dnl ---------------------------------------------------------------------
dnl LAC_DATATYPE_SIZES()
dnl ---------------------------------------------------------------------
AC_DEFUN([LAC_DATATYPE_SIZES],[
if test "$cross_compiling" = "no"; then
    AC_C_BIGENDIAN
    AC_CHECK_SIZEOF(short)
    AC_CHECK_SIZEOF(long)
else
    case "$target" in
      i860-intel-osf* )
        ac_cv_c_bigendian=no
        ac_cv_sizeof_short=2
        ac_cv_sizeof_long=4
        ;;
      * )
        ac_cv_c_bigendian=yes
        ac_cv_sizeof_short=2
        ac_cv_sizeof_long=4
        ;;
    esac
    echo "guessing whether byte ordering is big endian... $ac_cv_c_bigendian"
    echo "guessing size of short... $ac_cv_sizeof_short"
    echo "guessing size of long... $ac_cv_sizeof_long"
fi
])

dnl ---------------------------------------------------------------------
dnl LAC_DATA_CONVERSION()
dnl ---------------------------------------------------------------------
AC_DEFUN([LAC_DATA_CONVERSION],
[

LAC_DATATYPE_SIZES

GLOBUS_DC_FORMAT_32BIT_LE=0
GLOBUS_DC_FORMAT_32BIT_BE=1
GLOBUS_DC_FORMAT_64BIT_LE=2
GLOBUS_DC_FORMAT_64BIT_BE=3
GLOBUS_DC_FORMAT_CRAYC90=4
GLOBUS_DC_FORMAT_JAVA=5
GLOBUS_DC_FORMAT_CRAYT3E=6

case "$ac_cv_sizeof_long-$ac_cv_c_bigendian" in
    "4-no" )
        GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_32BIT_LE
        AC_DEFINE(GLOBUS_DC_FORMAT_32BIT_LE)
        ;;
    "4-yes" )
        GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_32BIT_BE
        AC_DEFINE(GLOBUS_DC_FORMAT_32BIT_BE)
        ;;
    "8-no" )
        GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_64BIT_LE
        AC_DEFINE(GLOBUS_DC_FORMAT_64BIT_LE)
        ;;
    "8-yes" )
        if test "$ac_cv_sizeof_short" = "2" ; then
            GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_64BIT_BE
            AC_DEFINE(GLOBUS_DC_FORMAT_64BIT_BE)
        elif test "$ac_cv_sizeof_short" = "4" ; then
            GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_CRAYT3E
            AC_DEFINE(GLOBUS_DC_FORMAT_CRAYT3E)
        else
            GLOBUS_DC_FORMAT_LOCAL=$GLOBUS_DC_FORMAT_CRAYC90
            AC_DEFINE(GLOBUS_DC_FORMAT_CRAYC90)
        fi
        ;;
esac
AC_DEFINE_UNQUOTED(GLOBUS_DC_FORMAT_LOCAL, $GLOBUS_DC_FORMAT_LOCAL)
])
