/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */

/******************************************************************************
globus_mp_mpi.c

Description:

  MPI activation

CVS Information:

  $Source: /home/globdev/CVS/globus-packages/mp/source/globus_mp_mpi.c,v $
  $Date: 2005/04/18 21:41:55 $
  $Revision: 1.9 $
  $State: Exp $
  $Author: smartin $
******************************************************************************/

/******************************************************************************
			     Include header files
******************************************************************************/
#include "globus_mp_mpi.h"
#ifdef GLOBUS_MP_HAS_MPI_PROTO

#include "version.h"

/******************************************************************************
			  Module activation structure
******************************************************************************/
static int
globus_l_mp_mpi_activate(void);

static int
globus_l_mp_mpi_deactivate(void);

static void
globus_l_mp_mpi_atexit(void);


globus_module_descriptor_t		globus_i_mp_mpi_module =
{
    "globus_mp_mpi",
    globus_l_mp_mpi_activate,
    globus_l_mp_mpi_deactivate,
    globus_l_mp_mpi_atexit,
    GLOBUS_NULL,
    &local_version
};

static globus_bool_t globus_l_mp_mpi_initialized = GLOBUS_FALSE;

/******************************************************************************
			   MPI activation functions
******************************************************************************/
static int
globus_l_mp_mpi_activate(void)
{
    int					initialized;

    MPI_Initialized(&initialized);
    if (!initialized)
    {
	int *argc;
	char ***argv;

	globus_l_mp_mpi_initialized = GLOBUS_TRUE;
	globus_module_get_args(&argc, &argv);
	if (argc && argv)
	{
	    MPI_Init(argc, argv);
	}
	else
	{
	    MPI_Init(NULL, NULL);
	} /* endif */

    }

    return GLOBUS_SUCCESS;
}


static int
globus_l_mp_mpi_deactivate(void)
{
    return GLOBUS_SUCCESS;
}


static void
globus_l_mp_mpi_atexit(void)
{
    if (globus_l_mp_mpi_initialized)
    {
	MPI_Finalize();
    }
}

#endif
