/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * defs.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/defs.h,v 1.26 2006/01/19 05:57:05 mlink Exp $"
 */

#ifndef _NEXUS_INCLUDE_DEFS_H
#define _NEXUS_INCLUDE_DEFS_H

/*
 * A magic number used in debugging nexus buffers
 */
#ifdef BUILD_DEBUG
#define NEXUS_BUFFER_MAGIC 12344321
#endif

/*
 * MAX_NEW_PROCESS_PARAMS
 *
 * Maximum length (in bytes) that the new_process_params string can be.
 */
#define MAX_NEW_PROCESS_PARAMS 1024

/*
 * NEXUS_MAX_COMMAND_LENGTH
 *
 * Maximum length of any command strings that are created.
 */
#define NEXUS_MAX_COMMAND_LENGTH 1024

/*
 * NEXUS_MAX_SESSION_STRING_LENGTH
 *
 * Maximum length of any session string returned
 * by _nx_md_get_unique_session_string().
 */
#define NEXUS_MAX_SESSION_STRING_LENGTH 1024

/*
 * GLOBUS_I_NEXUS_MI_PROTO_HEADER_VERSION
 *
 * Version number for the mi_proto header.  Increment this if you ever
 * want to change the format of the mi_proto header.
 */
#define GLOBUS_I_NEXUS_MI_PROTO_HEADER_VERSION 0

/*
 * GLOBUS_I_NEXUS_BUFFER_VERSION
 *
 * Version number for standard buffer that is packed by nexus_send_rsr().
 * This version number is never really used by itself.  A buffer
 * format change is, in some sense, just a special case of changing
 * a protocol module's wire format.  However, if you change the buffer
 * version it affect all protocol modules.  So instead of having to
 * propogate such a change to all protocol modules by hand, the
 * protocol modules include the buffer version as part of their version:
 *   #define GLOBUS_L_XXX_PROTOCOL_VERSION (4 + GLOBUS_I_NEXUS_BUFFER_VERSION)
 * So if you change the buffer format, you can just increment this
 * buffer version, and that will have the affect of incrementing
 * all protocol module versions.
 */
#define GLOBUS_I_NEXUS_BUFFER_VERSION 0

#ifndef NEXUS_DATABASE_PREFIX
#define NEXUS_DATABASE_PREFIX "resource_database"
#endif

#define NEXUS_DATABASE_PREFIX_SIZE (sizeof(NEXUS_DATABASE_PREFIX)-1)

#ifndef NEXUS_DBFILE
#define NEXUS_DBFILE ".resource_database"
#endif

#define NEXUS_TRANSFORM_TABLE_SIZE 256

#endif /* _NEXUS_INCLUDE_DEFS_H */
