/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * nx_ver.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/nx_ver.h,v 1.17 2006/01/19 05:57:05 mlink Exp $"
 */

#ifndef _NEXUS_INCLUDE_NX_VERSION_H
#define _NEXUS_INCLUDE_NX_VERSION_H

#ifndef EXTERN_C_BEGIN
#    ifdef __cplusplus
#        define EXTERN_C_BEGIN extern "C" {
#        define EXTERN_C_END }
#    else
#        define EXTERN_C_BEGIN
#        define EXTERN_C_END
#    endif
#endif

EXTERN_C_BEGIN



#ifdef NEXUS_LINK_TEST

#ifdef BUILD_PROFILE
extern int _nexus_linked_profile;
static int _nexus_defined_profile(void) { return _nexus_linked_profile; }
#else
extern int _nexus_linked_no_profile;
static int _nexus_defined_profile(void) { return _nexus_linked_no_profile; }
#endif

#ifdef BUILD_DEBUG
extern int _nexus_linked_debug;
static int _nexus_defined_debug(void) { return _nexus_linked_debug; }
#else
extern int _nexus_linked_no_debug;
static int _nexus_defined_debug(void) { return _nexus_linked_no_debug; }
#endif

/* two levels of static function calls are needed in order to fool
   the IBM AIX 3.2 compilers and/or linker into not optimizing away
   the linkguards (jwg).
*/
/* REFERENCED */
static int _nexus_force_resolution(void)
{
	return _nexus_defined_profile() + _nexus_defined_debug();
}

#endif

EXTERN_C_END

#endif /* _NEXUS_INCLUDE_NX_VERSION_H */
