/*
 * Copyright (C) 2000-2010  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
//#include <QtGui>
//#include <QModelIndex>
//#include <QImage>

#include "frmPrincipal.h"

#include "peca/peca.h"
#include "peca/conjuntpeces.h"
#include "comuns/constants.h"
#include "comuns/configuracio.h"
#include "formularis/desafigura.h"
#include "formularis/creaconcurs.h"
#include "comuns/funcions.h"


class QSettings;



formulariPrincipal::formulariPrincipal()
{


charPathSeparator=QDir().separator();

estatDelJoc=Inactiu;

//QTime midnight(0, 0, 0);
//qsrand(midnight.secsTo(QTime::currentTime()));
//midnight.destroy;

//srand (time(NULL));

setMinimumSize (QSize(900,620));
setMaximumSize(QSize(900,620));


//cream la configuració del programa
configuracioJoc= new Configuracio();

figuresResoltesList=new QStringList();
carregaFiguresResoltes();

figuresSemblantsList=new QStringList();

    sceneFrame=new QFrame(this);
    sceneFrame->setGeometry(0,60,900,550);

    //Panell de la mostra de les figures
    sceneMostra=new QGraphicsScene(0, 0, 140, 140);

    viewMostra = new QGraphicsView(sceneMostra,sceneFrame);
    viewMostra->setRenderHints(QPainter::Antialiasing
                             | QPainter::TextAntialiasing);
    viewMostra->move(QPoint(150,0));

    //Panell del joc
    sceneJoc = new QGraphicsScene(0, 0, 600, 530);
    connect(sceneJoc,SIGNAL(selectionChanged()),
            this,SLOT(canvisSceneJoc()));

    viewJoc = new QGraphicsView(sceneJoc,sceneFrame);
    viewJoc->setRenderHints(QPainter::Antialiasing
                           | QPainter::TextAntialiasing);
    viewJoc->move(QPoint(300,0));


    contadorsFrame=new QFrame(sceneFrame);
    contadorsFrame->setGeometry(0,0,140,140);
    contadorsFrame->move(QPoint(0,0));

    rellotgeLabel = new Rellotge(contadorsFrame);
    rellotgeLabel->setGeometry(0,0,140,30);
    rellotgeLabel->setAlignment(Qt::AlignHCenter);

    numFigures= new QLabel("Figures",contadorsFrame);
    numFigures->setGeometry(0,35,140,30);
    numFigures->setAlignment(Qt::AlignHCenter);

    punts= new QLabel("Punts",contadorsFrame);
    punts->setGeometry(0,70,140,30);
    punts->setAlignment(Qt::AlignHCenter);



    //arbre de figures
    arbreFiguresTreeWidget= new QTreeWidget(sceneFrame);
    arbreFiguresTreeWidget->setGeometry(0,0,295,390);
 //   arbreFiguresTreeWidget->setMinimumSize(QSize(295,390));
    arbreFiguresTreeWidget->move(QPoint(0,145));
    arbreFiguresTreeWidget->expandAll();
    connect(arbreFiguresTreeWidget,SIGNAL(itemSelectionChanged()),
           this,SLOT(seleccioFigura()));
    connect(arbreFiguresTreeWidget,SIGNAL(itemDoubleClicked ( QTreeWidgetItem *, int )),
            this,SLOT(seleccionFiguraItemDoubleClicked (QTreeWidgetItem *, int )));
   // connect(arbreFiguresTreeWidget,SIGNAL(mousePressEvent ( QMouseEvent * )),
  //          this,SLOT(seleccionFiguraMouseEvent(QMouseEvent *)));


    creaAcccions();
    creaMenus();
    creaBarraTasques();


    setWindowTitle("Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")");
    setWindowIcon(QIcon(":/images/pecesset.png"));
 //   setCentralWidget(sceneFrame);

    creaTangram(configuracioJoc->tipusTangram);
    canviaNivellJoc(configuracioJoc->nivellJoc);

    switch (configuracioJoc->nivellJoc){
        case NIVELL_INFANTIL:
         nivellInfantilAction->setChecked(true);
         break;
        case NIVELL_PRINCIPIANT:
         nivellPrincipiantAction->setChecked(true);
         break;
        case NIVELL_INICIAT:
         nivellIniciatAction->setChecked(true);
         break;
        case NIVELL_EXPERT:
         nivellExpertAction->setChecked(true);
         break;
        default:
         nivellIniciatAction->setChecked(true);
    }
}

void formulariPrincipal::actualitzaMenus(){
    creaFiguraMenu->setEnabled(estatDelJoc==Inactiu);
    comprovaMostraAction->setEnabled(estatDelJoc==Inactiu);
    esborraMostraAction->setEnabled(estatDelJoc==Inactiu);
    desaFiguraAction->setEnabled(estatDelJoc==Inactiu);
    cercaFiguraAction->setEnabled(estatDelJoc==Inactiu &&
                                arbreFiguresTreeWidget->topLevelItem(0)!=0 );
    cercaNomFigura->setEnabled(estatDelJoc != JocIniciat &&
                               arbreFiguresTreeWidget->topLevelItem(0)!=0 );

    proposaFigura->setEnabled(estatDelJoc != JocIniciat);
    mostraSolucioAction->setEnabled(estatDelJoc==JocIniciat );
    colocaPecaAction->setEnabled(estatDelJoc==JocIniciat && configuracioJoc->nivellJoc != NIVELL_EXPERT
                                 && configuracioJoc->nivellJoc != NIVELL_INFANTIL);

    if (estatDelJoc==JocIniciat && configuracioJoc->nivellJoc != NIVELL_EXPERT
                                 && configuracioJoc->nivellJoc != NIVELL_INFANTIL){
       colocaPecaAction->setEnabled(true);
    }
    else {
        colocaPecaAction->setEnabled(false);
        colocaPecaAction->setChecked(false);
        configuracioJoc->colocaPeca=false;
    }
    carregaFiguresArxiuAction->setEnabled(estatDelJoc !=JocIniciat);
    carregaFiguresProgramaAction->setEnabled(estatDelJoc!=JocIniciat);

    elimnaRecordAction->setEnabled(estatDelJoc!=JocIniciat);
    eliminaTotsRecordsAction->setEnabled(estatDelJoc!=JocIniciat);

}

 void formulariPrincipal::canviaEstatDelJoc(EstatsDelJoc estat){
    missatgeStatusBar("");
    switch (estatDelJoc){
        case Inactiu:
            switch (estat){
               case FiguraCarregada:
                    estatDelJoc=estat;
               break;
               case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
               break;
               /* això no es pot fer, ja que els conjunts
                  no existeixen al principi
               case Inactiu:               
                    conjuntFigura->conjuntVisible(false);
                    conjuntMostra->conjuntVisible(false);
               break;
               */
               case Inactiu:
               case JocIniciat:
               case MostraSolucio:
               break;
           }
        break;

        case FiguraCarregada:
            switch (estat){
                case Inactiu:
                estatDelJoc=estat;
                conjuntFigura->conjuntVisible(false);
                conjuntMostra->conjuntVisible(false);
                break;
                case JocIniciat:
                estatDelJoc=estat;
                //posar en marxa el rellotge
                rellotgeLabel->iniciaRellotge();
                /* 4.0.2 21/12/10
                 Aquesta absurda repetició soluciona el problema de la col·locació
                 de les peces en el nivell infantil. Abans, en el primer intent
                 de col·locar la primera peça, no es col·locava.
                   */
                conjuntJoc->arrayPeces[0]->setSelected(true);
                conjuntJoc->arrayPeces[0]->setSelected(false);
                break;
                case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                break;
                case FiguraCarregada:
                case MostraSolucio:
                break;
            }
        break;

        case JocIniciat:
            switch (estat){
                case FiguraResolta:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       if (!configuracioJoc->colocaPeca){
                       actualitzaPuntuacio(1,configuracioJoc->nivellJoc*conjuntJoc->arrayPeces.size());
                        }
                       desaContadors();
                       conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                       conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                       arbreFiguresTreeWidget->selectedItems().first()->setIcon(0,iconeFigura(4));
                       arbreFiguresTreeWidget->selectedItems().first()->setText(3,"1");
     /*
       v. 4.0.2 20/12/10
       S'fegeix la col·locació de les peces. Així es conserva la solució
       obtinguda per l'usuari
       */
                       figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1;").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0))+
                                QString("%1").arg(conjuntJoc->coordenadesFigura()));
                    //v. 4.0.2 20/12/10
                    //Es desen les figures resoltes inmediatament.
                    desaFiguresResoltes();
                    break;
                case FiguraCarregada:
                case Inactiu:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       desaContadors();
                    break;
                case MostraSolucio:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       actualitzaPuntuacio(1,-configuracioJoc->nivellJoc*conjuntJoc->arrayPeces.size());
                       desaContadors();
                       conjuntFigura->conjuntSolucio();
                       arbreFiguresTreeWidget->selectedItems().first()->setIcon(0,iconeFigura(4));
                       arbreFiguresTreeWidget->selectedItems().first()->setText(3,"1");
                       figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0)));
                    break;
                    case JocIniciat:
                    break;
            }
        break;
        case FiguraResolta:
                switch (estat){
                    case Inactiu:
                       estatDelJoc=estat;
                       conjuntFigura->conjuntVisible(false);
                       conjuntMostra->conjuntVisible(false);
                    break;
                    case FiguraCarregada:
                       estatDelJoc=estat;
                    break;
                    case FiguraResolta:
                        estatDelJoc=estat;
                        conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                        conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    break;
                    case JocIniciat:
                    case MostraSolucio:
                    break;
                }
        break;
        case MostraSolucio:
           switch (estat){
                case Inactiu:
                    estatDelJoc=estat;
                    conjuntFigura->conjuntVisible(false);
                    conjuntMostra->conjuntVisible(false);
                break;
                case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                break;
                case FiguraCarregada:
                   estatDelJoc=estat;
                break;
                case JocIniciat:
                case MostraSolucio:
                break;
           }
        break;
    }
 // actualitzar l'estat de les QActions
 actualitzaMenus();
 }
/*
  Gestiona els canvis al panell de joc
*/
void formulariPrincipal::canvisSceneJoc(){
   switch (estatDelJoc){
        case Inactiu:
        break;
        case FiguraCarregada:
            canviaEstatDelJoc(JocIniciat);
        break;
        case JocIniciat:
            //si estem al nivell infantil, controlam si cal
            //col·locar la peça directament
            if (configuracioJoc->nivellJoc==NIVELL_INFANTIL){

                    for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
                        if(conjuntJoc->arrayPeces.value(i)->isSelected() &&
                          sceneJoc->selectedItems().indexOf(conjuntJoc->arrayPeces.value(i))>-1){
                          pecaSeleccionadaNivellInfantil=i;
                          break;
                        }
                    }

                if (pecaSeleccionadaNivellInfantil>=0){
                    if(colocaPecaNivellInfantil(pecaSeleccionadaNivellInfantil)){
                              colocaPeca(pecaSeleccionadaNivellInfantil);
                              pecaSeleccionadaNivellInfantil=-1;
                          }
                    }
                /*
                    for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
                        if(conjuntJoc->arrayPeces.value(i)->isSelected() &&
                          sceneJoc->selectedItems().indexOf(conjuntJoc->arrayPeces.value(i))>-1){
                          pecaSeleccionadaNivellInfantil=i;
                          break;
                        }
                    }
                    */
                }

            if (configuracioJoc->colocaPeca){
               for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
                   if(conjuntJoc->arrayPeces.value(i)->isSelected() &&
                      sceneJoc->selectedItems().indexOf(conjuntJoc->arrayPeces.value(i))>-1){
                      actualitzaPuntuacio(0,-configuracioJoc->nivellJoc);
                      colocaPeca(i);
                      break;
                      }
                   }
               }
            //cal revisa si la figura està resolta
            //Aquest if evita que es faci la comprovació dues vegades
            //(Quan es selecciona i quan es deselecciona una peça)
            if(sceneJoc->selectedItems().size()==0){
            float percentatgeSolucio;
            percentatgeSolucio=figuraSolucionada();
            if ( percentatgeSolucio>=PERCENTATGE_COINCIDENCIA_SOLUCIO) {
                        canviaEstatDelJoc(FiguraResolta);
                    }
             }
        break;
        case FiguraResolta:
        break;
        case MostraSolucio:
        break;
    }
}

float formulariPrincipal::figuraSolucionada(){

    int positiu,positiu1,totals;
    positiu=0;
    positiu1=0;
    totals=0;
/*
if (configuracioJoc->nivellJoc==NIVELL_INFANTIL){
    if (figuraSolucionadaNivellInfantil()){
        return 100;
    }
    else return 0;
}
else {
*/
    QVector<QPointF> pSolucio;

    //Si el nivell és expert, primer cal "resituar"
    //el conjuntFigura (nomès si la figura no és "composta")
    if (configuracioJoc->nivellJoc==NIVELL_EXPERT &&
        !conjuntFigura->arrayPeces[0]->pecaVisible){
        conjuntFigura->recolocaPeces(conjuntJoc->vertexSuperiorEsquerra());
    }

//Carregam els vèrtex de la figura
QPointF vertSupEsq=conjuntJoc->vertexSuperiorEsquerra();
for(int i=0;i<=conjuntFigura->arrayPeces.size()-1;i++){
   conjuntFigura->arrayPeces[i]->puntsSolucio(pSolucio,0.9);
   }

/* Això estaria molt be, però cal trobar un triangle que sigui
   el "MCD" de totes les peces (...que no sembla possible)
for(int j=0;j<=pSolucio.size()-1;j++){
    for(int k=0;k<=pJoc.size()-1;k++){
     QPointF punt=pSolucio.value(j)-pJoc.value(k);
        if(sqrt(pow(punt.x(),2)+pow(punt.y(),2))<=DISTANCIA_PUNTS_SOLUCIO){
          positiu1=positiu1+1;
          break;
        }
    }
}
*/
//ara fem la comprovació
totals=pSolucio.size();
for(int j=0;j<=pSolucio.size()-1;j++){
    for(int k=0;k<=conjuntJoc->arrayPeces.size()-1;k++){
        if(conjuntJoc->arrayPeces[k]->shape().contains(
                pSolucio.value(j)-conjuntJoc->arrayPeces[k]->pos())){
            positiu=positiu+1;
            //aquest break evita que un mateix punt es comptabilitzi
            //més d'una vegada si hi ha peces superposades
            break;
        }
        //    printf(QString("Peces %1 Positius %2 totals %3 \n").arg(k).arg(positiu).arg(totals).toAscii());
    }
}
if (totals<1){
    return 0.0;}
else {
//qCritical("Positius %d totals %d \n",positiu,totals);
 /* 4.0.2
    Afegit aquest avís per facilitar la resolució de figures
    */
 missatgeStatusBar(QString("%1 %").arg(positiu*100/(totals)));
//printf(QString("Positius %1 totals %2 \n").arg(positiu).arg(totals).toAscii());
    return positiu*100/(totals);
  }
 }
//}

bool formulariPrincipal::figuraSolucionadaNivellInfantil(){
QString coordenadesFigura;
coordenadesFigura=conjuntFigura->coordenadesFigura();
  if (coordenadesFigura==conjuntJoc->coordenadesFigura()){
     return true;
  }
  else {
    QList<int> index;
    int indexPeca;
    QPointF vertexFigura=conjuntFigura->vertexSuperiorEsquerra();
    for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
       indexPeca=coordenadesFigura.indexOf(conjuntJoc->arrayPeces[i]->cadenaPropietatsPeca(
               vertexFigura));
       if(indexPeca>-1 && index.indexOf(indexPeca==-1)){
          index.append(indexPeca);
       }
    }
return index.size()==conjuntJoc->arrayPeces.size();
  }
}

/* 4.0.2
  Elimina la solució de la figuera obtinguda per l'usuari
  */
void formulariPrincipal::seleccionFiguraItemDoubleClicked(QTreeWidgetItem * item, int column){
    //si la figura ha estat resolta
   if (item->text(3)=="1" ){
        QString nom=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).
                      arg(arbreFiguresTreeWidget->selectedItems().first()->text(0));
          QRegExp rx(nom+"*");
          rx.setPatternSyntax(QRegExp::Wildcard);
          QStringList dades=figuresResoltesList->value(figuresResoltesList->indexOf(rx)).split(";");
          //Cal evitar que es demani si es vol eliminar les dades de la solució....quan no n'hi ha!
          if (dades.size()>3){
          QMessageBox missatgeBox;
        //missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.solucio"));
        missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.solucio.pregunta"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
          //Eliminam la figura resolta
          figuresResoltesList->removeAt(figuresResoltesList->indexOf(rx));
          //I ara l'afegim sense les dades de la solució
          figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0)));
          desaFiguresResoltes();
          conjuntJoc->colocaPecesAtzar();
         }
        }
  }
}

/*
Gestiona la selecció d'una figura a l'arbre
(conectat amb arbreFiguresTreeWidget::itemSelectionChanged ()
*/
void formulariPrincipal::seleccioFigura(){

if (!arbreFiguresTreeWidget->selectedItems().isEmpty()){
 QTreeWidgetItem *item;
 item=arbreFiguresTreeWidget->selectedItems().first();
 //S'ha clicat el nus arrel
 if (item->childCount()>0){
    canviaEstatDelJoc(Inactiu);
    conjuntMostra->conjuntVisible(false);
    conjuntFigura->conjuntVisible(false);
    creaFiguraMenu->setEnabled(true);
     }
 else if (!item->text(1).isEmpty()){
    canviaEstatDelJoc(FiguraCarregada);
    conjuntMostra->colocaPeces(item->text(1));
    conjuntMostra->conjuntVisible(true);
    conjuntMostra->conjuntDeMostra();
    conjuntFigura->colocaPeces(item->text(1));
    conjuntFigura->conjuntDeMostra(); //&& item->text(4)=="0"
   if(configuracioJoc->nivellJoc==NIVELL_EXPERT ){
    conjuntFigura->conjuntVisible(false);
    }
   conjuntJoc->colocaPecesAtzar();
   //La figura ja ha estat resolta per l'usuari
    if (item->text(3)=="1"){
     canviaEstatDelJoc(FiguraResolta);
      //Carregam la solució de l'usuari
     conjuntJoc->colocaPeces(figuraJaResoltaPosicioPeces(item->text(0)));
     //restablim l'angle de gir de les peces
     angleGirConjuntPecesJoc();
     }
   // conjuntJoc->colocaPecesAtzar();
   //Això és necessari degut a que, a vegades, queda algun
   //"rastre" de la figura anterior
   sceneMostra->update();
   sceneJoc->update();
  // creaArxiuImatge(item->text(0));
  }
else {
    canviaEstatDelJoc(Inactiu);
    conjuntMostra->conjuntVisible(false);
    conjuntFigura->conjuntVisible(false);
    conjuntJoc->colocaPecesAtzar();
   }
 }


}
/*
  Crea un arxiu amb la imatge actual del conjuntMostra
  */
void formulariPrincipal::creaArxiuImatge(QString nomArxiu){
if (!nomArxiu.isEmpty()){
  //  QImage *image1 = new QImage(sceneMostra->width(), sceneMostra->height(), QImage::Format_ARGB32_Premultiplied);
    QRectF rectFigura =conjuntMostra->rectangleFigura();
 //   printf(QString("%1  %2 \n").arg(rectFigura.width()).arg(rectFigura.height()).toAscii());
    QImage *image1 = new QImage(rectFigura.width(),
                                rectFigura.height(),
                                QImage::Format_ARGB32_Premultiplied);
    QPainter *painter= new QPainter(image1);
    conjuntMostra->conjuntSolucio();
    sceneMostra->update();
    QRectF target;
    sceneMostra->render(painter,target,rectFigura);
    painter->end();
    QString  nomArxiuImatge;
    nomArxiuImatge=QDir::homePath ()+QDir().separator()+"tangram"+QDir().separator()+nomArxiu+".png";
  //  printf(nomArxiuImatge.toAscii());
    QFile arxiu(nomArxiuImatge);
    arxiu.remove(nomArxiuImatge);
    if(!image1->save(nomArxiuImatge)){
        printf("no s'ha desat");
    }
  }
}

void formulariPrincipal::carregaArbreFigures(QString nomArxiu){
//return;
QApplication::setOverrideCursor(Qt::WaitCursor);

carregaContadors();

canviaEstatDelJoc(Inactiu);
//netejam
arbreFiguresTreeWidget->clear();
arbreFiguresTreeWidget->setColumnCount(4);
arbreFiguresTreeWidget->setColumnHidden(1,true);
arbreFiguresTreeWidget->setColumnHidden(2,true);
arbreFiguresTreeWidget->setColumnHidden(3,true);
arbreFiguresTreeWidget->setColumnHidden(4,true);
//1: visible la mostra de la figura al nivell 4
//arbreFiguresTreeWidget->setColumnHidden(5,true);

//posam la capçalera de l'arbre
QTreeWidgetItem *item=new QTreeWidgetItem();
item->setIcon(0,QIcon(":/images/"+configuracioJoc->nomIcone));
item->setText(0,configuracioJoc->tradueixCadena(configuracioJoc->nomJocArbreFigures));
arbreFiguresTreeWidget->setHeaderItem(item);
llegeixArxiuFigures(nomArxiu);
//actualitzaMenus();
QApplication::setOverrideCursor(Qt::ArrowCursor);
}

void formulariPrincipal::llegeixArxiuFigures( QString nomArxiu){
  //obrim l'arxiu de figures
  QFile arxiuFigures(nomArxiu);
    if (!arxiuFigures.open(QIODevice::ReadOnly | QIODevice::Text)){
        QMessageBox::information(this, "Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")",
                                configuracioJoc->tradueixCadena("ArxiuNoTrobat").arg(nomArxiu) );
         return ;
     }

  QSettings *controlArxiu;
  controlArxiu=new QSettings(QSettings::IniFormat, QSettings::UserScope,"De Marchi", "NomFigures");
  controlArxiu->clear();

     QTextStream entrada(&arxiuFigures);
     QString linia0 = entrada.readLine();
     QString linia1,linia2;
     bool figuraComposta;

     QTreeWidgetItem *arrel=new QTreeWidgetItem();
     int numFig, intPosDarrerPunt;
     while (!linia0.isNull()) {
         linia1=entrada.readLine();
         linia2=entrada.readLine();
            //Controla si cal NO carregar la figura al nivell expert
            //(a les figures "compostes")
            if (linia2.length()==5){
               if (linia2.mid(4,1)=="1"){
                   figuraComposta=true;}
               else figuraComposta=false;
           }
            else figuraComposta=false;

         //El nivell iniciat també carrega les figures del nivell expert
         //(a partir de la versió 4.0)
         if ( ( (linia2.mid(0,1).toInt()<=configuracioJoc->nivellJoc) ||
              configuracioJoc->nivellJoc== NIVELL_INICIAT ) &&
              //les figures "compostes" no son visibles al nivell expert
              !(figuraComposta && configuracioJoc->nivellJoc==NIVELL_EXPERT)  ){
            QTreeWidgetItem *item=new QTreeWidgetItem();
            intPosDarrerPunt=linia0.lastIndexOf(".");
            if (intPosDarrerPunt<=0){intPosDarrerPunt=linia0.length();}
            numFig=controlArxiu->value(linia0.mid(0,intPosDarrerPunt),"1").toInt();
            QString cadena;
          //Només cal fer la traducció dels noms de figura, quan es carrega
          //un arxiu de figures (no de concurs)            
          if(arxiuFigures.fileName().mid(arxiuFigures.fileName().lastIndexOf("."),
                 arxiuFigures.fileName().length())==".fig"){
            //posam espais al principi per a què les cadenes tenguin
            //la mateixa longitud i quedin ben ordenades
            cadena=QString::number(numFig);
            while (cadena.length()<4){cadena=" "+cadena;}
            cadena=configuracioJoc->tradueixCadena(linia0.mid(0,intPosDarrerPunt))+cadena;
             }
            else cadena=linia0;

            //Això per botar-se la traducció
            //cadena=linia0;
            item->setText(0,cadena);
            numFig++;
            controlArxiu->setValue(linia0.mid(0,intPosDarrerPunt),numFig);
            item->setText(1,linia1);
            item->setText(2,linia2);
            //controla si  la figura ja s'ha resolt
            item->setText(3,"0");
            item->setIcon(0,iconeFigura(linia2.mid(2,1).toInt()));
            //miram si la figura ja ha estat resolta
            if (figuraJaResolta(cadena)){
               item->setIcon(0,iconeFigura(4));
               item->setText(3,"1");
            }
           arrel->addChild(item);
         }
         linia0 = entrada.readLine();
     }
arbreFiguresTreeWidget->addTopLevelItem(arrel);
arbreFiguresTreeWidget->sortItems(0,Qt::AscendingOrder);
//arbreFiguresTreeWidget->sortByColumn(0,Qt::AscendingOrder);
arrel->setText(0,configuracioJoc->tradueixCadena(
                                  configuracioJoc->nomNivellArbreFigures.toAscii())
                                  +" ("+QString::number(arrel->childCount()) +")");
arbreFiguresTreeWidget->expandAll();
controlArxiu->clear();
}

/*
  Slots d'eliminació de records
*/
void formulariPrincipal::eliminaRecordSlot(){
    QMessageBox missatgeBox;
        missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.record.pregunta"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
          canviaEstatDelJoc(Inactiu);
          rellotgeLabel->estableixTemps("00:00:00");
          configuracioJoc->temps=rellotgeLabel->retornaTemps(1);
          actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
          eliminaFiguresResoltes(1);
          desaFiguresResoltes();
          carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
        }

    }

void formulariPrincipal::eliminaTotsRecordsSlot(){
QMessageBox missatgeBox;
missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.tots.records.pregunta"));
missatgeBox.setIcon(QMessageBox::Question);
missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
missatgeBox.setDefaultButton(QMessageBox::No);
if(missatgeBox.exec()==QMessageBox::Yes){
    canviaEstatDelJoc(Inactiu);
    rellotgeLabel->estableixTemps("00:00:00");
    configuracioJoc->temps=rellotgeLabel->retornaTemps(1);
    actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
    int registre=configuracioJoc->configArxiu->value("joc/registre",0).toInt();
    QString locale =configuracioJoc->configArxiu->value("joc/idioma",QLocale::system().name().mid(0,2)).toString();
    configuracioJoc->configArxiu->clear();
    configuracioJoc->configArxiu->setValue("joc/tipusTangram", configuracioJoc->tipusTangram);
    configuracioJoc->configArxiu->setValue("joc/nivellJoc", configuracioJoc->nivellJoc);
    configuracioJoc->configArxiu->setValue("joc/registre", registre);
    configuracioJoc->configArxiu->setValue("joc/idioma", locale);
    eliminaFiguresResoltes(0);
    desaFiguresResoltes();
    carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
  }
}


void formulariPrincipal::carregaFiguresProgramaSlot(){
//configuracioJoc->carregaPuntuacio();
configuracioJoc->directoriArxiuDadesFigures=directoriLinux()+
                            charPathSeparator+"figures"+charPathSeparator+configuracioJoc->arxiuDadesFigures;
//configuracioJoc->directoriArxiuDadesFigures=QCoreApplication::applicationDirPath ()+
  //                   charPathSeparator+"figures"+charPathSeparator+configuracioJoc->arxiuDadesFigures;
carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
configuracioJoc->desaRecords=true;
 actualitzaMenus();
}

void formulariPrincipal::carregaFiguresArxiuSlot(){
    configuracioJoc->directoriArxiuDadesFigures = QFileDialog::getOpenFileName(this,
                                 configuracioJoc->tradueixCadena("carrega.arxiu.figures"),
                                 directoriFiguresPersonals(),
                                 configuracioJoc->arxiuDadesFigures);

    if(configuracioJoc->directoriArxiuDadesFigures.isEmpty()){
       carregaFiguresProgramaSlot();
       }
    else{
   carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
   configuracioJoc->desaRecords=false;
   reiniciaContadors();
   conjuntFigura->conjuntVisible(false);
   conjuntMostra->conjuntVisible(false);
   }
 actualitzaMenus();
}

/*
  Slots de creació dels tangrams
*/
void formulariPrincipal::tangramBrugnerSlot(){
    creaTangram(TIPUS_TANGRAM_TB);
}//final formulariPrincipal::tangramBrugnerSlot

void formulariPrincipal::tangram4Slot(){
    creaTangram(TIPUS_TANGRAM_T4);
}//final formulariPrincipal::tangram4Slot

void formulariPrincipal::tangram4IISlot(){
    creaTangram(TIPUS_TANGRAM_T4II);
}//final formulariPrincipal::tangram4IISlot

void formulariPrincipal::tangram5Slot(){
    creaTangram(TIPUS_TANGRAM_T5);
}//final formulariPrincipal::tangram5Slot

void formulariPrincipal::tangramSLSlot(){
    creaTangram(TIPUS_TANGRAM_TSL);
}//final formulariPrincipal::tangramSLSlot Tangram Sam Lloyd

void formulariPrincipal::tangramRegulusSlot(){
    creaTangram(TIPUS_TANGRAM_TREGULUS);
}//final formulariPrincipal::tangramRegulusSlot Regulus

void formulariPrincipal::tangram6Slot(){
    creaTangram(TIPUS_TANGRAM_T6);
}//final formulariPrincipal::tangram6Slot

void formulariPrincipal::tangram6IISlot(){
    creaTangram(TIPUS_TANGRAM_T6II);
}//final formulariPrincipal::tangram6IISlot

void formulariPrincipal::tangramHexagramaSlot(){
    creaTangram(TIPUS_TANGRAM_TH);
}//final formulariPrincipal::tangramHexagramaSlot

void formulariPrincipal::tangramClassicSlot(){
    creaTangram(TIPUS_TANGRAM_T7_CLASSIC);
}//final formulariPrincipal::tangramClassicSlot

void formulariPrincipal::tangram7ISlot(){
    creaTangram(TIPUS_TANGRAM_T7I);
}//final formulariPrincipal::tangram7ISlot

void formulariPrincipal::tangram7IISlot(){
    creaTangram(TIPUS_TANGRAM_T7II);
}//final formulariPrincipal::tangram7IISlot Revathi

void formulariPrincipal::tangramFletcherSlot(){
    creaTangram(TIPUS_TANGRAM_TF);
}//final formulariPrincipal::tangramFletcherSlot

void formulariPrincipal::tangramHEPSlot(){
    creaTangram(TIPUS_TANGRAM_THEP);
}//final formulariPrincipal::tangramHEPSlot Heptex

void formulariPrincipal::tangramXinesSlot(){
    creaTangram(TIPUS_TANGRAM_TX);
}//final formulariPrincipal::tangramFletcherSlot

void formulariPrincipal::tangramSaviesaSlot(){
    creaTangram(TIPUS_TANGRAM_TS);
}//final formulariPrincipal::tangramSaviesaSlot

void formulariPrincipal::tangram8Slot(){
    creaTangram(TIPUS_TANGRAM_T8);
}

void formulariPrincipal::tangramCIISlot(){
    creaTangram(TIPUS_TANGRAM_TCII);
}

void formulariPrincipal::tangram9Slot(){
    creaTangram(TIPUS_TANGRAM_T9);
}

void formulariPrincipal::tangram9TSlot(){
    creaTangram(TIPUS_TANGRAM_T9T);
}
void formulariPrincipal::tangramOuSlot(){
    creaTangram(TIPUS_TANGRAM_TOU);
}

void formulariPrincipal::tangramCorSlot(){
    creaTangram(TIPUS_TANGRAM_COR);
}

void formulariPrincipal::tangram10Slot(){
    creaTangram(TIPUS_TANGRAM_T10);
}

void formulariPrincipal::tangramESlot(){
    creaTangram(TIPUS_TANGRAM_TE);
}

void formulariPrincipal::tangramELSlot(){
    creaTangram(TIPUS_TANGRAM_EL);
}

void formulariPrincipal::tangramCISlot(){
    creaTangram(TIPUS_TANGRAM_TCIRI);
}
void formulariPrincipal::tangram11Slot(){
    creaTangram(TIPUS_TANGRAM_T11);
}

void formulariPrincipal::tangramStomachSlot(){
    creaTangram(TIPUS_TANGRAM_STOMACH);
}

void formulariPrincipal::tangramRusSlot(){
    creaTangram(TIPUS_TANGRAM_TR);
}

void formulariPrincipal::tangram13Slot(){
    creaTangram(TIPUS_TANGRAM_T13);
}

void formulariPrincipal::tangram14Slot(){
    creaTangram(TIPUS_TANGRAM_T14);
}
void formulariPrincipal::tangramStomachionSlot(){
    creaTangram(TIPUS_TANGRAM_STOMACHION);
}
void formulariPrincipal::tangramStomachionIISlot(){
    creaTangram(TIPUS_TANGRAM_STOMACHION_II);
}
//Final dels Slots de creació dels tangrams

void formulariPrincipal::creaTangram(int tipusTangram){
    if (tangramActual !=tipusTangram){
        canviaEstatDelJoc(Inactiu);
        tangramActual=tipusTangram;
        configuracioJoc->canviaTipusTangram(tipusTangram);

        nomFiguraPerCercar.clear();
        indexFiguraPerCercar=0;
        //eliminam les peces actuals
        sceneJoc->clear();
        sceneMostra->clear();


        conjuntJoc= new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntMostra=new ConjuntPeces(tipusTangram,ESCALA_MOSTRA);
        conjuntMostra->conjuntDeMostra();
        conjuntMostra->conjuntVisible(false);
        conjuntFigura=new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntFigura->conjuntDeMostra();
        conjuntFigura->conjuntVisible(false);

       //ara afegim les peces a l'scena
        for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
            conjuntJoc->arrayPeces[i]->setZValue(0);
            conjuntJoc->arrayPeces[i]->estableixAngleGirPeca(configuracioJoc->angleGir);
            sceneJoc->addItem(conjuntJoc->arrayPeces[i]);
            sceneJoc->addItem(conjuntFigura->arrayPeces[i]);
            sceneMostra->addItem(conjuntMostra->arrayPeces[i]);
            }
        //Cal posar això aqui degut a que cal tenir les dades
        //de l'scene!!
        conjuntJoc->colocaPecesAtzar();
        //Carregam l'arbre de figures
        carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
        }
}//final formulariPrincipal::creaTangram(int tipusTangram)

/*
  Slots de nivell de Joc
*/
void formulariPrincipal::nivellInfantilSlot(){
    canviaNivellJoc(NIVELL_INFANTIL);
}
void formulariPrincipal::nivellPrincipiantSlot(){
    canviaNivellJoc(NIVELL_PRINCIPIANT);
}
void formulariPrincipal::nivellIniciatSlot(){
    canviaNivellJoc(NIVELL_INICIAT);
}
void formulariPrincipal::nivellExpertSlot(){
    canviaNivellJoc(NIVELL_EXPERT);
}
//Fa els canvis de nivell de joc
void formulariPrincipal::canviaNivellJoc(int pnivellJoc){
 //només es mouran les peces si el canvi de nivell és
 //cap avall
 bool pecesAtzar=false;
 if (nivellJocActual !=pnivellJoc){
     if (nivellJocActual>pnivellJoc){pecesAtzar=true;}
   canviaEstatDelJoc(Inactiu);
   nivellJocActual=pnivellJoc;
   pecaSeleccionadaNivellInfantil=-1;
   configuracioJoc->canviaNivellJoc(pnivellJoc);
   nomFiguraPerCercar.clear();
   indexFiguraPerCercar=0;
   conjuntMostra->conjuntVisible(false);
   conjuntFigura->conjuntVisible(false);

   /* 4.0.2 21/12/10 Creació de mou procediment
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
       conjuntJoc->arrayPeces[i]->estableixAngleGirPeca(configuracioJoc->angleGir);
       }
       */
   angleGirConjuntPecesJoc();
   if (pecesAtzar) {conjuntJoc->colocaPecesAtzar();}
   carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
  }
}

/*
  Estableix l'angle de gir de les peces del conjunt conjuntJoc
  */
void formulariPrincipal::angleGirConjuntPecesJoc(){
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
       conjuntJoc->arrayPeces[i]->estableixAngleGirPeca(configuracioJoc->angleGir);
       }
}

void formulariPrincipal::actualitzaPuntuacio(int numFig,int afegeixPunts){
configuracioJoc->comptadorFigures=configuracioJoc->comptadorFigures+numFig;
configuracioJoc->comptadorPunts=configuracioJoc->comptadorPunts+afegeixPunts;
numFigures->setText(configuracioJoc->tradueixCadena("Figures")+
                       QString(" %1").arg(configuracioJoc->comptadorFigures ));
punts->setText(configuracioJoc->tradueixCadena("Punts") +
                       QString(" %1").arg(configuracioJoc->comptadorPunts ));
desaContadors();
}

void formulariPrincipal::carregaContadors(){
   //Actualitzam els comptadors amb la puntuació prèvia      
   configuracioJoc->carregaPuntuacio();
   rellotgeLabel->estableixTemps(configuracioJoc->temps);
   numFigures->setText(configuracioJoc->tradueixCadena("Figures")+
                       QString(" %1").arg(configuracioJoc->comptadorFigures ));
   punts->setText(configuracioJoc->tradueixCadena("Punts") +
                  QString(" %1").arg(configuracioJoc->comptadorPunts ));
}

void formulariPrincipal::desaContadors(){
  configuracioJoc->desaPuntuacio(rellotgeLabel->retornaTemps(1));
}

void formulariPrincipal::reiniciaContadors(){
    actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
    rellotgeLabel->estableixTemps("00:00:00");
}

 void formulariPrincipal::closeEvent(QCloseEvent *event){
   desaContadors();
   desaFiguresResoltes();
   event->accept();
 }

void formulariPrincipal::carregaFiguresResoltes(){
QString nomArxiu=nomArxiuFiguresResoltes();
QDir dirArxiu;
 if (dirArxiu.exists(nomArxiu)){
     QFile arxiu(nomArxiu);
     if (arxiu.open(QFile::ReadOnly | QFile::Text)){
        QTextStream lectura(&arxiu);
        QString linia0 = lectura.readLine();
        while (!linia0.isNull()) {
            figuresResoltesList->append(linia0);
            linia0 = lectura.readLine();
     }
     }
 }
figuresResoltesList->sort();
}

void formulariPrincipal::desaFiguresResoltes(){
QString nomArxiu=nomArxiuFiguresResoltes();
QDir dirArxiu;
 if (dirArxiu.exists(nomArxiu)){
    dirArxiu.remove(nomArxiu);
}

if (figuresResoltesList->size()<1){
    return;
}
     QFile arxiu(nomArxiu);
     if (arxiu.open(QFile::WriteOnly | QFile::Text)){
     QTextStream entrada(&arxiu);
        for(int i=0;i<=figuresResoltesList->size()-1;i++){
            entrada<<(QString("%1\n").arg(figuresResoltesList->value(i)));
     }
  arxiu.close();
   }
 }

void formulariPrincipal::eliminaFiguresResoltes(int tipus){
    switch(tipus){
        //elimina tot
        case 0:
          figuresResoltesList->clear();
        break;
        //nomès elimina les corresponents al tipusTangram i nivell actual
        case 1:
            QString nom=QString("%1;%2;").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc);
            QRegExp reg(nom+"*",Qt::CaseSensitive,QRegExp::Wildcard);
            while (figuresResoltesList->indexOf(reg)>-1){
                figuresResoltesList->removeAt(figuresResoltesList->indexOf(reg));
            }
        break;
    }
}

//Comprova si el nom de la figura passada per paràmetre
//està a la llista de figures resoltes
bool formulariPrincipal::figuraJaResolta(QString nomFigura){
 QString nom=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).arg(nomFigura);
 //return (figuresResoltesList->indexOf(nom)>-1);
 /*4.0.2
 Canviat degut a que s'ha afegit les dades de la posició de les peces
 Ara no es pot fer servir el caràcter ? en el nom de les figures
 */
 QRegExp rx(nom+"*");
 rx.setPatternSyntax(QRegExp::Wildcard);
 return (figuresResoltesList->indexOf(rx)>-1);
//return (figuresResoltesList->contains(nom));
}

//Comprova si el nom de la figura passada per paràmetre
//ja està resolta i, en cas positiu, retorna
//la cadena amb la posició de les peces
QString formulariPrincipal::figuraJaResoltaPosicioPeces(QString nomFigura){
    if (figuraJaResolta(nomFigura)){
    QString nom=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).arg(nomFigura);
    QRegExp rx(nom+";*");
    rx.setPatternSyntax(QRegExp::Wildcard);
    QString dadesFigura=figuresResoltesList->value(figuresResoltesList->indexOf(rx));
    QStringList dadesFiguraList=dadesFigura.split(";");
    //qCritical("nom %s ", qPrintable(nom));
    //qCritical("dades %s ", qPrintable(dadesFiguraList.value(3)));
    return dadesFiguraList.value(3);
    }
 return QString("");
}

QString formulariPrincipal::nomArxiuFiguresResoltes(){
    QString directoriHomeConfig = QFileInfo(
            configuracioJoc->configArxiu->fileName()).absolutePath();
    QString nomArxiu=directoriHomeConfig+
                     charPathSeparator+"figres.fig";
return nomArxiu;
}

/*
  Ajuda per resoldre les figures
*/
void formulariPrincipal::mostraSolucioSlot(){
 canviaEstatDelJoc(MostraSolucio);
}

void formulariPrincipal::colocaPecaSlot(){
    configuracioJoc->colocaPeca=!configuracioJoc->colocaPeca;
    colocaPecaAction->setChecked(configuracioJoc->colocaPeca);
}


void formulariPrincipal::colocaPeca(int indexPecaAColocar){
 for(int i=0;i<=conjuntFigura->arrayPeces.size()-1;i++){
     if (conjuntJoc->arrayPeces[indexPecaAColocar]->tipusPeca==
         conjuntFigura->arrayPeces[i]->tipusPeca){
         if(!pecaJaColocada(i)){
             colocaPeca(indexPecaAColocar,i);
             break;
         }
     }
  }
}

/*
  En el nivell infantil, si es col·loca el centre de la peça dins
  de la silueta, llavors el programa col·loca automàticament
  la peça a la seva posició
  */
bool formulariPrincipal::colocaPecaNivellInfantil(int indexPeca){
QPointF centrePeca=conjuntJoc->arrayPeces[indexPeca]->pos()+
                   conjuntJoc->arrayPeces[indexPeca]->centrePeca();
bool resultat= false;
for(int j=0;j<=conjuntFigura->arrayPeces.size()-1;j++){
   if(conjuntFigura->arrayPeces[j]->shape().contains(centrePeca-
                                                     conjuntFigura->arrayPeces[j]->pos())){
       resultat= true;
    }
}
return resultat;
}
/*
  Comprovam si en el conjuntJoc ja hi ha una peça que te les
  mateixes propietats que la peça que volem col·locar
  */
bool formulariPrincipal::pecaJaColocada(int indexPecaAColocar){
bool resultat=false;
 QVector<QPointF> pSolucio;
    conjuntFigura->arrayPeces[indexPecaAColocar]->puntsSolucio(pSolucio,0.9);

int coincidencies=0;
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
      for(int j=0;j<=pSolucio.size()-1;j++){
      if(conjuntJoc->arrayPeces[i]->shape().contains(
         pSolucio.value(j)-conjuntJoc->arrayPeces[i]->pos())){
            coincidencies=coincidencies+1;
        }
     }
     if (coincidencies>=pSolucio.size()-1){
       resultat=true;
       break;
     }
     else coincidencies=0;
   }

/* Aquest sistema falla alguna vegada!!!
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
     if(conjuntJoc->arrayPeces[i]->cadenaPropietatsPeca(conjuntJoc->vertexSuperiorEsquerra())
      ==conjuntFigura->arrayPeces[indexPecaAColocar]->cadenaPropietatsPeca(conjuntFigura->vertexSuperiorEsquerra())){
       resultat=true;
       break;
     }
   }
   */
return resultat;
}

void formulariPrincipal::colocaPeca(int indexPecaAColocar,int pecaFigura){
/*
 conjuntJoc->colocaPeca(conjuntFigura->arrayPeces[pecaFigura]->cadenaPropietatsPeca(
                       conjuntFigura->vertexSuperiorEsquerra()),indexPecaAColocar,
                        conjuntFigura->vertexSuperiorEsquerra());
*/
conjuntJoc->arrayPeces[indexPecaAColocar]->reiniciaAnglesVertex(
        conjuntJoc->arrayPeces[indexPecaAColocar]->tipusPeca);

 if(!conjuntJoc->arrayPeces[indexPecaAColocar]->simetriaBool==
   conjuntFigura->arrayPeces[pecaFigura]->simetriaBool){
    conjuntJoc->arrayPeces[indexPecaAColocar]->simetriaPeca();
   }
 conjuntJoc->arrayPeces[indexPecaAColocar]->setPos(
      conjuntFigura->arrayPeces[pecaFigura]->pos());
  conjuntJoc->arrayPeces[indexPecaAColocar]->setAngleRotacio(
      conjuntFigura->arrayPeces[pecaFigura]->anglesVertex[0]-
      conjuntFigura->arrayPeces[pecaFigura]->angleInicial);

conjuntJoc->arrayPeces[indexPecaAColocar]->setSelected(false);
}

/*
Creació de noves figures
*/
void formulariPrincipal::comprovaMostraSlot(){
    conjuntFigura->colocaPeces(conjuntJoc->coordenadesFigura());
    //colocam el conjunt al vertex sup.esq per a què es vegi millor
    //(enlloc de centrat);
    conjuntFigura->recolocaPeces(QPointF(50,50));
    conjuntFigura->conjuntVisible(true);
    conjuntFigura->conjuntDeMostra();
    conjuntMostra->colocaPeces(conjuntJoc->coordenadesFigura());
    conjuntMostra->conjuntVisible(true);
    conjuntMostra->conjuntDeMostra();
    sceneJoc->update();
}

void formulariPrincipal::esborraMostraSlot(){
    conjuntFigura->conjuntVisible(false);
    conjuntMostra->conjuntVisible(false);
    missatgeStatusBar("");
}
void formulariPrincipal::desaFiguraSlot(){
     DesaFigura desaFiguraFormulari(configuracioJoc,this);
     //passam les dades de la figura al formulari
     desaFiguraFormulari.dadesFigura.append(conjuntJoc->coordenadesFigura());
     desaFiguraFormulari.exec();
}
void formulariPrincipal::simetriaVerticalSlot(){
    conjuntJoc->simetriaVertical();
}
void formulariPrincipal::simetriaHoritzontalSlot(){
    conjuntJoc->simetriaHoritzontal();
}
void formulariPrincipal::cercaFiguraSlot(){
 if (arbreFiguresTreeWidget->topLevelItem(0)==0){ return;}

    QProgressDialog progres(
            configuracioJoc->tradueixCadena("Cercant.figura")+"...",
            configuracioJoc->tradueixCadena("Atura.cerca"), 0,
            arbreFiguresTreeWidget->topLevelItem(0)->childCount(), this);

   progres.setWindowModality(Qt::WindowModal);

//QApplication::setOverrideCursor(Qt::WaitCursor);
missatgeStatusBar("");
float resultat;
figuresSemblantsList->clear();
    conjuntJoc->centraFiguraScene();
    conjuntFigura->conjuntDeMostra();
    conjuntFigura->conjuntVisible(true);
    for(int i=0;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
      //el formulari genera un missatge d'error
      //a la consola (comunicat a Qt)
      progres.setValue(i+1);
      conjuntFigura->colocaPeces(arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(1));
      //això per evitar que quedin "rastres"
      sceneJoc->update();
      resultat=figuraSolucionada();
      if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
          afegeixFiguraSemblant(resultat,i);
      }
      else {
          conjuntFigura->simetriaHoritzontal();
          //això per evitar que quedin "rastres"
          sceneJoc->update();
          resultat=figuraSolucionada();
          if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
              afegeixFiguraSemblant(resultat,i);
          }
          else {
              conjuntFigura->simetriaVertical();
             //això per evitar que quedin "rastres"
             sceneJoc->update();
              resultat=figuraSolucionada();
              if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                  afegeixFiguraSemblant(resultat,i);
              }
              else {
                  conjuntFigura->simetriaHoritzontal();
                 //això per evitar que quedin "rastres"
                 sceneJoc->update();
                  resultat=figuraSolucionada();
                  if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                    //Aquesta linea fa que algunes vegades, la cerca s'aturi abans d'acabar
                    //  if (arbreFiguresTreeWidget->headerItem()->childCount()<1){ return;}
                      afegeixFiguraSemblant(resultat,i);
                  }
              }
          }
      }
      /*
      if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
          afegeixFiguraSemblant(resultat,i);
      }      
      else {
          conjuntFigura->simetriaHoritzontal();
          resultat=figuraSolucionada();
          if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                afegeixFiguraSemblant(resultat,i);
          }
          else {
          conjuntFigura->simetriaVertical();
          resultat=figuraSolucionada();
              if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                    afegeixFiguraSemblant(resultat,i);
              }
              else {
              conjuntFigura->simetriaHoritzontal();
              resultat=figuraSolucionada();
              if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                    {if (arbreFiguresTreeWidget->headerItem()->childCount()<1){ return;}
                    afegeixFiguraSemblant(resultat,i);
                 }
                }
            }
        }
    }
      */
  if (progres.wasCanceled())  break;
  }//for
//Això és innecessari
//  progres.setValue(arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1);

//QApplication::setOverrideCursor(Qt::ArrowCursor);

sceneJoc->update();
if (figuresSemblantsList->size()>0){
    indexLlistaFiguraSemblant=0;
    figuresSemblantsList->sort();
    figuraSeguentAction->setEnabled(true);
    figuraAnteriorAction->setEnabled(true);
    mostraFiguraSemblant(0);
QMessageBox::information(this, configuracioJoc->tradueixCadena("Cerca.figura"),
                    configuracioJoc->tradueixCadena("msg.FiguraTrobada").arg(figuresSemblantsList->size()));
}
else {conjuntFigura->conjuntVisible(false);
QMessageBox::information(this, configuracioJoc->tradueixCadena("Cerca.figura"),
                    configuracioJoc->tradueixCadena("msg.FiguraNoTrobada"));
}

}


//Afegeix a la llista de figures semblants (creació de figures)
//les dades d'una figura
void formulariPrincipal::afegeixFiguraSemblant(float percentatge,int index){
    QString Missatge;
    Missatge.append(QString("%1;").arg(100-percentatge));
    Missatge.append(QString(arbreFiguresTreeWidget->topLevelItem(0)->child(index)->text(0)));
    Missatge.append(QString(" "));
    Missatge.append(QString("( %1 % ) ;").arg(percentatge));
    Missatge.append(arbreFiguresTreeWidget->topLevelItem(0)->child(index)->text(1));
    figuresSemblantsList->append(Missatge);
}

void formulariPrincipal::figuraSeguentSlot(){
  if (indexLlistaFiguraSemblant<figuresSemblantsList->size()-1){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant+1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);      
      //això per evitar que quedin "rastres"
      sceneJoc->update();
  }
}
void formulariPrincipal::figuraAnteriorSlot(){
  if (indexLlistaFiguraSemblant>0){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant-1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);
      //això per evitar que quedin "rastres"
      sceneJoc->update();
  }
}

void formulariPrincipal::mostraFiguraSemblant(int index){
if (index>-1 && index<=figuresSemblantsList->size()-1) {
  QStringList list1 = figuresSemblantsList->value(index).split(";");
  conjuntFigura->colocaPeces(list1.value(2));
  //colocam el conjunt al vertex sup.esq per a què es vegi millor
  //(enlloc de centrat);
  conjuntFigura->recolocaPeces(QPointF(10,10));
  conjuntFigura->colorPecesConjunt(Qt::black);
  conjuntFigura->conjuntVisible(true);
  missatgeStatusBar(list1.value(1));
 }
}

/*
 Gestió de concurs
*/
void formulariPrincipal::creaConcursSlot(){
CreaConcurs concurs(configuracioJoc,this);
concurs.exec();
}

void formulariPrincipal::carregaConcursSlot(){

QString directoriSeleccionat = QFileDialog::getOpenFileName(this,
                                 configuracioJoc->tradueixCadena("Carrega.concurs"),
                                 directoriFiguresPersonals(),
                                 filtreArxiusConcurs(configuracioJoc) );
    if(!directoriSeleccionat.isEmpty()){
        carregaArbreFigures(directoriSeleccionat);
        canviaEstatDelJoc(Inactiu);        
        configuracioJoc->desaRecords=false;
        reiniciaContadors();
    }
}


void formulariPrincipal::tradueixGUI(){
   setWindowTitle("Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")");

   surtAction->setText(configuracioJoc->tradueixCadena("&Surt")) ;

   elimnaRecordAction->setText(configuracioJoc->tradueixCadena("Elimina.record"));
   eliminaTotsRecordsAction->setText(configuracioJoc->tradueixCadena("Elimina.tots.records"));

    carregaFiguresProgramaAction->setText(configuracioJoc->tradueixCadena("carrega.figures.paquet"));
    carregaFiguresArxiuAction->setText(configuracioJoc->tradueixCadena("carrega.dades.figures.arxiu"));

   mostraSolucioAction->setText(configuracioJoc->tradueixCadena("Mostra.solucio"));
   colocaPecaAction->setText(configuracioJoc->tradueixCadena("Coloca.peca"));

   tangramBrugnerAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_B));
   tangram4Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_4));
   tangram4IIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_4II));
   tangram5Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_5));
   tangramSLAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_SL));
   tangramRegulusAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_REGULUS));
   tangram6Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_6));
   tangram6IIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_6II));
    tangramHexagramaAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_H));
    tangramClassicAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7));
    tangram7IAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7I));
    tangram7IIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7II));
    tangramFletcherAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_F));
    tangramHEPAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_HEP));
    tangramXinesAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_X));
    tangramSaviesaAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_S));
    tangram8Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_8));
    tangramCIIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_CII));
    tangram9Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_9));
    tangram9TAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_9T));
    tangramOuAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_OU));
    tangramCorAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_COR));
    tangram10Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_10));
    tangramEAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_E));
    tangramELAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_EL));
    tangramCIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_CIRI));
    tangram11Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_11));
    tangramRusAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_R));
    tangram13Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_13));
    tangram14Action->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_14));
    tangramStomachAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACH));
    tangramStomachionAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACHION));
    tangramStomachionIIAction->setText(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACHION_II));

    nivellInfantilAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_INFANTIL));
    nivellPrincipiantAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_PRINCIPIANT));
    nivellIniciatAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_INICIAT));
    nivellExpertAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_EXPERT));

    creaFiguraMenu->setTitle(configuracioJoc->tradueixCadena("crea.nova.figura"));
    comprovaMostraAction->setText(configuracioJoc->tradueixCadena("comprova.mostra"));
    esborraMostraAction->setText(configuracioJoc->tradueixCadena("esborra.mostra"));
    desaFiguraAction->setText(configuracioJoc->tradueixCadena("desa.dades.figura"));
    simetriaVerticalAction->setText(configuracioJoc->tradueixCadena("Simetria.vertical"));
    simetriaHoritzontalAction->setText(configuracioJoc->tradueixCadena("Simetria.horitzontal"));
    cercaFiguraAction->setText(configuracioJoc->tradueixCadena("Cerca.figura"));    
    figuraSeguentAction->setText(configuracioJoc->tradueixCadena("seguent.figura"));
    figuraAnteriorAction->setText(configuracioJoc->tradueixCadena("anterior.figura"));






    aplicacioMenu->setTitle(configuracioJoc->tradueixCadena("Programa"));

    jocMenu->setTitle(configuracioJoc->tradueixCadena("Joc"));
    jocsTangramMenu->setTitle(configuracioJoc->tradueixCadena("Jocs.tangram"));

    proposaFigura->setText(configuracioJoc->tradueixCadena("Proposa.figura"));


    cercaNomFigura->setText(configuracioJoc->tradueixCadena("cerca.nom.figura"));
    continuaCercaNomFigura->setText(configuracioJoc->tradueixCadena("continua.cerca.nom.figura"));

    //Concurs
    concursMenu->setTitle(configuracioJoc->tradueixCadena("Concurs"));
    creaConcursAction->setText(configuracioJoc->tradueixCadena("Crea.concurs"));
    carregaConcursAction->setText(configuracioJoc->tradueixCadena("Carrega.concurs"));;

    idiomaMenu->setTitle(configuracioJoc->tradueixCadena("idioma"));
    /*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
    localeSistema->setText(configuracioJoc->tradueixCadena("idioma.sistema"));
    localeCatala->setText(configuracioJoc->tradueixCadena("Catala"));
    localeCastella->setText(configuracioJoc->tradueixCadena("Castellano"));
    localeGalleg->setText(configuracioJoc->tradueixCadena("Galego"));
    localeEuskera->setText(configuracioJoc->tradueixCadena("Euskera"));
    localePortugues->setText(configuracioJoc->tradueixCadena("Portugues"));
    localeFrances->setText(configuracioJoc->tradueixCadena("Frances"));
    localeItalia->setText(configuracioJoc->tradueixCadena("Italia"));
    localeAlemany->setText(configuracioJoc->tradueixCadena("Alemany"));
    localeAngles->setText(configuracioJoc->tradueixCadena("Angles"));
    */

ajudaMenu->setTitle(configuracioJoc->tradueixCadena("Ajuda"));
    ajuda->setText(configuracioJoc->tradueixCadena("Ajuda"));
    webPrograma->setText(configuracioJoc->tradueixCadena("Web.programa"));
    creditsPrograma->setText(configuracioJoc->tradueixCadena("Credits"));
    colaboraPrograma->setText(configuracioJoc->tradueixCadena("Colabora"));


    actualitzaPuntuacio(0,0);
    carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
}


void formulariPrincipal::creaAcccions()
{
    surtAction = new QAction(configuracioJoc->tradueixCadena("&Surt"), this);
    surtAction->setShortcut(tr("Ctrl+S"));
    surtAction->setIcon(QIcon(":/images/quit.png"));
    connect(surtAction, SIGNAL(triggered()), this, SLOT(close()));

    elimnaRecordAction= new QAction(configuracioJoc->tradueixCadena("Elimina.record"), this);
    connect(elimnaRecordAction, SIGNAL(triggered()), this, SLOT(eliminaRecordSlot()));

    eliminaTotsRecordsAction= new QAction(configuracioJoc->tradueixCadena("Elimina.tots.records"), this);
    connect(eliminaTotsRecordsAction, SIGNAL(triggered()), this, SLOT(eliminaTotsRecordsSlot()));

    carregaFiguresProgramaAction= new QAction(configuracioJoc->tradueixCadena("carrega.figures.paquet"), this);
    connect(carregaFiguresProgramaAction, SIGNAL(triggered()), this, SLOT(carregaFiguresProgramaSlot()));

    carregaFiguresArxiuAction= new QAction(configuracioJoc->tradueixCadena("carrega.dades.figures.arxiu"), this);
    connect(carregaFiguresArxiuAction, SIGNAL(triggered()), this, SLOT(carregaFiguresArxiuSlot()));

    mostraSolucioAction= new QAction(configuracioJoc->tradueixCadena("Mostra.solucio"), this);
    mostraSolucioAction->setIcon(QIcon(":/images/solucio.png"));
    connect(mostraSolucioAction, SIGNAL(triggered()), this, SLOT(mostraSolucioSlot()));


    colocaPecaAction= new QAction(configuracioJoc->tradueixCadena("Coloca.peca"), this);
    colocaPecaAction->setCheckable(true);
    connect(colocaPecaAction, SIGNAL(triggered()), this, SLOT(colocaPecaSlot()));

    proposaFigura= new QAction(configuracioJoc->tradueixCadena("Proposa.figura"), this);
    proposaFigura->setShortcut(tr("Ctrl+P"));
    connect(proposaFigura, SIGNAL(triggered()), this, SLOT(proposaFiguraSlot()));


    cercaNomFigura= new QAction(configuracioJoc->tradueixCadena("cerca.nom.figura"), this);
    cercaNomFigura->setShortcut(tr("Ctrl+N"));
    connect(cercaNomFigura, SIGNAL(triggered()), this, SLOT(cercaNomFiguraSlot()));

    continuaCercaNomFigura= new QAction(configuracioJoc->tradueixCadena("continua.cerca.nom.figura"), this);
    continuaCercaNomFigura->setShortcut(tr("F3"));
    connect(continuaCercaNomFigura, SIGNAL(triggered()), this, SLOT(continuaCercaNomFiguraSlot()));
    continuaCercaNomFigura->setEnabled(false);


    /*
      Accions que crean els tangrams
      */
    tangramBrugnerAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_B), this);
    tangramBrugnerAction->setIcon(QIcon(":/images/"+TB_ICONE));
    connect(tangramBrugnerAction, SIGNAL(triggered()), this, SLOT(tangramBrugnerSlot()));

    tangram4Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_4), this);
    tangram4Action->setIcon(QIcon(":/images/"+T4_ICONE));
    connect(tangram4Action, SIGNAL(triggered()), this, SLOT(tangram4Slot()));

    tangram4IIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_4II), this);
    tangram4IIAction->setIcon(QIcon(":/images/"+T4II_ICONE));
    connect(tangram4IIAction, SIGNAL(triggered()), this, SLOT(tangram4IISlot()));

    tangram5Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_5), this);
    tangram5Action->setIcon(QIcon(":/images/"+T5_ICONE));
    connect(tangram5Action, SIGNAL(triggered()), this, SLOT(tangram5Slot()));

    tangramSLAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_SL), this);
    tangramSLAction->setIcon(QIcon(":/images/"+TSL_ICONE));
    connect(tangramSLAction, SIGNAL(triggered()), this, SLOT(tangramSLSlot()));

    tangramRegulusAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_REGULUS), this);
    tangramRegulusAction->setIcon(QIcon(":/images/" + TREG_ICONE));
    connect(tangramRegulusAction, SIGNAL(triggered()), this, SLOT(tangramRegulusSlot()));

    tangram6Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_6), this);
    tangram6Action->setIcon(QIcon(":/images/"+T6_ICONE));
    connect(tangram6Action, SIGNAL(triggered()), this, SLOT(tangram6Slot()));

    tangram6IIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_6II), this);
    tangram6IIAction->setIcon(QIcon(":/images/"+T6II_ICONE));
    connect(tangram6IIAction, SIGNAL(triggered()), this, SLOT(tangram6IISlot()));

    tangramHexagramaAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_H), this);
    tangramHexagramaAction->setIcon(QIcon(":/images/"+TH_ICONE));
    connect(tangramHexagramaAction, SIGNAL(triggered()), this, SLOT(tangramHexagramaSlot()));

    tangramClassicAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7), this);
    tangramClassicAction->setIcon(QIcon(":/images/" + T7_ICONE));
    connect(tangramClassicAction, SIGNAL(triggered()), this, SLOT(tangramClassicSlot()));

    tangram7IAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7I), this);
    tangram7IAction->setIcon(QIcon(":/images/" + T7I_ICONE));
    connect(tangram7IAction, SIGNAL(triggered()), this, SLOT(tangram7ISlot()));

    tangram7IIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_7II), this);
    tangram7IIAction->setIcon(QIcon(":/images/" + T7II_ICONE));
    connect(tangram7IIAction, SIGNAL(triggered()), this, SLOT(tangram7IISlot()));

    tangramFletcherAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_F), this);
    tangramFletcherAction->setIcon(QIcon(":/images/"+TF_ICONE));
    connect(tangramFletcherAction, SIGNAL(triggered()), this, SLOT(tangramFletcherSlot()));

    tangramHEPAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_HEP), this);
    tangramHEPAction->setIcon(QIcon(":/images/"+THEP_ICONE));
    connect(tangramHEPAction, SIGNAL(triggered()), this, SLOT(tangramHEPSlot()));

    tangramXinesAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_X), this);
    tangramXinesAction->setIcon(QIcon(":/images/"+TX_ICONE));
    connect(tangramXinesAction, SIGNAL(triggered()), this, SLOT(tangramXinesSlot()));

    tangramSaviesaAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_S), this);
    tangramSaviesaAction->setIcon(QIcon(":/images/"+TS_ICONE));
    connect(tangramSaviesaAction, SIGNAL(triggered()), this, SLOT(tangramSaviesaSlot()));

    tangram8Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_8), this);
    tangram8Action->setIcon(QIcon(":/images/"+T8_ICONE));
    connect(tangram8Action, SIGNAL(triggered()), this, SLOT(tangram8Slot()));

    tangramCIIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_CII), this);
    tangramCIIAction->setIcon(QIcon(":/images/"+TCII_ICONE));
    connect(tangramCIIAction, SIGNAL(triggered()), this, SLOT(tangramCIISlot()));

    tangram9Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_9), this);
    tangram9Action->setIcon(QIcon(":/images/"+T9_ICONE));
    connect(tangram9Action, SIGNAL(triggered()), this, SLOT(tangram9Slot()));

    tangram9TAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_9T), this);
    tangram9TAction->setIcon(QIcon(":/images/"+T9T_ICONE));
    connect(tangram9TAction, SIGNAL(triggered()), this, SLOT(tangram9TSlot()));

    tangramOuAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_OU), this);
    tangramOuAction->setIcon(QIcon(":/images/"+TOU_ICONE));
    connect(tangramOuAction, SIGNAL(triggered()), this, SLOT(tangramOuSlot()));

    tangramCorAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_COR), this);
    tangramCorAction->setIcon(QIcon(":/images/"+TCOR_ICONE));
    connect(tangramCorAction, SIGNAL(triggered()), this, SLOT(tangramCorSlot()));

    tangram10Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_10), this);
    tangram10Action->setIcon(QIcon(":/images/"+T10_ICONE));
    connect(tangram10Action, SIGNAL(triggered()), this, SLOT(tangram10Slot()));

    tangramEAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_E), this);
    tangramEAction->setIcon(QIcon(":/images/"+TE_ICONE));
    connect(tangramEAction, SIGNAL(triggered()), this, SLOT(tangramESlot()));

    tangramELAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_EL), this);
    tangramELAction->setIcon(QIcon(":/images/"+EL_ICONE));
    connect(tangramELAction, SIGNAL(triggered()), this, SLOT(tangramELSlot()));

    tangramCIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_CIRI), this);
    tangramCIAction->setIcon(QIcon(":/images/"+TCIRI_ICONE));
    connect(tangramCIAction, SIGNAL(triggered()), this, SLOT(tangramCISlot()));

    tangram11Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_11), this);
    tangram11Action->setIcon(QIcon(":/images/"+T11_ICONE));
    connect(tangram11Action, SIGNAL(triggered()), this, SLOT(tangram11Slot()));

    tangramRusAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_R), this);
    tangramRusAction->setIcon(QIcon(":/images/"+TR_ICONE));
    connect(tangramRusAction, SIGNAL(triggered()), this, SLOT(tangramRusSlot()));

    tangram13Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_13), this);
    tangram13Action->setIcon(QIcon(":/images/"+T13_ICONE));
    connect(tangram13Action, SIGNAL(triggered()), this, SLOT(tangram13Slot()));

    tangram14Action = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_14), this);
    tangram14Action->setIcon(QIcon(":/images/"+T14_ICONE));
    connect(tangram14Action, SIGNAL(triggered()), this, SLOT(tangram14Slot()));

    tangramStomachAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACH), this);
    tangramStomachAction->setIcon(QIcon(":/images/"+TSTIII_ICONE));
    connect(tangramStomachAction, SIGNAL(triggered()), this, SLOT(tangramStomachSlot()));

    tangramStomachionAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACHION), this);
    tangramStomachionAction->setIcon(QIcon(":/images/"+TST_ICONE));
    connect(tangramStomachionAction, SIGNAL(triggered()), this, SLOT(tangramStomachionSlot()));

    tangramStomachionIIAction = new QAction(configuracioJoc->tradueixCadena(ARBRE_FIGURES_TANGRAM_STOMACHION_II), this);
    tangramStomachionIIAction->setIcon(QIcon(":/images/"+TSTII_ICONE));
    connect(tangramStomachionIIAction, SIGNAL(triggered()), this, SLOT(tangramStomachionIISlot()));

    //final de les accions de creació de tangrams

    /*
      Nivell del Joc
    */
    nivellJocGroup = new QActionGroup(this);

    nivellInfantilAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_INFANTIL), this);
    nivellInfantilAction->setCheckable(true);
    nivellInfantilAction->setActionGroup(nivellJocGroup);
    nivellInfantilAction->setIcon(QIcon(":/images/nivellInfantil.png"));
    nivellInfantilAction->setShortcut(tr("Alt+1"));
    connect(nivellInfantilAction, SIGNAL(triggered()), this, SLOT(nivellInfantilSlot()));

    nivellPrincipiantAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_PRINCIPIANT), this);
    nivellPrincipiantAction->setCheckable(true);
    nivellPrincipiantAction->setActionGroup(nivellJocGroup);
    nivellPrincipiantAction->setIcon(QIcon(":/images/nivellPrincipiant.png"));
    nivellPrincipiantAction->setShortcut(tr("Alt+2"));
    connect(nivellPrincipiantAction, SIGNAL(triggered()), this, SLOT(nivellPrincipiantSlot()));

    nivellIniciatAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_INICIAT), this);
    nivellIniciatAction->setCheckable(true);
    nivellIniciatAction->setActionGroup(nivellJocGroup);
    nivellIniciatAction->setIcon(QIcon(":/images/nivellIniciat.png"));
    nivellIniciatAction->setShortcut(tr("Alt+3"));
    connect(nivellIniciatAction, SIGNAL(triggered()), this, SLOT(nivellIniciatSlot()));

    nivellExpertAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_EXPERT), this);
    nivellExpertAction->setCheckable(true);
    nivellExpertAction->setActionGroup(nivellJocGroup);
    nivellExpertAction->setIcon(QIcon(":/images/nivellExpert.png"));
    nivellExpertAction->setShortcut(tr("Alt+4"));
    connect(nivellExpertAction, SIGNAL(triggered()), this, SLOT(nivellExpertSlot()));

    nivellInfantilAction->setChecked(true);

    comprovaMostraAction = new QAction(configuracioJoc->tradueixCadena("comprova.mostra"), this);
    comprovaMostraAction->setShortcut(Qt::CTRL + Qt::Key_M);
    connect(comprovaMostraAction, SIGNAL(triggered()), this, SLOT(comprovaMostraSlot()));

    esborraMostraAction = new QAction(configuracioJoc->tradueixCadena("esborra.mostra"), this);
    esborraMostraAction->setShortcut(Qt::CTRL + Qt::Key_E);
    connect(esborraMostraAction, SIGNAL(triggered()), this, SLOT(esborraMostraSlot()));

    desaFiguraAction = new QAction(configuracioJoc->tradueixCadena("desa.dades.figura"), this);
    desaFiguraAction->setShortcut(Qt::CTRL + Qt::Key_D);
    connect(desaFiguraAction, SIGNAL(triggered()), this, SLOT(desaFiguraSlot()));

    simetriaVerticalAction = new QAction(configuracioJoc->tradueixCadena("Simetria.vertical"), this);
    simetriaVerticalAction->setShortcut(Qt::CTRL + Qt::Key_V);
    connect(simetriaVerticalAction, SIGNAL(triggered()), this, SLOT(simetriaVerticalSlot()));

    simetriaHoritzontalAction = new QAction(configuracioJoc->tradueixCadena("Simetria.horitzontal"), this);
    simetriaHoritzontalAction->setShortcut(Qt::CTRL + Qt::Key_H);
    connect(simetriaHoritzontalAction, SIGNAL(triggered()), this, SLOT(simetriaHoritzontalSlot()));

    cercaFiguraAction = new QAction(configuracioJoc->tradueixCadena("Cerca.figura"), this);
    cercaFiguraAction->setShortcut(Qt::CTRL + Qt::Key_F);
    connect(cercaFiguraAction, SIGNAL(triggered()), this, SLOT(cercaFiguraSlot()));


    figuraSeguentAction = new QAction(configuracioJoc->tradueixCadena("seguent.figura"), this);
    figuraSeguentAction->setShortcut(QKeySequence::MoveToNextPage);
    figuraSeguentAction->setEnabled(false);
    connect(figuraSeguentAction, SIGNAL(triggered()), this, SLOT(figuraSeguentSlot()));

    figuraAnteriorAction = new QAction(configuracioJoc->tradueixCadena("anterior.figura"), this);
    figuraAnteriorAction->setShortcut(QKeySequence::MoveToPreviousPage);
    figuraAnteriorAction->setEnabled(false);
    connect(figuraAnteriorAction, SIGNAL(triggered()), this, SLOT(figuraAnteriorSlot()));

    /* Creació de concurs */
    creaConcursAction = new QAction(configuracioJoc->tradueixCadena("Crea.concurs"), this);
    connect(creaConcursAction, SIGNAL(triggered()), this, SLOT(creaConcursSlot()));

    carregaConcursAction = new QAction(configuracioJoc->tradueixCadena("Carrega.concurs"), this);
    connect(carregaConcursAction, SIGNAL(triggered()), this, SLOT(carregaConcursSlot()));

//Idiomes
    /*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
    localeSistema = new QAction(configuracioJoc->tradueixCadena("idioma.sistema"), this);
    connect(localeSistema, SIGNAL(triggered()), this, SLOT(localeSistemaSlot()));

    localeCatala = new QAction(configuracioJoc->tradueixCadena("Catala"), this);
    connect(localeCatala, SIGNAL(triggered()), this, SLOT(localeCatalaSlot()));

    localeCastella = new QAction(configuracioJoc->tradueixCadena("Castellano"), this);
    connect(localeCastella, SIGNAL(triggered()), this, SLOT(localeCastellaSlot()));    

    localeGalleg = new QAction(configuracioJoc->tradueixCadena("Galego"), this);
    connect(localeGalleg, SIGNAL(triggered()), this, SLOT(localeGallegSlot()));

    localeEuskera = new QAction(configuracioJoc->tradueixCadena("Euskera"), this);
    connect(localeEuskera, SIGNAL(triggered()), this, SLOT(localeEuskeraSlot()));

    localePortugues = new QAction(configuracioJoc->tradueixCadena("Portugues"), this);
    connect(localePortugues, SIGNAL(triggered()), this, SLOT(localePortuguesSlot()));

    localeFrances = new QAction(configuracioJoc->tradueixCadena("Frances"), this);
    connect(localeFrances, SIGNAL(triggered()), this, SLOT(localeFrancesSlot()));

    localeItalia = new QAction(configuracioJoc->tradueixCadena("Italia"), this);
    connect(localeItalia, SIGNAL(triggered()), this, SLOT(localeItaliaSlot()));

    localeAlemany = new QAction(configuracioJoc->tradueixCadena("Alemany"), this);
    connect(localeAlemany, SIGNAL(triggered()), this, SLOT(localeAlemanySlot()));

    localeAngles = new QAction(configuracioJoc->tradueixCadena("Angles"), this);
    connect(localeAngles, SIGNAL(triggered()), this, SLOT(localeAnglesSlot()));
    */

    ajuda= new QAction(configuracioJoc->tradueixCadena("Ajuda"), this);
    connect(ajuda, SIGNAL(triggered()), this, SLOT(ajudaSlot()));

    webPrograma= new QAction(configuracioJoc->tradueixCadena("Web.programa"), this);
    connect(webPrograma, SIGNAL(triggered()), this, SLOT(webProgramaSlot()));

    creditsPrograma= new QAction(configuracioJoc->tradueixCadena("Credits"), this);
    connect(creditsPrograma, SIGNAL(triggered()), this, SLOT(creditsProgramaSlot()));

    colaboraPrograma= new QAction(configuracioJoc->tradueixCadena("Colabora"), this);
    connect(colaboraPrograma, SIGNAL(triggered()), this, SLOT(colaboraProgramaSlot()));

}

//Crea el menú de selecció d'idioma de l'aplicació
void formulariPrincipal::creaIdiomaMenu(){
    idiomaActionGroup = new QActionGroup(this);
    connect(idiomaActionGroup, SIGNAL(triggered(QAction *)), this, SLOT(seleccioIdioma(QAction * )));
  //  connect(idiomaActionGroup, SIGNAL(triggered(QAction *)), this, SLOT(canviaIdioma(QAction *)));

    QDir dir(directoriLinux()+QDir().separator()+"locales");
    QStringList arxiusIdioma = dir.entryList(QStringList("locale_*.lo"));

for (int i = 0; i < arxiusIdioma.size(); ++i) {
    QString locale = arxiusIdioma[i];
    locale.remove(0, locale.indexOf('_') + 1);
    locale.truncate(locale.lastIndexOf('.'));


     QString nomArxiu=directoriLinux()+QDir().separator()+"locales"+QDir().separator()+arxiusIdioma[i];
     QSettings *arxiuLocale=new QSettings(nomArxiu,QSettings::IniFormat);
     QString language=arxiuLocale->value("Language","Language").toString().toLatin1();

    QAction *action = new QAction(tr("&%1 %2").arg(i + 1).arg(language), this);
    action->setCheckable(true);
    action->setData(locale);
//qCritical("locale %s",qPrintable(locale));
    idiomaMenu->addAction(action);
    idiomaActionGroup->addAction(action);

   // qCritical("%s", qPrintable(QLocale::system().languageToString(QLocale::system().language())));
   if (configuracioJoc->strLocale().contains((locale) )){
        action->setChecked(true);
        //a debian, sense això es carregan les cadenes
        //originals enlloc de les traduïdes
         configuracioJoc->canviaArxiuLocale(locale);
        //canviaIdioma(action);
       }
  }
}

void formulariPrincipal::seleccioIdioma(QAction *action){
    configuracioJoc->canviaArxiuLocale(action->data().toString());
   // configuracioJoc->canviaArxiuLocale(locale);
    tradueixGUI();
}
/*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
void formulariPrincipal::localeSistemaSlot(){
    //seleccioIdioma(QLocale::system().name().mid(0,2));
}
void formulariPrincipal::localeCatalaSlot(){
 //   seleccioIdioma("ca");
}
void formulariPrincipal::localeCastellaSlot(){
  //  seleccioIdioma("es");
}
void formulariPrincipal::localeGallegSlot(){
  //  seleccioIdioma("gl");
}
void formulariPrincipal::localeEuskeraSlot(){
  //  seleccioIdioma("eu");
}
void formulariPrincipal::localePortuguesSlot(){
 //   seleccioIdioma("pt");
}
void formulariPrincipal::localeFrancesSlot(){
  //  seleccioIdioma("fr");
}
void formulariPrincipal::localeItaliaSlot(){
 //   seleccioIdioma("it");
}
void formulariPrincipal::localeAlemanySlot(){
  //  seleccioIdioma("de");
}
void formulariPrincipal::localeAnglesSlot(){
    //seleccioIdioma("en");
}
*/

//Ajuda
void formulariPrincipal::ajudaSlot(){
 QDir dirArxiu;
 QString directori=directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            configuracioJoc->strLocale()+
                            charPathSeparator+
                            "index.html";

    if (dirArxiu.exists(directori)){
     // QDesktopServices::openUrl(directori);
      //  QDesktopServices::openUrl(QUrl::fromLocalFile(directori));
     //Això evita problemas amb els espais als noms dels directoris
        QDesktopServices::openUrl(QUrl("file:///"+directori, QUrl::TolerantMode));
    }
   else  QDesktopServices::openUrl(QUrl("file:///"+directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            "en"+
                            charPathSeparator+
                            "index.html", QUrl::TolerantMode));
}

void formulariPrincipal::webProgramaSlot(){
   QDesktopServices::openUrl(ADRECA_WEB_PROGRAMA);
}

void formulariPrincipal::creditsProgramaSlot(){
    QDate avui=QDate::currentDate () ;
  //  QString adrecaWeb("http://www.mallorcaweb.net/tangrampeces/");
  //  QString adrecaCorreu("tangram.peces@gmail.com");

    QString missatge=QString("<h2>"+configuracioJoc->tradueixCadena("credits.versio")+""
                             +QString(" v. %1 </h2><br/>").
                                                          arg(qApp->applicationVersion()));
 //   missatge.append( QString("<h2>v. %1</h2>").
   //                                                       arg(qApp->applicationVersion()));

    missatge.append(QString("&copy;  "+QString("2000-%1").arg(avui.year())+"  I. De Marchi <br/>" ));
    missatge.append(QString(configuracioJoc->tradueixCadena("credits.llicencia")+"<br/>"));

    missatge.append(QString("<a href=\"%1\">%1</a><br/>").arg(ADRECA_WEB_PROGRAMA));
    missatge.append(QString("<a href=mailto:%1>%1</a><br/>").arg(ADRECA_CORREU));
//missatge.append(QString("<p>"));
    missatge.append(QString("<p>Thanks for translations: <br/>"));
    missatge.append(QString("Portuguese: Américo Monteiro  (v. 4.0.1) <br/>"));
    missatge.append(QString("Italiano :      Vincenzo Campanella  (v. 4.0.2) <br/>"));
    missatge.append(QString("Deutsch :     Erik Pfannenstein  (v. 4.0.2) <br/>"));
    missatge.append(QString("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Hendrik Knackstedt  (v. 4.0.2) <br/>"));
    missatge.append(QString("Portuguese do Brasil (Brasileiro) :     Adriano Rafael Gomes  (v. 4.0.2) <br/>"));

    QMessageBox::about(this,
            configuracioJoc->tradueixCadena("credits.rotul"),missatge);

/*
    QDate avui=QDate::currentDate () ;
    QMessageBox::about(this,
            configuracioJoc->tradueixCadena("credits.rotul"),
            "<h2>"+configuracioJoc->tradueixCadena("credits.versio")+"</h2>"
             "<p> &copy;  "+QString("2000-%1").arg(avui.year())+"  I. De Marchi" +
             //  "<p> &copy;  "+configuracioJoc->tradueixCadena("credits.dretsAutor")+
               "<p>"+configuracioJoc->tradueixCadena("credits.llicencia")+
               "<p>" +ADRECA_WEB_PROGRAMA+
               "<p>"+ADRECA_CORREU);
               */
}


void formulariPrincipal::colaboraProgramaSlot(){
   QDir dirArxiu;
 QString directori=directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            configuracioJoc->strLocale()+
                            charPathSeparator+
                            "html/colabora.html";

    if (dirArxiu.exists(directori)){
      QDesktopServices::openUrl(QUrl("file:///"+directori, QUrl::TolerantMode));
    }
   else  QDesktopServices::openUrl(QUrl("file:///"+directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            "en"+
                            charPathSeparator+
                            "html/colabora.html", QUrl::TolerantMode));
}


/*
  Selecciona a l'atzar una de les figures de l'arbre
*/
void formulariPrincipal::proposaFiguraSlot(){
   QTreeWidgetItem *item= arbreFiguresTreeWidget->topLevelItem(0);
   if(item->childCount()>0){
   int nus=qrand() % item->childCount();
   QTreeWidgetItem *itemSel=item->child(nus);
   arbreFiguresTreeWidget->setCurrentItem(itemSel);
}
}


void formulariPrincipal::cercaNomFiguraSlot(){
 if (arbreFiguresTreeWidget->topLevelItem(0)==0){ return;}

nomFiguraPerCercar.clear();
indexFiguraPerCercar=0;
bool busca;
bool trobat=false;
nomFiguraPerCercar = QInputDialog::getText(this,
                            configuracioJoc->tradueixCadena("cerca.nom.figura"),
                            configuracioJoc->tradueixCadena("label.nom.figura"),
                            QLineEdit::Normal,
                            "", &busca);

 if (busca && !nomFiguraPerCercar.isEmpty()){
    for(int i=0;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
        indexFiguraPerCercar=i;
        if (arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(0).contains(
                nomFiguraPerCercar,Qt::CaseInsensitive)){
           continuaCercaNomFigura->setEnabled(true);
           arbreFiguresTreeWidget->setCurrentItem(arbreFiguresTreeWidget->topLevelItem(0)->child(i));
           indexFiguraPerCercar=i+1;
           trobat=true;
           break;
        }
     }

 //if(indexFiguraPerCercar>=arbreFiguresTreeWidget->topLevelItem(0)->childCount()){
    if (!trobat){
     QMessageBox::information(this, configuracioJoc->tradueixCadena("cerca.nom.figura"),
                    configuracioJoc->tradueixCadena("msg.nomFigura.noTrobada"));
  }
 }
}

void formulariPrincipal::continuaCercaNomFiguraSlot(){
    bool trobat=false;
for(int i=indexFiguraPerCercar;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
    indexFiguraPerCercar=i;
    if (arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(0).contains(
           nomFiguraPerCercar,Qt::CaseInsensitive)){
       arbreFiguresTreeWidget->setCurrentItem(arbreFiguresTreeWidget->topLevelItem(0)->child(i));
       indexFiguraPerCercar=i+1;
       trobat=true;
       break;
    }
 }
//if(indexFiguraPerCercar+1>=arbreFiguresTreeWidget->topLevelItem(0)->childCount()){
if (!trobat){
    nomFiguraPerCercar.clear();
    indexFiguraPerCercar=0;
    continuaCercaNomFigura->setEnabled(false);
    QMessageBox::information(this, configuracioJoc->tradueixCadena("cerca.nom.figura"),
                    configuracioJoc->tradueixCadena("msg.nomFigura.noTrobada"));
  }
}

void formulariPrincipal::creaMenus()
{
    aplicacioMenu = menuBar()->addMenu(configuracioJoc->tradueixCadena("Programa"));
    aplicacioMenu->addAction(elimnaRecordAction);
    aplicacioMenu->addAction(eliminaTotsRecordsAction);
    aplicacioMenu->addSeparator();

    aplicacioMenu->addAction(carregaFiguresProgramaAction);
    aplicacioMenu->addAction(carregaFiguresArxiuAction);

    aplicacioMenu->addSeparator();
    aplicacioMenu->addAction(surtAction);


    jocMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Joc"));
    jocsTangramMenu=jocMenu->addMenu(configuracioJoc->tradueixCadena("Jocs.tangram"));
        jocsTangramMenu->addAction(tangramBrugnerAction);
        jocsTangramMenu->addAction(tangram4Action);
        jocsTangramMenu->addAction(tangram4IIAction);
        jocsTangramMenu->addAction(tangram5Action);
        jocsTangramMenu->addAction(tangramSLAction);
        jocsTangramMenu->addAction(tangramRegulusAction);
        jocsTangramMenu->addAction(tangram6Action);
        jocsTangramMenu->addAction(tangram6IIAction);
        jocsTangramMenu->addAction(tangramHexagramaAction);
        jocsTangramMenu->addAction(tangramClassicAction);
        jocsTangramMenu->addAction(tangram7IAction);
        jocsTangramMenu->addAction(tangram7IIAction);
        jocsTangramMenu->addAction(tangramFletcherAction);
        jocsTangramMenu->addAction(tangramHEPAction);
        jocsTangramMenu->addAction(tangramXinesAction);
        jocsTangramMenu->addAction(tangramSaviesaAction);
        jocsTangramMenu->addAction(tangram8Action);
        jocsTangramMenu->addAction(tangramCIIAction);
        jocsTangramMenu->addAction(tangram9Action);
        jocsTangramMenu->addAction(tangram9TAction);
        jocsTangramMenu->addAction(tangramOuAction);
        jocsTangramMenu->addAction(tangramCorAction);
        jocsTangramMenu->addAction(tangram10Action);
        jocsTangramMenu->addAction(tangramEAction);
        jocsTangramMenu->addAction(tangramELAction);
        jocsTangramMenu->addAction(tangramCIAction);
        jocsTangramMenu->addAction(tangram11Action);
        jocsTangramMenu->addAction(tangramStomachAction);
        jocsTangramMenu->addAction(tangramRusAction);
        jocsTangramMenu->addAction(tangram13Action);
        jocsTangramMenu->addAction(tangram14Action);
        jocsTangramMenu->addAction(tangramStomachionAction);
        jocsTangramMenu->addAction(tangramStomachionIIAction);

    jocMenu->addSeparator();
    //menú del nivell de Joc
    jocMenu->addAction(nivellInfantilAction);
    jocMenu->addAction(nivellPrincipiantAction);
    jocMenu->addAction(nivellIniciatAction);
    jocMenu->addAction(nivellExpertAction);
     /*
      Creació de noves figures
    */
    jocMenu->addSeparator();
    creaFiguraMenu=jocMenu->addMenu(configuracioJoc->tradueixCadena("crea.nova.figura"));    
        creaFiguraMenu->addAction(comprovaMostraAction);
        creaFiguraMenu->addAction(esborraMostraAction);
        creaFiguraMenu->addAction(desaFiguraAction);
        creaFiguraMenu->addSeparator();
        creaFiguraMenu->addAction(simetriaVerticalAction);
        creaFiguraMenu->addAction(simetriaHoritzontalAction);
        creaFiguraMenu->addSeparator();
        creaFiguraMenu->addAction(cercaFiguraAction);
        creaFiguraMenu->addAction(figuraSeguentAction);
        creaFiguraMenu->addAction(figuraAnteriorAction);



    jocMenu->addSeparator();
    jocMenu->addAction(proposaFigura);

    jocMenu->addSeparator();

    jocMenu->addAction(cercaNomFigura);
    jocMenu->addAction(continuaCercaNomFigura);



    //ajuda a la resolució de figures
    jocMenu->addSeparator();
    jocMenu->addAction(colocaPecaAction);
    jocMenu->addAction(mostraSolucioAction);

    //creació de concurs
    concursMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Concurs"));
    concursMenu->addAction(creaConcursAction);
    concursMenu->addAction(carregaConcursAction);

    //selecció d'idioma
    idiomaMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("idioma"));
    /*
    idiomaMenu->addAction(localeSistema);
    idiomaMenu->addSeparator();
    idiomaMenu->addAction(localeCatala);
    idiomaMenu->addAction(localeCastella);
    idiomaMenu->addAction(localeGalleg);
    idiomaMenu->addAction(localeEuskera);
    idiomaMenu->addAction(localeAlemany);
    idiomaMenu->addAction(localeAngles);
    idiomaMenu->addAction(localeFrances);
    idiomaMenu->addAction(localeItalia);
    idiomaMenu->addAction(localePortugues);
    */
    creaIdiomaMenu();

    //Ajuda
    ajudaMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Ajuda"));
        ajudaMenu->addAction(ajuda);
        ajudaMenu->addAction(webPrograma);
        ajudaMenu->addAction(colaboraPrograma);
        ajudaMenu->addSeparator();
        ajudaMenu->addAction(creditsPrograma);
}


  void formulariPrincipal::missatgeStatusBar(QString missatge)
 {
     statusBar()->showMessage(missatge);
 }

void formulariPrincipal::creaBarraTasques()
{
    tangramsToolBar = addToolBar(configuracioJoc->tradueixCadena("Tangrams"));
    tangramsToolBar->setIconSize(QSize(15,15));
    tangramsToolBar->addAction(tangramBrugnerAction);
    tangramsToolBar->addAction(tangram4Action);
    tangramsToolBar->addAction(tangram4IIAction);
    tangramsToolBar->addAction(tangram5Action);
    tangramsToolBar->addAction(tangramSLAction);
    tangramsToolBar->addAction(tangramRegulusAction);
    tangramsToolBar->addAction(tangram6Action);
    tangramsToolBar->addAction(tangram6IIAction);
    tangramsToolBar->addAction(tangramHexagramaAction);
    tangramsToolBar->addAction(tangramClassicAction);
    tangramsToolBar->addAction(tangram7IAction);
    tangramsToolBar->addAction(tangram7IIAction);
    tangramsToolBar->addAction(tangramFletcherAction);
    tangramsToolBar->addAction(tangramHEPAction);
    tangramsToolBar->addAction(tangramXinesAction);
    tangramsToolBar->addAction(tangramSaviesaAction);
    tangramsToolBar->addAction(tangram8Action);
    tangramsToolBar->addAction(tangramCIIAction);
    tangramsToolBar->addAction(tangram9Action);
    tangramsToolBar->addAction(tangram9TAction);
    tangramsToolBar->addAction(tangramOuAction);
    tangramsToolBar->addAction(tangramCorAction);
    tangramsToolBar->addAction(tangram10Action);
    tangramsToolBar->addAction(tangramEAction);
    tangramsToolBar->addAction(tangramELAction);
    tangramsToolBar->addAction(tangramCIAction);
    tangramsToolBar->addAction(tangram11Action);
    tangramsToolBar->addAction(tangramStomachAction);
    tangramsToolBar->addAction(tangramRusAction);
    tangramsToolBar->addAction(tangram13Action);
    tangramsToolBar->addAction(tangram14Action);
    tangramsToolBar->addAction(tangramStomachionAction);
    tangramsToolBar->addAction(tangramStomachionIIAction);

    tangramsToolBar->addSeparator();

    //nivell de Joc
    tangramsToolBar->addAction(nivellInfantilAction);
    tangramsToolBar->addAction(nivellPrincipiantAction);
    tangramsToolBar->addAction(nivellIniciatAction);
    tangramsToolBar->addAction(nivellExpertAction);

}


