/*
 * Copyright (C) 2000-2011  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
//#include <QtGui>
//#include <QModelIndex>
//#include <QImage>

#include "frmPrincipal.h"

#include "peca/peca.h"
#include "peca/conjuntpeces.h"
#include "comuns/constants.h"
#include "comuns/configuracio.h"
#include "formularis/desafigura.h"
#include "formularis/creaconcurs.h"
#include "comuns/funcions.h"


class QSettings;

//Numero de figures
//int numeroFigures=0;

formulariPrincipal::formulariPrincipal()
{


charPathSeparator=QDir().separator();

estatDelJoc=Inactiu;


setMinimumSize (QSize(900,620));
//28/02/11
//setMaximumSize(QSize(900,620));


//cream la configuració del programa
configuracioJoc= new Configuracio();
//Dimensionam segons les dades de configuració
setGeometry(0,0,configuracioJoc->configArxiu->value(
                          QString("General/amplada")).toInt(),
                  configuracioJoc->configArxiu->value(
                          QString("General/alt")).toInt());

figuresResoltesList=new QStringList();
carregaFiguresResoltes();

figuresSemblantsList=new QStringList();

    sceneFrame=new QFrame(this);
    sceneFrame->setGeometry(0,60,900,550);
    sceneFrame->setMinimumSize(900,550);

    //Panell de la mostra de les figures
    sceneMostra=new QGraphicsScene(0, 0, 140, 140);

    viewMostra = new QGraphicsView(sceneMostra,sceneFrame);
    viewMostra->setRenderHints(QPainter::Antialiasing
                             | QPainter::TextAntialiasing);
    viewMostra->move(QPoint(150,0));

    //Panell del joc
    sceneJoc = new QGraphicsScene(0, 0, 600, 530);
    connect(sceneJoc,SIGNAL(selectionChanged()),
            this,SLOT(canvisSceneJoc()));
    viewJoc = new QGraphicsView(sceneJoc,sceneFrame);
    viewJoc->setRenderHints(QPainter::Antialiasing
                           | QPainter::TextAntialiasing);
    viewJoc->move(QPoint(300,0));
    //No es  mostraran les barres de desplaçament
    viewJoc->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    viewJoc->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    viewJoc->setMinimumSize(600,530);


    contadorsFrame=new QFrame(sceneFrame);
    contadorsFrame->setGeometry(0,0,140,140);
    contadorsFrame->move(QPoint(0,0));

    rellotgeLabel = new Rellotge(contadorsFrame);
    rellotgeLabel->setGeometry(0,0,140,30);
    rellotgeLabel->setAlignment(Qt::AlignHCenter);

    numFigures= new QLabel("Figures",contadorsFrame);
    numFigures->setGeometry(0,35,140,30);
    numFigures->setAlignment(Qt::AlignHCenter);

    punts= new QLabel("Punts",contadorsFrame);
    punts->setGeometry(0,70,140,30);
    punts->setAlignment(Qt::AlignHCenter);



    //arbre de figures
    arbreFiguresTreeWidget= new QTreeWidget(sceneFrame);
    arbreFiguresTreeWidget->setGeometry(0,0,295,390);
    arbreFiguresTreeWidget->setMinimumSize(QSize(295,390));
    arbreFiguresTreeWidget->move(QPoint(0,145));
    arbreFiguresTreeWidget->expandAll();
    connect(arbreFiguresTreeWidget,SIGNAL(itemSelectionChanged()),
           this,SLOT(seleccioFigura()));
    connect(arbreFiguresTreeWidget,SIGNAL(itemDoubleClicked ( QTreeWidgetItem *, int )),
            this,SLOT(seleccionFiguraItemDoubleClicked (QTreeWidgetItem *, int )));


    creaAcccions();
    creaMenus();
    creaBarraTasques();


    setWindowTitle("Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")");
    setWindowIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"pecesset.png"));

    creaTangram(configuracioJoc->tipusTangram);
    canviaNivellJoc(configuracioJoc->nivellJoc);

    switch (configuracioJoc->nivellJoc){
        case NIVELL_INFANTIL:
         nivellInfantilAction->setChecked(true);
         break;
        case NIVELL_PRINCIPIANT:
         nivellPrincipiantAction->setChecked(true);
         break;
        case NIVELL_INICIAT:
         nivellIniciatAction->setChecked(true);
         break;
        case NIVELL_EXPERT:
         nivellExpertAction->setChecked(true);
         break;
        default:
         nivellIniciatAction->setChecked(true);
    }
 //Això és necessari degut a que canviaNivellJoc()
 //col·loca les peces a l'atzar
 figuraInicialTangram(configuracioJoc->tipusTangram);

 //Numero de figures
 /*numeroFigures=0;
 canviaNivellJoc(NIVELL_INICIAT);
 for(int i=1;i<=38;i++){
     creaTangram(i);
    // qDebug("Numero de figures: %d",numeroFigures);
 }
 qDebug("Numero total de figures: %d",numeroFigures);
 */
}

void formulariPrincipal::actualitzaMenus(){
    creaFiguraMenu->setEnabled(estatDelJoc==Inactiu);
    comprovaMostraAction->setEnabled(estatDelJoc==Inactiu);
    esborraMostraAction->setEnabled(estatDelJoc==Inactiu);
    desaFiguraAction->setEnabled(estatDelJoc==Inactiu);
    cercaFiguraAction->setEnabled(estatDelJoc==Inactiu &&
                                arbreFiguresTreeWidget->topLevelItem(0)!=0 );
    cercaNomFigura->setEnabled(estatDelJoc != JocIniciat &&
                               arbreFiguresTreeWidget->topLevelItem(0)!=0 );

    proposaFigura->setEnabled(estatDelJoc != JocIniciat);
    mostraSolucioAction->setEnabled(estatDelJoc==JocIniciat );
    colocaPecaAction->setEnabled(estatDelJoc==JocIniciat && configuracioJoc->nivellJoc != NIVELL_EXPERT
                                 && configuracioJoc->nivellJoc != NIVELL_INFANTIL);

    if (estatDelJoc==JocIniciat && configuracioJoc->nivellJoc != NIVELL_EXPERT
                                 && configuracioJoc->nivellJoc != NIVELL_INFANTIL){
       colocaPecaAction->setEnabled(true);
    }
    else {
        colocaPecaAction->setEnabled(false);
        colocaPecaAction->setChecked(false);
        configuracioJoc->colocaPeca=false;
    }
    carregaFiguresArxiuAction->setEnabled(estatDelJoc !=JocIniciat);
    carregaFiguresProgramaAction->setEnabled(estatDelJoc!=JocIniciat);

    elimnaRecordAction->setEnabled(estatDelJoc!=JocIniciat);
    eliminaTotsRecordsAction->setEnabled(estatDelJoc!=JocIniciat);
}

 void formulariPrincipal::canviaEstatDelJoc(EstatsDelJoc estat){

    switch (estatDelJoc){
        case Inactiu:
            switch (estat){
               case FiguraCarregada:
                    estatDelJoc=estat;
               break;
               case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    break;
               case Inactiu:
               case JocIniciat:
               case MostraSolucio:
               break;
           }
        break;//Fina Inactiu

        case FiguraCarregada:
            switch (estat){
                case Inactiu:
                estatDelJoc=estat;
                conjuntFigura->conjuntVisible(false);
                conjuntMostra->conjuntVisible(false);
                break;
                case JocIniciat:
                estatDelJoc=estat;
                //posar en marxa el rellotge
                rellotgeLabel->iniciaRellotge();
                /* 4.0.2 21/12/10
                 Aquesta absurda repetició soluciona el problema de la col·locació
                 de les peces en el nivell infantil. Abans, en el primer intent
                 de col·locar la primera peça, no es col·locava.
                   */
                conjuntJoc->arrayPeces[0]->setSelected(true);
                conjuntJoc->arrayPeces[0]->setSelected(false);
                break;
                case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                break;
                case FiguraCarregada:
                case MostraSolucio:
                break;
            }
        break;  // FiguraCarregada

        case JocIniciat:
            switch (estat){
                case FiguraResolta:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       if (!configuracioJoc->colocaPeca){
                       actualitzaPuntuacio(1,configuracioJoc->nivellJoc*conjuntJoc->arrayPeces.size());
                        }
                       desaContadors();
                       conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                       conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                       arbreFiguresTreeWidget->selectedItems().first()->setIcon(0,iconeFigura(4));
                       arbreFiguresTreeWidget->selectedItems().first()->setText(3,"1");
     /*
       v. 4.0.2 20/12/10
       S'afageix la col·locació de les peces. Així es conserva la solució
       obtinguda per l'usuari
       */
                       /* v. 4.1 28/01/11
                          Afegit el % de coincidència de la solució
                          */
                       figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1;").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0))+
                                QString("%1;").arg(conjuntJoc->coordenadesFigura())+
                                QString("%1").arg(figuraSolucionada() ));
                    //v. 4.0.2 20/12/10
                    //Es desen les figures resoltes inmediatament.
                    desaFiguresResoltes();
                    break;
                case FiguraCarregada:
                case Inactiu:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       desaContadors();
                    break;
                case MostraSolucio:
                       estatDelJoc=estat;
                        //cal aturar el rellotge
                       rellotgeLabel->aturaRellotge();
                       actualitzaPuntuacio(1,-configuracioJoc->nivellJoc*conjuntJoc->arrayPeces.size());
                       desaContadors();
                       conjuntFigura->conjuntSolucio();
                       arbreFiguresTreeWidget->selectedItems().first()->setIcon(0,iconeFigura(4));
                       arbreFiguresTreeWidget->selectedItems().first()->setText(3,"1");
                       figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0)));
                    break;
                    case JocIniciat:
                    break;
            }
        break; //JocIniciat

        case FiguraResolta:
                switch (estat){
                    case Inactiu:
                       estatDelJoc=estat;
                       conjuntFigura->conjuntVisible(false);
                       conjuntMostra->conjuntVisible(false);
                    break;
                    case FiguraCarregada:
                       estatDelJoc=estat;
                    break;
                    case FiguraResolta:
                        estatDelJoc=estat;
                        //primer cal eliminar les dades de la figura anterior
                        //QString nomFigura=QString("%1;").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0));
                        figuresResoltesList->removeAt(buscaFiguraSolucionadaEnLlista(
                                arbreFiguresTreeWidget->selectedItems().first()->text(0)));
                        figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1;").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0))+
                                QString("%1;").arg(conjuntJoc->coordenadesFigura())+
                                QString("%1").arg(figuraSolucionada() ));
                    //v. 4.0.2 20/12/10
                    //Es desen les figures resoltes inmediatament.
                    desaFiguresResoltes();
                        conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                        conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    break;
                    case JocIniciat:
                    case MostraSolucio:
                    break;
                }
        break; //  FiguraResolta


        case MostraSolucio:
           switch (estat){
                case Inactiu:
                    estatDelJoc=estat;
                    conjuntFigura->conjuntVisible(false);
                    conjuntMostra->conjuntVisible(false);
                break;
                case FiguraResolta:
                    estatDelJoc=estat;
                    conjuntFigura->colorPecesConjunt(COLOR_FIG_RESOLTA);
                    conjuntMostra->colorPecesConjunt(COLOR_FIG_RESOLTA);
                break;
                case FiguraCarregada:
                   estatDelJoc=estat;
                break;
                case JocIniciat:
                case MostraSolucio:
                break;
           }
        break;  //  MostraSolucio
    }
 // actualitzar l'estat de les QActions
 actualitzaMenus();
 }
/*
  Gestiona els canvis al panell de joc
*/
void formulariPrincipal::canvisSceneJoc(){
   switch (estatDelJoc){
        case Inactiu:
        break;
        case FiguraCarregada:
            canviaEstatDelJoc(JocIniciat);
        break;
        case JocIniciat:
            //si estem al nivell infantil, controlam si cal
            //col·locar la peça directament
            if (configuracioJoc->nivellJoc==NIVELL_INFANTIL){
                    for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
                        if(conjuntJoc->arrayPeces.value(i)->isSelected() &&
                          sceneJoc->selectedItems().indexOf(conjuntJoc->arrayPeces.value(i))>-1){
                          pecaSeleccionadaNivellInfantil=i;
                          break;
                        }
                    }

                if (pecaSeleccionadaNivellInfantil>=0){
                    if(colocaPecaNivellInfantil(pecaSeleccionadaNivellInfantil)){
                              colocaPeca(pecaSeleccionadaNivellInfantil);
                              pecaSeleccionadaNivellInfantil=-1;
                          }
                    }
                }

            if (configuracioJoc->colocaPeca){
               for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
                   if(conjuntJoc->arrayPeces.value(i)->isSelected() &&
                      sceneJoc->selectedItems().indexOf(conjuntJoc->arrayPeces.value(i))>-1){
                      actualitzaPuntuacio(0,-configuracioJoc->nivellJoc);
                      colocaPeca(i);
                      break;
                      }
                   }
               }
            //cal revisa si la figura està resolta
            //Aquest if evita que es faci la comprovació dues vegades
            //(Quan es selecciona i quan es deselecciona una peça)
            if(sceneJoc->selectedItems().size()==0){
            float percentatgeSolucio;
            percentatgeSolucio=figuraSolucionada();
            if ( percentatgeSolucio>=PERCENTATGE_COINCIDENCIA_SOLUCIO) {
                        canviaEstatDelJoc(FiguraResolta);
                    }
             }
        break;
        case FiguraResolta:
        /* 4.1  28/01/11
           Si l'usuari aconsegueix un percentatge major a la solució,
           llavors es controla
           */
           if(sceneJoc->selectedItems().size()==0){
            float percentatgeSolucio;
            percentatgeSolucio=figuraSolucionada();
            if(percentatgeSolucio>=PERCENTATGE_COINCIDENCIA_SOLUCIO){
            if (percentatgeSolucio>percentatgeSolucioAnterior(
                    arbreFiguresTreeWidget->selectedItems().first()->text(0))) {
                    QMessageBox missatgeBox;
                    missatgeBox.setText(configuracioJoc->tradueixCadena("Desa.Solucio.pregunta"));
                    missatgeBox.setIcon(QMessageBox::Question);
                    missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
                    missatgeBox.setDefaultButton(QMessageBox::No);
                    if(missatgeBox.exec()==QMessageBox::Yes){
                        canviaEstatDelJoc(FiguraResolta);
                    }
                }
             }
        }
        break;
        case MostraSolucio:
        break;
    }
}

/* 4.1 28/01/11
   Quan l'usuari juga a "millorar" una figura ja resolta,
   aquesta funció retorna el % de la solució anterior de la figura
   */
float formulariPrincipal::percentatgeSolucioAnterior(QString nomFigura){
    if (figuraJaResolta(nomFigura)){
    QString dadesFigura=figuresResoltesList->value(buscaFiguraSolucionadaEnLlista(nomFigura));
    QStringList dadesFiguraList=dadesFigura.split(";");
    if(dadesFiguraList.count()>4){
       QString percentatgeString=dadesFiguraList.value(4);
    return percentatgeString.toLong();
    }
    else return 0;
  }
else return 0;
}

float formulariPrincipal::figuraSolucionada(){
    int positiu,positiu1,totals;
    positiu=0;
    positiu1=0;
    totals=0;
    QVector<QPointF> pSolucio;

    //Si el nivell és expert, primer cal "resituar"
    //el conjuntFigura (nomès si la figura no és "composta")
    if (configuracioJoc->nivellJoc==NIVELL_EXPERT &&
       !conjuntFigura->arrayPeces[0]->pecaVisible){
        conjuntFigura->recolocaPeces(conjuntJoc->vertexSuperiorEsquerra());
    }

//Carregam els vèrtex de la figura
QPointF vertSupEsq=conjuntJoc->vertexSuperiorEsquerra();
for(int i=0;i<=conjuntFigura->arrayPeces.size()-1;i++){
   if (configuracioJoc->nivellJoc==NIVELL_EXPERT){
    /* 4.0.2 afegit aquest if per millorar una mica la correcció amb
       el nivell expert*/
       conjuntFigura->arrayPeces[i]->puntsSolucio(pSolucio,0.85);}
   else  conjuntFigura->arrayPeces[i]->puntsSolucio(pSolucio,0.9);
   }

/* Això estaria molt be, però cal trobar un triangle que sigui
   el "MCD" de totes les peces (...que no sembla possible)
for(int j=0;j<=pSolucio.size()-1;j++){
    for(int k=0;k<=pJoc.size()-1;k++){
     QPointF punt=pSolucio.value(j)-pJoc.value(k);
        if(sqrt(pow(punt.x(),2)+pow(punt.y(),2))<=DISTANCIA_PUNTS_SOLUCIO){
          positiu1=positiu1+1;
          break;
        }
    }
}
*/
//ara fem la comprovació
totals=pSolucio.size();
for(int j=0;j<=pSolucio.size()-1;j++){
    for(int k=0;k<=conjuntJoc->arrayPeces.size()-1;k++){
        if(conjuntJoc->arrayPeces[k]->shape().contains(
                pSolucio.value(j)-conjuntJoc->arrayPeces[k]->pos())){
            positiu=positiu+1;
            //aquest break evita que un mateix punt es comptabilitzi
            //més d'una vegada si hi ha peces superposades
            break;
        }
    }
}
if (totals<1){
    return 0.0;}
else {
 /* 4.0.2
    Afegit aquest avís per facilitar la resolució de figures
    */
missatgeStatusBar(QString("%1 %").arg(positiu*100/(totals)));
    return positiu*100/(totals);
  }
 }


/* 4.1 Aquesta funció no es fa servir

bool formulariPrincipal::figuraSolucionadaNivellInfantil(){
QString coordenadesFigura;
coordenadesFigura=conjuntFigura->coordenadesFigura();
  if (coordenadesFigura==conjuntJoc->coordenadesFigura()){
     return true;
  }
  else {
    QList<int> index;
    int indexPeca;
    QPointF vertexFigura=conjuntFigura->vertexSuperiorEsquerra();
    for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
       indexPeca=coordenadesFigura.indexOf(conjuntJoc->arrayPeces[i]->cadenaPropietatsPeca(
               vertexFigura));
       if(indexPeca>-1 && index.indexOf(indexPeca==-1)){
          index.append(indexPeca);
       }
    }
return index.size()==conjuntJoc->arrayPeces.size();
  }
}
*/

/* 4.1 28/01/11
    Busca en la llista de figures resoltes el nom passat per paràmetre
    i retorna el índex
       */
int formulariPrincipal::buscaFiguraSolucionadaEnLlista(QString nom){
    QString nom1=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).
                      arg(nom);
    QRegExp rx(nom1+"*");
    rx.setPatternSyntax(QRegExp::Wildcard);
    return figuresResoltesList->indexOf(rx);
}


/* 4.0.2
  Elimina la solució de la figura obtinguda per l'usuari
  */
void formulariPrincipal::seleccionFiguraItemDoubleClicked(QTreeWidgetItem * item, int column){
    //si la figura ha estat resolta
   if (item->text(3)=="1" ){
        /* 4.1 28/01/11
           Introduida la nova funció buscaFiguraSolucionadaEnLlista()
           */
          int indexFigura= buscaFiguraSolucionadaEnLlista(arbreFiguresTreeWidget->selectedItems().first()->text(0));
          QStringList dades=figuresResoltesList->value(indexFigura).split(";");
          //Cal evitar que es demani si es vol eliminar les dades de la solució....quan no n'hi ha!
          if (dades.size()>3){
          QMessageBox missatgeBox;
        missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.solucio.pregunta"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
          //Eliminam la figura resolta
          figuresResoltesList->removeAt(indexFigura);
          //I ara l'afegim sense les dades de la solució
          figuresResoltesList->append(
                                QString("%1;").arg(configuracioJoc->tipusTangram)+
                                QString("%1;").arg(configuracioJoc->nivellJoc)+
                                QString("%1").arg(arbreFiguresTreeWidget->selectedItems().first()->text(0)));
          desaFiguresResoltes();
          conjuntJoc->colocaPecesAtzar();
         }
        }
  }
}

/*
Gestiona la selecció d'una figura a l'arbre
(conectat amb arbreFiguresTreeWidget::itemSelectionChanged ()
*/
void formulariPrincipal::seleccioFigura(){

if (!arbreFiguresTreeWidget->selectedItems().isEmpty()){
 QTreeWidgetItem *item;
 item=arbreFiguresTreeWidget->selectedItems().first();
 //S'ha clicat el nus arrel
 if (item->childCount()>0){
    canviaEstatDelJoc(Inactiu);
    conjuntMostra->conjuntVisible(false);
    conjuntFigura->conjuntVisible(false);
    creaFiguraMenu->setEnabled(true);
     }
 else if (!item->text(1).isEmpty()){
    canviaEstatDelJoc(FiguraCarregada);
    conjuntMostra->colocaPeces(item->text(1));
 //qCritical("%s", qPrintable(item->text(1)));
    conjuntMostra->conjuntVisible(true);
    conjuntMostra->conjuntDeMostra();
    conjuntFigura->colocaPeces(item->text(1));
    conjuntFigura->conjuntDeMostra(); //&& item->text(4)=="0"
   if(configuracioJoc->nivellJoc==NIVELL_EXPERT ){
    conjuntFigura->conjuntVisible(false);
    }
   conjuntJoc->colocaPecesAtzar();
   //La figura ja ha estat resolta per l'usuari
    if (item->text(3)=="1"){
     canviaEstatDelJoc(FiguraResolta);
      //Carregam la solució de l'usuari
     conjuntJoc->colocaPeces(figuraJaResoltaPosicioPeces(item->text(0)));
     //restablim l'angle de gir de les peces
     angleGirConjuntPecesJoc();
     }
   // conjuntJoc->colocaPecesAtzar();
   //Això és necessari degut a que, a vegades, queda algun
   //"rastre" de la figura anterior
   sceneMostra->update();
   sceneJoc->update();
  // creaArxiuImatge(item->text(0));
  }
else {
    canviaEstatDelJoc(Inactiu);
    conjuntMostra->conjuntVisible(false);
    conjuntFigura->conjuntVisible(false);
    conjuntJoc->colocaPecesAtzar();
   }
 }


}
/*
  Crea un arxiu amb la imatge actual del conjuntMostra
  */
void formulariPrincipal::creaArxiuImatge(QString nomArxiu){
if (!nomArxiu.isEmpty()){
    QRectF rectFigura =conjuntMostra->rectangleFigura();
    QImage *image1 = new QImage(rectFigura.width(),
                                rectFigura.height(),
                                QImage::Format_ARGB32_Premultiplied);
    QPainter *painter= new QPainter(image1);
    conjuntMostra->conjuntSolucio();
    sceneMostra->update();
    QRectF target;
    sceneMostra->render(painter,target,rectFigura);
    painter->end();
    QString  nomArxiuImatge;
    nomArxiuImatge=QDir::homePath ()+QDir().separator()+"tangram"+QDir().separator()+nomArxiu+".png";
    QFile arxiu(nomArxiuImatge);
    arxiu.remove(nomArxiuImatge);
    if(!image1->save(nomArxiuImatge)){
        qDebug("no s'ha desat");
    }
  }
}

void formulariPrincipal::carregaArbreFigures(QString nomArxiu){
QApplication::setOverrideCursor(Qt::WaitCursor);

carregaContadors();

canviaEstatDelJoc(Inactiu);
//netejam
arbreFiguresTreeWidget->clear();
arbreFiguresTreeWidget->setColumnCount(4);
arbreFiguresTreeWidget->setColumnHidden(1,true);
arbreFiguresTreeWidget->setColumnHidden(2,true);
arbreFiguresTreeWidget->setColumnHidden(3,true);
arbreFiguresTreeWidget->setColumnHidden(4,true);
//1: visible la mostra de la figura al nivell 4
//arbreFiguresTreeWidget->setColumnHidden(5,true);

//posam la capçalera de l'arbre
QTreeWidgetItem *item=new QTreeWidgetItem();
//13/02/11 Canviat per eliminar icones del resources.qrc
item->setIcon(0,QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+configuracioJoc->nomIcone));


item->setText(0,configuracioJoc->tradueixCadena(configuracioJoc->nomJocArbreFigures));
arbreFiguresTreeWidget->setHeaderItem(item);
llegeixArxiuFigures(nomArxiu);
//actualitzaMenus();
QApplication::setOverrideCursor(Qt::ArrowCursor);
}

void formulariPrincipal::llegeixArxiuFigures( QString nomArxiu){
  //obrim l'arxiu de figures
  QFile arxiuFigures(nomArxiu);
    if (!arxiuFigures.open(QIODevice::ReadOnly | QIODevice::Text)){
        QMessageBox::information(this, "Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")",
                                configuracioJoc->tradueixCadena("ArxiuNoTrobat").arg(nomArxiu) );
         return ;
     }

  QSettings *controlArxiu;
  controlArxiu=new QSettings(QSettings::IniFormat, QSettings::UserScope,"De Marchi", "NomFigures");
  controlArxiu->clear();

     QTextStream entrada(&arxiuFigures);
     QString linia0 = entrada.readLine();
     QString linia1,linia2;
     bool figuraComposta;

     QTreeWidgetItem *arrel=new QTreeWidgetItem();
     int numFig, intPosDarrerPunt;
     while (!linia0.isNull()) {
         linia1=entrada.readLine();
         linia2=entrada.readLine();
            //Controla si cal NO carregar la figura al nivell expert
            //(a les figures "compostes")
            if (linia2.length()==5){
               if (linia2.mid(4,1)=="1"){
                   figuraComposta=true;}
               else figuraComposta=false;
           }
            else figuraComposta=false;

         //El nivell iniciat també carrega les figures del nivell expert
         //(a partir de la versió 4.0)
         if ( ( (linia2.mid(0,1).toInt()<=configuracioJoc->nivellJoc) ||
              configuracioJoc->nivellJoc== NIVELL_INICIAT ) &&
              //les figures "compostes" no son visibles al nivell expert
              !(figuraComposta && configuracioJoc->nivellJoc==NIVELL_EXPERT)  ){
            QTreeWidgetItem *item=new QTreeWidgetItem();
            intPosDarrerPunt=linia0.lastIndexOf(".");
            if (intPosDarrerPunt<=0){intPosDarrerPunt=linia0.length();}
            numFig=controlArxiu->value(linia0.mid(0,intPosDarrerPunt),"1").toInt();
            QString cadena;
          //Només cal fer la traducció dels noms de figura, quan es carrega
          //un arxiu de figures (no de concurs)            
          if(arxiuFigures.fileName().mid(arxiuFigures.fileName().lastIndexOf("."),
                 arxiuFigures.fileName().length())==".fig"){
            //posam espais al principi per a què les cadenes tenguin
            //la mateixa longitud i quedin ben ordenades
            cadena=QString::number(numFig);
            while (cadena.length()<4){cadena=" "+cadena;}
            cadena=configuracioJoc->tradueixCadena(linia0.mid(0,intPosDarrerPunt))+cadena;
             }
            else cadena=linia0;

            //Això per botar-se la traducció
            //cadena=linia0;
            item->setText(0,cadena);
            numFig++;
            controlArxiu->setValue(linia0.mid(0,intPosDarrerPunt),numFig);
            item->setText(1,linia1);
            item->setText(2,linia2);
            //controla si  la figura ja s'ha resolt
            item->setText(3,"0");
            item->setIcon(0,iconeFigura(linia2.mid(2,1).toInt()));
            //miram si la figura ja ha estat resolta
            if (figuraJaResolta(cadena)){
               item->setIcon(0,iconeFigura(4));
               item->setText(3,"1");
            }
           arrel->addChild(item);
         }
         linia0 = entrada.readLine();
     }
arbreFiguresTreeWidget->addTopLevelItem(arrel);
arbreFiguresTreeWidget->sortItems(0,Qt::AscendingOrder);
//arbreFiguresTreeWidget->sortByColumn(0,Qt::AscendingOrder);
arrel->setText(0,configuracioJoc->tradueixCadena(
                                  configuracioJoc->nomNivellArbreFigures.toAscii())
                                  +" ("+QString::number(arrel->childCount()) +")");
arbreFiguresTreeWidget->expandAll();
controlArxiu->clear();

//Numero de figures
//numeroFigures +=arrel->childCount();
}

/*
  Slots d'eliminació de records
*/
void formulariPrincipal::eliminaRecordSlot(){
    QMessageBox missatgeBox;
        missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.record.pregunta"));
        missatgeBox.setIcon(QMessageBox::Question);
        missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
        missatgeBox.setDefaultButton(QMessageBox::No);
        if(missatgeBox.exec()==QMessageBox::Yes){
          canviaEstatDelJoc(Inactiu);
          rellotgeLabel->estableixTemps("00:00:00");
          configuracioJoc->temps=rellotgeLabel->retornaTemps(1);
          actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
          eliminaFiguresResoltes(1);
          desaFiguresResoltes();
          carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
        }
    }

void formulariPrincipal::eliminaTotsRecordsSlot(){
QMessageBox missatgeBox;
missatgeBox.setText(configuracioJoc->tradueixCadena("Elimina.tots.records.pregunta"));
missatgeBox.setIcon(QMessageBox::Question);
missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
missatgeBox.setDefaultButton(QMessageBox::No);
if(missatgeBox.exec()==QMessageBox::Yes){
    canviaEstatDelJoc(Inactiu);
    rellotgeLabel->estableixTemps("00:00:00");
    configuracioJoc->temps=rellotgeLabel->retornaTemps(1);
    actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
    int registre=configuracioJoc->configArxiu->value("joc/registre",0).toInt();
    QString locale =configuracioJoc->configArxiu->value("joc/idioma",QLocale::system().name().mid(0,2)).toString();
    configuracioJoc->configArxiu->clear();
    configuracioJoc->configArxiu->setValue("joc/tipusTangram", configuracioJoc->tipusTangram);
    configuracioJoc->configArxiu->setValue("joc/nivellJoc", configuracioJoc->nivellJoc);
    configuracioJoc->configArxiu->setValue("joc/registre", registre);
    configuracioJoc->configArxiu->setValue("joc/idioma", locale);
    eliminaFiguresResoltes(0);
    desaFiguresResoltes();
    carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
  }
}


void formulariPrincipal::carregaFiguresProgramaSlot(){
//configuracioJoc->carregaPuntuacio();
configuracioJoc->directoriArxiuDadesFigures=directoriLinux()+
                            charPathSeparator+"figures"+charPathSeparator+configuracioJoc->arxiuDadesFigures;
//configuracioJoc->directoriArxiuDadesFigures=QCoreApplication::applicationDirPath ()+
  //                   charPathSeparator+"figures"+charPathSeparator+configuracioJoc->arxiuDadesFigures;
carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
configuracioJoc->desaRecords=true;
 actualitzaMenus();
}

void formulariPrincipal::carregaFiguresArxiuSlot(){
    configuracioJoc->directoriArxiuDadesFigures = QFileDialog::getOpenFileName(this,
                                 configuracioJoc->tradueixCadena("carrega.arxiu.figures"),
                                 directoriFiguresPersonals(),
                                 configuracioJoc->arxiuDadesFigures);

    if(configuracioJoc->directoriArxiuDadesFigures.isEmpty()){
       carregaFiguresProgramaSlot();
       }
    else{
   carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
   configuracioJoc->desaRecords=false;
   reiniciaContadors();
   conjuntFigura->conjuntVisible(false);
   conjuntMostra->conjuntVisible(false);
   }
 actualitzaMenus();
}

void formulariPrincipal::creaTangram(int tipusTangram){
    if (tangramActual !=tipusTangram){
        canviaEstatDelJoc(Inactiu);
        tangramActual=tipusTangram;
        configuracioJoc->canviaTipusTangram(tipusTangram);

        nomFiguraPerCercar.clear();
        indexFiguraPerCercar=0;
        //eliminam les peces actuals
        sceneJoc->clear();
        sceneMostra->clear();


        conjuntJoc= new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntMostra=new ConjuntPeces(tipusTangram,ESCALA_MOSTRA);
        conjuntMostra->conjuntDeMostra();
        conjuntMostra->conjuntVisible(false);
        conjuntFigura=new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntFigura->conjuntDeMostra();
        conjuntFigura->conjuntVisible(false);

       //ara afegim les peces a l'scena
        for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
            conjuntJoc->arrayPeces[i]->setZValue(0);
            conjuntJoc->arrayPeces[i]->estableixAngleGirPeca(configuracioJoc->angleGir);
            sceneJoc->addItem(conjuntJoc->arrayPeces[i]);
            sceneJoc->addItem(conjuntFigura->arrayPeces[i]);
            sceneMostra->addItem(conjuntMostra->arrayPeces[i]);
            }
        //Cal posar això aqui degut a que cal tenir les dades
        //de l'scene!!
        // conjuntJoc->colocaPecesAtzar();
        //20/02/11 Inicialment, les peces es col·loquen
        //formant la figura inicial
        figuraInicialTangram(tipusTangram);
        //Carregam l'arbre de figures
        carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
        }
}//final formulariPrincipal::creaTangram(int tipusTangram)

/* 20/02/11
  Col·loca les peces en la figura
  "inicial" del tangram*/
void formulariPrincipal::figuraInicialTangram(int tipusTangram){
    //NOU TANGRAM 2
    QStringList dadesFiguraInicial;
    dadesFiguraInicial.append("55.0 4 26 78 3.9269908169872414 0 5 137 58 -0.7853981633974483 0 2 40 142 2.356194490192345 0 4 78 26 5.497787143782138 0 2 105 77 7.0685834705770345 0 1 79 116 -0.7853981633974483 0 3 130 129 4.71238898038469 0");
    //tangram clàssic                                       codi 1
    dadesFiguraInicial.append("55.0 6 28 83 -1.5707963267948966 0 6 83 28 0.0 0 4 128 74 4.71238898038469 0 7 82 138 -0.7853981633974483 1 2 147 147 4.71238898038469 0");
    //Tangram 5                                                 codi 2
    dadesFiguraInicial.append("58 10 18.2276 18.2277 1.5708 0 3 136.707 54.6829 4.71239 0 3 54.683 136.707 4.71239 0 11 91.1382 36.4553 1.5708 0 8 123.037 123.037 3.14159 0 9 27.3415 82.0244 -0.785398 0");
    //Tangram 6 I                                           codi 3
    dadesFiguraInicial.append("55.0 8 39 118 1.5707963267948966 1 12 117 79 -1.5707963267948966 1 3 130 131 0.0 1 3 26 53 1.5707963267948966 1 1 78 40 2.356194490192345 1 2 39 14 0.7853981633974483 1 2 117 14 0.7853981633974483 1");
    //Tangram de Fletcher (Pitàgores)                      codi 4
    dadesFiguraInicial.append("58 3 27.3416 27.3415 1.5708 0 3 136.707 27.3415 3.14159 0 13 20.5061 102.531 5.49779 0 14 123.037 82.0244 -8.63938 1 15 143.543 164.049 1.5708 0 15 20.5061 164.049 -1.5708 1 16 82.0244 143.543 3.14159 0");
    //Tangram del xinès també Tangram Pitagòric    codi 5
    dadesFiguraInicial.append("58 1 82.0244 41.0122 -0.785398 0 2 123.037 13.6708 5.49779 0 3 136.707 136.707 4.71239 0 3 27.3415 27.3415 1.5708 0 5 61.5183 143.543 -0.785398 1 13 20.5061 102.531 5.49779 0 17 123.037 82.0244 -0.785398 0");
    //Tangram de la saviesa Chie-No-Ita                   codi 6
    dadesFiguraInicial.append("58 1 29 145 2.18557e-08 0 2 19.3333 19.3334 1.5708 0 2 19.3333 96.6667 -5.01216e-09 0 3 77.3334 58 3.92699 0 3 38.6667 58 0.785398 0 3 116 19.3334 5.49779 0 13 87 116 -1.5708 1 14 145 87 -10.9956 1");
    //Tangram 8                                         codi 7
    dadesFiguraInicial.append("58 18 123.037 47.3568 -1.0472 0 18 82.0244 165.749 -1.19209e-07 0 18 41.0122 189.427 3.14159 0 19 191.39 189.427 3.14159 0 19 95.6951 118.392 3.14159 1 19 218.732 189.427 3.14159 1 19 68.3536 118.392 3.14159 0 20 143.543 106.553 4.18879 1 20 143.543 177.588 2.0944 0");
    //Tangram 9                                codi 8
    dadesFiguraInicial.append("55.0 17 28 111 1.5707963267948966 0 21 87 83 -1.5707963267948966 0 21 119 138 1.5707963267948966 0 23 79 179 1.5707963267948961 1 22 119 193 -1.5707963267948966 0 22 87 28 1.5707963267948966 0 23 127 42 4.71238898038469 1 2 169 65 5.551115123125783E-17 0 1 179 111 0.0 0 2 170 157 1.5707963267948966 0");
    //Tangram 10                              codi 9
    dadesFiguraInicial.append("58 23 150.688 58.8657 2.61799 0 23 100.459 29.8657 2.61799 0 23 50.2295 58.8657 -0.523599 0 22 184.508 29.2886 -0.523599 0 22 83.5492 87.5771 1.5708 0 22 16.9098 29.5771 0.523599 0 22 184.508 87.8657 3.66519 0 24 33.4863 97.5323 -1.5708 0 24 133.945 97.5324 -1.5708 0 25 50.7293 10.2438 0 1 25 151.188 10.2438 0 0");
    //Tangram 11                        codi 10
    dadesFiguraInicial.append("58 1 147.644 98.4295 0.785398 0 2 98.4294 32.8098 2.35619 0 2 98.4291 65.6197 5.49779 0 2 32.8098 98.4294 0.785401 0 3 164.049 164.049 -3.33285e-06 1 13 73.8221 123.037 -2.35619 1 15 24.6075 49.2149 1.57079 1 26 180.454 16.405 3.14159 0 26 16.4052 180.454 1.57079 1 26 65.6196 16.405 3.14159 1 27 36.9114 159.948 0.785398 1 27 159.947 36.9111 3.92699 0");
    //Tangram rus                         codi 11
    dadesFiguraInicial.append("55.0 2 39 143 2.356194490192345 0 2 78 130 5.497787143782138 0 2 117 143 2.356194490192345 0 2 143 117 7.0685834705770345 0 2 78 104 2.356194490192345 0 2 13 117 3.9269908169872414 0 1 39 78 3.9269908169872414 0 1 78 39 3.9269908169872414 0 2 143 39 7.0685834705770345 0 2 117 13 5.497787143782138 0 2 13 39 3.9269908169872414 0 2 39 13 5.497787143782138 0 1 117 78 3.9269908169872414 0");
    //Tangram 13                               codi 12
    dadesFiguraInicial.append("58 1 29 29 3.14159 1 1 145 203 -1.5708 1 2 77.3333 19.3334 3.14159 1 2 19.3333 96.6667 1.5708 1 2 193.333 212.667 1.5708 1 2 135.333 135.333 3.14159 1 3 212.667 174 2.35619 1 3 96.6667 58 2.35619 1 4 77.3334 154.667 -1.5708 1 4 38.6667 193.333 1.5708 1 4 193.333 77.3334 5.01216e-09 1 4 154.667 38.6667 3.14159 1 5 58 87 3.14159 1 5 174 145 0 0");
    //Tangram 14                             codi 13
    dadesFiguraInicial.append("55.0 28 186 74 3.141592653589784 1 30 122 52 4.031710572106918 1 29 76 89 -0.680678408277775 1");
    //Tangram de Brügner                                         codi 14
    dadesFiguraInicial.append("58 31 173.473 100.977 5.23599 1 32 29 100.977 5.23599 1 21 115.473 33.4863 2.0944 1 34 145 185.341 1.0472 1 35 85.9455 151.595 0 1 36 64.8545 63.0136 1.0472 1");
    //Tangram Hexagrama                                 codi 15
    dadesFiguraInicial.append("58 37 45.9878 157.012 3.92699 0 37 128.012 157.371 2.35619 1 38 74.9878 203.358 0.785398 0 38 99.0122 203.358 1.48578e-08 0 39 58 116.358 -1.5708 1 39 116 116.358 1.5708 0 40 117.759 56.5993 -2.35619 0 40 56.2409 56.2409 2.35619 0 41 87 75.3463 3.14159 0");
    //Tangram de l'ou                          codi 16
    dadesFiguraInicial.append("58 42 41.8244 30.6586 5.49779 0 42 14.483 58 3.92699 0 42 150.92 57.1878 0.785398 0 43 137.519 24.9959 3.92699 0 43 110.178 24.9959 3.14159 0 13 103.343 119.518 5.49779 0 1 82.8366 58 3.92699 0 2 28.1537 99.0122 0.785398 0 5 62.3305 119.518 3.92699 1");
    //Tangram del cor                             codi 17
    dadesFiguraInicial.append("58 44 174.352 107.124 -1.7308e-08 1 46 174.352 64.9424 1.5708 1 55 142.715 144.033 3.14159 0 45 147.988 21.7061 4.05327e-08 1 47 105.806 28.0333 1.5708 0 54 95.2606 41.7424 3.14159 1 48 42.5333 11.1606 7.04857e-08 0 51 10.897 74.4333 4.71239 1 52 31.9879 95.5242 4.71239 1 45 42.5333 170.397 3.14159 1 48 53.0788 118.724 1.5708 1 53 86.8242 128.215 -3.94854e-08 1 49 116.352 117.67 -1.5708 0 50 132.17 86.0333 3.94854e-08 1");
    ///Tangram Stomachion o Luculus Archimedius                              codi 18
    dadesFiguraInicial.append("58 56 87 140.024 -4.74932e-07 0 2 19.3335 202.715 -5.41454e-07 0 58 49.5062 172.543 2.35619 1 59 29.0001 82.0244 3.14159 1");
    //Tangram de 4 peces I                                     codi 19
    dadesFiguraInicial.append("58 60 96.6668 77.3333 -1.5708 0 60 135.333 77.351 1.5708 1 60 96.6666 154.667 4.71239 1 60 135.333 154.684 1.5708 0 61 212.666 82.5311 -1.57079 0 61 212.666 149.504 4.71239 1 62 135.333 43.8647 4.71239 0 62 135.333 188.171 -1.5708 1 63 57.9999 57.9999 1.5708 1 63 58 174 1.5708 0");
    //Tangram circular I                   codi 20
    dadesFiguraInicial.append("58 21 58.0003 66.9729 -1.0472 0 21 116 33.4866 2.0944 0 24 164.333 150.688 2.0944 0 24 154.667 100.459 -1.0472 0 64 116 171.918 2.43431e-07 0 65 188.5 75.3446 1.0472 1 66 58.0001 133.946 3.14159 1");
    //Tangram 7 I                                    codi 21
    dadesFiguraInicial.append("58 22 58.0002 84.049 3.14159 0 64 58.0001 121.689 8.29453e-07 1 65 116 100.459 1.0472 0 67 106.333 33.4863 2.0944 0 67 20.4523 83.7161 3.14159 1 67 154.667 83.7159 3.14159 0 68 50.75 37.6721 1.0472 0 69 87.5595 175.642 3.14159 1");
    //Tangram circular de 8 peces CII             codi 22
   // dadesFiguraInicial.append("58 22 58.0002 84.049 3.14159 0 64 58.0001 121.689 8.29453e-07 1 65 116 100.459 1.0472 0 67 106.333 33.4863 2.0944 0 67 20.4523 83.7161 3.14159 1 67 154.667 83.7159 3.14159 0 68 50.75 37.6721 1.0472 0 69 87.5595 175.642 3.14159 1");
    dadesFiguraInicial.append("58 1 41.0122 82.0244 0.785398 0 5 102.531 20.5061 2.35619 1 3 27.3415 27.3415 1.5708 0 70 147.644 123.037 8.17162e-08 0 71 123.037 65.6195 4.71239 1 72 41.0122 147.644 1.5708 0");
    //Tangram 6 II                                         codi 23
    dadesFiguraInicial.append("58 1 82.0244 41.0127 2.35619 0 5 61.5183 102.53 3.92699 0 3 136.707 27.342 3.14159 0 2 13.6708 123.037 3.92699 0 70 16.4051 41.0123 3.14159 0 13 143.543 102.53 0.785398 1 73 82.0244 143.543 -3.17868e-09 0");
    //Tangram 7 II Revathi                               codi 24
    dadesFiguraInicial.append("58 3 136.707 27.3415 3.14159 0 3 27.3415 136.707 -1.83826e-07 0 13 102.531 143.543 3.92699 0 16 41.0122 61.5184 -5.41454e-07 0 12 123.037 82.0244 1.5708 0");
    //Tangram 5 I Regulus                                    codi 25
    dadesFiguraInicial.append("58 3 27.3418 27.3416 1.5708 0 3 136.707 136.707 4.71239 0 13 61.5186 143.543 2.35619 1 2 123.037 13.6709 5.49779 0 12 41.0125 82.0245 1.5708 1 5 102.53 61.5184 0.785398 1 5 143.543 61.5184 2.35619 0");
    //Tangram 7 Heptex                                    codi 26
    dadesFiguraInicial.append("58 78 92.1242 92.5396 1.09956 0 74 128.48 12.6447 -0.471237 0 75 122.275 153.54 5.91034e-07 1 76 165.208 55.3015 1.09956 0 77 18.3412 74.0608 1.5708 0");
    //Tangram de Sam Lloyds                                codi 27
    dadesFiguraInicial.append("58 79 141.375 56.5082 2.0944 0 79 119.625 131.852 -2.0944 0 80 179.437 28.2541 -1.0472 0 80 65.25 56.5082 3.14159 0 81 210.25 138.131 3.66519 1 82 29 100.459 1.5708 1 83 239.25 87.9016 2.0944 1 84 168.562 103.598 1.0472 0 84 92.4375 103.598 -1.0472 0");
    //Tangram "los nueve tangram"              codi 28
    dadesFiguraInicial.append("58 74 122.968 92.1677 -2.04203 0 74 128.478 12.645 -0.471239 0 74 56.3216 172.154 2.67035 0 74 12.6449 56.3216 -2.04204 0 74 172.154 128.478 1.09956 0 76 19.3154 129.638 -2.04203 0 76 129.638 165.484 2.67035 0 76 92.3997 92.3996 1.09956 0 76 165.484 55.1617 1.09956 0 76 55.1616 19.3154 -0.471236 0");
    //Tangram Egipci                       codi 29
    dadesFiguraInicial.append("58 3 136.707 27.3415 3.14159 0 85 61.5183 41.0122 3.14159 1 85 123.037 102.53 -1.5708 0 86 61.5183 102.53 -4.76837e-07 0");
    //Tangram de 4 peces II                                    codi 30
    dadesFiguraInicial.append("58 3 156.601 191.4 2.35619 0 74 130.501 165.3 5.49779 1 87 78.3006 182.7 2.35619 1 88 60.9 8.70023 2.35619 1 89 139.2 11.6002 3.14159 1 90 174 58.0002 2.35619 0 90 139.2 46.4003 -0.785398 0 91 87.0002 63.8003 0.785398 1 91 17.4002 40.6002 3.92699 1 91 17.4008 168.201 -0.785398 0 92 52.2003 104.4 0.785398 1 93 17.4008 133.401 3.92699 1 94 156.6 133.4 0.785398 0 95 191.4 121.8 2.35619 1");
    //Tangram Stomachion rectangular                                          codi 31
    dadesFiguraInicial.append("58 54 64.4789 119.625 -1.07875e-06 1 45 21.9455 53.1671 -1.5708 0 46 160.179 31.9001 3.14159 0 47 138.912 153.845 1.5708 0 48 138.912 106.334 -1.67933e-07 0 46 128.279 175.451 3.14159 1 76 48.1893 143.212 -2.38419e-07 0 90 86.3487 21.4178 3.14159 1 53 128.279 71.7754 1.5708 0 45 170.812 138.234 1.5708 0 48 53.8456 85.067 3.14159 0");
    //Tangram Stomach (modificació de Stomachion)                                                   codi 32
    dadesFiguraInicial.append("58 15 43.5 159.5 2.35619 1 15 130.5 14.5 -0.785398 1 15 159.5 130.5 0.785398 1 15 14.5 43.5 -2.35619 1 3 58 19.3334 5.49779 0 3 154.667 58 2.35619 1 3 19.3333 116 -0.785398 1 3 87 67.6667 2.35619 0 3 116 154.667 2.35619 0 3 87 106.333 5.49779 0");
    //Tangram Elzzup (10 peces)                  codi 33
    dadesFiguraInicial.append("58 31 174.577 100.459 1.0472 0 32 160.077 226.033 4.18879 1 34 29.2886 284.466 1.0472 0 35 87.5772 251.147 3.14159 0 36 174.577 276.261 3.14159 0 21 116.577 167.431 1.0472 0 33 268.827 213.475 1.0472 0 57 225.327 238.59 1.0472 1");
    //Tangram dels vuit elements (8 peces)         codi 34
    dadesFiguraInicial.append("58 1 130.5 43.5003 5.96046e-08 0 2 29.0002 116 1.5708 0 2 29.0001 58.0002 -3.27826e-07 0 2 58.0001 29.0002 3.14159 0 3 203 87.0003 3.92699 0 13 87.0001 130.5 3.27826e-07 0 15 282.75 152.25 3.92699 0 26 217.5 159.5 2.35619 0 96 261 72.5 -3.57628e-07 0 96 275.5 87 1.5708 0 97 261 32.625 -5.96046e-08 0 97 315.375 87 1.5708 0");
    //Tangram de 12 peces         codi 35
    dadesFiguraInicial.append("58 3 154.667 116 0.785398 0 1 29.0001 145 1.5708 0 16 130.5 43.5 3.92699 0 4 38.6669 38.6667 1.5708 0 98 87.0003 116 3.14159 1");
    //Tangram 5 II         codi 36
    dadesFiguraInicial.append("58 3 150.378 27.3415 1.5708 0 3 177.719 136.707 4.71239 0 13 102.531 61.5185 2.35619 0 14 164.049 82.0245 5.49779 0 15 41.0125 61.5187 3.14159 0 15 41.0122 102.53 1.49012e-07 1 99 41.0125 20.5067 -5.36442e-07 0 99 41.0122 143.543 3.14159 1");
    //Tangram Armonigrama         codi 37
    dadesFiguraInicial.append("58 3 226.2 125.668 2.35619 0 3 150.8 100.534 5.49779 0 13 75.4 37.7008 -3.27826e-07 1 1 37.7002 113.101 1.5708 0 2 276.467 25.1338 3.14159 0 2 276.466 100.534 -1.5708 1 2 100.533 125.667 -8.9407e-08 0 12 188.5 37.7003 3.92699 0");
    //Tangram rectangular         codi 38
    conjuntJoc->colocaPeces(dadesFiguraInicial.value(tipusTangram-1));
    angleGirConjuntPecesJoc();
}


/*
  Slots de nivell de Joc
*/
void formulariPrincipal::nivellInfantilSlot(){
    canviaNivellJoc(NIVELL_INFANTIL);
}
void formulariPrincipal::nivellPrincipiantSlot(){
    canviaNivellJoc(NIVELL_PRINCIPIANT);
}
void formulariPrincipal::nivellIniciatSlot(){
    canviaNivellJoc(NIVELL_INICIAT);
}
void formulariPrincipal::nivellExpertSlot(){
    canviaNivellJoc(NIVELL_EXPERT);
}
//Fa els canvis de nivell de joc
void formulariPrincipal::canviaNivellJoc(int pnivellJoc){
 //només es mouran les peces si el canvi de nivell és
 //cap avall
 bool pecesAtzar=false;
 if (nivellJocActual !=pnivellJoc){
     if (nivellJocActual>pnivellJoc){pecesAtzar=true;}
   canviaEstatDelJoc(Inactiu);
   nivellJocActual=pnivellJoc;
   pecaSeleccionadaNivellInfantil=-1;
   configuracioJoc->canviaNivellJoc(pnivellJoc);
   nomFiguraPerCercar.clear();
   indexFiguraPerCercar=0;
   conjuntMostra->conjuntVisible(false);
   conjuntFigura->conjuntVisible(false);

   /* 4.0.2 21/12/10 Nou procediment */
   angleGirConjuntPecesJoc();
   if (pecesAtzar) {conjuntJoc->colocaPecesAtzar();}
   carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
  }
}

/*
  Estableix l'angle de gir de les peces del conjunt conjuntJoc
  Assegurant que és l'adequat al nivell de jo actual
  */
void formulariPrincipal::angleGirConjuntPecesJoc(){
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
       conjuntJoc->arrayPeces[i]->estableixAngleGirPeca(configuracioJoc->angleGir);
       }
}

void formulariPrincipal::actualitzaPuntuacio(int numFig,int afegeixPunts){
configuracioJoc->comptadorFigures=configuracioJoc->comptadorFigures+numFig;
configuracioJoc->comptadorPunts=configuracioJoc->comptadorPunts+afegeixPunts;
numFigures->setText(configuracioJoc->tradueixCadena("Figures")+
                       QString(" %1").arg(configuracioJoc->comptadorFigures ));
punts->setText(configuracioJoc->tradueixCadena("Punts") +
                       QString(" %1").arg(configuracioJoc->comptadorPunts ));
desaContadors();
}

void formulariPrincipal::carregaContadors(){
   //Actualitzam els comptadors amb la puntuació prèvia      
   configuracioJoc->carregaPuntuacio();
   rellotgeLabel->estableixTemps(configuracioJoc->temps);
   numFigures->setText(configuracioJoc->tradueixCadena("Figures")+
                       QString(" %1").arg(configuracioJoc->comptadorFigures ));
   punts->setText(configuracioJoc->tradueixCadena("Punts") +
                  QString(" %1").arg(configuracioJoc->comptadorPunts ));
}

void formulariPrincipal::desaContadors(){
  configuracioJoc->desaPuntuacio(rellotgeLabel->retornaTemps(1));
}

void formulariPrincipal::reiniciaContadors(){
    actualitzaPuntuacio(-configuracioJoc->comptadorFigures,
                        -configuracioJoc->comptadorPunts);
    rellotgeLabel->estableixTemps("00:00:00");
}

 void formulariPrincipal::closeEvent(QCloseEvent *event){
   desaContadors();
   desaFiguresResoltes();
   configuracioJoc->configArxiu->setValue(
           QString("General/amplada"),this->width());
   configuracioJoc->configArxiu->setValue(
           QString("General/alt"),this->height());
   event->accept();
 }

void formulariPrincipal::carregaFiguresResoltes(){
QString nomArxiu=nomArxiuFiguresResoltes();
QDir dirArxiu;
 if (dirArxiu.exists(nomArxiu)){
     QFile arxiu(nomArxiu);
     if (arxiu.open(QFile::ReadOnly | QFile::Text)){
        QTextStream lectura(&arxiu);
        QString linia0 = lectura.readLine();
        while (!linia0.isNull()) {
            figuresResoltesList->append(linia0);
            linia0 = lectura.readLine();
     }
     }
 }
figuresResoltesList->sort();
}

void formulariPrincipal::desaFiguresResoltes(){
QString nomArxiu=nomArxiuFiguresResoltes();
QDir dirArxiu;
 if (dirArxiu.exists(nomArxiu)){
    dirArxiu.remove(nomArxiu);
}

if (figuresResoltesList->size()<1){
    return;
}
     QFile arxiu(nomArxiu);
     if (arxiu.open(QFile::WriteOnly | QFile::Text)){
     QTextStream entrada(&arxiu);
        for(int i=0;i<=figuresResoltesList->size()-1;i++){
            entrada<<(QString("%1\n").arg(figuresResoltesList->value(i)));
     }
  arxiu.close();
   }
 }

void formulariPrincipal::eliminaFiguresResoltes(int tipus){
    switch(tipus){
        //elimina tot
        case 0:
          figuresResoltesList->clear();
        break;
        //nomès elimina les corresponents al tipusTangram i nivell actual
        case 1:
            QString nom=QString("%1;%2;").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc);
            QRegExp reg(nom+"*",Qt::CaseSensitive,QRegExp::Wildcard);
            while (figuresResoltesList->indexOf(reg)>-1){
                figuresResoltesList->removeAt(figuresResoltesList->indexOf(reg));
            }
        break;
    }
}

//Comprova si el nom de la figura passada per paràmetre
//està a la llista de figures resoltes
bool formulariPrincipal::figuraJaResolta(QString nomFigura){
 QString nom=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).arg(nomFigura);
 //return (figuresResoltesList->indexOf(nom)>-1);
 /*4.0.2
 Canviat degut a que s'ha afegit les dades de la posició de les peces
 Ara no es pot fer servir el caràcter ? en el nom de les figures
 */
 QRegExp rx(nom+"*");
 rx.setPatternSyntax(QRegExp::Wildcard);
 return (figuresResoltesList->indexOf(rx)>-1);
}

//Comprova si el nom de la figura passada per paràmetre
//ja està resolta i, en cas positiu, retorna
//la cadena amb la posició de les peces
QString formulariPrincipal::figuraJaResoltaPosicioPeces(QString nomFigura){
    if (figuraJaResolta(nomFigura)){
    QString nom=QString("%1;%2;%3").arg(configuracioJoc->tipusTangram).arg(configuracioJoc->nivellJoc).arg(nomFigura);
    QRegExp rx(nom+";*");
    rx.setPatternSyntax(QRegExp::Wildcard);
    QString dadesFigura=figuresResoltesList->value(figuresResoltesList->indexOf(rx));
    QStringList dadesFiguraList=dadesFigura.split(";");
    return dadesFiguraList.value(3);
    }
 return QString("");
}

QString formulariPrincipal::nomArxiuFiguresResoltes(){
    QString directoriHomeConfig = QFileInfo(
            configuracioJoc->configArxiu->fileName()).absolutePath();
    QString nomArxiu=directoriHomeConfig+
                     charPathSeparator+"figres.fig";
return nomArxiu;
}

/*
  Ajuda per resoldre les figures
*/
void formulariPrincipal::mostraSolucioSlot(){
 canviaEstatDelJoc(MostraSolucio);
}

void formulariPrincipal::colocaPecaSlot(){
    configuracioJoc->colocaPeca=!configuracioJoc->colocaPeca;
    colocaPecaAction->setChecked(configuracioJoc->colocaPeca);
}


void formulariPrincipal::colocaPeca(int indexPecaAColocar){
 for(int i=0;i<=conjuntFigura->arrayPeces.size()-1;i++){
     if (conjuntJoc->arrayPeces[indexPecaAColocar]->tipusPeca==
         conjuntFigura->arrayPeces[i]->tipusPeca){
         if(!pecaJaColocada(i)){
             colocaPeca(indexPecaAColocar,i);
             break;
         }
     }
  }
}

/*
  En el nivell infantil, si es col·loca el centre de la peça dins
  de la silueta, llavors el programa col·loca automàticament
  la peça a la seva posició
  */
bool formulariPrincipal::colocaPecaNivellInfantil(int indexPeca){
QPointF centrePeca=conjuntJoc->arrayPeces[indexPeca]->pos()+
                   conjuntJoc->arrayPeces[indexPeca]->centrePeca();
bool resultat= false;
for(int j=0;j<=conjuntFigura->arrayPeces.size()-1;j++){
   if(conjuntFigura->arrayPeces[j]->shape().contains(centrePeca-
                                                     conjuntFigura->arrayPeces[j]->pos())){
       resultat= true;
    }
}
return resultat;
}
/*
  Comprovam si en el conjuntJoc ja hi ha una peça que te les
  mateixes propietats que la peça que volem col·locar
  */
bool formulariPrincipal::pecaJaColocada(int indexPecaAColocar){
bool resultat=false;
 QVector<QPointF> pSolucio;
    conjuntFigura->arrayPeces[indexPecaAColocar]->puntsSolucio(pSolucio,0.9);

int coincidencies=0;
   for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
      for(int j=0;j<=pSolucio.size()-1;j++){
      if(conjuntJoc->arrayPeces[i]->shape().contains(
         pSolucio.value(j)-conjuntJoc->arrayPeces[i]->pos())){
            coincidencies=coincidencies+1;
        }
     }
     if (coincidencies>=pSolucio.size()-1){
       resultat=true;
       break;
     }
     else coincidencies=0;
   }
return resultat;
}

void formulariPrincipal::colocaPeca(int indexPecaAColocar,int pecaFigura){

conjuntJoc->arrayPeces[indexPecaAColocar]->reiniciaAnglesVertex();

 if(!conjuntJoc->arrayPeces[indexPecaAColocar]->simetriaBool==
   conjuntFigura->arrayPeces[pecaFigura]->simetriaBool){
    conjuntJoc->arrayPeces[indexPecaAColocar]->simetriaPeca();
   }
 conjuntJoc->arrayPeces[indexPecaAColocar]->setPos(
      conjuntFigura->arrayPeces[pecaFigura]->pos());
  conjuntJoc->arrayPeces[indexPecaAColocar]->setAngleRotacio(
      conjuntFigura->arrayPeces[pecaFigura]->anglesVertex[0]-
      conjuntFigura->arrayPeces[pecaFigura]->angleInicial);

conjuntJoc->arrayPeces[indexPecaAColocar]->setSelected(false);
}

/*
Creació de noves figures
*/
void formulariPrincipal::comprovaMostraSlot(){
    conjuntFigura->colocaPeces(conjuntJoc->coordenadesFigura());
    //colocam el conjunt al vertex sup.esq per a què es vegi millor
    //(enlloc de centrat);
    conjuntFigura->recolocaPeces(QPointF(50,50));
    conjuntFigura->conjuntVisible(true);
    conjuntFigura->conjuntDeMostra();
    conjuntMostra->colocaPeces(conjuntJoc->coordenadesFigura());
    conjuntMostra->conjuntVisible(true);
    conjuntMostra->conjuntDeMostra();
    sceneJoc->update();
}

void formulariPrincipal::esborraMostraSlot(){
    conjuntFigura->conjuntVisible(false);
    conjuntMostra->conjuntVisible(false);
    missatgeStatusBar("");
}
void formulariPrincipal::desaFiguraSlot(){
     DesaFigura desaFiguraFormulari(configuracioJoc,this);
     //passam les dades de la figura al formulari
     desaFiguraFormulari.dadesFigura.append(conjuntJoc->coordenadesFigura());
     desaFiguraFormulari.exec();
}
void formulariPrincipal::simetriaVerticalSlot(){
    conjuntJoc->simetriaVertical();
}
void formulariPrincipal::simetriaHoritzontalSlot(){
    conjuntJoc->simetriaHoritzontal();
}

void formulariPrincipal::cercaFiguraSlot(){
 if (arbreFiguresTreeWidget->topLevelItem(0)==0){ return;}

    QProgressDialog progres(
            configuracioJoc->tradueixCadena("Cercant.figura")+"...",
            configuracioJoc->tradueixCadena("Atura.cerca"), 0,
            arbreFiguresTreeWidget->topLevelItem(0)->childCount(), this);

   progres.setWindowModality(Qt::WindowModal);

missatgeStatusBar("");
float resultat;
figuresSemblantsList->clear();
    conjuntJoc->centraFiguraScene();
    conjuntFigura->conjuntDeMostra();
    conjuntFigura->conjuntVisible(true);
    for(int i=0;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
      //el formulari genera un missatge d'error
      //a la consola (comunicat a Qt)
      progres.setValue(i+1);
      conjuntFigura->colocaPeces(arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(1));
      //això per evitar que quedin "rastres"
      sceneJoc->update();
      resultat=figuraSolucionada();
      if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
          afegeixFiguraSemblant(resultat,i);
      }
      else {
          conjuntFigura->simetriaHoritzontal();
          //això per evitar que quedin "rastres"
          sceneJoc->update();
          resultat=figuraSolucionada();
          if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
              afegeixFiguraSemblant(resultat,i);
          }
          else {
              conjuntFigura->simetriaVertical();
             //això per evitar que quedin "rastres"
             sceneJoc->update();
              resultat=figuraSolucionada();
              if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                  afegeixFiguraSemblant(resultat,i);
              }
              else {
                  conjuntFigura->simetriaHoritzontal();
                 //això per evitar que quedin "rastres"
                 sceneJoc->update();
                  resultat=figuraSolucionada();
                  if (resultat>=PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA){
                    //Aquesta linea fa que algunes vegades, la cerca s'aturi abans d'acabar
                    //  if (arbreFiguresTreeWidget->headerItem()->childCount()<1){ return;}
                      afegeixFiguraSemblant(resultat,i);
                  }
              }
          }
      }

  if (progres.wasCanceled())  break;
  }//for

sceneJoc->update();
if (figuresSemblantsList->size()>0){
    indexLlistaFiguraSemblant=0;
    figuresSemblantsList->sort();
    figuraSeguentAction->setEnabled(true);
    figuraAnteriorAction->setEnabled(true);
    mostraFiguraSemblant(0);
QMessageBox::information(this, configuracioJoc->tradueixCadena("Cerca.figura"),
                    configuracioJoc->tradueixCadena("msg.FiguraTrobada").arg(figuresSemblantsList->size()));
}
else {conjuntFigura->conjuntVisible(false);
QMessageBox::information(this, configuracioJoc->tradueixCadena("Cerca.figura"),
                    configuracioJoc->tradueixCadena("msg.FiguraNoTrobada"));
}

}


//Afegeix a la llista de figures semblants (creació de figures)
//les dades d'una figura
void formulariPrincipal::afegeixFiguraSemblant(float percentatge,int index){
    QString Missatge;
    Missatge.append(QString("%1;").arg(100-percentatge));
    Missatge.append(QString(arbreFiguresTreeWidget->topLevelItem(0)->child(index)->text(0)));
    Missatge.append(QString(" "));
    Missatge.append(QString("( %1 % ) ;").arg(percentatge));
    Missatge.append(arbreFiguresTreeWidget->topLevelItem(0)->child(index)->text(1));
    figuresSemblantsList->append(Missatge);
}

void formulariPrincipal::figuraSeguentSlot(){
  if (indexLlistaFiguraSemblant<figuresSemblantsList->size()-1){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant+1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);      
      //això per evitar que quedin "rastres"
      sceneJoc->update();
  }
}
void formulariPrincipal::figuraAnteriorSlot(){
  if (indexLlistaFiguraSemblant>0){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant-1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);
      //això per evitar que quedin "rastres"
      sceneJoc->update();
  }
}

void formulariPrincipal::mostraFiguraSemblant(int index){
if (index>-1 && index<=figuresSemblantsList->size()-1) {
  QStringList list1 = figuresSemblantsList->value(index).split(";");
  conjuntFigura->colocaPeces(list1.value(2));
  //colocam el conjunt al vertex sup.esq per a què es vegi millor
  //(enlloc de centrat);
  conjuntFigura->recolocaPeces(QPointF(10,10));
  conjuntFigura->colorPecesConjunt(Qt::black);
  conjuntFigura->conjuntVisible(true);
  missatgeStatusBar(list1.value(1));
 }
}

/*
 Gestió de concurs
*/
void formulariPrincipal::creaConcursSlot(){
CreaConcurs concurs(configuracioJoc,this);
concurs.exec();
}

void formulariPrincipal::carregaConcursSlot(){

QString directoriSeleccionat = QFileDialog::getOpenFileName(this,
                                 configuracioJoc->tradueixCadena("Carrega.concurs"),
                                 directoriFiguresPersonals(),
                                 filtreArxiusConcurs(configuracioJoc) );
    if(!directoriSeleccionat.isEmpty()){
        carregaArbreFigures(directoriSeleccionat);
        canviaEstatDelJoc(Inactiu);        
        configuracioJoc->desaRecords=false;
        reiniciaContadors();
    }
}


void formulariPrincipal::tradueixGUI(){
   setWindowTitle("Peces (" + configuracioJoc->tradueixCadena("Jocs.tangram")+")");

   surtAction->setText(configuracioJoc->tradueixCadena("&Surt")) ;

   elimnaRecordAction->setText(configuracioJoc->tradueixCadena("Elimina.record"));
   eliminaTotsRecordsAction->setText(configuracioJoc->tradueixCadena("Elimina.tots.records"));

    carregaFiguresProgramaAction->setText(configuracioJoc->tradueixCadena("carrega.figures.paquet"));
    carregaFiguresArxiuAction->setText(configuracioJoc->tradueixCadena("carrega.dades.figures.arxiu"));

   mostraSolucioAction->setText(configuracioJoc->tradueixCadena("Mostra.solucio"));
   colocaPecaAction->setText(configuracioJoc->tradueixCadena("Coloca.peca"));
   // 13/02/11
   tradueixNomsJocsTangram();

    nivellInfantilAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_INFANTIL));
    nivellPrincipiantAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_PRINCIPIANT));
    nivellIniciatAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_INICIAT));
    nivellExpertAction->setText(configuracioJoc->tradueixCadena(NOM_NIVELL_EXPERT));

    creaFiguraMenu->setTitle(configuracioJoc->tradueixCadena("crea.nova.figura"));
    comprovaMostraAction->setText(configuracioJoc->tradueixCadena("comprova.mostra"));
    esborraMostraAction->setText(configuracioJoc->tradueixCadena("esborra.mostra"));
    desaFiguraAction->setText(configuracioJoc->tradueixCadena("desa.dades.figura"));
    simetriaVerticalAction->setText(configuracioJoc->tradueixCadena("Simetria.vertical"));
    simetriaHoritzontalAction->setText(configuracioJoc->tradueixCadena("Simetria.horitzontal"));
    cercaFiguraAction->setText(configuracioJoc->tradueixCadena("Cerca.figura"));    
    figuraSeguentAction->setText(configuracioJoc->tradueixCadena("seguent.figura"));
    figuraAnteriorAction->setText(configuracioJoc->tradueixCadena("anterior.figura"));

    aplicacioMenu->setTitle(configuracioJoc->tradueixCadena("Programa"));

    jocMenu->setTitle(configuracioJoc->tradueixCadena("Joc"));
    jocsTangramMenu->setTitle(configuracioJoc->tradueixCadena("Jocs.tangram"));

    proposaFigura->setText(configuracioJoc->tradueixCadena("Proposa.figura"));


    cercaNomFigura->setText(configuracioJoc->tradueixCadena("cerca.nom.figura"));
    continuaCercaNomFigura->setText(configuracioJoc->tradueixCadena("continua.cerca.nom.figura"));

    //Concurs
    concursMenu->setTitle(configuracioJoc->tradueixCadena("Concurs"));
    creaConcursAction->setText(configuracioJoc->tradueixCadena("Crea.concurs"));
    carregaConcursAction->setText(configuracioJoc->tradueixCadena("Carrega.concurs"));;

    idiomaMenu->setTitle(configuracioJoc->tradueixCadena("idioma"));
    /*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
    */

ajudaMenu->setTitle(configuracioJoc->tradueixCadena("Ajuda"));
    ajuda->setText(configuracioJoc->tradueixCadena("Ajuda"));
    webPrograma->setText(configuracioJoc->tradueixCadena("Web.programa"));
    creditsPrograma->setText(configuracioJoc->tradueixCadena("Credits"));
    colaboraPrograma->setText(configuracioJoc->tradueixCadena("Colabora"));


    actualitzaPuntuacio(0,0);
    carregaArbreFigures(configuracioJoc->directoriArxiuDadesFigures);
}


void formulariPrincipal::creaAcccions()
{
    surtAction = new QAction(configuracioJoc->tradueixCadena("&Surt"), this);
    surtAction->setShortcut(tr("Ctrl+S"));
    surtAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"surt.png"));
    connect(surtAction, SIGNAL(triggered()), this, SLOT(close()));

    elimnaRecordAction= new QAction(configuracioJoc->tradueixCadena("Elimina.record"), this);
    connect(elimnaRecordAction, SIGNAL(triggered()), this, SLOT(eliminaRecordSlot()));

    eliminaTotsRecordsAction= new QAction(configuracioJoc->tradueixCadena("Elimina.tots.records"), this);
    connect(eliminaTotsRecordsAction, SIGNAL(triggered()), this, SLOT(eliminaTotsRecordsSlot()));

    carregaFiguresProgramaAction= new QAction(configuracioJoc->tradueixCadena("carrega.figures.paquet"), this);
    connect(carregaFiguresProgramaAction, SIGNAL(triggered()), this, SLOT(carregaFiguresProgramaSlot()));

    carregaFiguresArxiuAction= new QAction(configuracioJoc->tradueixCadena("carrega.dades.figures.arxiu"), this);
    connect(carregaFiguresArxiuAction, SIGNAL(triggered()), this, SLOT(carregaFiguresArxiuSlot()));

    mostraSolucioAction= new QAction(configuracioJoc->tradueixCadena("Mostra.solucio"), this);
    mostraSolucioAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"solucio.png"));
    connect(mostraSolucioAction, SIGNAL(triggered()), this, SLOT(mostraSolucioSlot()));


    colocaPecaAction= new QAction(configuracioJoc->tradueixCadena("Coloca.peca"), this);
    colocaPecaAction->setCheckable(true);
    connect(colocaPecaAction, SIGNAL(triggered()), this, SLOT(colocaPecaSlot()));

    proposaFigura= new QAction(configuracioJoc->tradueixCadena("Proposa.figura"), this);
    proposaFigura->setShortcut(tr("Ctrl+P"));
    connect(proposaFigura, SIGNAL(triggered()), this, SLOT(proposaFiguraSlot()));


    cercaNomFigura= new QAction(configuracioJoc->tradueixCadena("cerca.nom.figura"), this);
    cercaNomFigura->setShortcut(tr("Ctrl+N"));
    connect(cercaNomFigura, SIGNAL(triggered()), this, SLOT(cercaNomFiguraSlot()));

    continuaCercaNomFigura= new QAction(configuracioJoc->tradueixCadena("continua.cerca.nom.figura"), this);
    continuaCercaNomFigura->setShortcut(tr("F3"));
    connect(continuaCercaNomFigura, SIGNAL(triggered()), this, SLOT(continuaCercaNomFiguraSlot()));
    continuaCercaNomFigura->setEnabled(false);

    pausaAction= new QAction(tr("Pausa"), this);
    pausaAction->setShortcut(tr("Ctrl+A"));
    pausaAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"atura.png"));
    connect(pausaAction, SIGNAL(triggered()), this, SLOT(pausaSlot()));

    /*
      Accions que crean els tangrams
      13/02/11
      Ara es crean en temps d'execució
    */

    /*
      Nivell del Joc
    */
    nivellJocGroup = new QActionGroup(this);

    nivellInfantilAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_INFANTIL), this);
    nivellInfantilAction->setCheckable(true);
    nivellInfantilAction->setActionGroup(nivellJocGroup);
    nivellInfantilAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"nivellInfantil.png"));
    nivellInfantilAction->setShortcut(tr("Alt+1"));
    connect(nivellInfantilAction, SIGNAL(triggered()), this, SLOT(nivellInfantilSlot()));

    nivellPrincipiantAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_PRINCIPIANT), this);
    nivellPrincipiantAction->setCheckable(true);
    nivellPrincipiantAction->setActionGroup(nivellJocGroup);
    nivellPrincipiantAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"nivellPrincipiant.png"));
    nivellPrincipiantAction->setShortcut(tr("Alt+2"));
    connect(nivellPrincipiantAction, SIGNAL(triggered()), this, SLOT(nivellPrincipiantSlot()));

    nivellIniciatAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_INICIAT), this);
    nivellIniciatAction->setCheckable(true);
    nivellIniciatAction->setActionGroup(nivellJocGroup);
    nivellIniciatAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"nivellIniciat.png"));
    nivellIniciatAction->setShortcut(tr("Alt+3"));
    connect(nivellIniciatAction, SIGNAL(triggered()), this, SLOT(nivellIniciatSlot()));

    nivellExpertAction = new QAction(configuracioJoc->tradueixCadena(NOM_NIVELL_EXPERT), this);
    nivellExpertAction->setCheckable(true);
    nivellExpertAction->setActionGroup(nivellJocGroup);
    nivellExpertAction->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"nivellExpert.png"));
    nivellExpertAction->setShortcut(tr("Alt+4"));
    connect(nivellExpertAction, SIGNAL(triggered()), this, SLOT(nivellExpertSlot()));

    nivellInfantilAction->setChecked(true);

    comprovaMostraAction = new QAction(configuracioJoc->tradueixCadena("comprova.mostra"), this);
    comprovaMostraAction->setShortcut(Qt::CTRL + Qt::Key_M);
    connect(comprovaMostraAction, SIGNAL(triggered()), this, SLOT(comprovaMostraSlot()));

    esborraMostraAction = new QAction(configuracioJoc->tradueixCadena("esborra.mostra"), this);
    esborraMostraAction->setShortcut(Qt::CTRL + Qt::Key_E);
    connect(esborraMostraAction, SIGNAL(triggered()), this, SLOT(esborraMostraSlot()));

    desaFiguraAction = new QAction(configuracioJoc->tradueixCadena("desa.dades.figura"), this);
    desaFiguraAction->setShortcut(Qt::CTRL + Qt::Key_D);
    connect(desaFiguraAction, SIGNAL(triggered()), this, SLOT(desaFiguraSlot()));

    simetriaVerticalAction = new QAction(configuracioJoc->tradueixCadena("Simetria.vertical"), this);
    simetriaVerticalAction->setShortcut(Qt::CTRL + Qt::Key_V);
    connect(simetriaVerticalAction, SIGNAL(triggered()), this, SLOT(simetriaVerticalSlot()));

    simetriaHoritzontalAction = new QAction(configuracioJoc->tradueixCadena("Simetria.horitzontal"), this);
    simetriaHoritzontalAction->setShortcut(Qt::CTRL + Qt::Key_H);
    connect(simetriaHoritzontalAction, SIGNAL(triggered()), this, SLOT(simetriaHoritzontalSlot()));

    cercaFiguraAction = new QAction(configuracioJoc->tradueixCadena("Cerca.figura"), this);
    cercaFiguraAction->setShortcut(Qt::CTRL + Qt::Key_F);
    connect(cercaFiguraAction, SIGNAL(triggered()), this, SLOT(cercaFiguraSlot()));


    figuraSeguentAction = new QAction(configuracioJoc->tradueixCadena("seguent.figura"), this);
    figuraSeguentAction->setShortcut(QKeySequence::MoveToNextPage);
    figuraSeguentAction->setEnabled(false);
    connect(figuraSeguentAction, SIGNAL(triggered()), this, SLOT(figuraSeguentSlot()));

    figuraAnteriorAction = new QAction(configuracioJoc->tradueixCadena("anterior.figura"), this);
    figuraAnteriorAction->setShortcut(QKeySequence::MoveToPreviousPage);
    figuraAnteriorAction->setEnabled(false);
    connect(figuraAnteriorAction, SIGNAL(triggered()), this, SLOT(figuraAnteriorSlot()));

    /* Creació de concurs */
    creaConcursAction = new QAction(configuracioJoc->tradueixCadena("Crea.concurs"), this);
    connect(creaConcursAction, SIGNAL(triggered()), this, SLOT(creaConcursSlot()));

    carregaConcursAction = new QAction(configuracioJoc->tradueixCadena("Carrega.concurs"), this);
    connect(carregaConcursAction, SIGNAL(triggered()), this, SLOT(carregaConcursSlot()));

//Idiomes
    /*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
  Les accions es crean en temps d'execució
     */

    ajuda= new QAction(configuracioJoc->tradueixCadena("Ajuda"), this);
    connect(ajuda, SIGNAL(triggered()), this, SLOT(ajudaSlot()));

    webPrograma= new QAction(configuracioJoc->tradueixCadena("Web.programa"), this);
    connect(webPrograma, SIGNAL(triggered()), this, SLOT(webProgramaSlot()));

    creditsPrograma= new QAction(configuracioJoc->tradueixCadena("Credits"), this);
    connect(creditsPrograma, SIGNAL(triggered()), this, SLOT(creditsProgramaSlot()));

    colaboraPrograma= new QAction(configuracioJoc->tradueixCadena("Colabora"), this);
    connect(colaboraPrograma, SIGNAL(triggered()), this, SLOT(colaboraProgramaSlot()));

}

/* 13/02/11
  Crea les accions, menus i botons amb
   dels tipus de tangram
  */
void formulariPrincipal::creaTipusTangramMenu(){
    jocsTangramActionGroup = new QActionGroup(this);
    connect(jocsTangramActionGroup, SIGNAL(triggered(QAction *)), this, SLOT(creaTangramAccio(QAction *)));

   //QString nomArxiu=directoriLinux()+QDir().separator()+"dades"+QDir().separator()+"dades_menus_tan.dat";
   //QStringList dadesArxiu=llegeixArxiuALlista(nomArxiu);

    /*Tangrams ordenats pel número de peces
    Codi del tangram, codi del nom
    nom del icone
    NOU TANGRAM 1
    darrer codi 38*/
    QStringList dadesArxiu;
    dadesArxiu.append("14;Fig_TB;peces_b.png");
    dadesArxiu.append("19;Fig_T4;peces4.png");
    dadesArxiu.append("30;Fig_T4II;peces4II.png");
    dadesArxiu.append("2;Fig_T5;peces5.png");
    dadesArxiu.append("36;Fig_T5II;peces5II.png");
    dadesArxiu.append("27;Fig_TSL;pecesSL.png");
    dadesArxiu.append("25;Fig_REG;pecesREG.png");
    dadesArxiu.append("3;Fig_T6;peces6.png");
    dadesArxiu.append("23;Fig_T6II;peces6II.png");
    dadesArxiu.append("15;Fig_TH;peces_h.png");
    dadesArxiu.append("1;Fig_T7;pecesset.png");
    dadesArxiu.append("4;Fig_TF;peces_f.png");
    dadesArxiu.append("21;Fig_T7I;peces7I.png");
    dadesArxiu.append("24;Fig_T7II;peces7II.png");
    dadesArxiu.append("26;Fig_THEP;pecesHEP.png");
    dadesArxiu.append("34;Fig_T8E;peces8E.png");
    dadesArxiu.append("5;Fig_TX;peces_x.png");
    dadesArxiu.append("6;Fig_TS;peces_s.png");
    dadesArxiu.append("7;Fig_T8;peces8.png");
    dadesArxiu.append("22;Fig_TCII;pecesCII.png");
    dadesArxiu.append("37;Fig_TA;pecesA.png");
    dadesArxiu.append("38;Fig_TREC;pecesrec.png");//Tangram rectangular
    dadesArxiu.append("8;Fig_T9;peces9.png");
    dadesArxiu.append("28;Fig_T9T;peces9t.png");
    dadesArxiu.append("16;Fig_TOU;peces_ou.png");
    dadesArxiu.append("17;Fig_COR;peces_c.png");
    dadesArxiu.append("9;Fig_T10;peces10.png");
    dadesArxiu.append("29;Fig_TE;pecese.png");
    dadesArxiu.append("33;Fig_EL;pecesel.png");
    dadesArxiu.append("20;Fig_TCIRI;pecesCI.png");
    dadesArxiu.append("10;Fig_T11;peces11.png");
    dadesArxiu.append("32;Fig_STIII;pecesSTOIII.png");
    dadesArxiu.append("11;Fig_TR;peces_r.png");
    dadesArxiu.append("35;Fig_T12;peces12.png"); //Tangram de 12 peces
    dadesArxiu.append("12;Fig_T13;peces13.png");
    dadesArxiu.append("13;Fig_T14;peces14.png");
    dadesArxiu.append("18;Fig_ST;peces_sto.png");
    dadesArxiu.append("31;Fig_STII;pecesSTOII.png");
   nomsDelsJocsPerTraduccio.clear();
   if (dadesArxiu.count()>0){
       //Començam a llegir les dades de la llista de menus que cal crear
      for (int i = 0; i < dadesArxiu.count(); ++i) {
         QStringList dadesMenu= dadesArxiu.value(i).split(";");
         //Ara cream l'acció
         QAction *action = new QAction(configuracioJoc->tradueixCadena(dadesMenu.value(1)), this);
        //La llista amb els codis dels noms dels jocs de tangram
        //per fer servir en la traduccio del GUI
        nomsDelsJocsPerTraduccio.append(dadesMenu.value(1));
        action->setData(dadesMenu.value(0));
        action->setIcon(QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+dadesMenu.value(2)));
        jocsTangramMenu->addAction(action);
        jocsTangramActionGroup->addAction(action);
      }
   }
}

/* 13/02/11
   Crea el tipus de tangram segons les dades
   de l'acció
  */
void formulariPrincipal::creaTangramAccio(QAction *accio){
   creaTangram(accio->data().toInt());
}

/* 13/02/11
   Tradueix els noms dels jocs de tangram en les
   actions
   */
void formulariPrincipal::tradueixNomsJocsTangram(){
   for(int i=0;i<jocsTangramActionGroup->actions().count();i++){
     jocsTangramActionGroup->actions().value(i)->setText(
             configuracioJoc->tradueixCadena(nomsDelsJocsPerTraduccio.value(i)));
   }
}

/*
  13/02/11
  Carrega el contingut de l'arxiu passat per paràmetre
  a una llista (que retorna)
  */
QStringList formulariPrincipal::llegeixArxiuALlista(QString arxiu){
    //obrim l'arxiu de jocs
    QFile arxiuData(arxiu);
    QStringList  dadesArxiu;
    if (arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
     QTextStream entrada(&arxiuData);
     QString linia0 = entrada.readLine();
     while (!linia0.isNull()) {
         if ( ! (linia0.mid(0,1)=="#") ){
            dadesArxiu.append(linia0);
         }
       linia0 = entrada.readLine();
     } //final del while de la lectura de l'arxiu
 }
 return dadesArxiu;
}


//Crea el menú de selecció d'idioma de l'aplicació
void formulariPrincipal::creaIdiomaMenu(){
    idiomaActionGroup = new QActionGroup(this);
    connect(idiomaActionGroup, SIGNAL(triggered(QAction *)), this, SLOT(seleccioIdioma(QAction * )));

    QDir dir(directoriLinux()+QDir().separator()+"locales");
    QStringList arxiusIdioma = dir.entryList(QStringList("locale_*.lo"));

for (int i = 0; i < arxiusIdioma.size(); ++i) {
    QString locale = arxiusIdioma[i];
    locale.remove(0, locale.indexOf('_') + 1);
    locale.truncate(locale.lastIndexOf('.'));


     QString nomArxiu=directoriLinux()+QDir().separator()+"locales"+QDir().separator()+arxiusIdioma[i];
     QSettings *arxiuLocale=new QSettings(nomArxiu,QSettings::IniFormat);
     QString language=arxiuLocale->value("Language","Language").toString().toLatin1();

    QAction *action = new QAction(tr("&%1 %2").arg(i + 1).arg(language), this);
    action->setCheckable(true);
    action->setData(locale);
    idiomaMenu->addAction(action);
    idiomaActionGroup->addAction(action);
   if (configuracioJoc->strLocale().contains((locale) )){
        action->setChecked(true);
        //a debian, sense això es carregan les cadenes
        //originals enlloc de les traduïdes
         configuracioJoc->canviaArxiuLocale(locale);
        //canviaIdioma(action);
       }
  }
}

void formulariPrincipal::seleccioIdioma(QAction *action){
    configuracioJoc->canviaArxiuLocale(action->data().toString());
    tradueixGUI();
}
/*
  Canviat el sistema de gestió del idioma
  v. 4.0.2
*/

//Ajuda
void formulariPrincipal::ajudaSlot(){
 QDir dirArxiu;
 QString directori=directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            configuracioJoc->strLocale()+
                            charPathSeparator+
                            "index.html";

    if (dirArxiu.exists(directori)){
     //Això evita problemas amb els espais als noms dels directoris
        QDesktopServices::openUrl(QUrl("file:///"+directori, QUrl::TolerantMode));
    }
   else  QDesktopServices::openUrl(QUrl("file:///"+directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            "en"+
                            charPathSeparator+
                            "index.html", QUrl::TolerantMode));
}

void formulariPrincipal::webProgramaSlot(){
   QDesktopServices::openUrl(ADRECA_WEB_PROGRAMA);
}

void formulariPrincipal::creditsProgramaSlot(){
    QDate avui=QDate::currentDate () ;

    QString missatge=QString("<h2>"+configuracioJoc->tradueixCadena("credits.versio")+""
                             +QString(" v. %1 </h2><br/>").
                                                          arg(qApp->applicationVersion()));

    missatge.append(QString("&copy;  "+QString("2000-%1").arg(avui.year())+"  I. De Marchi <br/>" ));
    missatge.append(QString(configuracioJoc->tradueixCadena("credits.llicencia")+"<br/>"));

    missatge.append(QString("<a href=\"%1\">%1</a><br/>").arg(ADRECA_WEB_PROGRAMA));
    missatge.append(QString("<a href=mailto:%1>%1</a><br/>").arg(ADRECA_CORREU));
//missatge.append(QString("<p>"));
    missatge.append(QString("<p>Thanks for translations: <br/>"));
    missatge.append(QString("Portuguese: Américo Monteiro  (v. 4.0.1) <br/>"));
    missatge.append(QString("Italiano :      Vincenzo Campanella  (v. 4.0.2) <br/>"));
    missatge.append(QString("Deutsch :     Erik Pfannenstein  (v. 4.0.2) <br/>"));
    missatge.append(QString("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Hendrik Knackstedt  (v. 4.0.2) <br/>"));
    missatge.append(QString("Portuguese do Brasil (Brasileiro) :     Adriano Rafael Gomes  (v. 4.0.2) <br/>"));

    QMessageBox::about(this,
            configuracioJoc->tradueixCadena("credits.rotul"),missatge);
}


void formulariPrincipal::colaboraProgramaSlot(){
   QDir dirArxiu;
 QString directori=directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            configuracioJoc->strLocale()+
                            charPathSeparator+
                            "html/colabora.html";

    if (dirArxiu.exists(directori)){
      QDesktopServices::openUrl(QUrl("file:///"+directori, QUrl::TolerantMode));
    }
   else  QDesktopServices::openUrl(QUrl("file:///"+directoriLinux()+
                            charPathSeparator+
                            DIR_HELP+
                            charPathSeparator+
                            "en"+
                            charPathSeparator+
                            "html/colabora.html", QUrl::TolerantMode));
}


/*
  Selecciona a l'atzar una de les figures de l'arbre
*/
void formulariPrincipal::proposaFiguraSlot(){
   QTreeWidgetItem *item= arbreFiguresTreeWidget->topLevelItem(0);
   if(item->childCount()>0){
   int nus=qrand() % item->childCount();
   QTreeWidgetItem *itemSel=item->child(nus);
   arbreFiguresTreeWidget->setCurrentItem(itemSel);
}
}


void formulariPrincipal::cercaNomFiguraSlot(){
 if (arbreFiguresTreeWidget->topLevelItem(0)==0){ return;}

nomFiguraPerCercar.clear();
indexFiguraPerCercar=0;
bool busca;
bool trobat=false;
nomFiguraPerCercar = QInputDialog::getText(this,
                            configuracioJoc->tradueixCadena("cerca.nom.figura"),
                            configuracioJoc->tradueixCadena("label.nom.figura"),
                            QLineEdit::Normal,
                            "", &busca);

 if (busca && !nomFiguraPerCercar.isEmpty()){
    for(int i=0;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
        indexFiguraPerCercar=i;
        if (arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(0).contains(
                nomFiguraPerCercar,Qt::CaseInsensitive)){
           continuaCercaNomFigura->setEnabled(true);
           arbreFiguresTreeWidget->setCurrentItem(arbreFiguresTreeWidget->topLevelItem(0)->child(i));
           indexFiguraPerCercar=i+1;
           trobat=true;
           break;
        }
     }

 //if(indexFiguraPerCercar>=arbreFiguresTreeWidget->topLevelItem(0)->childCount()){
    if (!trobat){
     QMessageBox::information(this, configuracioJoc->tradueixCadena("cerca.nom.figura"),
                    configuracioJoc->tradueixCadena("msg.nomFigura.noTrobada"));
  }
 }
}

void formulariPrincipal::continuaCercaNomFiguraSlot(){
    bool trobat=false;
for(int i=indexFiguraPerCercar;i<=arbreFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
    indexFiguraPerCercar=i;
    if (arbreFiguresTreeWidget->topLevelItem(0)->child(i)->text(0).contains(
           nomFiguraPerCercar,Qt::CaseInsensitive)){
       arbreFiguresTreeWidget->setCurrentItem(arbreFiguresTreeWidget->topLevelItem(0)->child(i));
       indexFiguraPerCercar=i+1;
       trobat=true;
       break;
    }
 }
//if(indexFiguraPerCercar+1>=arbreFiguresTreeWidget->topLevelItem(0)->childCount()){
if (!trobat){
    nomFiguraPerCercar.clear();
    indexFiguraPerCercar=0;
    continuaCercaNomFigura->setEnabled(false);
    QMessageBox::information(this, configuracioJoc->tradueixCadena("cerca.nom.figura"),
                    configuracioJoc->tradueixCadena("msg.nomFigura.noTrobada"));
  }
}

void formulariPrincipal::creaMenus()
{
    aplicacioMenu = menuBar()->addMenu(configuracioJoc->tradueixCadena("Programa"));
    aplicacioMenu->addAction(elimnaRecordAction);
    aplicacioMenu->addAction(eliminaTotsRecordsAction);
    aplicacioMenu->addSeparator();

    aplicacioMenu->addAction(carregaFiguresProgramaAction);
    aplicacioMenu->addAction(carregaFiguresArxiuAction);

    aplicacioMenu->addSeparator();
    aplicacioMenu->addAction(surtAction);


    jocMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Joc"));
    jocsTangramMenu=jocMenu->addMenu(configuracioJoc->tradueixCadena("Jocs.tangram"));
    // 13/02/11
    creaTipusTangramMenu();
    jocMenu->addSeparator();
    //menú del nivell de Joc
    jocMenu->addAction(nivellInfantilAction);
    jocMenu->addAction(nivellPrincipiantAction);
    jocMenu->addAction(nivellIniciatAction);
    jocMenu->addAction(nivellExpertAction);
     /*
      Creació de noves figures
    */
    jocMenu->addSeparator();
    creaFiguraMenu=jocMenu->addMenu(configuracioJoc->tradueixCadena("crea.nova.figura"));    
        creaFiguraMenu->addAction(comprovaMostraAction);
        creaFiguraMenu->addAction(esborraMostraAction);
        creaFiguraMenu->addAction(desaFiguraAction);
        creaFiguraMenu->addSeparator();
        creaFiguraMenu->addAction(simetriaVerticalAction);
        creaFiguraMenu->addAction(simetriaHoritzontalAction);
        creaFiguraMenu->addSeparator();
        creaFiguraMenu->addAction(cercaFiguraAction);
        creaFiguraMenu->addAction(figuraSeguentAction);
        creaFiguraMenu->addAction(figuraAnteriorAction);



    jocMenu->addSeparator();
    jocMenu->addAction(proposaFigura);

    jocMenu->addSeparator();

    jocMenu->addAction(cercaNomFigura);
    jocMenu->addAction(continuaCercaNomFigura);

    //ajuda a la resolució de figures
    jocMenu->addSeparator();
    jocMenu->addAction(colocaPecaAction);
    jocMenu->addAction(mostraSolucioAction);

    jocMenu->addSeparator();
    jocMenu->addAction(pausaAction);

    //creació de concurs
    concursMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Concurs"));
    concursMenu->addAction(creaConcursAction);
    concursMenu->addAction(carregaConcursAction);

    //selecció d'idioma
    idiomaMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("idioma"));
    creaIdiomaMenu();

    //Ajuda
    ajudaMenu=menuBar()->addMenu(configuracioJoc->tradueixCadena("Ajuda"));
        ajudaMenu->addAction(ajuda);
        ajudaMenu->addAction(webPrograma);
        ajudaMenu->addAction(colaboraPrograma);
        ajudaMenu->addSeparator();
        ajudaMenu->addAction(creditsPrograma);
}


  void formulariPrincipal::missatgeStatusBar(QString missatge)
 {
     statusBar()->showMessage(missatge);
 }

void formulariPrincipal::creaBarraTasques()
{
    tangramsToolBar = addToolBar(configuracioJoc->tradueixCadena("Tangrams"));
    tangramsToolBar->setIconSize(QSize(15,15));


    // 13/02/11 Afegim les accions dels tipus de tangram
    for(int i=0;i<jocsTangramActionGroup->actions().count();i++){
        tangramsToolBar->addAction( jocsTangramActionGroup->actions().value(i));
   }

    tangramsToolBar->addSeparator();

    //nivell de Joc
    tangramsToolBar->addAction(nivellInfantilAction);
    tangramsToolBar->addAction(nivellPrincipiantAction);
    tangramsToolBar->addAction(nivellIniciatAction);
    tangramsToolBar->addAction(nivellExpertAction);
    tangramsToolBar->setMovable(false);

}
void formulariPrincipal::resizeEvent ( QResizeEvent * event ){
QSize augment=this->size()-this->minimumSize();
sceneFrame->resize(QSize(sceneFrame->minimumSize()+augment));
sceneJoc->setSceneRect(0,0,viewJoc->minimumSize().width()+augment.width(),
                       viewJoc->minimumSize().height()+augment.height());
viewJoc->resize(QSize(viewJoc->minimumSize()+augment));

arbreFiguresTreeWidget->resize(
     arbreFiguresTreeWidget->minimumSize().width(),
     arbreFiguresTreeWidget->minimumSize().height()+augment.height());

//recolocam les peces per evitar que quedin
//fora de la vista
conjuntFigura->centraFiguraScene();
conjuntJoc->centraFiguraScene();
for(int i=0;i<=conjuntJoc->arrayPeces.size()-1;i++){
   while  (!conjuntJoc->arrayPeces[i]->pecaEnLimits()){
     conjuntJoc->arrayPeces[i]->setPos(qrand() % viewJoc->width()
                                   ,qrand() % viewJoc->height());
  }
  }
QMainWindow::resizeEvent(event);
}

/*
  Manté el joc en pausa
  */
void formulariPrincipal::pausaSlot(){
    //Si s'està jugant, s'atura el joc
    if(rellotgeLabel->rellotgeEnMarxa()){
        QProgressDialog pausaProgres(tr("Pausa"), tr("Continua"), 0,0 ,this);
        rellotgeLabel->aturaRellotge();
        pausaProgres.setWindowModality(Qt::WindowModal);
        pausaProgres.setVisible(true);
        qApp->processEvents();
        conjuntJoc->conjuntVisible(false);
        conjuntMostra->conjuntVisible(false);
        bool conjuntFiguraVisible=conjuntFigura->arrayPeces[0]->pecaVisible;
        conjuntFigura->conjuntVisible(false);
        bool continua=true;
        while (continua){
            if (pausaProgres.wasCanceled()){
                continua=false;
                conjuntJoc->conjuntVisible(true);
                conjuntMostra->conjuntVisible(true);
                conjuntFigura->conjuntVisible(conjuntFiguraVisible);
                rellotgeLabel->iniciaRellotge();}
            qApp->processEvents();
        }
        pausaProgres.close();
  }
}


