/*
 * Copyright (C) 2000-2011  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <QApplication>

#include "formularis/frmPrincipal.h"
#include "comuns/funcions.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
        app.setApplicationName("Tangram");
        app.setApplicationVersion("4.1");
        app.setOrganizationName("De Marchi");

        //Això pels accents a les cadenes
        QTextCodec *linuxCodec = QTextCodec::codecForName("UTF-8");
        QTextCodec::setCodecForTr(linuxCodec);
        QTextCodec::setCodecForCStrings(linuxCodec);
        QTextCodec::setCodecForLocale(linuxCodec);

     QPixmap pixmap(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"present.png");

     QSplashScreen splash(pixmap);
     splash.show();
     app.processEvents();

    //Això per a que surtin traduïdes les cadenes dels formularis predefinits Qt
     QString translatorFileName = QLatin1String("qt_");
     translatorFileName += QLocale::system().name();
     QTranslator *translator = new QTranslator(&app);
    if (translator->load(translatorFileName, QLibraryInfo::location(QLibraryInfo::TranslationsPath)))
     app.installTranslator(translator);

    formulariPrincipal *frmPrincipal=new formulariPrincipal();
    frmPrincipal->show();


     splash.finish(frmPrincipal);
    return app.exec();
}
